/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.BulkMapNetTerm;
import com.sigrity.orbit.ui.bulk.BulkMapUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class BulkMapNetTermUI
extends BulkMapUI<Net, Term> {
    private static final String TITLE = "Bulk Map";

    public static BulkMapNetTermUI showUI(Window owner, Db db, String childDevPathStr) {
        DevicePath childDevPath = DevicePath.fromString((Db)db, (String)childDevPathStr);
        if (childDevPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{childDevPathStr});
            return null;
        }
        return BulkMapNetTermUI.showUI(owner, childDevPath);
    }

    public static BulkMapNetTermUI showUI(Window owner, DevicePath childDevPath) {
        BulkMapNetTermUI dlg = new BulkMapNetTermUI(owner, childDevPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected BulkMapNetTermUI(Window owner, DevicePath childDevPath) {
        super(owner, TITLE, childDevPath);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new BulkMapNetTermPanel();
    }

    protected class BulkMapNetTermPanel
    extends BulkMapUI.BulkMapPanel {
        protected BulkMapNetTermPanel() {
            super(BulkMapNetTermUI.this);
        }

        protected ItemBoxs.ObjItemBox<Net> newSelectedBox() {
            return new ItemBoxs.NetBox(BulkMapNetTermUI.this.getParentDevPath(), ItemBoxs.ItemBoxType.SELET);
        }

        protected ItemBoxs.ObjItemBox<Term> newMatchedBox() {
            return new ItemBoxs.TermBox(BulkMapNetTermUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.MATCH);
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)BulkMapNetTermUI.this.getDb(), (String)"Bulk map child terms to parent nets");){
                    this.cpBulkMap(BulkMapNetTerm.class);
                }
                UIUtil.closeWindow((Window)((Object)BulkMapNetTermUI.this));
            });
        }
    }
}

