/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.BulkMapTermTerm;
import com.sigrity.orbit.ui.bulk.BulkMapUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class BulkMapTermTermUI
extends BulkMapUI<Term, Term> {
    private static final String TITLE = "Bulk Map";

    public static BulkMapTermTermUI showUI(Window owner, Db db, String childDevPathStr) {
        DevicePath childDevPath = DevicePath.fromString((Db)db, (String)childDevPathStr);
        if (childDevPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{childDevPathStr});
            return null;
        }
        return BulkMapTermTermUI.showUI(owner, childDevPath);
    }

    public static BulkMapTermTermUI showUI(Window owner, DevicePath childDevPath) {
        BulkMapTermTermUI dlg = new BulkMapTermTermUI(owner, childDevPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected BulkMapTermTermUI(Window owner, DevicePath childDevPath) {
        super(owner, TITLE, childDevPath);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new BulkMapTermTermPanel();
    }

    protected class BulkMapTermTermPanel
    extends BulkMapUI.BulkMapPanel {
        protected BulkMapTermTermPanel() {
            super(BulkMapTermTermUI.this);
        }

        protected ItemBoxs.ObjItemBox<Term> newSelectedBox() {
            return new ItemBoxs.TermBox(BulkMapTermTermUI.this.getParentDevPath(), ItemBoxs.ItemBoxType.SELET);
        }

        protected ItemBoxs.ObjItemBox<Term> newMatchedBox() {
            return new ItemBoxs.TermBox(BulkMapTermTermUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.MATCH);
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)BulkMapTermTermUI.this.getDb(), (String)"Bulk map from parent terms to child terms");){
                    this.cpBulkMap(BulkMapTermTerm.class);
                }
                UIUtil.closeWindow((Window)((Object)BulkMapTermTermUI.this));
            });
        }
    }
}

