/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.term.BulkMap;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.netlist_editor.ItemFilters;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import javafx.util.Duration;

public abstract class BulkMapUI<J extends DbObject, K extends DbObject>
extends AJFXDesignDialog {
    private DevicePath mChildDevPath;

    protected BulkMapUI(Window owner, String title, DevicePath childDevPath) {
        super(childDevPath.getDb(), owner, title);
        this.mChildDevPath = childDevPath;
    }

    protected DevicePath getChildDevPath() {
        return this.mChildDevPath;
    }

    protected Device getChildDev() {
        return this.mChildDevPath.getDevice();
    }

    protected DevicePath getParentDevPath() {
        return this.mChildDevPath.getParent();
    }

    protected abstract class BulkMapPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 550;
        private static final int PANEL_HEIGHT = 600;
        private ItemBoxs.ObjItemBox<J> mSelectedBox;
        private ItemBoxs.ObjItemBox<K> mMatchedBox;

        protected abstract ItemBoxs.ObjItemBox<J> newSelectedBox();

        protected abstract ItemBoxs.ObjItemBox<K> newMatchedBox();

        protected abstract EventHandler<ActionEvent> getOkHandler();

        protected BulkMapPanel() {
            this.setPreferredSize(new Dimension(550, 600));
        }

        protected String getSelectorRegex() {
            return this.mSelectedBox.getRegex();
        }

        protected int getSelectorRegexFlags() {
            return this.mSelectedBox.getRegexFlags();
        }

        protected String getMactherRegex() {
            return this.mMatchedBox.getRegex();
        }

        protected int getMatchedRegexFlags() {
            return this.mMatchedBox.getRegexFlags();
        }

        protected IterableIterator<ItemFilters.ItemFilter<J>> getSelectedActiveFilter() {
            return this.mSelectedBox.getActiveFilters();
        }

        protected IterableIterator<ItemFilters.ItemFilter<K>> getMatchedActiveFilter() {
            return this.mMatchedBox.getActiveFilters();
        }

        protected void cpBulkMap(Class<? extends BulkMap<J, K>> bulkMapClass) {
            Cp.exec((String)"unset(\"_bulkMap\");", (Object[])new Object[0]);
            Cp.exec((String)"_bulkMap = new %s(%s)", (Object[])new Object[]{bulkMapClass.getName(), CpHelper.getObjCmdStr(BulkMapUI.this.getChildDev())});
            Cp.exec((String)"_bulkMap.setSelectorPattern(\"%s\", %d)", (Object[])new Object[]{this.getSelectorRegex(), this.getSelectorRegexFlags()});
            Cp.exec((String)"_bulkMap.setMatchedPattern(\"%s\", %d)", (Object[])new Object[]{this.getMactherRegex(), this.getMatchedRegexFlags()});
            for (ItemFilters.ItemFilter f : this.getSelectedActiveFilter()) {
                Cp.exec((String)"_bulkMap.addSelectedItemFilter(%s.%s.get())", (Object[])new Object[]{ItemFilters.class.getName(), f.getClass().getSimpleName()});
            }
            for (ItemFilters.ItemFilter f : this.getMatchedActiveFilter()) {
                Cp.exec((String)"_bulkMap.addMatchedItemFilter(%s.%s.get())", (Object[])new Object[]{ItemFilters.class.getName(), f.getClass().getSimpleName()});
            }
            Cp.exec((String)"_bulkMap.execute()", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_bulkMap\");", (Object[])new Object[0]);
        }

        protected Parent initSceneGraph() {
            BorderPane pane = new BorderPane();
            Node mainPane = this.getMainPane();
            pane.setCenter(mainPane);
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)BulkMapUI.this), this.getOkHandler());
            okCancelHBox.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
            pane.setBottom((Node)okCancelHBox);
            return pane;
        }

        private Node getMainPane() {
            SplitPane mainPane = new SplitPane();
            this.mSelectedBox = this.newSelectedBox();
            this.mSelectedBox.setRegexChangeListener(this.getSelectorChangeListener());
            this.mSelectedBox.setIngoreCaseChangeListener((EventHandler<ActionEvent>)((EventHandler)e -> this.runSelectorChangeAction()));
            this.mSelectedBox.setFilterMenuHideAction((EventHandler<Event>)((EventHandler)e -> this.runSelectorChangeAction()));
            this.mSelectedBox.setListViewSelectionChangeListener(this.getSelectedListViewListener());
            mainPane.getItems().add(this.mSelectedBox);
            this.mMatchedBox = this.newMatchedBox();
            this.mMatchedBox.setRegexChangeListener(this.getMatcherChangeListener());
            this.mMatchedBox.setIngoreCaseChangeListener((EventHandler<ActionEvent>)((EventHandler)e -> this.runMatcherChangeAction()));
            this.mMatchedBox.setFilterMenuHideAction((EventHandler<Event>)((EventHandler)e -> this.runMatcherChangeAction()));
            this.mMatchedBox.setListViewSelectionChangeListener(this.getMatchedListViewListener());
            mainPane.getItems().add(this.mMatchedBox);
            this.runSelectorChangeAction();
            BulkMapUI.this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Platform.runLater(() -> {
                        BulkMapPanel.this.mSelectedBox.cancelBackgroundTask();
                        BulkMapPanel.this.mMatchedBox.cancelBackgroundTask();
                    });
                }
            });
            return mainPane;
        }

        private ChangeListener<String> getSelectorChangeListener() {
            PauseTransition pause = new PauseTransition(Duration.seconds((double)1.0));
            return (observable, oldValue, newValue) -> {
                pause.setOnFinished(event -> this.runSelectorChangeAction());
                pause.playFromStart();
            };
        }

        private ChangeListener<String> getMatcherChangeListener() {
            PauseTransition pause = new PauseTransition(Duration.seconds((double)1.0));
            return (observable, oldValue, newValue) -> {
                pause.setOnFinished(event -> this.runMatcherChangeAction());
                pause.playFromStart();
            };
        }

        private ChangeListener<J> getSelectedListViewListener() {
            return (observable, oldValue, newValue) -> {
                if (newValue == null) {
                    return;
                }
                Object matchedItem = this.getMatchedItem(newValue);
                if (matchedItem != null) {
                    this.mMatchedBox.select(matchedItem);
                    this.mMatchedBox.scrollToSelection();
                }
            };
        }

        private ChangeListener<K> getMatchedListViewListener() {
            return (observable, oldValue, newValue) -> {
                if (newValue == null) {
                    return;
                }
                Object selectedItem = this.getSelectedItem(newValue);
                if (selectedItem != null) {
                    this.mSelectedBox.select(selectedItem);
                    this.mSelectedBox.scrollToSelection();
                }
            };
        }

        private void runSelectorChangeAction() {
            this.setSelectedHighlighter();
            this.setSelectedFilter();
            this.setMatchedFilter();
        }

        private void runMatcherChangeAction() {
            this.setSelectedHighlighter();
            this.setMatchedFilter();
        }

        private void setSelectedFilter() {
            Pattern selectorPattern = this.getSelectorPattern();
            ArrayList selectorPatterns = selectorPattern == null ? Collections.emptyList() : AUtil.arrayList((Object[])new Pattern[]{selectorPattern});
            this.mSelectedBox.setFilterPattern(selectorPatterns);
        }

        private Pattern getSelectorPattern() {
            return BulkHelper.getSelectorPattern(this.getSelectorRegex(), this.getSelectorRegexFlags());
        }

        private void setMatchedFilter() {
            String regex = this.getMactherRegex();
            int regexFlags = this.getMatchedRegexFlags();
            ArrayList<Pattern> mMatchedPatterns = new ArrayList<Pattern>();
            for (List vals : this.mSelectedBox.getRegexCapturedValues()) {
                Pattern p = BulkHelper.getMatchedPattern(regex, regexFlags, vals);
                if (p == null) continue;
                mMatchedPatterns.add(p);
            }
            this.mMatchedBox.setFilterPattern(mMatchedPatterns);
        }

        private void setSelectedHighlighter() {
            this.mSelectedBox.setHighLighter(this::hasMatchedItem);
            this.refresh();
        }

        private boolean hasMatchedItem(J item) {
            return this.getMatchedItem(item) != null;
        }

        private K getMatchedItem(J item) {
            Pattern selectorPattern = this.getSelectorPattern();
            if (selectorPattern == null) {
                return null;
            }
            String matchedRegex = this.getMactherRegex();
            int matchedRegexFlags = this.getMatchedRegexFlags();
            String refStr = this.mSelectedBox.getShowedStr(item);
            Pattern matcherPattern = BulkHelper.getMatchedPattern(selectorPattern, refStr, matchedRegex, matchedRegexFlags);
            if (matcherPattern == null) {
                return null;
            }
            for (DbObject i : this.mMatchedBox.getItems()) {
                String itemStr;
                if (!this.mMatchedBox.isVisibleItem(i) || !matcherPattern.matcher(itemStr = this.mMatchedBox.getShowedStr(i)).matches()) continue;
                return i;
            }
            return null;
        }

        private J getSelectedItem(K item) {
            Pattern selectorPattern = this.getSelectorPattern();
            if (selectorPattern == null) {
                return null;
            }
            String matchedRegex = this.getMactherRegex();
            int matchedRegexFlags = this.getMatchedRegexFlags();
            String itemStr = this.mMatchedBox.getShowedStr(item);
            for (DbObject i : this.mSelectedBox.getItems()) {
                String refStr;
                Pattern matcherPattern;
                if (!this.mSelectedBox.isVisibleItem(i) || (matcherPattern = BulkHelper.getMatchedPattern(selectorPattern, refStr = this.mSelectedBox.getShowedStr(i), matchedRegex, matchedRegexFlags)) == null || !matcherPattern.matcher(itemStr).matches()) continue;
                return i;
            }
            return null;
        }

        private void refresh() {
            this.mSelectedBox.refresh();
            this.mMatchedBox.refresh();
        }
    }
}

