/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.BulkRenameNet;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class BulkRenameNetUI
extends BulkCreateUI<Net> {
    private static final String TITLE = "Bulk Rename Nets";

    public static BulkRenameNetUI showUI(Window owner, Db db, String childDevPathStr) {
        DevicePath childDevPath = DevicePath.fromString((Db)db, (String)childDevPathStr);
        if (childDevPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{childDevPathStr});
            return null;
        }
        return BulkRenameNetUI.showUI(owner, childDevPath);
    }

    public static BulkRenameNetUI showUI(Window owner, DevicePath childDevPath) {
        BulkRenameNetUI dlg = new BulkRenameNetUI(owner, childDevPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected BulkRenameNetUI(Window owner, DevicePath childDevPath) {
        super(owner, TITLE, childDevPath);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new BulkRanameNetPanel();
    }

    protected class BulkRanameNetPanel
    extends BulkCreateUI.BulkCreatePanel {
        protected BulkRanameNetPanel() {
        }

        protected ItemBoxs.ObjItemBox<Net> newSelectedBox() {
            return new ItemBoxs.NetBox(BulkRenameNetUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(BulkRenameNetUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)BulkRenameNetUI.this.getDb(), (String)"Bulk rename nets");){
                    this.cpBulkCreate(BulkRenameNet.class);
                }
                UIUtil.closeWindow((Window)((Object)BulkRenameNetUI.this));
            });
        }
    }
}

