/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.BulkRenameTerm;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class BulkRenameTermUI
extends BulkCreateUI<Term> {
    private static final String TITLE = "Bulk Rename Terms";

    public static BulkRenameTermUI showUI(Window owner, Db db, String childDevPathStr) {
        DevicePath childDevPath = DevicePath.fromString((Db)db, (String)childDevPathStr);
        if (childDevPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{childDevPathStr});
            return null;
        }
        return BulkRenameTermUI.showUI(owner, childDevPath);
    }

    public static BulkRenameTermUI showUI(Window owner, DevicePath childDevPath) {
        BulkRenameTermUI dlg = new BulkRenameTermUI(owner, childDevPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected BulkRenameTermUI(Window owner, DevicePath childDevPath) {
        super(owner, TITLE, childDevPath);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new BulkRanameTermPanel();
    }

    protected class BulkRanameTermPanel
    extends BulkCreateUI.BulkCreatePanel {
        protected BulkRanameTermPanel() {
        }

        protected ItemBoxs.ObjItemBox<Term> newSelectedBox() {
            return new ItemBoxs.TermBox(BulkRenameTermUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(BulkRenameTermUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)BulkRenameTermUI.this.getDb(), (String)"Bulk rename nets");){
                    this.cpBulkCreate(BulkRenameTerm.class);
                }
                UIUtil.closeWindow((Window)((Object)BulkRenameTermUI.this));
            });
        }
    }
}

