/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.bump.BumpSelectedInfo;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.term.Bump2TermBulkCreate;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class Bump2TermBulkCreateUI
extends BulkCreateUI<Device> {
    private static final String TITLE = "Bulk Create Terms from Bumps";
    private final Map<DeviceTemplate, BumpSelectedInfo> mBumpDevT2SelectedInfo;

    public static Bump2TermBulkCreateUI showUI(Window owner, Db db, String devPathStr) {
        DevicePath devPath = DevicePath.fromString((Db)db, (String)devPathStr);
        if (devPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devPathStr});
            return null;
        }
        return Bump2TermBulkCreateUI.showUI(owner, devPath, Collections.emptyMap());
    }

    public static Bump2TermBulkCreateUI showUI(Window owner, DevicePath devPath, Map<DeviceTemplate, BumpSelectedInfo> bumpSelectedInfos) {
        Bump2TermBulkCreateUI dlg = new Bump2TermBulkCreateUI(owner, devPath, bumpSelectedInfos);
        dlg.setVisible(true);
        return dlg;
    }

    protected Bump2TermBulkCreateUI(Window owner, DevicePath devPath, Map<DeviceTemplate, BumpSelectedInfo> bumpDevT2SelectedInfo) {
        super(owner, TITLE, devPath);
        this.mBumpDevT2SelectedInfo = bumpDevT2SelectedInfo;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new Bump2TermBulkCreatePanel();
    }

    protected class Bump2TermBulkCreatePanel
    extends BulkCreateUI.BulkCreatePanel {
        protected Bump2TermBulkCreatePanel() {
        }

        protected ItemBoxs.ObjItemBox<Device> newSelectedBox() {
            ArrayList stringGetters = AUtil.arrayList((Object[])new BulkHelper.StringGetter[]{BulkHelper.BumpStringGetter, BulkHelper.BumpNetStringGetter});
            return new ItemBoxs.BumpBox(Bump2TermBulkCreateUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET, null, stringGetters);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(Bump2TermBulkCreateUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)Bump2TermBulkCreateUI.this.getDb(), (String)"Bulk create nets from terms");){
                    this.cpBulkCreate(Bump2TermBulkCreate.class, this.getSelectorStringGetter());
                }
                UIUtil.closeWindow((Window)((Object)Bump2TermBulkCreateUI.this));
            });
        }

        @Override
        protected void cpPreExecuteCmd() {
            Bump2TermBulkCreateUI.this.mBumpDevT2SelectedInfo.forEach((k, v) -> Cp.exec((String)"_bulkCreate.setBumpTerm(%s, %s)", (Object[])new Object[]{CpHelper.getObjCmdStr(k), CpHelper.getObjCmdStr(v.getTerm())}));
        }
    }
}

