/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.ChildTerm2ParentNetBulkCreate;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class ChildTerm2ParentNetBulkCreateUI
extends BulkCreateUI<Term> {
    private static final String TITLE = "Bulk Create Parent Nets";

    public static ChildTerm2ParentNetBulkCreateUI showUI(Window owner, Db db, String childDevPathStr) {
        DevicePath childDevPath = DevicePath.fromString((Db)db, (String)childDevPathStr);
        if (childDevPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{childDevPathStr});
            return null;
        }
        return ChildTerm2ParentNetBulkCreateUI.showUI(owner, childDevPath);
    }

    public static ChildTerm2ParentNetBulkCreateUI showUI(Window owner, DevicePath childDevPath) {
        ChildTerm2ParentNetBulkCreateUI dlg = new ChildTerm2ParentNetBulkCreateUI(owner, childDevPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected ChildTerm2ParentNetBulkCreateUI(Window owner, DevicePath childDevPath) {
        super(owner, TITLE, childDevPath);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new ChildTerm2ParentNetBulkCreatePanel();
    }

    protected class ChildTerm2ParentNetBulkCreatePanel
    extends BulkCreateUI.BulkCreatePanel {
        protected ChildTerm2ParentNetBulkCreatePanel() {
        }

        protected ItemBoxs.ObjItemBox<Term> newSelectedBox() {
            return new ItemBoxs.TermBox(ChildTerm2ParentNetBulkCreateUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(ChildTerm2ParentNetBulkCreateUI.this.getParentDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)ChildTerm2ParentNetBulkCreateUI.this.getDb(), (String)"Bulk create parent nets from child terms");){
                    this.cpBulkCreate(ChildTerm2ParentNetBulkCreate.class);
                }
                UIUtil.closeWindow((Window)((Object)ChildTerm2ParentNetBulkCreateUI.this));
            });
        }
    }
}

