/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.term.ChildTerm2ParentTermBulkCreate;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import java.awt.Window;
import java.util.ArrayList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class ChildTerm2ParentTermBulkCreateUI
extends BulkCreateUI<Term> {
    private static final String TITLE = "Bulk Create Parent Terms";

    public static ChildTerm2ParentTermBulkCreateUI showUI(Window owner, Db db, String childDevPathStr) {
        DevicePath childDevPath = DevicePath.fromString((Db)db, (String)childDevPathStr);
        if (childDevPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{childDevPathStr});
            return null;
        }
        return ChildTerm2ParentTermBulkCreateUI.showUI(owner, childDevPath);
    }

    public static ChildTerm2ParentTermBulkCreateUI showUI(Window owner, DevicePath childDevPath) {
        ChildTerm2ParentTermBulkCreateUI dlg = new ChildTerm2ParentTermBulkCreateUI(owner, childDevPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected ChildTerm2ParentTermBulkCreateUI(Window owner, DevicePath childDevPath) {
        super(owner, TITLE, childDevPath);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new ChildTerm2ParentTermBulkCreatePanel();
    }

    protected class ChildTerm2ParentTermBulkCreatePanel
    extends BulkCreateUI.BulkCreatePanel {
        protected ChildTerm2ParentTermBulkCreatePanel() {
        }

        protected ItemBoxs.ObjItemBox<Term> newSelectedBox() {
            ArrayList showedStrGetters = AUtil.arrayList((Object[])new BulkHelper.StringGetter[]{BulkHelper.TermStringGetter, BulkHelper.TermParentNetStringGetter});
            return new ItemBoxs.TermBox(ChildTerm2ParentTermBulkCreateUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET, null, showedStrGetters);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(ChildTerm2ParentTermBulkCreateUI.this.getParentDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)ChildTerm2ParentTermBulkCreateUI.this.getDb(), (String)"Bulk create parent nets from child terms");){
                    this.cpBulkCreate(ChildTerm2ParentTermBulkCreate.class, this.getSelectorStringGetter());
                }
                UIUtil.closeWindow((Window)((Object)ChildTerm2ParentTermBulkCreateUI.this));
            });
        }
    }
}

