/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.NestedIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXMenuButton;
import com.sigrity.acl.jfxui.AListView;
import com.sigrity.orbit.DeviceFilters;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.jfxui.OrbitJFXImages;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.ui.netlist_editor.FilterMenuItems;
import com.sigrity.orbit.ui.netlist_editor.ItemFilters;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class ItemBoxs {
    private static final String DEFAULT_SELECTED_REGEX = "(.*)";
    private static final String DEFAULT_MATCHED_REGEX = "{1}";
    private static final String HIGHLIGHT_STYLE = "-fx-background-color: palegreen; -fx-text-fill: black;";
    private static final String SELECTED_HIGHLIGHT_STYLE = "-fx-background-color: limegreen; -fx-text-fill: black;";
    private static final String STYLE_BLUE_TEXT = "-fx-text-fill: steelblue;";
    protected static final ItemsCollector<Net> NetItemsCollector = owner -> AUtil.arrayList((Iterator)owner.getNets());
    protected static final ItemsCollector<Term> TermItemsCollector = owner -> AUtil.arrayList((Iterator)owner.getTerms());

    private ItemBoxs() {
    }

    protected static interface ItemsCollector<T> {
        public List<T> collectItems(DeviceTemplate var1);
    }

    protected static interface HighLighter<T> {
        public boolean isHighLight(T var1);
    }

    protected static enum ItemBoxType {
        SELET("Selector:", "(.*)"),
        MATCH("Matcher:", "{1}"),
        NEW("Pattern:", "{1}");

        private final String regexLabelStr;
        private final String defaultRegex;

        private ItemBoxType(String regexLabelStr, String defaultRegex) {
            this.regexLabelStr = regexLabelStr;
            this.defaultRegex = defaultRegex;
        }

        public String getRegexLabelStr() {
            return this.regexLabelStr;
        }

        public String getDefaultRegex() {
            return this.defaultRegex;
        }
    }

    protected static abstract class ItemBox
    extends VBox {
        private DevicePath mOwner;
        private ItemBoxType mBoxType;
        private TextField mRegexTxtField;
        protected HBox mToolbar;
        protected GridPane mOptionsPane;

        public ItemBox(DevicePath owner, ItemBoxType boxType) {
            super(5.0);
            this.setPadding(new Insets(10.0));
            this.mOwner = owner;
            this.mBoxType = boxType;
        }

        public abstract void refresh();

        public abstract int getRegexFlags();

        public String getRegex() {
            String regex = this.mRegexTxtField.getText();
            if (this.mBoxType == ItemBoxType.SELET) {
                regex = this.expandSelectorRegex(regex);
            }
            return regex;
        }

        public void setRegexChangeListener(ChangeListener<String> changeListener) {
            this.mRegexTxtField.textProperty().addListener(changeListener);
        }

        protected void init() {
            this.initOwnerBox();
            this.initOptionsBox();
            this.initListView();
        }

        private void initOwnerBox() {
            Device ownerDev = this.getOwnerDev();
            String labelStr = ownerDev == null ? this.getOwnerDevT().getName() : ownerDev.getName();
            Label ownerLabel = new Label(labelStr);
            this.getChildren().add((Object)ownerLabel);
            this.getChildren().add((Object)new Separator());
        }

        private void initOptionsBox() {
            this.mOptionsPane = new GridPane();
            this.mOptionsPane.setAlignment(Pos.CENTER_LEFT);
            this.mOptionsPane.setHgap(2.0);
            this.mOptionsPane.setVgap(2.0);
            this.initOptionsPaneContext();
            ItemBox.setVgrow((Node)this.mOptionsPane, (Priority)Priority.NEVER);
            this.getChildren().add((Object)this.mOptionsPane);
        }

        protected void initOptionsPaneContext() {
            this.initRegexBox();
        }

        private void initRegexBox() {
            Label regexLabel = new Label(this.getRegexLabelStr());
            regexLabel.setMinWidth(Double.NEGATIVE_INFINITY);
            HBox.setHgrow((Node)regexLabel, (Priority)Priority.NEVER);
            this.mOptionsPane.add((Node)regexLabel, 0, 0);
            this.mRegexTxtField = new TextField();
            this.mRegexTxtField.setText(this.getDefaultRegex());
            this.mRegexTxtField.setPrefWidth(80.0);
            GridPane.setHgrow((Node)this.mRegexTxtField, (Priority)Priority.ALWAYS);
            this.mOptionsPane.add((Node)this.mRegexTxtField, 1, 0);
            this.mToolbar = new HBox();
            this.loadToolbarBtns();
            GridPane.setHgrow((Node)this.mToolbar, (Priority)Priority.NEVER);
            this.mOptionsPane.add((Node)this.mToolbar, 2, 0);
        }

        protected abstract void initListView();

        protected void loadToolbarBtns() {
            AJFXButton patternHelpBtn = AJFXButton.createHelpButton((String)"http://docs.oracle.com/javase/6/docs/api/java/util/regex/Pattern.html#sum", (String)"Help");
            patternHelpBtn.transparentBorder();
            this.mToolbar.getChildren().add((Object)patternHelpBtn);
        }

        protected Device getOwnerDev() {
            return this.mOwner.getDevice();
        }

        protected DeviceTemplate getOwnerDevT() {
            return this.mOwner.getDeviceTemplate();
        }

        private String getRegexLabelStr() {
            return this.mBoxType.getRegexLabelStr();
        }

        private String getDefaultRegex() {
            return this.mBoxType.getDefaultRegex();
        }

        private String expandSelectorRegex(String selectorRegex) {
            if (!(selectorRegex.contains("\\") || selectorRegex.contains(".") || selectorRegex.contains("[") || selectorRegex.contains("$"))) {
                return String.format("%s.*", selectorRegex);
            }
            return selectorRegex;
        }
    }

    protected static class NewNameBox
    extends ItemBox {
        private AListView<String> mListView;

        public NewNameBox(DevicePath owner) {
            super(owner, ItemBoxType.NEW);
            this.init();
        }

        public void setItems(List<String> items) {
            ObservableList observableList = FXCollections.observableArrayList(items);
            this.mListView.setItems(observableList);
        }

        public void setListViewMouseClickHandler(EventHandler<MouseEvent> eventHandler) {
            this.mListView.setOnMouseClicked(eventHandler);
        }

        public void setListViewSelectionChangeListener(ChangeListener<? super String> changeListener) {
            this.mListView.getSelectionModel().selectedItemProperty().addListener(changeListener);
        }

        public String getSelectedItem() {
            return (String)this.mListView.getSelectionModel().getSelectedItem();
        }

        public void select(String item) {
            this.mListView.getSelectionModel().select((Object)item);
        }

        @Override
        public void refresh() {
            this.mListView.refresh();
        }

        @Override
        public int getRegexFlags() {
            return 0;
        }

        public void scrollToSelection() {
            this.mListView.scrollToSelection();
        }

        @Override
        protected void initListView() {
            this.mListView = new AListView();
            this.mListView.setCachedCellFactory(this.getItemListCellFactory());
            NewNameBox.setVgrow(this.mListView, (Priority)Priority.ALWAYS);
            this.getChildren().add(this.mListView);
        }

        private Callback<ListView<String>, ListCell<String>> getItemListCellFactory() {
            return termList -> new ListCell<String>(){

                protected void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (item == null || empty) {
                        this.setText(null);
                        this.setStyle(this.getStyle());
                        return;
                    }
                    if (this.isSelected()) {
                        this.setStyle(ItemBoxs.SELECTED_HIGHLIGHT_STYLE);
                    } else {
                        this.setStyle(ItemBoxs.HIGHLIGHT_STYLE);
                    }
                    this.setText(item);
                }
            };
        }
    }

    protected static abstract class ObjItemBox<T extends DbObject>
    extends ItemBox {
        private List<BulkHelper.StringGetter<T>> mShowedStrGetters;
        private FilteredList<T> mFilteredList;
        private AListView<T> mListView;
        private HBox mProgressBox;
        private ProgressBar mProgressBar;
        private ComboBox<BulkHelper.StringGetter<T>> mShowedStrGettersComboBox;
        private CheckBox mIngoreCaseCheckBox;
        private HighLighter<T> mHighLighter;
        private List<Pattern> mFilterPatterns;
        private Task<Void> mSearchMacthedTask;
        private Set<T> mIncludedItems;
        private AJFXMenuButton mFilterMenuBtn;

        public ObjItemBox(DevicePath owner, ItemBoxType boxType, List<BulkHelper.StringGetter<T>> showedStrGetters) {
            super(owner, boxType);
            this.mShowedStrGetters = showedStrGetters;
        }

        protected abstract void loadFilterMenuItems();

        @Override
        public void refresh() {
            this.mListView.refresh();
        }

        @Override
        protected void init() {
            super.init();
            this.initIngoreCaseMatch();
        }

        @Override
        protected void loadToolbarBtns() {
            this.mFilterMenuBtn = new AJFXMenuButton(OrbitJFXImages.FILTER_TABLE, "Filter");
            this.mFilterMenuBtn.transparentBorder();
            this.loadFilterMenuItems();
            this.mToolbar.getChildren().add((Object)this.mFilterMenuBtn);
            super.loadToolbarBtns();
        }

        protected void addFilterMenuItem(List<MenuItem> menuItems) {
            this.mFilterMenuBtn.getItems().addAll(menuItems);
        }

        public void scrollToSelection() {
            this.mListView.scrollToSelection();
        }

        public void refreshSearchMatchedTask() {
            this.setFilterPattern(this.mFilterPatterns);
        }

        public void setFilterPattern(List<Pattern> patterns) {
            this.cancelBackgroundTask();
            this.mProgressBox.setVisible(true);
            this.mListView.setVisible(false);
            this.mIncludedItems = null;
            this.mFilterPatterns = patterns;
            this.startNewSearchMatchedTask();
        }

        public void cancelBackgroundTask() {
            if (this.mSearchMacthedTask != null && this.mSearchMacthedTask.isRunning()) {
                this.mSearchMacthedTask.cancel(true);
            }
        }

        public void setShowedStrGettersComboBoxListener(EventHandler<ActionEvent> changeListener) {
            if (this.mShowedStrGettersComboBox != null) {
                this.mShowedStrGettersComboBox.setOnAction(changeListener);
            }
        }

        public void setIngoreCaseChangeListener(EventHandler<ActionEvent> changeListener) {
            if (this.mIngoreCaseCheckBox != null) {
                this.mIngoreCaseCheckBox.setOnAction(changeListener);
            }
        }

        public void setFilterMenuHideAction(EventHandler<Event> changeListener) {
            if (this.mFilterMenuBtn != null) {
                this.mFilterMenuBtn.setOnHidden(changeListener);
            }
        }

        @Override
        public int getRegexFlags() {
            int flags = 0;
            if (this.isIgnoreCase()) {
                flags |= 2;
            }
            return flags;
        }

        private boolean isIgnoreCase() {
            return this.mIngoreCaseCheckBox != null && this.mIngoreCaseCheckBox.isSelected();
        }

        @Override
        protected void initOptionsPaneContext() {
            super.initOptionsPaneContext();
            this.initShowedStrGettersComboBox();
        }

        private void initShowedStrGettersComboBox() {
            if (this.mShowedStrGetters.size() < 2) {
                return;
            }
            Label label = new Label("From: ");
            this.mOptionsPane.add((Node)label, 0, 1);
            this.mShowedStrGettersComboBox = new ComboBox();
            this.mShowedStrGettersComboBox.setMaxWidth(Double.MAX_VALUE);
            this.mShowedStrGettersComboBox.getItems().addAll(this.mShowedStrGetters);
            this.mShowedStrGettersComboBox.getSelectionModel().select(0);
            GridPane.setHgrow(this.mShowedStrGettersComboBox, (Priority)Priority.ALWAYS);
            this.mOptionsPane.add(this.mShowedStrGettersComboBox, 1, 1);
        }

        private void initIngoreCaseMatch() {
            this.mIngoreCaseCheckBox = new CheckBox("Case insensitive match");
            this.getChildren().add((Object)this.mIngoreCaseCheckBox);
        }

        private void startNewSearchMatchedTask() {
            this.mSearchMacthedTask = new Task<Void>(){

                public Void call() {
                    if (mFilterPatterns == null || mFilterPatterns.isEmpty()) {
                        return null;
                    }
                    List items = this.getItems();
                    int itemCount = items.size();
                    int curIndex = 0;
                    mIncludedItems = new HashSet();
                    String combinePatternStr = null;
                    for (Pattern pattern : mFilterPatterns) {
                        String patternStr = pattern.pattern();
                        if (combinePatternStr == null) {
                            combinePatternStr = patternStr;
                            continue;
                        }
                        combinePatternStr = String.format("%s|(%s)", combinePatternStr, patternStr);
                    }
                    Pattern combinePattern = Pattern.compile(combinePatternStr, this.getRegexFlags());
                    for (DbObject item : items) {
                        String itemStr;
                        if (!this.isVisibleItem(item) || (itemStr = this.getShowedStr(item)) == null) continue;
                        try {
                            if (combinePattern.matcher(itemStr).matches()) {
                                mIncludedItems.add(item);
                            }
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            // empty catch block
                        }
                        this.updateProgress(++curIndex, itemCount);
                    }
                    return null;
                }
            };
            this.mProgressBar.progressProperty().bind((ObservableValue)this.mSearchMacthedTask.progressProperty());
            this.mSearchMacthedTask.addEventHandler(WorkerStateEvent.WORKER_STATE_SUCCEEDED, t -> {
                this.mFilteredList.setPredicate(this::isIncludeItem);
                this.mProgressBox.setVisible(false);
                this.mListView.setVisible(true);
            });
            new Thread((Runnable)this.mSearchMacthedTask).start();
        }

        public void setHighLighter(HighLighter<T> highLighter) {
            this.mHighLighter = highLighter;
        }

        public IterableIterator<List<String>> getRegexCapturedValues() {
            if (this.mFilterPatterns == null || this.mFilterPatterns.isEmpty()) {
                return AEmptyItr.create();
            }
            return new NestedIterator<T, List<String>>(this.getItems().iterator()){

                public Iterator<List<String>> getLowerIterator(T item) {
                    final String itemStr = this.getShowedStr(item);
                    if (itemStr == null || !this.isVisibleItem(item)) {
                        return AEmptyItr.create();
                    }
                    return new ProcessingIterator<Pattern, List<String>>(mFilterPatterns.iterator()){

                        protected List<String> process(Pattern pattern) {
                            List<String> capturedValue = BulkHelper.getCapturedValue(pattern, itemStr);
                            return capturedValue.isEmpty() ? null : capturedValue;
                        }
                    };
                }
            };
        }

        public void setListViewSelectionChangeListener(ChangeListener<? super T> changeListener) {
            this.mListView.getSelectionModel().selectedItemProperty().addListener(changeListener);
        }

        public T getSelectedItem() {
            return (T)((DbObject)this.mListView.getSelectionModel().getSelectedItem());
        }

        public void select(T item) {
            this.mListView.getSelectionModel().select(item);
        }

        public BulkHelper.StringGetter<T> getStringGetter() {
            assert (this.mShowedStrGetters != null && !this.mShowedStrGetters.isEmpty());
            if (this.mShowedStrGettersComboBox == null) {
                return this.mShowedStrGetters.get(0);
            }
            return (BulkHelper.StringGetter)this.mShowedStrGettersComboBox.getSelectionModel().getSelectedItem();
        }

        protected String getShowedStr(T item) {
            BulkHelper.StringGetter<T> curShowedStrGetter = this.getStringGetter();
            assert (curShowedStrGetter != null);
            return curShowedStrGetter.getShowedStr(this.getOwnerDev(), item);
        }

        protected abstract List<T> getItems();

        @Override
        protected void initListView() {
            this.mProgressBox = new HBox();
            Label searchLabel = new Label("Searching...");
            searchLabel.setStyle(ItemBoxs.STYLE_BLUE_TEXT);
            this.mProgressBox.getChildren().add((Object)searchLabel);
            this.mProgressBar = new ProgressBar();
            this.mProgressBox.getChildren().add((Object)this.mProgressBar);
            this.getChildren().add((Object)this.mProgressBox);
            this.mFilteredList = new FilteredList(this.getItemsObservableList(), data -> true);
            this.mListView = new AListView(this.mFilteredList);
            this.mListView.setCachedCellFactory(this.getItemListCellFactory());
            ObjItemBox.setVgrow(this.mListView, (Priority)Priority.ALWAYS);
            this.getChildren().add(this.mListView);
        }

        protected boolean isHighLight(T item) {
            return this.mHighLighter == null || this.mHighLighter.isHighLight(item);
        }

        protected ObservableList<T> getItemsObservableList() {
            return FXCollections.observableArrayList(this.getItems());
        }

        protected boolean isIncludeItem(T item) {
            return this.mIncludedItems != null && this.isVisibleItem(item) && this.mIncludedItems.contains(item);
        }

        protected boolean isVisibleItem(T item) {
            return FilterMenuItems.isVisibleItem((List<MenuItem>)this.mFilterMenuBtn.getItems(), item);
        }

        protected IterableIterator<ItemFilters.ItemFilter<T>> getActiveFilters() {
            return new ProcessingIterator<MenuItem, ItemFilters.ItemFilter<T>>(this.mFilterMenuBtn.getItems().iterator()){

                protected ItemFilters.ItemFilter<T> process(MenuItem i) {
                    FilterMenuItems.FilterMenuItem fMenuItem;
                    if (i instanceof FilterMenuItems.FilterMenuItem && (fMenuItem = (FilterMenuItems.FilterMenuItem)i).isSelected()) {
                        return fMenuItem.getFilter();
                    }
                    return null;
                }
            };
        }

        private Callback<ListView<T>, ListCell<T>> getItemListCellFactory() {
            return termList -> new ListCell<T>(){

                protected void updateItem(T item, boolean empty) {
                    super.updateItem(item, empty);
                    if (item == null || empty) {
                        this.setText(null);
                        this.setStyle(this.getStyle());
                        return;
                    }
                    if (this.isHighLight(item)) {
                        if (this.isSelected()) {
                            this.setStyle(ItemBoxs.SELECTED_HIGHLIGHT_STYLE);
                        } else {
                            this.setStyle(ItemBoxs.HIGHLIGHT_STYLE);
                        }
                    } else {
                        this.setStyle(this.getStyle());
                    }
                    this.setText(this.getShowedStr(item));
                }
            };
        }
    }

    protected static class BumpBox
    extends ObjItemBox<Device> {
        private List<Device> items;

        public BumpBox(DevicePath owner, ItemBoxType boxType) {
            this(owner, boxType, (List<Device>)null);
        }

        public BumpBox(DevicePath owner, ItemBoxType boxType, List<Device> userItems) {
            this(owner, boxType, userItems, AUtil.arrayList((Object[])new BulkHelper.StringGetter[]{BulkHelper.BumpStringGetter}));
        }

        public BumpBox(DevicePath owner, ItemBoxType boxType, List<Device> userItems, List<BulkHelper.StringGetter<Device>> stringGetters) {
            super(owner, boxType, stringGetters);
            this.items = userItems;
            this.init();
        }

        @Override
        public List<Device> getItems() {
            if (this.items == null) {
                this.items = AUtil.sort((IterableIterator)this.getOwnerDevT().getChildren(DeviceFilters.FILTER_BUMP), (Comparator)Device.CompareName);
            }
            return this.items;
        }

        @Override
        protected void loadFilterMenuItems() {
            this.addFilterMenuItem(FilterMenuItems.getBumpFilterMenuItems());
        }
    }

    protected static class NetBox
    extends ObjItemBox<Net> {
        private List<Net> items;

        public NetBox(DevicePath owner, ItemBoxType boxType) {
            this(owner, boxType, (List<Net>)null);
        }

        public NetBox(DevicePath owner, ItemBoxType boxType, List<Net> userNets) {
            super(owner, boxType, AUtil.arrayList((Object[])new BulkHelper.StringGetter[]{BulkHelper.NetStringGetter}));
            this.items = userNets;
            this.init();
        }

        @Override
        public List<Net> getItems() {
            if (this.items == null) {
                this.items = AUtil.sort((IterableIterator)this.getOwnerDevT().getNets(false), (Comparator)Net.NameComparator);
            }
            return this.items;
        }

        @Override
        protected void loadFilterMenuItems() {
            this.addFilterMenuItem(FilterMenuItems.getNetFilterMenuItems());
        }
    }

    protected static class TermBox
    extends ObjItemBox<Term> {
        private List<Term> items;

        public TermBox(DevicePath owner, ItemBoxType boxType) {
            this(owner, boxType, (List<Term>)null);
        }

        public TermBox(DevicePath owner, ItemBoxType boxType, List<Term> userTerms) {
            this(owner, boxType, userTerms, AUtil.arrayList((Object[])new BulkHelper.StringGetter[]{BulkHelper.TermStringGetter}));
        }

        public TermBox(DevicePath owner, ItemBoxType boxType, List<Term> userTerms, List<BulkHelper.StringGetter<Term>> showedStrGetters) {
            super(owner, boxType, showedStrGetters);
            this.items = userTerms;
            this.init();
        }

        @Override
        public List<Term> getItems() {
            if (this.items == null) {
                this.items = AUtil.sort((IterableIterator)this.getOwnerDevT().getTerms(), (Comparator)Term.NAME_COMPARATOR);
            }
            return this.items;
        }

        @Override
        protected void loadFilterMenuItems() {
            this.addFilterMenuItem(FilterMenuItems.getTermFilterMenuItems());
        }
    }
}

