/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.Net2TermBulkCreate;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class Net2TermBulkCreateUI
extends BulkCreateUI<Net> {
    private static final String TITLE = "Bulk Create Terms from Nets";

    public static Net2TermBulkCreateUI showUI(Window owner, Db db, String devPathStr) {
        DevicePath devPath = DevicePath.fromString((Db)db, (String)devPathStr);
        if (devPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devPathStr});
            return null;
        }
        return Net2TermBulkCreateUI.showUI(owner, devPath);
    }

    public static Net2TermBulkCreateUI showUI(Window owner, DevicePath devPath) {
        Net2TermBulkCreateUI dlg = new Net2TermBulkCreateUI(owner, devPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected Net2TermBulkCreateUI(Window owner, DevicePath devPath) {
        super(owner, TITLE, devPath);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new Net2TermBulkCreatePanel();
    }

    protected class Net2TermBulkCreatePanel
    extends BulkCreateUI.BulkCreatePanel {
        protected Net2TermBulkCreatePanel() {
        }

        protected ItemBoxs.ObjItemBox<Net> newSelectedBox() {
            return new ItemBoxs.NetBox(Net2TermBulkCreateUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(Net2TermBulkCreateUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)Net2TermBulkCreateUI.this.getDb(), (String)"Bulk create nets from terms");){
                    this.cpBulkCreate(Net2TermBulkCreate.class);
                }
                UIUtil.closeWindow((Window)((Object)Net2TermBulkCreateUI.this));
            });
        }
    }
}

