/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.ParentNet2ChildTermBulkCreate;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class ParentNet2ChildTermBulkCreateUI
extends BulkCreateUI<Net> {
    private static final String TITLE = "Bulk Create From Parent Nets";

    public static ParentNet2ChildTermBulkCreateUI showUI(Window owner, Db db, String childDevPathStr) {
        DevicePath childDevPath = DevicePath.fromString((Db)db, (String)childDevPathStr);
        if (childDevPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{childDevPathStr});
            return null;
        }
        return ParentNet2ChildTermBulkCreateUI.showUI(owner, childDevPath);
    }

    public static ParentNet2ChildTermBulkCreateUI showUI(Window owner, DevicePath childDevPath) {
        ParentNet2ChildTermBulkCreateUI dlg = new ParentNet2ChildTermBulkCreateUI(owner, childDevPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected ParentNet2ChildTermBulkCreateUI(Window owner, DevicePath childDevPath) {
        super(owner, TITLE, childDevPath);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new ChildTerm2ParentNetBulkCreatePanel();
    }

    protected class ChildTerm2ParentNetBulkCreatePanel
    extends BulkCreateUI.BulkCreatePanel {
        protected ChildTerm2ParentNetBulkCreatePanel() {
        }

        protected ItemBoxs.ObjItemBox<Net> newSelectedBox() {
            return new ItemBoxs.NetBox(ParentNet2ChildTermBulkCreateUI.this.getParentDevPath(), ItemBoxs.ItemBoxType.SELET);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(ParentNet2ChildTermBulkCreateUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)ParentNet2ChildTermBulkCreateUI.this.getDb(), (String)"Bulk create parent nets from child terms");){
                    this.cpBulkCreate(ParentNet2ChildTermBulkCreate.class);
                }
                UIUtil.closeWindow((Window)((Object)ParentNet2ChildTermBulkCreateUI.this));
            });
        }
    }
}

