/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.ParentTerm2ChildTermBulkCreate;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class ParentTerm2ChildTermBulkCreateUI
extends BulkCreateUI<Term> {
    private static final String TITLE = "Bulk Create From Parent Terms";

    public static ParentTerm2ChildTermBulkCreateUI showUI(Window owner, Db db, String childDevPathStr) {
        DevicePath childDevPath = DevicePath.fromString((Db)db, (String)childDevPathStr);
        if (childDevPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{childDevPathStr});
            return null;
        }
        return ParentTerm2ChildTermBulkCreateUI.showUI(owner, childDevPath);
    }

    public static ParentTerm2ChildTermBulkCreateUI showUI(Window owner, DevicePath childDevPath) {
        ParentTerm2ChildTermBulkCreateUI dlg = new ParentTerm2ChildTermBulkCreateUI(owner, childDevPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected ParentTerm2ChildTermBulkCreateUI(Window owner, DevicePath childDevPath) {
        super(owner, TITLE, childDevPath);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new ChildTerm2ParentNetBulkCreatePanel();
    }

    protected class ChildTerm2ParentNetBulkCreatePanel
    extends BulkCreateUI.BulkCreatePanel {
        protected ChildTerm2ParentNetBulkCreatePanel() {
        }

        protected ItemBoxs.ObjItemBox<Term> newSelectedBox() {
            return new ItemBoxs.TermBox(ParentTerm2ChildTermBulkCreateUI.this.getParentDevPath(), ItemBoxs.ItemBoxType.SELET);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(ParentTerm2ChildTermBulkCreateUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)ParentTerm2ChildTermBulkCreateUI.this.getDb(), (String)"Bulk create parent nets from child terms");){
                    this.cpBulkCreate(ParentTerm2ChildTermBulkCreate.class);
                }
                UIUtil.closeWindow((Window)((Object)ParentTerm2ChildTermBulkCreateUI.this));
            });
        }
    }
}

