/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.Term2NetBulkCreate;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class Term2NetBulkCreateUI
extends BulkCreateUI<Term> {
    private static final String TITLE = "Bulk Rename Terms";

    public static Term2NetBulkCreateUI showUI(Window owner, Db db, String childDevPathStr) {
        DevicePath childDevPath = DevicePath.fromString((Db)db, (String)childDevPathStr);
        if (childDevPath == null) {
            ALog.logError((String)"DevicePath '%s' does not exist", (Object[])new Object[]{childDevPathStr});
            return null;
        }
        return Term2NetBulkCreateUI.showUI(owner, childDevPath);
    }

    public static Term2NetBulkCreateUI showUI(Window owner, DevicePath childDevPath) {
        Term2NetBulkCreateUI dlg = new Term2NetBulkCreateUI(owner, childDevPath);
        dlg.setVisible(true);
        return dlg;
    }

    protected Term2NetBulkCreateUI(Window owner, DevicePath childDevPath) {
        super(owner, TITLE, childDevPath);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new BulkTerm2NetPanel();
    }

    protected class BulkTerm2NetPanel
    extends BulkCreateUI.BulkCreatePanel {
        protected BulkTerm2NetPanel() {
        }

        protected ItemBoxs.ObjItemBox<Term> newSelectedBox() {
            return new ItemBoxs.TermBox(Term2NetBulkCreateUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(Term2NetBulkCreateUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)Term2NetBulkCreateUI.this.getDb(), (String)"Bulk create nets from terms");){
                    this.cpBulkCreate(Term2NetBulkCreate.class);
                }
                UIUtil.closeWindow((Window)((Object)Term2NetBulkCreateUI.this));
            });
        }
    }
}

