/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Window;
import java.util.List;
import java.util.regex.Pattern;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class UserBulkRenameNetUI
extends BulkCreateUI<Net> {
    private static final String TITLE = "Bulk Rename Nets";
    private List<Net> mUserNets;

    public static UserBulkRenameNetUI showUI(Window owner, DevicePath childDevPath, List<Net> userNets) {
        UserBulkRenameNetUI dlg = new UserBulkRenameNetUI(owner, childDevPath, userNets);
        dlg.setVisible(true);
        return dlg;
    }

    protected UserBulkRenameNetUI(Window owner, DevicePath childDevPath, List<Net> userNets) {
        super(owner, TITLE, childDevPath);
        this.mUserNets = userNets;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new BulkRanameNetPanel();
    }

    protected class BulkRanameNetPanel
    extends BulkCreateUI.BulkCreatePanel {
        protected BulkRanameNetPanel() {
        }

        protected ItemBoxs.ObjItemBox<Net> newSelectedBox() {
            return new ItemBoxs.NetBox(UserBulkRenameNetUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET, UserBulkRenameNetUI.this.mUserNets);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(UserBulkRenameNetUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)UserBulkRenameNetUI.this.getDb(), (String)"Bulk rename nets");){
                    Pattern selectorPattern = this.getSelectorPattern(this.getSelectorRegex(), this.getSelectorRegexFlags());
                    for (Net item : AUtil.arrayList(UserBulkRenameNetUI.this.mUserNets)) {
                        String refStr;
                        String newName;
                        if (!this.isVisibleSelectedItem(item) || (newName = this.getNewName(selectorPattern, refStr = this.getSelectorShowedStr(item))) == null || newName.isEmpty() || item.isUnused()) continue;
                        if (this.isNameConflict(selectorPattern, newName)) {
                            ALog.flogWarn((String)"Rename %s to an existing net name '%s'. Merge the net into '%s'.", (Object[])new Object[]{item.getName(), newName, newName});
                            this.cpMergeAndDeleteNet(item, newName);
                            continue;
                        }
                        this.cpNetSetName(item, newName);
                    }
                }
                UIUtil.closeWindow((Window)((Object)UserBulkRenameNetUI.this));
            });
        }

        private void cpNetSetName(Net item, String newName) {
            Cp.exec((String)"%s.setName(\"%s\");", (Object[])new Object[]{CpHelper.getObjCmdStr(item), newName});
        }

        private void cpMergeAndDeleteNet(Net item, String newName) {
            Net newNet = UserBulkRenameNetUI.this.getChildDevT().getNet(newName);
            Cp.exec((String)"%s.mergeAndDelete(%s);", (Object[])new Object[]{CpHelper.getObjCmdStr(newNet), CpHelper.getObjCmdStr(item)});
        }

        private String getNewName(Pattern selectorPattern, String refStr) {
            return BulkHelper.getNewName(selectorPattern, refStr, this.getNewNameRegex());
        }

        private Pattern getSelectorPattern(String regex, int regexFlags) {
            return Pattern.compile(regex, regexFlags);
        }

        private boolean isNameConflict(Pattern selectorPattern, String name) {
            return UserBulkRenameNetUI.this.getChildDev().getTemplate().getNet(name) != null && !this.isRenamedName(selectorPattern, name);
        }

        private boolean isRenamedName(Pattern selectorPattern, String name) {
            String newName = this.getNewName(selectorPattern, name);
            return newName != null && !newName.equals(name);
        }
    }
}

