/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Window;
import java.util.List;
import java.util.regex.Pattern;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class UserBulkRenameTermUI
extends BulkCreateUI<Term> {
    private static final String TITLE = "Bulk Rename Nets";
    private List<Term> mUserTerms;

    public static UserBulkRenameTermUI showUI(Window owner, DevicePath childDevPath, List<Term> userTerms) {
        UserBulkRenameTermUI dlg = new UserBulkRenameTermUI(owner, childDevPath, userTerms);
        dlg.setVisible(true);
        return dlg;
    }

    protected UserBulkRenameTermUI(Window owner, DevicePath childDevPath, List<Term> userTerms) {
        super(owner, TITLE, childDevPath);
        this.mUserTerms = userTerms;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new BulkRanameTermPanel();
    }

    protected class BulkRanameTermPanel
    extends BulkCreateUI.BulkCreatePanel {
        protected BulkRanameTermPanel() {
        }

        protected ItemBoxs.ObjItemBox<Term> newSelectedBox() {
            return new ItemBoxs.TermBox(UserBulkRenameTermUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET, UserBulkRenameTermUI.this.mUserTerms);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(UserBulkRenameTermUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)UserBulkRenameTermUI.this.getDb(), (String)"Bulk rename terms");){
                    Pattern selectorPattern = this.getSelectorPattern(this.getSelectorRegex(), this.getSelectorRegexFlags());
                    for (Term item : AUtil.arrayList(UserBulkRenameTermUI.this.mUserTerms)) {
                        String refStr;
                        String newName;
                        if (!this.isVisibleSelectedItem(item) || (newName = this.getNewName(selectorPattern, refStr = this.getSelectorShowedStr(item))) == null || newName.isEmpty()) continue;
                        if (this.isNameConflict(selectorPattern, newName)) {
                            ALog.flogWarn((String)"Rename %s to an existing term name '%s'. Merge two terms.", (Object[])new Object[]{item.getName(), newName});
                            this.cpMergeAndDeleteTerm(item, newName);
                            continue;
                        }
                        this.cpSetName(item, newName);
                    }
                }
                UIUtil.closeWindow((Window)((Object)UserBulkRenameTermUI.this));
            });
        }

        private void cpMergeAndDeleteTerm(Term item, String newName) {
            Term newTerm = UserBulkRenameTermUI.this.getChildDevT().getTerm(newName);
            Cp.exec((String)"%s.mergeAndDelete(%s)", (Object[])new Object[]{CpHelper.getObjCmdStr(newTerm), CpHelper.getObjCmdStr(item)});
        }

        private void cpSetName(Term item, String newName) {
            Cp.exec((String)"%s.setName(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(item), newName});
        }

        private String getNewName(Pattern selectorPattern, String refStr) {
            return BulkHelper.getNewName(selectorPattern, refStr, this.getNewNameRegex());
        }

        private Pattern getSelectorPattern(String regex, int regexFlags) {
            return Pattern.compile(regex, regexFlags);
        }

        private boolean isNameConflict(Pattern selectorPattern, String name) {
            return UserBulkRenameTermUI.this.getChildDev().getTemplate().getTerm(name) != null && !this.isRenamedName(selectorPattern, name);
        }

        private boolean isRenamedName(Pattern selectorPattern, String name) {
            String newName = this.getNewName(selectorPattern, name);
            return newName != null && !newName.equals(name);
        }
    }
}

