/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.bump.BumpSelectedInfo;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class UserBump2TermBulkCreateUI
extends BulkCreateUI<Device> {
    private static final String TITLE = "Bulk Create Terms from Bumps";
    private final List<Device> mUserItems;
    private final Map<DeviceTemplate, BumpSelectedInfo> mBumpDevT2SelectedInfo;

    public static UserBump2TermBulkCreateUI showUI(Window owner, DevicePath devPath, List<Device> userItems, Map<DeviceTemplate, BumpSelectedInfo> bumpDevT2SelectedInfo) {
        UserBump2TermBulkCreateUI dlg = new UserBump2TermBulkCreateUI(owner, devPath, userItems, bumpDevT2SelectedInfo);
        dlg.setVisible(true);
        return dlg;
    }

    protected UserBump2TermBulkCreateUI(Window owner, DevicePath devPath, List<Device> userItems, Map<DeviceTemplate, BumpSelectedInfo> bumpDevT2SelectedInfo) {
        super(owner, TITLE, devPath);
        this.mUserItems = userItems;
        this.mBumpDevT2SelectedInfo = bumpDevT2SelectedInfo;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new UserNet2TermBulkCreatePanel();
    }

    protected class UserNet2TermBulkCreatePanel
    extends BulkCreateUI.BulkCreatePanel {
        protected UserNet2TermBulkCreatePanel() {
        }

        protected ItemBoxs.ObjItemBox<Device> newSelectedBox() {
            ArrayList stringGetters = AUtil.arrayList((Object[])new BulkHelper.StringGetter[]{BulkHelper.BumpStringGetter, BulkHelper.BumpNetStringGetter});
            return new ItemBoxs.BumpBox(UserBump2TermBulkCreateUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET, UserBump2TermBulkCreateUI.this.mUserItems, stringGetters);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(UserBump2TermBulkCreateUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)UserBump2TermBulkCreateUI.this.getDb(), (String)"Bulk create nets from terms");){
                    Pattern selectorPattern = this.getSelectorPattern(this.getSelectorRegex(), this.getSelectorRegexFlags());
                    for (Device item : UserBump2TermBulkCreateUI.this.mUserItems) {
                        String refStr;
                        String newName;
                        if (!this.isVisibleSelectedItem(item) || (newName = this.getNewName(selectorPattern, refStr = this.getSelectorShowedStr(item))) == null || newName.isEmpty()) continue;
                        this.cpCreateTerm(newName, item);
                    }
                }
                UIUtil.closeWindow((Window)((Object)UserBump2TermBulkCreateUI.this));
            });
        }

        private String getNewName(Pattern selectorPattern, String refStr) {
            return BulkHelper.getNewName(selectorPattern, refStr, this.getNewNameRegex());
        }

        private Pattern getSelectorPattern(String regex, int regexFlags) {
            return Pattern.compile(regex, regexFlags);
        }

        private void cpCreateTerm(String name, Device bumpDev) {
            DeviceTemplate bumpDevT = bumpDev.getTemplate();
            BumpSelectedInfo bumpSelectedInfo = UserBump2TermBulkCreateUI.this.mBumpDevT2SelectedInfo.get(bumpDevT);
            Term bumpTerm = bumpSelectedInfo == null ? bumpDevT.getTerm() : bumpSelectedInfo.getTerm();
            Cp.exec((String)"com.sigrity.orbit.term.Bump2Term.execute(%s, %s, \"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(bumpDev), CpHelper.getObjCmdStr(bumpTerm), name});
        }
    }
}

