/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.bulk;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.term.BulkHelper;
import com.sigrity.orbit.ui.bulk.BulkCreateUI;
import com.sigrity.orbit.ui.bulk.ItemBoxs;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Window;
import java.util.List;
import java.util.regex.Pattern;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.SwingUtilities;

public class UserNet2TermBulkCreateUI
extends BulkCreateUI<Net> {
    private static final String TITLE = "Bulk Create Terms from Nets";
    private List<Net> mUserNets;

    public static UserNet2TermBulkCreateUI showUI(Window owner, DevicePath devPath, List<Net> userNets) {
        UserNet2TermBulkCreateUI dlg = new UserNet2TermBulkCreateUI(owner, devPath, userNets);
        dlg.setVisible(true);
        return dlg;
    }

    protected UserNet2TermBulkCreateUI(Window owner, DevicePath devPath, List<Net> userNets) {
        super(owner, TITLE, devPath);
        this.mUserNets = userNets;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new UserNet2TermBulkCreatePanel();
    }

    protected class UserNet2TermBulkCreatePanel
    extends BulkCreateUI.BulkCreatePanel {
        protected UserNet2TermBulkCreatePanel() {
        }

        protected ItemBoxs.ObjItemBox<Net> newSelectedBox() {
            return new ItemBoxs.NetBox(UserNet2TermBulkCreateUI.this.getChildDevPath(), ItemBoxs.ItemBoxType.SELET, UserNet2TermBulkCreateUI.this.mUserNets);
        }

        @Override
        protected ItemBoxs.NewNameBox newNewItemBox() {
            return new ItemBoxs.NewNameBox(UserNet2TermBulkCreateUI.this.getChildDevPath());
        }

        @Override
        protected EventHandler<ActionEvent> getOkHandler() {
            return e -> SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)UserNet2TermBulkCreateUI.this.getDb(), (String)"Bulk create nets from terms");){
                    Pattern selectorPattern = this.getSelectorPattern(this.getSelectorRegex(), this.getSelectorRegexFlags());
                    for (Net item : UserNet2TermBulkCreateUI.this.mUserNets) {
                        String refStr;
                        String newName;
                        if (!this.isVisibleSelectedItem(item) || (newName = this.getNewName(selectorPattern, refStr = this.getSelectorShowedStr(item))) == null || newName.isEmpty()) continue;
                        this.cpCreateTerm(newName, item);
                    }
                }
                UIUtil.closeWindow((Window)((Object)UserNet2TermBulkCreateUI.this));
            });
        }

        private String getNewName(Pattern selectorPattern, String refStr) {
            return BulkHelper.getNewName(selectorPattern, refStr, this.getNewNameRegex());
        }

        private Pattern getSelectorPattern(String regex, int regexFlags) {
            return Pattern.compile(regex, regexFlags);
        }

        private void cpCreateTerm(String name, Net net) {
            Cp.exec((String)"Term.create(\"%s\", %s)", (Object[])new Object[]{name, CpHelper.getObjCmdStr(net)});
        }
    }
}

