/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APlatformUtil;
import com.sigrity.acl.AStream;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.ASeparator;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DbObjectHighlighter;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.canvas_modes.InspectMode;
import com.sigrity.orbit.ui.canvas_modes.RulerMode;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class AbstractViewMode
implements DesignView2D.ViewMode {
    public static final int MaxMenuItems = 100;
    protected static final Paint UndefPaint = AbstractViewMode.getUndefPaint();
    protected ContextMenu mContextMenu = null;
    protected MouseHandler mMouseHandler = this.createMouseHandler();
    protected MouseWheelHandler mMouseWheelHandler = this.createMouseWheelHandler();
    protected KeyListener mKeyHandler = this.createKeyHandler();
    protected int mModifiers = 0;
    protected DesignView2D.MouseAction mMouseAction = null;
    protected DesignView2D mView;
    protected NAVMODE mNavMode = NAVMODE.NONE;
    protected Point mNavStart;
    protected Point mNavCurrent;
    protected ZOOMDIR mZoomDir = ZOOMDIR.IN;
    protected Image mPanImage = null;
    protected static Point mLastInspectedPoint = null;
    protected LinkedList<ViewModeListener> mViewModeListeners = new LinkedList();
    protected JComponent mOverlay = new JComponent(){
        {
            this.setDoubleBuffered(false);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            DesignCanvas2D d2d;
            super.paintComponent(graphics);
            if (AbstractViewMode.this.mOverlay == null) {
                return;
            }
            Graphics2D g = (Graphics2D)graphics;
            DesignView2D v2d = AbstractViewMode.this.getView();
            if (v2d == null) {
                AbstractViewMode.this.mView = v2d = (DesignView2D)OrbitIO.getCurView();
            }
            DesignCanvas2D designCanvas2D = d2d = v2d == null ? null : v2d.getCanvas();
            if (d2d == null) {
                ALog.logWarn((Throwable)new IllegalStateException("Attempt to draw overlay in invalid state, getView() is null."));
                return;
            }
            try (DesignCanvas2D.BaseScale scale = d2d.openIdentityScale(g);){
                Rectangle bounds = UIUtil.getBoundsMinusInsets((JComponent)AbstractViewMode.this.mOverlay);
                bounds = DesignCanvas2D.scaleRect(bounds, scale.getScale());
                bounds = SwingUtilities.convertRectangle(this, bounds, AbstractViewMode.this.mOverlay);
                g.setClip(bounds);
                AbstractViewMode.this.paintOverlay(g, bounds);
            }
        }
    };
    protected UserInfoWindow mUserInfoWindow = null;

    private static Paint getUndefPaint() {
        int side = 20;
        Color c1 = Color.GRAY;
        Color c2 = Color.LIGHT_GRAY;
        Rectangle r = new Rectangle(side, side);
        BufferedImage i = new BufferedImage(side * 2, side * 2, 1);
        Graphics2D g = i.createGraphics();
        g.setColor(c1);
        g.fillRect(0, 0, side * 2, side * 2);
        g.setColor(c2);
        g.fillRect(0, side, side, side);
        g.fillRect(side, 0, side, side);
        g.dispose();
        return new TexturePaint(i, r);
    }

    public static Point getLastInspectedPoint() {
        return mLastInspectedPoint;
    }

    protected void installedMode() {
        for (ViewModeListener l : AUtil.linkedList(this.mViewModeListeners)) {
            l.modeInstalled();
        }
        this.mView.getCanvas().requestFocusInWindow();
    }

    protected void removingMode() {
    }

    public boolean isNavigationInProgress() {
        return this.mNavMode != NAVMODE.NONE || this.mMouseWheelHandler.isZoomPending();
    }

    @Override
    public void installMode(DesignView2D view) {
        this.mView = view;
        this.mView.addOverlay(this.mOverlay);
        try {
            if (this.getName().toLowerCase().contains("select") && this.mView.getColorizer().getUseArrowCursorForSelectModes()) {
                this.mOverlay.setCursor(Cursor.getDefaultCursor());
            } else {
                this.mOverlay.setCursor(this.getCursor());
            }
        }
        catch (Exception e) {
            ALog.logWarn((String)"Error setting cursor for mode.");
        }
        this.mView.getCanvas().addMouseListener(this.mMouseHandler);
        this.mView.getCanvas().addMouseMotionListener(this.mMouseHandler);
        this.mView.getCanvas().addMouseWheelListener(this.mMouseWheelHandler);
        this.mView.getCanvas().addKeyListener(this.mKeyHandler);
        this.installedMode();
    }

    @Override
    public void uninstallMode() {
        this.clearInformUser();
        this.endNavMode();
        try {
            this.removingMode();
        }
        catch (Exception e) {
            ALog.logWarn((Throwable)e, (String)"Exception while removing mode, the mode may not have been properly uninstalled.", (Object[])new Object[0]);
        }
        if (this.mView != null && this.mView.getCanvas() != null) {
            this.mView.getCanvas().removeMouseMotionListener(this.mMouseHandler);
            this.mView.getCanvas().removeMouseListener(this.mMouseHandler);
            this.mView.getCanvas().removeKeyListener(this.mKeyHandler);
        }
        if (this.mContextMenu != null) {
            this.mContextMenu.setVisible(false);
        }
        this.mContextMenu = null;
        if (this.mView != null) {
            this.mView.removeOverlay(this.mOverlay);
        }
        this.mView = null;
        for (ViewModeListener l : AUtil.linkedList(this.mViewModeListeners)) {
            l.modeUninstalled();
        }
    }

    public void addViewModeListener(ViewModeListener l) {
        this.mViewModeListeners.add(l);
    }

    public boolean removeViewModeListener(ViewModeListener l) {
        return this.mViewModeListeners.remove(l);
    }

    public void mouseEntered(DesignView2D.MouseAction e) {
    }

    public void mouseExited(DesignView2D.MouseAction e) {
    }

    public void mouseMoved(DesignView2D.MouseAction e) {
    }

    public void mousePressed(DesignView2D.MouseAction e) {
        this.clearInformUser();
        if (SwingUtilities.isMiddleMouseButton(e)) {
            if (e.isControlDown() || APlatformUtil.isMacPlatform() && e.isMetaDown()) {
                this.mNavMode = NAVMODE.ZOOM;
            } else {
                this.mNavMode = NAVMODE.PAN;
                this.mPanImage = this.mView.getCanvas().getImage(true);
            }
            this.mNavStart = e.getPoint();
            this.mNavCurrent = null;
        } else if (SwingUtilities.isRightMouseButton(e)) {
            this.mNavMode = NAVMODE.ZOOM;
            this.mNavStart = e.getPoint();
            this.mNavCurrent = null;
        }
    }

    public void mouseDragged(DesignView2D.MouseAction e) {
        if (this.mNavMode != NAVMODE.NONE) {
            this.mNavCurrent = e.getPoint();
            if (SwingUtilities.isRightMouseButton(e)) {
                this.mZoomDir = ZOOMDIR.IN;
                if (e.isShiftDown()) {
                    this.mZoomDir = ZOOMDIR.OUT;
                }
            } else {
                this.mZoomDir = this.mNavCurrent.getY() < this.mNavStart.getY() ? ZOOMDIR.IN : ZOOMDIR.OUT;
            }
            if (new Date().getTime() - e.getWhen() > 500L) {
                return;
            }
            this.mOverlay.repaint();
        }
    }

    public void mouseReleased(DesignView2D.MouseAction e) {
        if (this.mNavMode == NAVMODE.NONE) {
            return;
        }
        if (new Date().getTime() - e.getWhen() > 500L) {
            this.endNavMode();
            return;
        }
        if (e.getX() == this.mNavStart.x && e.getY() == this.mNavStart.y && this.mNavCurrent == null) {
            this.mView.getCanvas().getXForm().recenter(e.getPoint());
        } else {
            this.mNavCurrent = e.getPoint();
            DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
            APoint2D currentPt = this.mView.getCanvas().getXForm().getWorldPt(this.mNavCurrent);
            APoint2D startPt = this.mView.getCanvas().getXForm().getWorldPt(this.mNavStart);
            DesignCanvas2D canvas = this.mView.getCanvas();
            Point2D.Double s = canvas.getScale(null);
            int dx = (int)((double)(this.mNavCurrent.x - this.mNavStart.x) * s.x);
            int dy = (int)((double)(this.mNavCurrent.y - this.mNavStart.y) * s.y);
            if (this.mNavMode == NAVMODE.PAN || this.mNavMode == NAVMODE.ZOOM && dx == 0 && dy == 0) {
                xform.moveWorldBy(-(currentPt.getX() - startPt.getX()), -(currentPt.getY() - startPt.getY()));
            } else if (this.mNavMode == NAVMODE.ZOOM) {
                Rectangle r = new Rectangle(this.mNavStart);
                r.add(this.mNavCurrent);
                if (r.height == 0) {
                    r.height = 1;
                }
                if (r.width == 0) {
                    r.width = 1;
                }
                ARect zr = xform.getWorldRect(r);
                if (this.mZoomDir == ZOOMDIR.IN) {
                    Cp.exec((String)"%s.zoomTo(%s)", (Object[])new Object[]{UserCommands.class.getName(), zr.getAsStringArg()});
                } else {
                    ARect world = new ARect(xform.getWorld());
                    Point scenter = new Point((int)r.getCenterX(), (int)r.getCenterY());
                    world.moveCenterTo(xform.getWorldPt(scenter));
                    double x = (float)zr.width() / (float)world.width() * 4.0f;
                    double y = (float)zr.height() / (float)world.height() * 4.0f;
                    world.changeSizeBy(Math.min(x, y));
                    Cp.exec((String)"%s.zoomTo(%s)", (Object[])new Object[]{UserCommands.class.getName(), world.getAsStringArg()});
                }
            }
        }
        this.endNavMode();
        this.mView.getCanvas().refreshNow();
    }

    public void mouseClicked(DesignView2D.MouseAction e) {
    }

    protected void paintOverlay(Graphics2D g, Rectangle bounds) {
        DesignCanvas2D canvas = this.mView.getCanvas();
        try {
            if (canvas.getColorizer().getUseArrowCursorForSelectModes()) {
                this.mOverlay.setCursor(Cursor.getDefaultCursor());
            } else {
                this.mOverlay.setCursor(this.getCursor());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mMouseWheelHandler.paintOverlay(g, bounds);
        for (RulerMode.Ruler ruler : RulerMode.getRulers()) {
            ruler.update();
            ruler.paint(g);
        }
        if (this.mNavMode == NAVMODE.NONE || this.mNavStart == null || this.mNavCurrent == null) {
            return;
        }
        try (DesignCanvas2D.BaseScale scale = canvas.openIdentityScale(g);){
            Point2D.Double gScale = canvas.getScale(null);
            int dx = (int)((double)(this.mNavCurrent.x - this.mNavStart.x) * gScale.x);
            int dy = (int)((double)(this.mNavCurrent.y - this.mNavStart.y) * gScale.y);
            if (this.mNavMode == NAVMODE.PAN) {
                g.setPaint(UndefPaint);
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                Rectangle viewBounds = canvas.getPaintBounds();
                int panImgW = this.mPanImage.getWidth(null);
                int panImgH = this.mPanImage.getHeight(null);
                if (panImgW > viewBounds.width) {
                    dx -= (panImgW - viewBounds.width) / 2;
                }
                if (panImgH > viewBounds.height) {
                    dy -= (panImgH - viewBounds.height) / 2;
                }
                g.drawImage(this.mPanImage, dx, dy, null);
            } else if (this.mNavMode == NAVMODE.ZOOM) {
                g.setXORMode(Color.WHITE);
                g.setColor(Color.RED);
                Rectangle r = new Rectangle(this.mNavStart);
                r.add(this.mNavCurrent);
                g.drawRect(r.x, r.y, r.width, r.height);
                String sign = this.mZoomDir == ZOOMDIR.IN ? "Zoom In" : "Zoom Out";
                Rectangle2D tb = UIUtil.getTextBounds((Graphics2D)g, (String)sign);
                g.drawString(sign, this.mNavCurrent.x - (int)tb.getWidth() - 3, this.mNavCurrent.y - 1);
            }
        }
    }

    protected KeyHandler createKeyHandler() {
        return new KeyHandler();
    }

    protected MouseHandler createMouseHandler() {
        return new MouseHandler();
    }

    protected MouseWheelHandler createMouseWheelHandler() {
        return new MouseWheelHandler();
    }

    protected DesignView2D.MouseAction startMouseAction(MouseEvent me) {
        this.mMouseAction = this.createMouseAction(me);
        return this.mMouseAction;
    }

    protected DesignView2D.MouseAction getMouseAction() {
        return this.mMouseAction;
    }

    protected void endMouseAction() {
    }

    protected DesignView2D.MouseAction createMouseAction(MouseEvent me) {
        return new DesignView2D.MouseAction(me);
    }

    protected boolean updateModifiers(int newVal) {
        if (this.mModifiers == newVal) {
            return false;
        }
        this.mModifiers = newVal;
        return true;
    }

    protected int getModifiers() {
        return this.mModifiers;
    }

    protected boolean isShiftDown() {
        return UIUtil.isShiftDown((int)this.getModifiers());
    }

    protected boolean isCtrlDown() {
        return UIUtil.isCtrlDown((int)this.getModifiers());
    }

    public static void testWheel(int clicks) {
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        AbstractViewMode m = (AbstractViewMode)v.getCurMode();
        MouseWheelEvent e = new MouseWheelEvent(v, 507, new Date().getTime(), 0, 0, 0, 0, 0, 0, false, 0, clicks, clicks);
        m.mMouseWheelHandler.mouseWheelMoved(e);
    }

    protected void loadContextMenu(ContextMenu menu, Point loc) {
        menu.loadMenu(loc, null);
    }

    protected boolean showContextMenu(JPopupMenu menu, Point loc) {
        menu.show(this.mView.getCanvas(), loc.x, loc.y);
        return true;
    }

    protected void endNavMode() {
        this.mPanImage = null;
        this.mNavMode = NAVMODE.NONE;
        this.mNavStart = null;
        this.mNavCurrent = null;
    }

    public void repaintOverlay() {
        this.repaintOverlay(false);
    }

    public void repaintOverlay(boolean immediate) {
        if (immediate) {
            this.mOverlay.paintImmediately(this.mOverlay.getBounds());
        } else {
            this.mOverlay.repaint();
        }
    }

    public void repaintView() {
        this.mView.getCanvas().refresh();
    }

    public DesignView2D getView() {
        return this.mView;
    }

    public Db getDb() {
        return this.getView() == null ? null : this.getView().getDb();
    }

    public Window getParentWindow() {
        return UIUtil.getParentWindow((Component)this.mView);
    }

    public Component getViewComponent() {
        return this.mView.getComponent();
    }

    public static String getDbObjectName(DbObject dbo) {
        DbFieldDef dbfd;
        DbClass dbc = dbo.getDbClass();
        Class<?> jclass = dbo.getClass();
        Method m = AUtil.getMethod(jclass, (String)"getUserName", (Class[])null);
        if (m != null) {
            try {
                return (String)m.invoke((Object)dbo, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((m = AUtil.getMethod(jclass, (String)"getName", (Class[])null)) != null) {
            try {
                return (String)m.invoke((Object)dbo, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((dbfd = dbc.getField("name")) != null && String.class.isAssignableFrom(dbfd.getFieldClass())) {
            return (String)dbo.getValue("name", String.class);
        }
        return dbo.toString();
    }

    public APoint2D getWorldPoint(MouseEvent e) {
        return this.getWorldPoint(e.getPoint());
    }

    public APoint2D getWorldPoint(Point pt) {
        return this.mView.getCanvas().getXForm().getWorldPt(pt);
    }

    public long getWorldLen(int screenLen) {
        return this.mView.getCanvas().getXForm().getWorldLength(screenLen);
    }

    public long getWorldLen(double userLen) {
        return this.mView.getUnit().fromUser(userLen);
    }

    public Point getScreenPoint(APoint2D world) {
        return this.mView.getCanvas().getXForm().getScreenPt(world);
    }

    public int getScreenLen(long worldLen) {
        return this.mView.getCanvas().getXForm().getScreenLength(worldLen);
    }

    public Rectangle getScreenRect(ARect worldRect) {
        return this.mView.getCanvas().getXForm().getScreenRect(worldRect);
    }

    public Polygon getScreenPolygon(APolygon worldPoly) {
        return this.mView.getCanvas().getXForm().getScreenPolygon(worldPoly);
    }

    public Arc2D getScreenCircle(ACircle worldCircle) {
        return this.mView.getCanvas().getXForm().getScreenCircle(worldCircle);
    }

    public Line2D getScreenLine(ALine l) {
        return this.mView.getCanvas().getXForm().getScreenLine(l);
    }

    protected void informUser(String fmt, Object ... args) {
        this.clearInformUser();
        if (fmt == null) {
            return;
        }
        if (args != null) {
            fmt = String.format(fmt, args);
        }
        this.mUserInfoWindow = new UserInfoWindow(fmt);
    }

    protected void clearInformUser() {
        if (this.mUserInfoWindow != null) {
            this.mUserInfoWindow.close();
            this.mUserInfoWindow = null;
        }
    }

    @Override
    public JPanel getOptionPanel() {
        return null;
    }

    protected class UserInfoWindow
    extends JWindow {
        protected int mMsgTimeoutMillis;
        protected Timer mTimer;

        public UserInfoWindow(String msg) {
            super((Window)UIUtil.getAncestorOfType((Component)AbstractViewMode.this.mView, Window.class));
            this.mMsgTimeoutMillis = 10000;
            this.mTimer = null;
            JLabel txt = new JLabel(msg);
            txt.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            txt.setOpaque(true);
            txt.setBackground((Color)AColor.withAlpha((Color)this.getBackground(), (int)192));
            this.add(txt);
            this.pack();
            Rectangle r = this.getBounds();
            r = AbstractViewMode.this.mView.getBounds();
            Point loc = r.getLocation();
            loc.translate((r.width - this.getWidth()) / 2, (r.height - this.getHeight()) / 2);
            SwingUtilities.convertPointToScreen(loc, AbstractViewMode.this.mView.getParent());
            this.setLocation(loc);
            txt.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    UserInfoWindow.this.close();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    if (UIUtil.getParentWindow((Component)AbstractViewMode.this.mView) != null) {
                        UIUtil.getParentWindow((Component)AbstractViewMode.this.mView).toFront();
                    }
                    UserInfoWindow.this.removeWindowListener(this);
                }
            });
            this.setVisible(true);
            this.mTimer = new Timer(this.mMsgTimeoutMillis, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserInfoWindow.this.close();
                }
            });
            this.mTimer.start();
        }

        public void close() {
            if (this.mTimer != null) {
                this.mTimer.stop();
                this.mTimer = null;
            }
            this.dispose();
        }
    }

    public static class MenuComparator
    implements Comparator<JMenu> {
        @Override
        public int compare(JMenu o1, JMenu o2) {
            return o1.getText().compareTo(o2.getText());
        }
    }

    public static class ActionInspectPoint
    extends AbstractAction {
        Point mP;

        public ActionInspectPoint(Point p) {
            super("Inspect");
            this.mP = p;
            mLastInspectedPoint = p;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignView2D dv = (DesignView2D)OrbitIO.getCurView();
            InspectMode modeInspect = (InspectMode)dv.getMode("InspectMode");
            modeInspect.showInfoForScreenPt(this.mP);
        }
    }

    protected static class OverflowMenuItem
    extends JMenuItem {
        public OverflowMenuItem(String objType, int overflowCount) {
            String text = String.format("Truncated (more than %d %ss)", overflowCount, objType);
            this.setText(text);
            this.setEnabled(false);
        }
    }

    public class ContextMenu
    extends JPopupMenu {
        protected JMenuItem mItemUpdating = new JMenuItem(new ActionUpdateDbObject());
        protected boolean mDelayedMenuEnabled = true;
        protected LinkedList<JMenuItem> mDeferred = new LinkedList();

        @Override
        public void removeNotify() {
            super.removeNotify();
            AbstractViewMode.this.mContextMenu = null;
        }

        public void loadMenu(Point point, OrbitGuiShortcutActionRegistry.ViewConstraint vc) {
            Db db = OrbitIO.getCurDb();
            Selection selection = Design.getSelection((Db)db);
            DesignCanvas2D.XForm canvasXform = AbstractViewMode.this.mView.getCanvas().getXForm();
            APoint2D worldPoint = canvasXform.getWorldPt(point);
            OrbitGuiShortcutActionRegistry sar = OrbitGuiShortcutActionRegistry.get();
            for (Class c : sar.getClasses()) {
                if (vc != null && !vc.contains(c)) continue;
                for (Object obj : sar.getActions(c, db, selection, worldPoint)) {
                    if (obj instanceof Action) {
                        this.deferAdd((Action)obj);
                        continue;
                    }
                    if (!(obj instanceof JMenuItem)) continue;
                    this.deferAdd((JMenuItem)obj);
                }
                this.commitDeffered(sar.getGroupName(c));
            }
            if (this.getComponentCount() > 0) {
                this.add(new JSeparator());
            }
            this.add(new ActionInspectPoint(point));
            JMenuItem item = this.add(AbstractViewMode.this.mView.getCanvas().getActionMap().get("Refresh"));
            UIUtil.setUniqueMnemonic((JPopupMenu)this, (AbstractButton)item);
            item = this.add(AbstractViewMode.this.mView.getCanvas().getActionMap().get("Zoom Previous"));
            UIUtil.setUniqueMnemonic((JPopupMenu)this, (AbstractButton)item);
            item = this.add(AbstractViewMode.this.mView.getCanvas().getActionMap().get("Clear Selection"));
            UIUtil.setUniqueMnemonic((JPopupMenu)this, (AbstractButton)item);
            if (ShowMeTheWay.showMePopulated()) {
                item = this.add(AbstractViewMode.this.mView.getCanvas().getActionMap().get("Clear ShowMe"));
                UIUtil.setUniqueMnemonic((JPopupMenu)this, (AbstractButton)item);
            }
            if (DbObjectHighlighter.hasHighlight(AbstractViewMode.this.mView)) {
                item = this.add(AbstractViewMode.this.mView.getCanvas().getActionMap().get("Clear Highlight"));
                UIUtil.setUniqueMnemonic((JPopupMenu)this, (AbstractButton)item);
            }
            if (this.mDelayedMenuEnabled) {
                this.add(new JSeparator());
                this.mItemUpdating.setEnabled(false);
                this.mItemUpdating.setFont(this.mItemUpdating.getFont().deriveFont(2));
                this.add(this.mItemUpdating);
            }
        }

        protected int getPostition(Action a) {
            int i = 0;
            for (MenuElement me : this.getSubElements()) {
                JMenuItem mi;
                Component c = me.getComponent();
                if (c instanceof JMenuItem && (mi = (JMenuItem)c).getAction() == a) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected int getPostition(JMenuItem mi) {
            return this.getComponentIndex(mi);
        }

        protected int getPosition(AbstractButton a) {
            int i = 0;
            for (MenuElement me : this.getSubElements()) {
                if (me.getComponent() == a) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            APoint2D worldLoc = AbstractViewMode.this.mView.getCanvas().getXForm().getWorldPt(new Point(x, y));
            DelayedMenuUpdater dmu = new DelayedMenuUpdater(worldLoc);
            final Thread thread = new Thread((Runnable)dmu, "Async Context Menu Update");
            if (this.mDelayedMenuEnabled) {
                this.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        thread.start();
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                        thread.interrupt();
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }
                });
            }
            OrbitIO.getGuiWorkspace().beautify(this);
            super.show(invoker, x, y);
        }

        @Override
        public JMenuItem add(Action a) {
            if (a == null) {
                return null;
            }
            return this.add(this.menuItemFromAction(a));
        }

        protected JMenuItem menuItemFromAction(Action a) {
            if (a == null) {
                return null;
            }
            JMenuItem mi = ObjectActionRegistry.getJMenuItem(a);
            mi.setAction(a);
            String bt = (String)a.getValue("ButtonText");
            if (bt != null) {
                mi.setText(bt);
            }
            return mi;
        }

        public JMenuItem deferAdd(Action a) {
            return this.deferAdd(this.menuItemFromAction(a));
        }

        public JMenuItem deferAdd(JMenuItem mi) {
            if (mi != null) {
                this.mDeferred.add(mi);
            }
            return mi;
        }

        public void commitDeffered(String groupName) {
            Component last;
            if (this.mDeferred.isEmpty()) {
                return;
            }
            if (this.getComponentCount() > 0 && (last = this.getComponent(this.getComponentCount() - 1)) instanceof JSeparator) {
                this.remove(this.mItemUpdating);
            }
            this.add((Component)new ASeparator(groupName));
            for (JMenuItem mi : this.mDeferred) {
                this.add(mi);
            }
            this.mDeferred.clear();
        }

        protected boolean containsMenuItem(Container cont, String text) {
            for (Component c : cont.getComponents()) {
                String t;
                if (!(c instanceof JMenuItem) || (t = ((JMenuItem)c).getText()) == null || !t.equals(text)) continue;
                return true;
            }
            for (Component c : cont.getComponents()) {
                if (!(c instanceof Container) || !this.containsMenuItem((Container)c, text)) continue;
                return true;
            }
            return false;
        }

        public void setDelayUpdatedEnabled(boolean enabled) {
            this.mDelayedMenuEnabled = enabled;
        }

        protected class DelayedMenuUpdater
        implements Runnable {
            APoint2D mLoc;
            protected BiMap<String, JMenu> mObjectType2Menu = HashBiMap.create();
            protected BiMap<HierInst<DbObject>, JMenu> mObject2Menu = HashBiMap.create();

            public DelayedMenuUpdater(APoint2D loc) {
                this.mLoc = loc;
            }

            private void insert(HierInst<DbObject> hierInst) {
                Net net;
                DbClass dbClass;
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
                ObjectActionRegistry oar = gws.getObjectActionRegistry();
                IterableIterator<JMenuItem> menuItems = oar.getJMenuItems(hierInst);
                if (!menuItems.hasNext()) {
                    return;
                }
                DbObject dbo = hierInst.getDbObject();
                if (dbo instanceof PortTemplate) {
                    dbo = ((PortTemplate)dbo).getPinTemplate();
                }
                if (dbo instanceof Connection) {
                    Connection connection = (Connection)dbo;
                    HierPin hp = connection.getDPPA();
                    if (hp == null) {
                        hp = connection.getDPPB();
                    }
                    if (hp == null || hp.getPin() == null) {
                        return;
                    }
                    Net net2 = hp.getNet();
                    net2 = NetMap.getTopmostNet((Net)net2, (DevicePath)hp.getPath());
                    DevicePath path = hp.getPath().pathTo(net2.getDeviceTemplate());
                    dbo = net2;
                    menuItems = oar.getJMenuItems(net2);
                    hierInst = HierInst.create((DevicePath)path, (DbObject)net2);
                }
                if ((dbClass = dbo.getDbClass()) == null) {
                    return;
                }
                String objType = dbClass.getName();
                String objName = AbstractViewMode.getDbObjectName(dbo);
                JMenu typeMenu = (JMenu)this.mObjectType2Menu.get((Object)objType);
                if (typeMenu == null) {
                    String menuName = objType.equals("PinTemplate") ? "Pin" : objType;
                    typeMenu = new JMenu(menuName);
                    this.mObjectType2Menu.put((Object)objType, (Object)typeMenu);
                }
                if (typeMenu.getItemCount() >= 100) {
                    JMenuItem last = typeMenu.getItem(typeMenu.getItemCount() - 1);
                    if (!(last instanceof OverflowMenuItem)) {
                        typeMenu.add(new OverflowMenuItem(objType, 100));
                    }
                    return;
                }
                JMenu objMenu = (JMenu)this.mObject2Menu.get(hierInst);
                if (objMenu != null) {
                    return;
                }
                objMenu = new JMenu(objName);
                objMenu.setIcon(DbExplorerPanel.getIconForDbObject(dbo));
                this.mObject2Menu.put((Object)hierInst, (Object)objMenu);
                typeMenu.add(objMenu);
                LinkedList sortedItems = AMenuUtil.groupByFirstWord(menuItems);
                AMenuUtil.sort((List)sortedItems, (boolean)true);
                for (JMenuItem a : sortedItems) {
                    objMenu.add(a);
                }
                if (dbo instanceof PinTemplate && (net = ((PinTemplate)dbo).getNet()) != null) {
                    if (hierInst.getPath().getDeviceTemplate() == net.getDeviceTemplate()) {
                        this.insert((HierInst<DbObject>)HierInst.create((DevicePath)hierInst.getPath(), (DbObject)net));
                    } else assert (false);
                }
            }

            @Override
            public void run() {
                Design design = Design.getDesign((Db)AbstractViewMode.this.mView.getDb(), (boolean)false);
                if (design == null) {
                    return;
                }
                OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
                ObjectActionRegistry oar = gws.getObjectActionRegistry();
                JMenu designMenu = new JMenu("Design");
                this.mObjectType2Menu.put((Object)designMenu.getText(), (Object)designMenu);
                Stream<JMenuItem> designItems = oar.getActions(new HierInst(null, (DbObject)design)).stream().map(ContextMenu.this::menuItemFromAction);
                for (Object mi : AMenuUtil.groupByFirstWord(designItems.iterator())) {
                    designMenu.add((JMenuItem)mi);
                }
                AMenuUtil.sort((JMenu)designMenu, (boolean)true);
                design.getObjectsAt(this.mLoc).stream().forEach(this::insert);
                DesignView2D v2 = (DesignView2D)OrbitIO.getCurView();
                for (Connection connection : design.getDb().getObjects(Connection.class)) {
                    Net net;
                    ALine line = connection.getLine();
                    Line2D screenLine = v2.getCanvas().getXForm().getScreenLine(line.distanceToPoint(this.mLoc));
                    double dist = Math.hypot(screenLine.getX1() - screenLine.getX2(), screenLine.getY1() - screenLine.getY2());
                    if (!(dist <= 15.0) || (net = connection.getNet()) == null) continue;
                    this.insert((HierInst<DbObject>)HierInst.create((DevicePath)Design.getDesignPath((Db)design.getDb()), (DbObject)connection));
                }
                BiMap menu2Object = this.mObject2Menu.inverse();
                this.mObjectType2Menu.values().stream().forEach(arg_0 -> DelayedMenuUpdater.lambda$run$4((Map)menu2Object, arg_0));
                JMenu selMenu = null;
                Selection selection = design.getCurSelection();
                for (JMenuItem mi : oar.getJMenuItems(selection)) {
                    if (ContextMenu.this.containsMenuItem(ContextMenu.this, mi.getText())) continue;
                    if (selMenu == null) {
                        selMenu = new JMenu("Selection");
                        this.mObjectType2Menu.put((Object)selMenu.getText(), (Object)selMenu);
                    }
                    selMenu.add(mi);
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                EventQueue.invokeLater(() -> {
                    int pos = ContextMenu.this.getPostition(ContextMenu.this.mItemUpdating);
                    if (pos >= 0) {
                        ContextMenu.this.remove(pos);
                    } else {
                        pos = 0;
                    }
                    ArrayList l = new ArrayList(this.mObjectType2Menu.values());
                    MenuComparator menuComparator = new MenuComparator();
                    Collections.sort(l, menuComparator);
                    for (JMenu menu : l) {
                        OrbitIO.getGuiWorkspace().beautify(menu);
                        ContextMenu.this.add((Component)menu, pos++);
                    }
                    if (ContextMenu.this.isVisible()) {
                        ContextMenu.this.pack();
                        AbstractViewMode.this.mContextMenu = ContextMenu.this;
                    }
                });
            }

            private static /* synthetic */ void lambda$run$4(Map menu2Object, JMenu objTypeMenu) {
                Map name2MenuItems = (Map)AStream.of((Object[])AMenuUtil.getMenuItems((JMenu)objTypeMenu)).filter(menuElement -> menuElement instanceof JMenuItem).map(menuElement -> (JMenuItem)menuElement).collect(Collectors.groupingBy(AbstractButton::getText));
                name2MenuItems.values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).forEach(menuItem -> {
                    HierInst hDbo = (HierInst)menu2Object.get(menuItem);
                    if (hDbo != null && hDbo.getPath() != null && !hDbo.getPath().isEmpty()) {
                        menuItem.setText(String.format("%s (%s)", menuItem.getText(), hDbo.getPath().escapedString()));
                    }
                });
                AMenuUtil.sort((JMenu)objTypeMenu, (boolean)false);
            }
        }

        protected class ActionUpdateDbObject
        extends AbstractAction {
            ActionUpdateDbObject() {
                super("Updating...");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        }
    }

    protected class MouseHandler
    implements MouseInputListener {
        protected boolean mTriggerPopup = false;

        protected MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            AbstractViewMode.this.updateModifiers(e.getModifiersEx());
            if (this.isContextMenuVisible()) {
                return;
            }
            AbstractViewMode.this.mouseEntered(AbstractViewMode.this.startMouseAction(e));
            AbstractViewMode.this.endMouseAction();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AbstractViewMode.this.updateModifiers(e.getModifiersEx());
            if (this.isContextMenuVisible()) {
                return;
            }
            AbstractViewMode.this.mouseExited(AbstractViewMode.this.startMouseAction(e));
            AbstractViewMode.this.endMouseAction();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            AbstractViewMode.this.updateModifiers(e.getModifiersEx());
            if (this.isContextMenuVisible()) {
                return;
            }
            AbstractViewMode.this.mouseMoved(AbstractViewMode.this.startMouseAction(e));
            AbstractViewMode.this.endMouseAction();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AbstractViewMode.this.updateModifiers(e.getModifiersEx());
            this.mTriggerPopup = false;
            if (e.isPopupTrigger()) {
                this.mTriggerPopup = true;
            }
            if (AbstractViewMode.this.mNavMode != NAVMODE.NONE) {
                return;
            }
            AbstractViewMode.this.mousePressed(AbstractViewMode.this.startMouseAction(e));
            AbstractViewMode.this.endMouseAction();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            AbstractViewMode.this.updateModifiers(e.getModifiersEx());
            if (this.handlePopup(e)) {
                return;
            }
            AbstractViewMode.this.mouseReleased(AbstractViewMode.this.startMouseAction(e));
            AbstractViewMode.this.endMouseAction();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AbstractViewMode.this.updateModifiers(e.getModifiersEx());
            if (this.handlePopup(e)) {
                return;
            }
            AbstractViewMode.this.mouseClicked(AbstractViewMode.this.startMouseAction(e));
            AbstractViewMode.this.endMouseAction();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            AbstractViewMode.this.updateModifiers(e.getModifiersEx());
            AbstractViewMode.this.mouseDragged(AbstractViewMode.this.startMouseAction(e));
            AbstractViewMode.this.endMouseAction();
        }

        protected boolean handlePopup(MouseEvent e) {
            if (AbstractViewMode.this.mNavMode != NAVMODE.NONE) {
                if (AbstractViewMode.this.mNavMode == NAVMODE.ZOOM) {
                    if (AbstractViewMode.this.mNavStart != null && (Math.abs(AbstractViewMode.this.mNavStart.getX() - e.getPoint().getX()) > 5.0 || Math.abs(AbstractViewMode.this.mNavStart.getY() - e.getPoint().getY()) > 5.0)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (!e.isPopupTrigger() && !this.mTriggerPopup) {
                return false;
            }
            AbstractViewMode.this.mContextMenu = new ContextMenu();
            Point pt = e.getPoint();
            AbstractViewMode.this.loadContextMenu(AbstractViewMode.this.mContextMenu, pt);
            AbstractViewMode.this.showContextMenu(AbstractViewMode.this.mContextMenu, pt);
            AbstractViewMode.this.endNavMode();
            return true;
        }

        protected boolean isContextMenuVisible() {
            return AbstractViewMode.this.mContextMenu != null && AbstractViewMode.this.mContextMenu.isVisible();
        }
    }

    protected class MouseWheelHandler
    implements MouseWheelListener,
    ActionListener {
        protected Point mLastPoint = null;
        protected APoint2D mLastWorldPoint = null;
        protected double mPendingZoom = 1.0;
        protected double mPriorZoom = 1.0;
        protected Rectangle mPriorBounds = null;
        protected BufferedImage mPriorImage = null;
        protected Image mCanvasImage = null;
        protected long mLastZoomTS = -1L;
        protected Timer mRedrawTimer = new Timer(500, this);

        protected MouseWheelHandler() {
            this.mRedrawTimer.setRepeats(false);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            AbstractViewMode.this.updateModifiers(e.getModifiersEx());
            if (AbstractViewMode.this.mView == null) {
                return;
            }
            AbstractViewMode.this.clearInformUser();
            int clicks = e.getWheelRotation();
            if (clicks == 0) {
                return;
            }
            if (e.getWhen() < this.mLastZoomTS) {
                return;
            }
            this.mRedrawTimer.stop();
            double factor = 1.0 + (double)(((Float)Settings.get((String)"UserPreferences", (String)"MouseWheelZoomSpeed", (Object)Float.valueOf(0.3f))).floatValue() / 10.0f);
            if (clicks < 0) {
                factor = 1.0 / factor;
                clicks = -clicks;
            }
            double amount = clicks == 1 ? factor : Math.pow(factor, clicks);
            this.mPendingZoom *= amount;
            if (this.mPendingZoom <= 1.0E-4 || Double.isNaN(this.mPendingZoom) || Double.isInfinite(this.mPendingZoom)) {
                this.mPendingZoom = 1.0E-4;
            }
            this.mPendingZoom = Math.min(this.mPendingZoom, 500.0);
            if (this.mLastPoint == null || !this.mLastPoint.equals(e.getPoint())) {
                this.mLastPoint = e.getPoint();
                this.mLastWorldPoint = AbstractViewMode.this.mView.getCanvas().getXForm().getWorldPt(this.mLastPoint);
            }
            if (AbstractViewMode.this.mOverlay != null) {
                AbstractViewMode.this.mOverlay.repaint();
            }
        }

        public void paintOverlay(Graphics2D g, Rectangle bounds) {
            if (this.mPendingZoom == 1.0) {
                return;
            }
            this.mPendingZoom = Math.min(this.mPendingZoom, 500.0);
            if (this.mPendingZoom != this.mPriorZoom || !bounds.equals(this.mPriorBounds) || this.mPriorImage == null) {
                this.mPriorZoom = this.mPendingZoom;
                if (!bounds.equals(this.mPriorBounds)) {
                    this.mPriorImage = null;
                    this.mPriorBounds = bounds;
                }
                DesignCanvas2D canvas = AbstractViewMode.this.mView.getCanvas();
                Point2D.Double gScale = canvas.getScale(null);
                double cdx = (double)this.mLastPoint.x * gScale.x - bounds.getCenterX();
                double cdy = (double)this.mLastPoint.y * gScale.y - bounds.getCenterY();
                if (this.mCanvasImage == null) {
                    this.mCanvasImage = canvas.getImage(true);
                }
                Rectangle imgBounds = !canvas.hasLargeBuffer() ? new Rectangle(0, 0, bounds.width, bounds.height) : new Rectangle(bounds.width, bounds.height, bounds.width, bounds.height);
                Point p1 = new Point(imgBounds.x, imgBounds.y);
                Point p2 = new Point(imgBounds.x + imgBounds.width, imgBounds.y + imgBounds.height);
                double dx = imgBounds.getCenterX() + cdx;
                double dy = imgBounds.getCenterY() + cdy;
                AffineTransform x = AffineTransform.getTranslateInstance(-dx, -dy);
                x.preConcatenate(AffineTransform.getScaleInstance(this.mPendingZoom, this.mPendingZoom));
                x.preConcatenate(AffineTransform.getTranslateInstance(dx, dy));
                x.transform(p1, p1);
                x.transform(p2, p2);
                if (this.mPriorImage == null) {
                    this.mPriorImage = new BufferedImage(bounds.width, bounds.height, 1);
                }
                Graphics2D bg = this.mPriorImage.createGraphics();
                bg.setPaint(UndefPaint);
                bg.fillRect(0, 0, bounds.width, bounds.height);
                bg.drawImage(this.mCanvasImage, 0, 0, bounds.width, bounds.height, p1.x, p1.y, p2.x, p2.y, null);
                bg.dispose();
            }
            g.drawImage((Image)this.mPriorImage, bounds.x, bounds.y, null);
            this.mRedrawTimer.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractViewMode.this.mView == null || AbstractViewMode.this.mView.getCanvas() == null) {
                return;
            }
            Db db = OrbitIO.getCurDb();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Zoom");){
                Cp.exec((String)"%s.zoom(%f, %s)", (Object[])new Object[]{UserCommands.class.getName(), this.mPendingZoom, this.mLastWorldPoint.getAsStringArg()});
            }
            this.mPendingZoom = 1.0;
            this.mPriorZoom = 1.0;
            this.mPriorBounds = null;
            this.mPriorImage = null;
            this.mCanvasImage = null;
            this.mLastZoomTS = new Date().getTime();
        }

        public boolean isZoomPending() {
            return this.mPendingZoom != 1.0;
        }
    }

    protected class KeyHandler
    implements KeyListener {
        protected KeyHandler() {
        }

        protected void process(KeyEvent e) {
            AbstractViewMode.this.updateModifiers(e.getModifiersEx());
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.process(e);
            if (e.getKeyCode() == 27 && AbstractViewMode.this.mView.getCanvas().getInputMap().get(KeyStroke.getKeyStroke("ESCAPE")) == null) {
                AbstractViewMode.this.mView.setDefaultViewMode();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.process(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.process(e);
        }
    }

    public static interface ViewModeListener {
        public void modeInstalled();

        public void modeUninstalled();
    }

    static enum ZOOMDIR {
        IN,
        OUT;

    }

    public static enum NAVMODE {
        NONE,
        PAN,
        ZOOM;

    }
}

