/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import com.google.common.collect.Sets;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AOctagon;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.EditDeviceUI;
import com.sigrity.orbit.ui.GridOverlay;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_modes.SpotLight;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.JPopupMenu;

public class EditDeviceBoundsMode
extends AbstractViewMode {
    public static final String MODE_KEY = "EditDeviceBoundsMode";
    public static final String MODE_NAME = "Edit Device Bounds";
    protected static DesignView2D.ViewMode oldMode = null;
    protected static DevicePath mDevicePath = null;
    protected static Device mDevice = null;
    protected static boolean mInUseMode = false;
    protected DeviceTemplate mDeviceTemplate = null;
    protected Db mDb = null;
    protected Point mCurLoc = null;
    private static final Color CURSOR_COLOR = Color.RED;
    private static final Color CURSOR_COLOR_XOR = Color.WHITE;
    private static final int CURSOR_LEG_SIZE = 7;
    private EditOverlay mEditOverlay;
    protected EditDeviceUI mDeviceUI = null;
    protected OverlayPainter mPrePaint = null;
    protected OverlayPainter mPostPaint = null;
    protected Mode mMode = null;
    protected APoint2D mCursorPt = null;

    public EditDeviceBoundsMode(Window owner, DevicePath path) {
        mDevicePath = path;
        mDevice = path.getLast();
        if (mDevice != null) {
            this.mDeviceTemplate = mDevice.getTemplate();
        }
        this.install((DesignView2D)OrbitIO.getCurView());
    }

    public static EditDeviceBoundsMode create(Window owner, DevicePath path) {
        if (mInUseMode) {
            ALog.logInfo((String)"Edit Device session already opened. Close existing session first.");
            return null;
        }
        mInUseMode = true;
        return new EditDeviceBoundsMode(owner, path);
    }

    public void install(DesignView2D view) {
        if (view == null) {
            return;
        }
        view.setMode(this);
    }

    @Override
    public void installMode(DesignView2D view) {
        super.installMode(view);
        this.mView = view;
        oldMode = view.getPriorMode();
        this.mEditOverlay = new EditOverlay(null);
        this.mEditOverlay.setCursor(this.getCursor());
        view.addOverlay(this.mEditOverlay);
        this.mDeviceUI = EditDeviceUI.showMe(OrbitIO.getMainWindow(), mDevicePath, oldMode);
        this.setEditMode(new EditBoundsMode());
    }

    @Override
    public void uninstallMode() {
        if (this.mEditOverlay != null) {
            this.mView.removeOverlay(this.mEditOverlay);
            this.mEditOverlay = null;
            mInUseMode = false;
        }
        super.uninstallMode();
    }

    @Override
    protected void installedMode() {
        if (this.mDeviceUI != null) {
            this.mDeviceUI.removeUninstallModeListener();
            UIUtil.closeWindow((Window)((Object)this.mDeviceUI));
        }
        this.mDb = OrbitIO.getCurDb();
    }

    public void setPrePaint(OverlayPainter painter) {
        this.mPrePaint = painter;
    }

    public void setPostPaint(OverlayPainter painter) {
        this.mPostPaint = painter;
    }

    protected void setEditMode(Mode mode) {
        if (this.mMode != null && !this.mMode.uninstall()) {
            return;
        }
        this.mMode = null;
        if (mode != null && mode.install()) {
            this.mMode = mode;
        }
        this.repaintOverlay();
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        if (this.mMode != null) {
            this.mMode.mouseClick(e);
        }
    }

    @Override
    public void mouseDragged(DesignView2D.MouseAction e) {
        super.mouseDragged(e);
        if (this.mMode != null) {
            this.mMode.mouseDrag(e);
        }
    }

    @Override
    public void mouseEntered(DesignView2D.MouseAction e) {
        super.mouseEntered(e);
        if (this.mMode != null) {
            this.mMode.mouseEnter(e);
        }
    }

    @Override
    public void mouseExited(DesignView2D.MouseAction e) {
        super.mouseExited(e);
        if (this.mMode != null) {
            this.mMode.mouseExit(e);
        }
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        if (this.mMode != null) {
            this.mMode.mouseMove(e);
        }
    }

    @Override
    public void mousePressed(DesignView2D.MouseAction e) {
        super.mousePressed(e);
        if (this.mMode != null) {
            this.mMode.mousePress(e);
        }
    }

    @Override
    public void mouseReleased(DesignView2D.MouseAction e) {
        super.mouseReleased(e);
        if (this.mMode != null) {
            this.mMode.mouseRelease(e);
        }
    }

    @Override
    public String getName() {
        return MODE_NAME;
    }

    public static boolean getInUse() {
        return mInUseMode;
    }

    protected void setCursorLoc(APoint2D worldLoc) {
        if (APoint2D.isEqualPoint((APoint2D)this.mCursorPt, (APoint2D)worldLoc)) {
            return;
        }
        this.mCursorPt = worldLoc;
        if (this.mEditOverlay instanceof EditOverlay) {
            this.mEditOverlay.drawCursor(null);
        }
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    public Device getEditDevice() {
        return mDevice;
    }

    protected class EditOverlay
    extends GridOverlay {
        protected boolean mSpotlight;
        protected Point mDrawnCursorLoc;

        public EditOverlay(NamedGrid grid) {
            super(EditDeviceBoundsMode.this.mView, null, null);
            this.mSpotlight = true;
            this.mDrawnCursorLoc = null;
        }

        public void setSpotlight(boolean b) {
            this.mSpotlight = b;
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (EditDeviceBoundsMode.this.isNavigationInProgress()) {
                return;
            }
            if (!(graphics instanceof Graphics2D)) {
                assert (false);
                return;
            }
            Graphics2D g = (Graphics2D)graphics;
            if (EditDeviceBoundsMode.this.mPrePaint != null) {
                EditDeviceBoundsMode.this.mPrePaint.paintOverlay(g);
            }
            if (this.mSpotlight && this.mDevicePath != null) {
                DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
                ARect viewBounds = this.mView.getViewBounds();
                ARect deviceBounds = this.mDevicePath.getBB();
                SpotLight.spotlight(g, viewBounds, (AGeom)deviceBounds, xform);
            }
            if (EditDeviceBoundsMode.this.mMode != null) {
                EditDeviceBoundsMode.this.mMode.paintOverlay(g);
            }
            this.mDrawnCursorLoc = null;
            this.drawCursor(g);
            if (EditDeviceBoundsMode.this.mPostPaint != null) {
                EditDeviceBoundsMode.this.mPostPaint.paintOverlay(g);
            }
        }

        protected void drawCursor(Graphics2D gIn) {
            Graphics2D g = gIn != null ? gIn : (Graphics2D)this.getGraphics();
            APoint2D clw = EditDeviceBoundsMode.this.mCursorPt;
            Point cl = clw == null ? null : this.mView.getCanvas().getXForm().getScreenPt(clw);
            Color oldColor = g.getColor();
            g.setColor(CURSOR_COLOR);
            g.setXORMode(CURSOR_COLOR_XOR);
            if (this.mDrawnCursorLoc != null && !this.mDrawnCursorLoc.equals(cl)) {
                this.drawCursor(g, this.mDrawnCursorLoc);
                this.mDrawnCursorLoc = null;
            }
            if (cl != null && !cl.equals(this.mDrawnCursorLoc)) {
                this.drawCursor(g, cl);
                this.mDrawnCursorLoc = cl;
            }
            g.setColor(oldColor);
            g.setPaintMode();
            if (gIn == null) {
                g.dispose();
            }
        }

        protected void drawCursor(Graphics2D g, Point loc) {
            g.drawLine(loc.x - 7, loc.y, loc.x - 1, loc.y);
            g.drawLine(loc.x + 1, loc.y, loc.x + 7, loc.y);
            g.drawLine(loc.x, loc.y - 7, loc.x, loc.y - 1);
            g.drawLine(loc.x, loc.y + 1, loc.x, loc.y + 7);
        }
    }

    protected class EditBoundsMode
    extends Mode {
        protected boolean mUninstallClearsEditState;
        protected Device mHighlightDevice;
        protected DragInfo mDragInfo;
        protected DevicePath mDevicePath;
        protected ARect mChildrenBounds;
        protected ARect mTempBounds;
        protected APoint2D[] mBoundBox;
        protected int mHandleIndex;

        protected EditBoundsMode() {
            this.mUninstallClearsEditState = true;
            this.mHighlightDevice = mDevice;
            this.mDragInfo = null;
            this.mDevicePath = mDevice.getADevicePath();
            this.mChildrenBounds = mDevice.getTemplate().deriveFullBounds(false).orElseGet(ARect::new).transform(this.mDevicePath.getTransform()).getBounds();
            this.mTempBounds = mDevice.getTemplate().getBounds(true).getBounds().transform(this.mDevicePath.getTransform()).getBounds();
            this.mBoundBox = new APoint2D[]{this.mTempBounds.getLL(), this.mTempBounds.getUL(), this.mTempBounds.getUR(), this.mTempBounds.getLR()};
            this.mHandleIndex = -1;
        }

        @Override
        public boolean install() {
            return super.install();
        }

        @Override
        public boolean uninstall() {
            EditDeviceBoundsMode.this.informUser(null, new Object[0]);
            this.mHighlightDevice = null;
            if (this.mUninstallClearsEditState) {
                EditDeviceBoundsMode.this.setCursorLoc(null);
            }
            return super.uninstall();
        }

        @Override
        public void paintOverlay(Graphics2D g) {
            ARect hlGeom;
            super.paintOverlay(g);
            if (EditDeviceBoundsMode.this.mView == null) {
                return;
            }
            RenderingHints oldRenderingHints = g.getRenderingHints();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color colorOld = g.getColor();
            if (EditDeviceUI.getNeedRefreshBound()) {
                this.mTempBounds = mDevice.getTemplate().getBounds(true).getBounds().transform(this.mDevicePath.getTransform()).getBounds();
                EditDeviceUI.clearNeedRefreshBound();
            }
            ARect aRect = hlGeom = this.mHighlightDevice == null ? null : this.mTempBounds;
            if (hlGeom != null) {
                g.setColor(Color.RED);
                g.setXORMode(Color.WHITE);
                AffineTransform xform = new AffineTransform();
                DesignCanvas2D.drawGeom(g, EditDeviceBoundsMode.this.mView.getCanvas().getXForm(), (AGeom)hlGeom, xform, null);
                this.drawHandles(g, EditDeviceBoundsMode.this.mView.getCanvas().getXForm(), (AGeom)hlGeom, xform);
                this.mChildrenBounds = mDevice.getTemplate().deriveFullBounds(false).orElseGet(ARect::new).transform(this.mDevicePath.getTransform()).getBounds();
                this.drawChildrenBounds(g, EditDeviceBoundsMode.this.mView.getCanvas().getXForm(), xform);
            }
            g.setPaintMode();
            g.setColor(colorOld);
            g.setRenderingHints(oldRenderingHints);
        }

        protected void sortBounds() {
            long minX = Long.MAX_VALUE;
            long maxX = Long.MIN_VALUE;
            long minY = Long.MAX_VALUE;
            long maxY = Long.MIN_VALUE;
            for (APoint2D p : this.mChildrenBounds.getPoints()) {
                minX = Math.min(minX, p.getX());
                minY = Math.min(minY, p.getY());
                maxX = Math.max(maxX, p.getX());
                maxY = Math.max(maxY, p.getY());
            }
            this.mChildrenBounds.setLL(minX, minY);
            this.mChildrenBounds.setUR(maxX, maxY);
        }

        protected void startDrag(Point screenPt) {
            this.mDragInfo = new DragInfo(screenPt);
            APoint2D dragPt = EditDeviceBoundsMode.this.getWorldPoint(screenPt);
            long maxDistance = Long.MAX_VALUE;
            for (int i = 0; i <= 3; ++i) {
                long distance = this.mBoundBox[i].distance(dragPt);
                if (distance >= maxDistance) continue;
                this.mHandleIndex = i;
                maxDistance = distance;
            }
            this.sortBounds();
            EditDeviceBoundsMode.this.repaintOverlay();
        }

        protected boolean inDrag() {
            return this.mDragInfo != null;
        }

        protected void endDrag() {
            this.mDragInfo = null;
        }

        protected void updateDrag(Point screenPoint) {
            APoint2D curWorldPoint = EditDeviceBoundsMode.this.getWorldPoint(screenPoint);
            EditDeviceBoundsMode.this.setCursorLoc(curWorldPoint);
            this.mBoundBox[0] = this.mTempBounds.getLL();
            this.mBoundBox[1] = this.mTempBounds.getUL();
            this.mBoundBox[2] = this.mTempBounds.getUR();
            this.mBoundBox[3] = this.mTempBounds.getLR();
            switch (this.mHandleIndex) {
                case 0: {
                    this.mBoundBox[0].setX(Math.min(EditDeviceBoundsMode.this.mCursorPt.getX(), this.mChildrenBounds.getLL().getX()));
                    this.mBoundBox[0].setY(Math.min(EditDeviceBoundsMode.this.mCursorPt.getY(), this.mChildrenBounds.getLL().getY()));
                    break;
                }
                case 1: {
                    this.mBoundBox[0].setX(Math.min(EditDeviceBoundsMode.this.mCursorPt.getX(), this.mChildrenBounds.getLL().getX()));
                    this.mBoundBox[2].setY(Math.max(EditDeviceBoundsMode.this.mCursorPt.getY(), this.mChildrenBounds.getUR().getY()));
                    break;
                }
                case 2: {
                    this.mBoundBox[2].setX(Math.max(EditDeviceBoundsMode.this.mCursorPt.getX(), this.mChildrenBounds.getUR().getX()));
                    this.mBoundBox[2].setY(Math.max(EditDeviceBoundsMode.this.mCursorPt.getY(), this.mChildrenBounds.getUR().getY()));
                    break;
                }
                case 3: {
                    this.mBoundBox[0].setY(Math.min(EditDeviceBoundsMode.this.mCursorPt.getY(), this.mChildrenBounds.getLL().getY()));
                    this.mBoundBox[2].setX(Math.max(EditDeviceBoundsMode.this.mCursorPt.getX(), this.mChildrenBounds.getUR().getX()));
                    break;
                }
                default: {
                    ALog.logInfo((String)"Internal error - incorrect bounds.");
                }
            }
            this.mTempBounds.setLL(this.mBoundBox[0]);
            this.mTempBounds.setUR(this.mBoundBox[2]);
            this.updateUIFields(false);
            EditDeviceBoundsMode.this.repaintOverlay();
        }

        @Override
        public void mouseMove(DesignView2D.MouseAction e) {
        }

        @Override
        public void mouseDrag(DesignView2D.MouseAction e) {
            if (this.inDrag()) {
                this.updateDrag(e.getPoint());
            }
        }

        @Override
        public void mousePress(DesignView2D.MouseAction e) {
            if (e.isPopupTrigger() || e.getButton() != 1) {
                return;
            }
            if (!this.inDrag()) {
                this.startDrag(e.getPoint());
            }
        }

        @Override
        public void mouseClick(DesignView2D.MouseAction e) {
            EditDeviceBoundsMode.this.informUser(null, new Object[0]);
            if (e.isPopupTrigger() || e.getButton() != 1) {
                return;
            }
            this.highlightOrSelectDevice(e.getPoint(), true);
            EditDeviceBoundsMode.this.repaintOverlay();
        }

        @Override
        public void mouseRelease(DesignView2D.MouseAction e) {
            if (e.isPopupTrigger() || e.getButton() != 1) {
                return;
            }
            if (this.inDrag()) {
                if (this.mDragInfo == null) {
                    EditDeviceBoundsMode.this.repaintOverlay();
                    return;
                }
                if (this.mDragInfo.getStart().equals(e.getPoint())) {
                    this.endDrag();
                    return;
                }
                this.updateUIFields(true);
                EditDeviceBoundsMode.this.repaintView();
            }
            this.endDrag();
        }

        private void updateUIFields(boolean updateDb) {
            EditDeviceBoundsMode.this.mDeviceUI.setDeviceCanvasHeight(this.mTempBounds.height());
            EditDeviceBoundsMode.this.mDeviceUI.setDeviceCanvasWidth(this.mTempBounds.width());
            EditDeviceBoundsMode.this.mDeviceUI.setDeviceCanvasLLX(this.mTempBounds.left());
            EditDeviceBoundsMode.this.mDeviceUI.setDeviceCanvasLLY(this.mTempBounds.bottom());
            if (updateDb) {
                EditDeviceBoundsMode.this.mDeviceUI.updateDb(false);
            }
        }

        protected void highlightOrSelectDevice(Point point, boolean select) {
            EditDeviceBoundsMode.this.repaintOverlay();
        }

        protected void drawHandles(Graphics2D g, DesignCanvas2D.XForm screenXform, AGeom geom, AffineTransform xform) {
            for (Rectangle h : this.getHandles(geom, xform, screenXform)) {
                g.fill(h);
            }
        }

        protected LinkedList<Rectangle> getHandles(AGeom geom, AffineTransform geomX, DesignCanvas2D.XForm screenX) {
            LinkedList<Rectangle> handles = new LinkedList<Rectangle>();
            if (geom instanceof ARect) {
                ARect r = (ARect)geom;
                for (APoint2D p : r.getPoints()) {
                    handles.add(this.createHandle(p, geomX, screenX));
                }
            } else if (geom instanceof AOctagon) {
                AOctagon o = (AOctagon)geom;
                for (APoint2D p : o.getPoints()) {
                    handles.add(this.createHandle(p, geomX, screenX));
                }
            } else if (geom instanceof APolygon) {
                APolygon poly = (APolygon)geom;
                for (APoint2D p : Sets.newHashSet((Iterator)poly.getPoints())) {
                    handles.add(this.createHandle(p, geomX, screenX));
                }
            } else if (geom instanceof ACircle) {
                ACircle c = (ACircle)geom;
                for (int i = 0; i < 8; ++i) {
                    double a = (double)i / 8.0 * Math.PI * 2.0;
                    APoint2D p = new APoint2D((long)((double)(c.getC().getX() + 1L) + (double)c.getR() * Math.cos(a)), (long)((double)c.getC().getY() + (double)c.getR() * Math.sin(a)));
                    handles.add(this.createHandle(p, geomX, screenX));
                }
            } else assert (false);
            return handles;
        }

        protected Rectangle createHandle(APoint2D pt, AffineTransform ptX, DesignCanvas2D.XForm screenX) {
            Point p = screenX.getScreenPt(pt.transform(ptX));
            return new Rectangle(p.x - 3, p.y - 3, 7, 7);
        }

        protected void drawChildrenBounds(Graphics2D g, DesignCanvas2D.XForm screenX, AffineTransform ptX) {
            int minX = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int minY = Integer.MAX_VALUE;
            int maxY = Integer.MIN_VALUE;
            for (APoint2D p : this.mChildrenBounds.getPoints()) {
                Point ll = screenX.getScreenPt(p.transform(ptX));
                minX = Math.min(minX, ll.x);
                minY = Math.min(minY, ll.y);
                maxX = Math.max(maxX, ll.x);
                maxY = Math.max(maxY, ll.y);
            }
            g.drawRect(minX, minY, maxX - minX, maxY - minY);
        }

        protected class DragInfo {
            protected Point mStart = null;

            public DragInfo(Point start) {
                this.mStart = start;
            }

            public Point getStart() {
                return this.mStart;
            }
        }
    }

    protected abstract class Mode {
        protected Mode() {
        }

        public boolean install() {
            return true;
        }

        public boolean uninstall() {
            return true;
        }

        public void mouseClick(DesignView2D.MouseAction e) {
        }

        public void mouseDrag(DesignView2D.MouseAction e) {
        }

        public void mouseEnter(DesignView2D.MouseAction e) {
        }

        public void mouseExit(DesignView2D.MouseAction e) {
        }

        public void mouseMove(DesignView2D.MouseAction e) {
        }

        public void mousePress(DesignView2D.MouseAction e) {
        }

        public void mouseRelease(DesignView2D.MouseAction e) {
        }

        public void paintOverlay(Graphics2D g) {
        }

        public IterableIterator<Action> getActions(Point loc) {
            return AEmptyItr.create();
        }

        public void prepareContexMenu(JPopupMenu menu, Point loc) {
        }
    }

    public static interface OverlayPainter {
        public void paintOverlay(Graphics2D var1);
    }
}

