/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import com.sigrity.acl.app.Settings;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.InterfaceTreeUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_modes.SpotLight;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class GeometryDrawerMode
extends AbstractViewMode {
    private static String mModeName = "";
    protected DesignView2D.ViewMode mPrevMode = null;
    protected InterfaceTreeUI mInterfaceUI = null;
    protected Point mSelAreaFrom;
    protected Point mSelAreaTo;
    protected APolygon mSelPolygon = new APolygon();
    protected static boolean mOutlineOnlyMode = false;
    protected static boolean mRemoveMode = false;
    protected static GeometryDrawerMode mGeomMode = null;
    protected Mode mMode;
    protected static GeometryDrawerHelper mHelper = null;
    protected static JMenuItem mDonePolygon = new JMenuItem(new AbstractAction("Done with shape"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (mGeomMode != null) {
                if (GeometryDrawerMode.mGeomMode.mMode == Mode.POLYGON) {
                    mGeomMode.completePolygon(false, (e.getModifiers() & 1) == 1, (e.getModifiers() & 2) == 2);
                } else if (GeometryDrawerMode.mGeomMode.mMode == Mode.PATH) {
                    mOutlineOnlyMode = true;
                    mGeomMode.completePolygon(true, (e.getModifiers() & 1) == 1, (e.getModifiers() & 2) == 2);
                } else if (GeometryDrawerMode.mGeomMode.mMode == Mode.LASSO) {
                    mGeomMode.completePolygon(false, (e.getModifiers() & 1) == 1, (e.getModifiers() & 2) == 2);
                }
            }
        }
    });
    protected static JMenuItem mCancelAreaSpecification = new JMenuItem(new AbstractAction("Cancel this shape"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (mGeomMode != null) {
                mGeomMode.cancelAreaSpecification();
            }
        }
    });
    protected static JMenuItem mCancelMode = new JMenuItem(new AbstractAction("Done " + mModeName){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (mGeomMode != null) {
                mGeomMode.cancelDrawingMode();
            }
        }
    });
    protected static JMenuItem mDoneAsPolygon = new JMenuItem(new AbstractAction("Select objects touching polyline edges"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (mGeomMode != null) {
                mOutlineOnlyMode = true;
                mGeomMode.completePolygon(true, (e.getModifiers() & 1) == 1, (e.getModifiers() & 2) == 2);
            }
        }
    });
    protected static JMenuItem mDoneAsPolyline = new JMenuItem(new AbstractAction("Select objects touching polygon outline"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (mGeomMode != null) {
                mOutlineOnlyMode = true;
                mGeomMode.completeAsPolygonOutline((e.getModifiers() & 1) == 1, (e.getModifiers() & 2) == 2);
            }
        }
    });
    protected static JMenuItem mUndoLastPoint = new JMenuItem(new AbstractAction("Undo last point"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (mGeomMode != null) {
                mGeomMode.decrementPoints();
            }
        }
    });
    protected AbstractButton[] mContextMenuItems = new AbstractButton[]{mCancelMode, mDonePolygon, mCancelAreaSpecification, mDoneAsPolyline, mDoneAsPolygon, mUndoLastPoint, null};
    protected AbstractButton[] mContextLassoMenuItems = new AbstractButton[]{mCancelMode, mDonePolygon, mCancelAreaSpecification, null};
    protected AbstractButton[] mContextCancelOnlyMenuItems = new AbstractButton[]{mCancelMode, mCancelAreaSpecification, null};

    public GeometryDrawerMode(DesignView2D.ViewMode prevMode, GeometryDrawerHelper helper) {
        mHelper = helper;
        this.mPrevMode = prevMode;
    }

    public void setMode(Mode md) {
        this.mMode = md;
        mModeName = mHelper.getModeName();
        switch (md) {
            case START_RECTANGLE: {
                mModeName = mModeName + " dragging a rectangle";
                break;
            }
            case START_LASSO: {
                mModeName = mModeName + " using a lasso";
                break;
            }
            case START_PATH: {
                mModeName = mModeName + " drawing a path";
                break;
            }
            case START_POLYGON: {
                mModeName = mModeName + " drawing a polygon";
                break;
            }
        }
    }

    @Override
    protected void installedMode() {
        mGeomMode = this;
    }

    @Override
    protected void removingMode() {
    }

    @Override
    public void mousePressed(DesignView2D.MouseAction e) {
        APoint2D p;
        super.mousePressed(e);
        if (e.getButton() != 1) {
            if (this.mMode == Mode.POLYGON && e.getButton() == 3) {
                APoint2D p2 = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
                this.mSelPolygon.setPoint(this.mSelPolygon.getPointCount() - 1, p2);
                this.mSelPolygon.addPoint(p2);
            }
            return;
        }
        if (this.mMode == Mode.LASSO || this.mMode == Mode.PATH) {
            APoint2D p3 = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
            this.mSelPolygon.setPoint(this.mSelPolygon.getPointCount() - 1, p3);
            if (this.mMode == Mode.LASSO) {
                this.completePolygon(false, e.isShiftDown(), e.isControlDown());
                this.mMode = Mode.END_LASSO;
            } else {
                mOutlineOnlyMode = true;
                this.completePolygon(true, e.isShiftDown(), e.isControlDown());
                this.mMode = Mode.END_PATH;
            }
            this.repaintOverlay();
            return;
        }
        if (this.mMode == Mode.UNKNOWN || this.mMode == Mode.END_LASSO || this.mMode == Mode.END_PATH || this.mMode == Mode.END_POLYGON) {
            return;
        }
        if (this.mMode == Mode.START_RECTANGLE) {
            this.mMode = Mode.POINT_RECTANGLE;
        } else if (this.mMode == Mode.START_LASSO || this.mMode == Mode.START_PATH || this.mMode == Mode.START_POLYGON) {
            if (this.mMode == Mode.START_LASSO) {
                this.mMode = Mode.LASSO;
            } else if (this.mMode == Mode.START_PATH) {
                this.mMode = Mode.PATH;
            } else if (this.mMode == Mode.START_POLYGON) {
                this.mMode = Mode.POLYGON;
            }
            this.mSelPolygon = new APolygon();
            p = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
            this.mSelPolygon.addPoint(p);
        }
        if (this.mMode == Mode.POLYGON) {
            p = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
            this.mSelPolygon.setPoint(this.mSelPolygon.getPointCount() - 1, p);
            if (e.isShiftDown()) {
                this.restrictPolygonOrthogonal();
            }
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.completePolygon(false, e.isShiftDown(), e.isControlDown());
                this.mMode = Mode.END_POLYGON;
                return;
            }
            this.mSelPolygon.addPoint(p);
        } else {
            this.mSelAreaFrom = e.getPoint();
            this.mSelAreaTo = null;
        }
        this.repaintOverlay();
    }

    private void completePolygon(boolean completeAsPolyline, boolean shiftPressed, boolean ctrlPressed) {
        if (completeAsPolyline) {
            this.mSelPolygon.completeAsPolyline();
        }
        this.mSelPolygon.removeRedundantPoints();
        if (this.mSelPolygon.getPointCount() == 1) {
            ARect pointRect = new ARect(this.mSelPolygon.getPoint(0), this.mSelPolygon.getPoint(0));
            this.selectByArea((AGeom)pointRect, shiftPressed, ctrlPressed);
        } else {
            this.selectByArea((AGeom)this.mSelPolygon, shiftPressed, ctrlPressed);
        }
        this.repaint();
        this.mMode = this.mMode == Mode.PATH ? Mode.START_PATH : (this.mMode == Mode.LASSO ? Mode.START_LASSO : Mode.START_POLYGON);
        this.mSelPolygon = new APolygon();
        this.mSelAreaFrom = null;
    }

    private void chooseStartingMode() {
        switch (this.mMode) {
            case END_POLYGON: {
                this.mMode = Mode.START_POLYGON;
                break;
            }
            case POLYGON: {
                this.mMode = Mode.START_POLYGON;
                break;
            }
            case LASSO: {
                this.mMode = Mode.START_LASSO;
                break;
            }
            case END_LASSO: {
                this.mMode = Mode.START_LASSO;
                break;
            }
            case END_PATH: {
                this.mMode = Mode.START_PATH;
                break;
            }
            case PATH: {
                this.mMode = Mode.START_PATH;
                break;
            }
        }
    }

    private void completeAsPolygonOutline(boolean shiftPressed, boolean ctrlPressed) {
        this.mSelPolygon.removePoint(this.mSelPolygon.getPointCount() - 1);
        this.mSelPolygon.addPoint(this.mSelPolygon.getPoint(0));
        this.mSelPolygon.completeAsPolyline();
        this.selectByArea((AGeom)this.mSelPolygon, shiftPressed, ctrlPressed);
        this.repaint();
        this.chooseStartingMode();
        this.mSelPolygon = new APolygon();
        this.mSelAreaFrom = null;
    }

    private void cancelAreaSpecification() {
        this.repaint();
        this.mSelPolygon = new APolygon();
        this.mSelAreaFrom = null;
        this.chooseStartingMode();
    }

    public void repaint() {
        if (this.mView != null) {
            this.repaintView();
        }
    }

    public void cancelDrawingMode() {
        this.repaint();
        this.mSelPolygon = new APolygon();
        this.mSelAreaFrom = null;
        this.chooseStartingMode();
        if ((DesignView2D)OrbitIO.getCurView() != null) {
            ((DesignView2D)OrbitIO.getCurView()).setMode(this.mPrevMode);
        }
        mHelper.cancelDrawingMode();
    }

    private void restrictPolygonOrthogonal() {
        this.mSelPolygon.restrictLastSegmentVertHoriz();
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        if (this.mMode == Mode.POLYGON) {
            this.mSelPolygon.setPoint(this.mSelPolygon.getPointCount() - 1, this.mView.getCanvas().getXForm().getWorldPt(e.getPoint()));
            if (e.isShiftDown()) {
                this.restrictPolygonOrthogonal();
            }
            this.repaintOverlay();
        } else if (this.mMode == Mode.LASSO || this.mMode == Mode.PATH) {
            APoint2D p = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
            this.mSelPolygon.addPoint(p);
            this.repaintOverlay(true);
        }
    }

    @Override
    public void mouseDragged(DesignView2D.MouseAction e) {
        super.mouseDragged(e);
        if (this.mMode == Mode.POLYGON || this.mMode == Mode.END_POLYGON) {
            return;
        }
        if (this.mMode == Mode.LASSO || this.mMode == Mode.PATH) {
            APoint2D p = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
            this.mSelPolygon.addPoint(p);
            this.repaintOverlay(true);
        }
        this.mSelAreaTo = e.getPoint();
        this.repaintOverlay();
    }

    @Override
    public void mouseReleased(DesignView2D.MouseAction e) {
        super.mouseReleased(e);
        if (this.mMode == Mode.POLYGON || this.mMode == Mode.LASSO || this.mMode == Mode.PATH || this.mMode == Mode.UNKNOWN) {
            return;
        }
        if (this.mMode == Mode.END_POLYGON) {
            this.mMode = Mode.START_POLYGON;
            return;
        }
        if (this.mMode == Mode.END_PATH) {
            this.mMode = Mode.START_PATH;
            return;
        }
        if (this.mMode == Mode.END_LASSO) {
            this.mMode = Mode.START_LASSO;
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        if (this.mSelAreaFrom == null) {
            this.mSelAreaFrom = e.getPoint();
        }
        this.mSelAreaTo = e.getPoint();
        Rectangle r = new Rectangle(this.mSelAreaFrom);
        r.add(this.mSelAreaTo);
        ARect worldRect = this.mView.getCanvas().getXForm().getWorldRect(r);
        this.selectByArea((AGeom)worldRect, e.isShiftDown(), e.isControlDown());
        this.mSelAreaTo = null;
        this.mSelAreaFrom = null;
        this.repaint();
    }

    protected void decrementPoints() {
        this.mSelPolygon.removePoint(this.mSelPolygon.getPointCount() - 1);
        this.mSelPolygon.removePoint(this.mSelPolygon.getPointCount() - 1);
        if (this.mSelPolygon.getPointCount() <= 1 && mGeomMode != null) {
            mGeomMode.cancelAreaSpecification();
        }
    }

    public static void insertItemsInMenu(AbstractViewMode.ContextMenu contextMenu, AbstractButton[] contextMenuItems) {
        for (int i = 0; i < contextMenuItems.length; ++i) {
            AbstractButton b = contextMenuItems[i];
            if (b == null) {
                contextMenu.insert(new JSeparator(), i);
                continue;
            }
            contextMenu.insert(b, i);
            UIUtil.setUniqueMnemonic((JPopupMenu)contextMenu, (AbstractButton)b);
        }
    }

    @Override
    protected boolean showContextMenu(JPopupMenu menu, Point loc) {
        if (this.mMode == Mode.POLYGON) {
            GeometryDrawerMode.insertItemsInMenu(this.mContextMenu, this.mContextMenuItems);
        } else if (this.mMode == Mode.PATH || this.mMode == Mode.LASSO) {
            GeometryDrawerMode.insertItemsInMenu(this.mContextMenu, this.mContextLassoMenuItems);
        } else {
            GeometryDrawerMode.insertItemsInMenu(this.mContextMenu, this.mContextCancelOnlyMenuItems);
        }
        boolean res = super.showContextMenu(menu, loc);
        return res;
    }

    @Override
    protected void paintOverlay(Graphics2D g, Rectangle bounds) {
        Rectangle2D tb;
        String sign;
        AGeom spotlightGeom;
        super.paintOverlay(g, bounds);
        if (((Boolean)Settings.get((String)"UserPreferences", (String)"EnableSpotlights", (Object)false)).booleanValue() && (spotlightGeom = mHelper.getSpotlightGeom()) != null) {
            DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
            ARect viewBounds = this.mView.getViewBounds();
            SpotLight.spotlight(g, viewBounds, spotlightGeom, xform);
        }
        if (this.mMode == Mode.UNKNOWN || this.mMode == Mode.END_POLYGON || this.mMode == Mode.END_PATH || this.mMode == Mode.END_LASSO) {
            return;
        }
        if (this.mMode == Mode.POLYGON || this.mMode == Mode.LASSO || this.mMode == Mode.PATH) {
            g.setXORMode(Color.WHITE);
            g.setColor(Color.RED);
            Polygon screenPoly = this.getScreenPolygon(this.mSelPolygon);
            if (screenPoly.npoints > 2) {
                g.drawPolyline(screenPoly.xpoints, screenPoly.ypoints, screenPoly.npoints);
                if (this.mMode == Mode.POLYGON || this.mMode == Mode.LASSO) {
                    g.setColor(Color.PINK);
                    g.drawLine(screenPoly.xpoints[0], screenPoly.ypoints[0], screenPoly.xpoints[screenPoly.npoints - 1], screenPoly.ypoints[screenPoly.npoints - 1]);
                    g.setColor(Color.RED);
                }
            } else {
                g.drawLine(screenPoly.xpoints[0], screenPoly.ypoints[0], screenPoly.xpoints[1], screenPoly.ypoints[1]);
            }
            sign = "Select Poly+";
            if (this.mMode == Mode.LASSO) {
                sign = "Select Lasso+";
            } else if (this.mMode == Mode.PATH) {
                sign = "Select Path+";
            }
            tb = UIUtil.getTextBounds((Graphics2D)g, (String)sign);
            g.drawString(sign, screenPoly.xpoints[screenPoly.npoints - 1] - (int)tb.getWidth() - 3, screenPoly.ypoints[screenPoly.npoints - 1] - 1);
            return;
        }
        if (this.mSelAreaFrom == null) {
            return;
        }
        if (this.mSelAreaTo == null) {
            this.mSelAreaTo = this.mSelAreaFrom;
        }
        g.setXORMode(Color.WHITE);
        g.setColor(Color.RED);
        Rectangle r = new Rectangle(this.mSelAreaFrom);
        r.add(this.mSelAreaTo);
        g.drawRect(r.x, r.y, r.width, r.height);
        sign = "Select +";
        tb = UIUtil.getTextBounds((Graphics2D)g, (String)sign);
        g.drawString(sign, this.mSelAreaTo.x - (int)tb.getWidth() - 3, this.mSelAreaTo.y - 1);
    }

    @Override
    public String getName() {
        return mModeName;
    }

    @Override
    public Cursor getCursor() {
        if (this.mMode == Mode.LASSO || this.mMode == Mode.START_LASSO || this.mMode == Mode.END_LASSO) {
            return UIUtil.createCursor((Icon)OrbitIcons.SELECT_LASSO);
        }
        return UIUtil.createCursor((Icon)OrbitIcons.SELECT);
    }

    protected void selectByArea(AGeom worldGeom, boolean shiftPressed, boolean ctrlPressed) {
        mHelper.selectByArea(worldGeom, mOutlineOnlyMode, shiftPressed, ctrlPressed);
        mOutlineOnlyMode = false;
    }

    public static interface GeometryDrawerHelper {
        public String getModeName();

        public void selectByArea(AGeom var1, boolean var2, boolean var3, boolean var4);

        public void cancelDrawingMode();

        public AGeom getSpotlightGeom();
    }

    public static enum Mode {
        POINT_RECTANGLE,
        POLYGON,
        UNKNOWN,
        END_POLYGON,
        LASSO,
        END_LASSO,
        PATH,
        END_PATH,
        START_RECTANGLE,
        START_POLYGON,
        START_LASSO,
        START_PATH;

    }
}

