/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import com.google.common.collect.Lists;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.log.ALogHelper;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InspectMode
extends AbstractViewMode {
    public static final String MODE_KEY = "InspectMode";
    public static final String MODE_NAME = "Inspect";
    protected Unit mUnit = Unit.IDENTITY;
    protected OptionWorkspace mOptionPanel;

    @Override
    public void installMode(DesignView2D view) {
        super.installMode(view);
        this.mUnit = this.mView == null ? null : this.mView.getUnit();
        this.mOptionPanel = new OptionWorkspace();
        if (this.mUnit == null) {
            this.mUnit = Unit.IDENTITY;
        }
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        if (e.getButton() != 1) {
            return;
        }
        this.showInfoForScreenPt(e.getPoint());
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        this.mOptionPanel.updateLocation(e.getPoint());
    }

    @Override
    public JPanel getOptionPanel() {
        return this.mOptionPanel;
    }

    public void showInfoForUserPt(double x, double y) {
        APoint2D worldPt = new APoint2D(this.mUnit.fromUser(x), this.mUnit.fromUser(y));
        this.showInfoForWorldPt(worldPt);
    }

    public void showInfoForScreenPt(Point p) {
        if (this.mView == null) {
            this.mView = (DesignView2D)OrbitIO.getCurView();
        }
        APoint2D worldPoint = this.mView.getCanvas().getXForm().getWorldPt(p);
        this.showInfoForWorldPt(worldPoint);
    }

    public static boolean isVisible(HierInst<DbObject> hierInst, ViewColorizer colorizer) {
        if (colorizer == null) {
            return true;
        }
        return colorizer.isVisible(hierInst);
    }

    private void logDevice(DevicePath path, Device device) {
        boolean m;
        boolean flipped;
        DeviceTemplate t = device.getTemplate();
        APoint2D relLoc = device.getLoc();
        Object format = "Device '%s' template '%s' at absolute %s, relative %s, with bounds %s of type %s";
        float r = device.getRotate();
        if (r != 0.0f) {
            format = (String)format + " rotated " + r;
        }
        if (flipped = device.getFlipped()) {
            format = (String)format + " flipped";
        }
        if (m = device.getMirror()) {
            format = (String)format + " and mirrored about Y-axis";
        }
        ALog.logInfo((String)format, (Object[])new Object[]{ALogHelper.createSelectElement((HierInst<DbObject>)HierInst.create((DevicePath)path, (DbObject)device), path.escapedString()), t == null ? "" : t.getName(), this.pt(new APoint2D().transform(path.getTransform())), this.pt(relLoc), this.rect(device.getBounds()), t == null ? "-" : t.getType()});
    }

    private void logPort(DevicePath path, PinTemplate pin, PortTemplate port, APoint2D dtRelPt) {
        APoint2D portRelPt = dtRelPt.transform(ATransformUtil.inverse((AffineTransform)port.getLocalTransform()));
        Object s = "";
        ArrayList lshapes = AUtil.arrayList((Iterator)port.getPadTemplate().getLayerShapes());
        Collections.sort(lshapes, new Comparator<LayerShape>(){

            @Override
            public int compare(LayerShape o1, LayerShape o2) {
                return o1.getLayer().compareTo((DbObject)o2.getLayer());
            }
        }.reversed());
        for (LayerShape ls : lshapes) {
            PinInstance pinInst;
            AGeom geom = ls.getGeom();
            if (!geom.intersects(portRelPt)) continue;
            Net net = pin.getNet();
            Net netTop = NetMap.getTopmostNet((Net)net, (DevicePath)path);
            String topNet = "";
            if (netTop != net) {
                topNet = String.format(" (Topmost: '%s')", netTop.getFullPathName());
            }
            String portDesc = "";
            if (pin.hasMultiplePorts()) {
                portDesc = String.format(" (port %d)", port.getPortNum());
            }
            Layer layer = ls.getLayer();
            APoint2D relLoc = port.getLoc();
            s = String.format("   PinTemplate '%s'%s type %s on Layer '%s', Net '%s'%s,", pin.getName(), portDesc, pin.getType(), layer.getName(), net.getName(), topNet);
            s = (String)s + String.format(" at absolute %s , relative %s%s, with shape %s %s", this.pt(relLoc.transform(path.getTransform())), this.pt(relLoc), InspectMode.getRotateMirrorDesc(pin.getRotate(), pin.getMirror()), geom.getName(), geom.toString(this.mUnit));
            if (path != null && !path.isEmpty() && (pinInst = PinInstance.getPinInstance((Device)path.getDevice(), (PinTemplate)pin)) != null) {
                String personalityStr;
                Object instInfo = "";
                if (!AUtil.equals((Object)pinInst.getName(), (Object)pin.getName())) {
                    instInfo = (String)instInfo + String.format("name '%s'", pinInst.getName());
                }
                if ((personalityStr = pinInst.getPersonalitiesString(true, false)).length() > 0) {
                    instInfo = (String)instInfo + String.format("%s%s", ((String)instInfo).length() > 0 ? " " : "", personalityStr);
                }
                if (((String)instInfo).length() > 0) {
                    s = (String)s + String.format(" [Instance info: %s]", instInfo);
                }
            }
            s = (String)s + ".";
            ALog.logInfo((String)s);
            s = null;
        }
    }

    public void showInfoForWorldPt(APoint2D worldPoint) {
        int MaxObjectsOutput = 100;
        Db db = this.mView.getDb();
        ViewColorizer colorizer = this.mView.getColorizer();
        Design design = Design.getDesign((Db)db);
        HashSet<PinTemplate> printedPins = new HashSet<PinTemplate>();
        String header = String.format("========= Inspecting Location %s %s =========", this.pt(worldPoint), this.mUnit.getUserName());
        ALog.logInfo((String)header);
        Interface intf = Interface.find((Db)db, (APoint2D)worldPoint, (boolean)false);
        if (intf != null) {
            Floorplan fp = intf.find(worldPoint);
            String s = null;
            String cnt = fp.getIOCountStr();
            s = String.format("Interface '%s' Floorplan %s (%d pins, IO/Count(Actual: %s, Expected: %d)", intf.getName(), fp.getName(), fp.getNumFloorplanPins(), cnt, intf.getExpectedIOCount());
            ALog.logInfo((String)s);
        }
        int objectsShown = 0;
        for (HierInst hierInst : design.getObjectsAt(worldPoint)) {
            Object layerList;
            HashSet<Layer> layers;
            if (!InspectMode.isVisible((HierInst<DbObject>)hierInst, colorizer)) continue;
            DevicePath path = hierInst.getPath();
            DbObject dbo = hierInst.getDbObject();
            APoint2D dtRelPt = path.getDeviceRelativePoint(worldPoint);
            Object s = null;
            if (dbo instanceof Device) {
                Device device = (Device)dbo;
                this.logDevice(path, device);
            } else if (dbo instanceof PortTemplate) {
                PortTemplate port = (PortTemplate)dbo;
                PinTemplate pin = port.getPinTemplate();
                if (printedPins.contains(pin)) continue;
                printedPins.add(pin);
                this.logPort(path, pin, port, dtRelPt);
            } else if (dbo instanceof Wire) {
                Wire wire = (Wire)dbo;
                APath gpath = wire.getPath();
                Layer layer = wire.getLayer();
                Net net = wire.getNet();
                if (gpath.intersects(dtRelPt)) {
                    s = String.format("   Wire %s of type %s; Layer '%s'; Net '%s'; width %s", wire.getKeyStr(), wire.getType(), layer == null ? "" : layer.getName(), net == null ? "" : net.getName(), this.mUnit.toUserStr(wire.getWidth()));
                    APath wirePath = wire.getPath();
                    if (wirePath != null && wirePath.getPointCount() > 0) {
                        s = (String)s + String.format("; start %s; end %s", wirePath.getFirstPoint().toString(this.mUnit), wirePath.getLastPoint().toString(this.mUnit));
                    }
                }
            } else if (dbo instanceof Metal) {
                Metal metal = (Metal)dbo;
                Layer layer = metal.getLayer();
                AGeom geom = metal.getGeom();
                if (geom.intersects(dtRelPt)) {
                    s = String.format("   Metal of shape '%s' on Layer %s (Net '%s')", geom.copySimplestGeom().getUserName(), layer.getName(), metal.getNet().getName());
                }
            } else if (dbo instanceof Obstacle) {
                Obstacle o = (Obstacle)dbo;
                layers = new HashSet<Layer>();
                for (LayerShape ls : o.getLayerShapes()) {
                    AGeom geom = ls.getGeom();
                    if (geom == null || !geom.intersects(dtRelPt)) continue;
                    layers.add(ls.getLayer());
                }
                if (!layers.isEmpty()) {
                    layerList = "";
                    LinkedList layerNames = Lists.newLinkedList();
                    for (Object l : layers) {
                        layerNames.add(l.getName());
                    }
                    Collections.sort(layerNames);
                    for (Object l : layerNames) {
                        layerList = (String)layerList + (String)l + " ";
                    }
                    s = String.format("   %s on layers %s", o.toString(), layerList);
                }
            } else if (dbo instanceof Bundle) {
                Bundle b = (Bundle)dbo;
                s = String.format("   Bundle '%s'; width %d", b.getName(), b.getDefinedArity());
                layers = new HashSet();
                for (Layer l : b.getLayers()) {
                    layers.add(l);
                }
                if (!layers.isEmpty()) {
                    layerList = layers.stream().map(Layer::getName).sorted().collect(Collectors.joining(", "));
                    s = (String)s + String.format("; connections on layers: %s", layerList);
                }
            } else assert (false) : "Unexpected database object found";
            if (objectsShown > 100) {
                ALog.logInfo((String)"Maximum number of items shown (%d), output stopped.", (Object[])new Object[]{100});
                break;
            }
            if (s == null) continue;
            ALog.logInfo(s);
            ++objectsShown;
        }
    }

    protected static String getRotateMirrorDesc(float rot, boolean mirror) {
        return (rot == 0.0f ? "" : String.format(" rotated %f", Float.valueOf(rot))) + (mirror ? " mirrored" : "");
    }

    @Override
    public String getName() {
        return MODE_NAME;
    }

    @Override
    public Cursor getCursor() {
        return UIUtil.createCursor((Icon)OrbitIcons.INSPECT);
    }

    protected String pt(APoint2D p) {
        return p == null ? "[null]" : p.toString(this.mUnit);
    }

    protected String rect(ARect r) {
        return r == null ? "[null]" : r.toString(this.mUnit);
    }

    protected class OptionWorkspace
    extends JPanel {
        JTextField mTxtX;
        JTextField mTxtY;

        OptionWorkspace() {
            GridBagManager l = new GridBagManager((Container)this);
            this.mTxtX = new JTextField("0", 12);
            this.mTxtY = new JTextField("0", 12);
            this.mTxtX.addActionListener(e -> this.showInfo());
            this.mTxtY.addActionListener(e -> this.showInfo());
            l.add((Component)new JLabel("X:"), (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mTxtX, (GridBagConstraints)GridBagManager.LEFT.insets(0));
            l.newline();
            l.add((Component)new JLabel("Y:"), (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)this.mTxtY, (GridBagConstraints)GridBagManager.LEFT.insets(0));
            l.addFillX();
        }

        public void updateLocation(Point p) {
            if (InspectMode.this.mView == null) {
                InspectMode.this.mView = (DesignView2D)OrbitIO.getCurView();
            }
            APoint2D worldPoint = InspectMode.this.mView.getCanvas().getXForm().getWorldPt(p);
            this.mTxtX.setText("" + worldPoint.getX());
            this.mTxtY.setText("" + worldPoint.getY());
        }

        private void showInfo() {
            try {
                long x = Long.parseLong(this.mTxtX.getText());
                long y = Long.parseLong(this.mTxtY.getText());
                InspectMode.this.showInfoForWorldPt(new APoint2D(x, y));
            }
            catch (Exception e) {
                ALog.logDebug((Throwable)e, (String)"Cannot show info", (Object[])new Object[0]);
            }
        }
    }
}

