/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.ActionOnPlaceableItem;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DbObjectHighlighter;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.public_source.canvas_info.CanvasInfoUtil;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.PlaceableItemUI;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_modes.MovePlaceableItemMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class InteractiveMoveMode
extends AbstractViewMode {
    public static final String MODE_KEY = "Move Mode";
    protected MoveType mMoveType = null;
    protected final Selection mFocusObjs;
    protected HierInst<DbObject> mLastFocusObj = null;
    protected Thread mActiveSearchThread;
    protected MoveKeyHandler mMoveKeyHandler = new MoveKeyHandler();
    protected AFloatWindow mWindow;
    protected boolean mWasVisible;
    ComponentListener mViewComponentListener = new ComponentAdapter(){

        @Override
        public void componentHidden(ComponentEvent e) {
            InteractiveMoveMode.this.mWasVisible = InteractiveMoveMode.this.mWindow.isVisible();
            InteractiveMoveMode.this.mWindow.setVisible(false);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (InteractiveMoveMode.this.mWasVisible) {
                InteractiveMoveMode.this.mWindow.setVisible(true);
            }
        }
    };

    public InteractiveMoveMode() {
        this.mFocusObjs = new Selection(this.getDb());
    }

    @Override
    public void installMode(DesignView2D view) {
        super.installMode(view);
        this.mView.getCanvas().addKeyListener(this.mMoveKeyHandler);
    }

    @Override
    public void installedMode() {
        super.installedMode();
        this.initOptionWindow();
        Rectangle viewBounds = this.mView.getBounds();
        Point p = new Point(viewBounds.x + viewBounds.width / 2 - this.mWindow.getBounds().width / 2, viewBounds.y + viewBounds.height);
        SwingUtilities.convertPointToScreen(p, this.mView.getParent());
        this.mWindow.setLocation(p);
        this.mWindow.setVisible(true);
        this.mWasVisible = true;
        this.mView.addComponentListener(this.mViewComponentListener);
    }

    private void initOptionWindow() {
        this.mWindow = AFloatWindow.createInstance(UIUtil.getParentWindow((Component)this.mView), "Move Options", false);
        GridBagManager l = new GridBagManager(this.mWindow.getContentPane());
        l.push("Common", (GridBagConstraints)GridBagManager.FILLX.width(2));
        MovePlaceableItemMode.MaskCheckBox cb = new MovePlaceableItemMode.MaskCheckBox(PlaceableItemUI.createMenuItemSmartAlign());
        l.add((Component)cb, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.newline();
        cb = new MovePlaceableItemMode.MaskCheckBox(PlaceableItemUI.createMenuItemRestrictOrthogonalMovement());
        l.add((Component)cb, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.newline();
        cb = new MovePlaceableItemMode.MaskCheckBox(PlaceableItemUI.createMenuItemAppropriateGrid());
        l.add((Component)cb, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.newline();
        cb = new MovePlaceableItemMode.MaskCheckBox(PlaceableItemUI.createMenuItemAuxiliaryLine());
        l.add((Component)cb, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.newline();
        l.addFillX();
        l.addFillY();
        l.pop();
        l.newline();
        l.push("Device/Pin", (GridBagConstraints)GridBagManager.FILLALL);
        cb = new MovePlaceableItemMode.MaskCheckBox(PlaceableItemUI.createMenuItemRestrictToParent());
        l.add((Component)cb, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.newline();
        l.addFillX();
        l.addFillY();
        l.pop();
        l.newline();
        this.mWindow.setForcePinned(true);
        this.mWindow.revalidate();
        this.mWindow.pack();
    }

    @Override
    public void uninstallMode() {
        this.mView.getCanvas().removeKeyListener(this.mMoveKeyHandler);
        this.mView.removeComponentListener(this.mViewComponentListener);
        super.uninstallMode();
        UIUtil.closeWindow((Window)((Object)this.mWindow));
    }

    protected void updateFocusObject(APoint2D worldPt) {
        Design design = Design.getDesign((Db)this.getDb(), (boolean)false);
        this.mActiveSearchThread = new Thread(() -> this.startSearch(design, worldPt), "InteractiveMoveMode-Search");
        this.mActiveSearchThread.start();
    }

    protected void stopSearch() {
        if (this.mActiveSearchThread == null) {
            return;
        }
        this.mActiveSearchThread.interrupt();
        this.mActiveSearchThread = null;
    }

    protected void startSearch(Design design, APoint2D worldPt) {
        HierInst<DbObject> hierInst = CanvasInfoUtil.getItemAt(design, worldPt, this.mView.getColorizer());
        this.mLastFocusObj = hierInst;
        if (this.mLastFocusObj == null) {
            OrbitIO.getGuiWorkspace().setStatus("");
        } else {
            OrbitIO.getGuiWorkspace().setStatus(String.format("%s (%s)", this.mLastFocusObj.getPath(), this.mLastFocusObj.getDbObject()));
        }
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        APoint2D worldPt = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
        this.updateFocusObject(worldPt);
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        if (e.getButton() != 1) {
            return;
        }
        if (e.isShiftDown()) {
            this.addFocusObject(this.mLastFocusObj);
        } else {
            this.addFocusObject(this.mLastFocusObj);
            this.startMove();
        }
    }

    protected void startMove() {
        if (this.mFocusObjs.getCountTotal() == 0L) {
            this.mMoveType = null;
            return;
        }
        if (this.mMoveType == MoveType.DEVICE) {
            ActionOnPlaceableItem a = new ActionOnPlaceableItem(this.mFocusObjs, 0, "Device", ActionOnPlaceableItem.ACTION.MOVE_SEL_INT, true, "false, false", "Move Selected Devices Interactively");
            a.actionPerformed(null);
        } else if (this.mMoveType == MoveType.PIN) {
            ActionOnPlaceableItem a = new ActionOnPlaceableItem(this.mFocusObjs, 0, "Pin", ActionOnPlaceableItem.ACTION.MOVE_SEL_INT, true, "false, false", "Move Selected Pins Interactively");
            a.actionPerformed(null);
        }
        this.mFocusObjs.clear();
        this.mMoveType = null;
    }

    protected void addFocusObject(HierInst<DbObject> hierInst) {
        if (hierInst == null) {
            return;
        }
        DevicePath path = hierInst.getPath();
        DbObject dbo = hierInst.getDbObject();
        if (this.mMoveType == MoveType.DEVICE && !(dbo instanceof Device)) {
            return;
        }
        if (this.mMoveType == MoveType.PIN && !(dbo instanceof PinInstance) && !(dbo instanceof PortTemplate)) {
            return;
        }
        if (dbo instanceof Device) {
            this.mMoveType = MoveType.DEVICE;
        } else if (dbo instanceof PinInstance) {
            this.mMoveType = MoveType.PIN;
        } else if (dbo instanceof PortTemplate) {
            this.mMoveType = MoveType.PIN;
            PortTemplate port = (PortTemplate)dbo;
            dbo = PinInstance.getPinInstance((Device)path.getDevice(), (PinTemplate)port.getPinTemplate());
            hierInst = HierInst.create((DevicePath)path, (DbObject)dbo);
        } else {
            return;
        }
        this.mFocusObjs.add(hierInst);
        DbObjectHighlighter.clear(this.mView);
        DbObjectHighlighter.highlight(this.mView, this.mFocusObjs);
    }

    @Override
    public String getName() {
        return MODE_KEY;
    }

    @Override
    public Cursor getCursor() {
        return UIUtil.createCursor((Icon)OrbitIcons.MOVE_ORTH);
    }

    protected class MoveKeyHandler
    implements KeyListener {
        protected MoveKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            InteractiveMoveMode.this.startMove();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    static enum MoveType {
        DEVICE,
        PIN;

    }
}

