/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.db.SelectionCriteria;
import com.sigrity.acl.db.Selector;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.ASeparator;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DbObjectHighlighter;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_modes.InteractiveSelectionUI;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.orbit.ui.route_edit.InteractiveRouteEditMode;
import com.sigrity.orbit.ui.shape_edit.ObstacleShapeEditMode;
import com.sigrity.orbit.ui.side_panels.SelOptionWorkspace;
import com.sigrity.orbit.ui.wb_route.RouteQueueDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;

public class InteractiveSelectMode
extends AbstractViewMode {
    public static final String MODE_KEY = "InteractiveSelectMode";
    public static final String MODE_NAME = "Interactive Select";
    public static final String GEOM_MODE_RECT = "Standard";
    public static final String GEOM_MODE_POLY = "Polygon";
    public static final String GEOM_MODE_LASSO = "Lasso";
    public static final String GEOM_MODE_PATH = "Path";
    protected static final String[] AllGeomModes = new String[]{"Standard", "Polygon", "Lasso", "Path"};
    protected APoint2D mSelAreaFrom;
    protected APoint2D mSelAreaTo;
    protected APolygon mSelPolygon = new APolygon();
    protected Mode mAreaMode = Mode.UNKNOWN;
    protected InteractiveSelectionUI.SelectFilter mSelFilter = null;
    protected SelectionCriteria mCriteria = null;
    protected static SelOptionWorkspace mOptionPanel;
    protected JMenuItem mDonePolygon = new JMenuItem(new AbstractAction("Done"){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (InteractiveSelectMode.this.mAreaMode == Mode.POLYGON) {
                InteractiveSelectMode.this.completePolygon(true, false);
            } else if (InteractiveSelectMode.this.mAreaMode == Mode.PATH) {
                InteractiveSelectMode.this.mSelFilter.setOutlineOnlyMode(true);
                InteractiveSelectMode.this.completePolygon(true, true);
            } else if (InteractiveSelectMode.this.mAreaMode == Mode.LASSO) {
                InteractiveSelectMode.this.completePolygon(true, false);
            }
        }
    });
    protected JMenuItem mCancelPolygon = new JMenuItem(new AbstractAction("Cancel selection"){

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveSelectMode.this.cancelPolygon();
        }
    });
    protected JMenuItem mDoneAsPolygon = new JMenuItem(new AbstractAction("Select Objects Touching Polyline Edges"){

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveSelectMode.this.mSelFilter.setOutlineOnlyMode(true);
            InteractiveSelectMode.this.completePolygon(true, true);
        }
    });
    protected JMenuItem mDoneAsPolyline = new JMenuItem(new AbstractAction("Select Objects Touching Polygon Outline"){

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveSelectMode.this.mSelFilter.setOutlineOnlyMode(true);
            InteractiveSelectMode.this.completeAsPolygonOutline();
        }
    });
    protected JMenuItem mUndoLastPoint = new JMenuItem(new AbstractAction("Undo Last Point"){

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveSelectMode.this.decrementPoints();
        }
    });
    protected JMenuItem mClickSelects = new JMenu("Click Selects"){
        {
            this.addOption("Single item");
            this.addOption("All items");
        }

        void addOption(String s) {
            this.add(InteractiveSelectMode.this.createRadioBtnMenuItem(AUtil.capitalizeFirst((String)s), () -> InteractiveSelectMode.this.mSelFilter.setPointSelectionMode(s), () -> InteractiveSelectMode.this.mSelFilter.getPointSelectionMode().equals(s)));
        }
    };
    protected JMenuItem mUpdateMode = new JMenu("Mode"){
        {
            for (Selection.Mode m : Selection.Mode.values()) {
                this.addOption(m);
            }
        }

        void addOption(Selection.Mode m) {
            this.add(InteractiveSelectMode.this.createRadioBtnMenuItem(m.toString(), () -> InteractiveSelectMode.this.mSelFilter.mSelPanel.setSelectedMode(m), () -> InteractiveSelectMode.this.mSelFilter.mSelPanel.getSelectedMode() == m));
        }
    };
    protected JMenuItem mAreaSelectShape = new JMenu("Select Area By"){
        {
            for (String s : AllGeomModes) {
                this.addOption(s);
            }
        }

        void addOption(String s) {
            this.add(InteractiveSelectMode.this.createRadioBtnMenuItem(AUtil.capitalizeFirst((String)s), () -> InteractiveSelectMode.this.mSelFilter.setGeometryMode(s), () -> InteractiveSelectMode.this.mSelFilter.getGeometryMode().equals(s)));
        }
    };
    protected JMenuItem mAreaSelectOpt = new JMenu("Area Selects"){
        {
            this.addOption("Touching");
            this.addOption("Inside");
        }

        void addOption(String s) {
            this.add(InteractiveSelectMode.this.createRadioBtnMenuItem(AUtil.capitalizeFirst((String)s), () -> InteractiveSelectMode.this.mSelFilter.setAreaTouchMode(s), () -> InteractiveSelectMode.this.mSelFilter.getAreaTouchMode().equals(s)));
        }
    };
    protected AbstractButton[] mContextMenuPolygonItems = new AbstractButton[]{this.mDonePolygon, this.mCancelPolygon, this.mDoneAsPolyline, this.mDoneAsPolygon, this.mUndoLastPoint};
    protected AbstractButton[] mContextLassoMenuItems = new AbstractButton[]{this.mDonePolygon, this.mCancelPolygon};
    private SelectCircularContext mSelectCircular = new SelectCircularContext();

    public InteractiveSelectionUI.SelectFilter getSelectFilter() {
        return this.mSelFilter;
    }

    public void setSelectFilter(InteractiveSelectionUI.SelectFilter filter) {
        this.mSelFilter = filter;
    }

    public InteractiveSelectMode() {
        this(new SelectionCriteria());
        this.mCriteria.setReferenceClass(Device.class.getTypeName());
        this.mCriteria.setAreaMode(Selection.AreaMode.Contain);
        this.mCriteria.setPointSelectsSingleItem(true);
        this.mCriteria.setMode(Selection.Mode.Replace);
    }

    public InteractiveSelectMode(SelectionCriteria sc) {
        this.mCriteria = sc;
    }

    @Override
    protected void installedMode() {
        super.installedMode();
        this.mSelFilter = new InteractiveSelectionUI.SelectFilter(this.mView);
        if (this.mCriteria != null) {
            this.mSelFilter.setCriteria(this.mCriteria);
        }
        this.mAreaMode = Mode.UNKNOWN;
        this.installOptionPanel();
    }

    @Override
    public void uninstallMode() {
        this.uninstallOptionPanel();
        super.uninstallMode();
    }

    private void installOptionPanel() {
        if (mOptionPanel == null) {
            mOptionPanel = new SelOptionWorkspace();
        }
        Db db = this.mView.getDb();
        Selection.getCurrentSelectionForDb((Db)db).addSelectionListener(mOptionPanel.getSelListener());
        db.getHistory().addListener(mOptionPanel.getDbHistoryListener());
        OrbitApp.getApp().addCurrentDbListener(mOptionPanel.getCurDbListener());
        DbObjectHighlighter.addHighlightListener(mOptionPanel.getHighlightListener());
    }

    private void uninstallOptionPanel() {
        Db db;
        if (mOptionPanel == null) {
            mOptionPanel = new SelOptionWorkspace();
        }
        if ((db = this.mView.getDb()) != null) {
            DbHistory history;
            Design design = Design.getDesign((Db)db, (boolean)false);
            if (design != null) {
                design.getCurSelection().removeSelectionListener(mOptionPanel.getSelListener());
            }
            if ((history = db.getHistory()) != null) {
                history.removeListener(mOptionPanel.getDbHistoryListener());
            }
        }
        if (OrbitApp.getApp() != null) {
            OrbitApp.getApp().removeCurrentDbListener(mOptionPanel.getCurDbListener());
        }
        DbObjectHighlighter.removeHighlightListener(mOptionPanel.getHighlightListener());
    }

    public void setCriteria(String selectionCriteriaId) {
        Optional s = SelectionCriteria.getSelectionCriteria((String)selectionCriteriaId);
        if (s.isPresent()) {
            this.mSelFilter.setCriteria((SelectionCriteria)s.get());
            this.setCriteria((SelectionCriteria)s.get());
        }
    }

    public void setCriteria(SelectionCriteria sc) {
        this.mCriteria = sc;
    }

    public SelectionCriteria getCriteria() {
        return this.mCriteria;
    }

    @Override
    protected void removingMode() {
        if (this.mSelFilter != null) {
            this.mSelFilter.enableSelectionPanel(false);
        }
    }

    @Override
    protected boolean updateModifiers(int newVal) {
        boolean r = super.updateModifiers(newVal);
        if (r) {
            this.repaintOverlay();
        }
        return r;
    }

    @Override
    public void mousePressed(DesignView2D.MouseAction e) {
        APoint2D p;
        super.mousePressed(e);
        if (e.getButton() != 1) {
            if (this.mAreaMode == Mode.POLYGON && e.getButton() == 3) {
                APoint2D p2 = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
                this.mSelPolygon.setPoint(this.mSelPolygon.getPointCount() - 1, p2);
                this.mSelPolygon.addPoint(p2);
            }
            return;
        }
        if (this.mAreaMode == Mode.LASSO || this.mAreaMode == Mode.PATH) {
            APoint2D p3 = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
            this.mSelPolygon.setPoint(this.mSelPolygon.getPointCount() - 1, p3);
            if (this.mAreaMode == Mode.LASSO) {
                this.completePolygon(true, false);
            } else {
                this.mSelFilter.setOutlineOnlyMode(true);
                this.completePolygon(true, true);
            }
            this.mAreaMode = Mode.END_POLYGON;
            this.repaintOverlay();
            return;
        }
        if (this.mAreaMode == Mode.UNKNOWN) {
            if (this.mSelFilter.getGeometryType().equals(GEOM_MODE_RECT)) {
                this.mAreaMode = Mode.POINT_RECTANGLE;
            } else {
                this.mAreaMode = this.mSelFilter.getGeometryType().equals(GEOM_MODE_LASSO) ? Mode.LASSO : (this.mSelFilter.getGeometryType().equals(GEOM_MODE_PATH) ? Mode.PATH : Mode.POLYGON);
                this.mSelPolygon = new APolygon();
                p = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
                this.mSelPolygon.addPoint(p);
            }
        }
        if (this.mAreaMode == Mode.POLYGON) {
            p = this.getWorldPoint(e.getPoint());
            this.mSelPolygon.setPoint(this.mSelPolygon.getPointCount() - 1, p);
            if (e.isShiftDown()) {
                this.restrictPolygonOrthogonal();
            }
            if (e.getButton() == 1 && e.getClickCount() == 2) {
                this.completePolygon(false, false);
                return;
            }
            this.mSelPolygon.addPoint(p);
        } else {
            this.mSelAreaFrom = this.getWorldPoint(e.getPoint());
            this.mSelAreaTo = null;
        }
        this.repaintOverlay();
    }

    private void completePolygon(boolean setModeUnknown, boolean completeAsPolyline) {
        if (completeAsPolyline) {
            this.mSelPolygon.completeAsPolyline();
        }
        this.mSelPolygon.removeRedundantPoints();
        if (this.mSelPolygon.getPointCount() == 1) {
            ARect pointRect = new ARect(this.mSelPolygon.getPoint(0), this.mSelPolygon.getPoint(0));
            this.selectByArea((AGeom)pointRect);
        } else {
            this.selectByArea((AGeom)this.mSelPolygon);
        }
        this.repaintView();
        this.mAreaMode = setModeUnknown ? Mode.UNKNOWN : Mode.END_POLYGON;
        this.mSelPolygon = new APolygon();
    }

    private void completeAsPolygonOutline() {
        this.mSelPolygon.removePoint(this.mSelPolygon.getPointCount() - 1);
        this.mSelPolygon.addPoint(this.mSelPolygon.getPoint(0));
        this.mSelPolygon.completeAsPolyline();
        this.selectByArea((AGeom)this.mSelPolygon);
        this.repaintView();
        this.mAreaMode = Mode.UNKNOWN;
        this.mSelPolygon = new APolygon();
    }

    private void cancelPolygon() {
        this.mSelPolygon = new APolygon();
        this.repaintView();
        this.mAreaMode = Mode.UNKNOWN;
    }

    private void restrictPolygonOrthogonal() {
        this.mSelPolygon.restrictLastSegmentVertHoriz();
    }

    private void moveToFit(Point screenLoc, Rectangle screenBound) {
        DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
        ARect worldRect = xform.getWorldRect(screenBound);
        APoint2D worldPt = xform.getWorldPt(screenLoc);
        long xOffset = 0L;
        long yOffset = 0L;
        if (worldPt.getX() < worldRect.left()) {
            xOffset = worldPt.getX() - worldRect.left();
        } else if (worldPt.getX() > worldRect.right()) {
            xOffset = worldPt.getX() - worldRect.right();
        }
        if (worldPt.getY() < worldRect.bottom()) {
            yOffset = worldPt.getY() - worldRect.bottom();
        } else if (worldPt.getY() > worldRect.top()) {
            yOffset = worldPt.getY() - worldRect.top();
        }
        xform.moveWorldBy(xOffset, yOffset);
        this.mView.getCanvas().refreshNow();
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        if (this.mAreaMode == Mode.POLYGON) {
            this.mSelPolygon.setPoint(this.mSelPolygon.getPointCount() - 1, this.mView.getCanvas().getXForm().getWorldPt(e.getPoint()));
            if (e.isShiftDown()) {
                this.restrictPolygonOrthogonal();
            }
            this.repaintOverlay();
        } else if (this.mAreaMode == Mode.LASSO || this.mAreaMode == Mode.PATH) {
            APoint2D p = this.mView.getCanvas().getXForm().getWorldPt(e.getPoint());
            this.mSelPolygon.addPoint(p);
            this.repaintOverlay(true);
        }
    }

    @Override
    public void mouseDragged(DesignView2D.MouseAction e) {
        super.mouseDragged(e);
        if (this.mAreaMode == Mode.POLYGON || this.mAreaMode == Mode.END_POLYGON) {
            return;
        }
        if (this.mAreaMode == Mode.LASSO || this.mAreaMode == Mode.PATH) {
            APoint2D p = this.getWorldPoint(e.getPoint());
            this.mSelPolygon.addPoint(p);
            this.repaintOverlay(true);
        } else if (this.mAreaMode == Mode.POINT_RECTANGLE && e.isOutside()) {
            Rectangle rect = e.getComponent().getBounds();
            Point pt = e.getPoint();
            this.moveToFit(pt, rect);
        }
        this.mSelAreaTo = this.getWorldPoint(e.getPoint());
        this.repaintOverlay();
    }

    @Override
    public void mouseReleased(DesignView2D.MouseAction e) {
        super.mouseReleased(e);
        if (this.mAreaMode == Mode.POLYGON || this.mAreaMode == Mode.LASSO || this.mAreaMode == Mode.PATH) {
            return;
        }
        if (this.mAreaMode == Mode.END_POLYGON) {
            this.mAreaMode = Mode.UNKNOWN;
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        if (this.mSelAreaFrom == null) {
            this.mSelAreaFrom = this.getWorldPoint(e.getPoint());
        }
        this.mSelAreaTo = this.getWorldPoint(e.getPoint());
        ARect worldRect = new ARect(this.mSelAreaFrom, this.mSelAreaFrom);
        worldRect.expand(this.mSelAreaTo);
        this.selectByArea((AGeom)worldRect);
        this.mSelAreaTo = null;
        this.mSelAreaFrom = null;
        this.repaintView();
        this.mAreaMode = Mode.UNKNOWN;
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        if (e.getButton() != 1) {
            return;
        }
        if (this.mCriteria == null || this.mCriteria.getReferenceClass() == null) {
            return;
        }
        if (e.getClickCount() > 1) {
            Point pt = e.getPoint();
            Rectangle r = new Rectangle(pt);
            ARect worldRect = this.mView.getCanvas().getXForm().getWorldRect(r);
            Db db = this.getDb();
            Selector.Descriptor selDesc = this.mCriteria.getSelectorDesciptor();
            if (selDesc == Selectors.BundleSelector.Descriptor) {
                Selectors.BundleSelector selector = new Selectors.BundleSelector(SelectionContext.create((Db)db));
                HierInst bestChoice = null;
                Iterator iterator = selector.getMatching((AGeom)worldRect, Selection.AreaMode.Touch, null, null).iterator();
                while (iterator.hasNext()) {
                    HierInst hw;
                    bestChoice = hw = (HierInst)iterator.next();
                }
                if (bestChoice != null) {
                    Bundle b = (Bundle)bestChoice.getDbObject();
                    InteractiveRouteEditMode.editBundleInit(b);
                }
            } else if (selDesc == Selectors.ShapeSelector.Descriptor) {
                LayerShape ls;
                Selectors.ShapeSelector selector = new Selectors.ShapeSelector(SelectionContext.create((Db)db));
                HierInst bestChoice = null;
                for (HierInst hw : selector.getMatching((AGeom)worldRect, Selection.AreaMode.Touch, null, null)) {
                    bestChoice = bestChoice == null ? hw : selector.getBetter(bestChoice, hw, worldRect);
                }
                if (bestChoice != null && bestChoice.getDbObject() instanceof LayerShape && (ls = (LayerShape)bestChoice.getDbObject()).getOwner() instanceof Obstacle) {
                    ObstacleShapeEditMode editMode = ObstacleShapeEditMode.install(this.mView);
                    editMode.selectLoc(worldRect.getLL());
                }
            } else if (selDesc == Selectors.WireSelector.Descriptor) {
                Selectors.WireSelector selector = new Selectors.WireSelector(SelectionContext.create((Db)db));
                HierInst bestChoice = null;
                Iterator ls = selector.getMatching((AGeom)worldRect, Selection.AreaMode.Touch, null, null).iterator();
                while (ls.hasNext()) {
                    HierInst hw;
                    bestChoice = hw = (HierInst)ls.next();
                }
                if (bestChoice != null) {
                    Wire w = (Wire)bestChoice.getDbObject();
                    AAppView view = OrbitIO.getCurView();
                    if (view instanceof DesignView2D) {
                        InteractiveRouteEditMode.startEditWire((DesignView2D)view, bestChoice.getPath(), w, true);
                    }
                }
            }
        }
    }

    protected void decrementPoints() {
        this.mSelPolygon.removePoint(this.mSelPolygon.getPointCount() - 1);
        this.mSelPolygon.removePoint(this.mSelPolygon.getPointCount() - 1);
        if (this.mSelPolygon.getPointCount() <= 1) {
            this.cancelPolygon();
        }
    }

    protected JRadioButtonMenuItem createRadioBtnMenuItem(String s, final Runnable action, final BooleanSupplier selected) {
        final AbstractAction a = new AbstractAction(AUtil.capitalizeFirst((String)s)){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.run();
            }
        };
        return new JRadioButtonMenuItem(a){

            @Override
            public void addNotify() {
                super.addNotify();
                a.putValue("SwingSelectedKey", selected.getAsBoolean());
            }
        };
    }

    @Override
    protected void loadContextMenu(AbstractViewMode.ContextMenu menu, Point loc) {
        if (this.mCriteria == null || this.mCriteria.getReferenceClass() == null) {
            super.loadContextMenu(menu, loc);
            return;
        }
        OrbitGuiShortcutActionRegistry.ViewConstraint vc = OrbitGuiShortcutActionRegistry.ViewConstraint.createAll();
        if (this.mCriteria.getReferenceClass().equals(Bundle.class.getName())) {
            vc = OrbitGuiShortcutActionRegistry.ViewConstraint.createEmpty();
            vc.add(Bundle.class);
            vc.add(HierInst.class);
        }
        menu.loadMenu(loc, vc);
    }

    @Override
    protected boolean showContextMenu(JPopupMenu menu, Point loc) {
        int insertAt;
        JMenuItem miClearSelection = null;
        Action actionClearSelection = this.mView.getCanvas().getActionMap().get("Clear Selection");
        int posSelItemsEnd = -1;
        boolean inSelItems = false;
        int posInspectAction = -1;
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component comp = menu.getComponent(i);
            if (comp instanceof JMenuItem) {
                JMenuItem mi = (JMenuItem)comp;
                Action action = mi.getAction();
                if (action != null && action == actionClearSelection) {
                    miClearSelection = mi;
                }
                if (action instanceof AbstractViewMode.ActionInspectPoint) {
                    posInspectAction = i;
                }
            }
            if (inSelItems && comp instanceof JSeparator) {
                posSelItemsEnd = i;
                inSelItems = false;
                continue;
            }
            if (!(comp instanceof ASeparator)) continue;
            String text = ((ASeparator)comp).getText();
            if (posSelItemsEnd >= 0 || text == null || !text.startsWith("Selection")) continue;
            inSelItems = true;
        }
        if (inSelItems && posSelItemsEnd == -1) {
            posSelItemsEnd = menu.getComponentCount();
        }
        int n = posSelItemsEnd >= 0 ? posSelItemsEnd : (insertAt = posInspectAction >= 0 ? posInspectAction : 0);
        if (insertAt == 0 && menu.getComponentCount() > 0 && !(menu.getComponent(0) instanceof JSeparator)) {
            menu.insert(new JSeparator(), 0);
        } else if (insertAt > 0 && menu.getComponent(insertAt - 1) instanceof JSeparator) {
            --insertAt;
        }
        LinkedList<Object> contextMenuItems = new LinkedList<Object>();
        if (posSelItemsEnd < 0) {
            contextMenuItems.add(new ASeparator("Selection Actions"));
        }
        if (miClearSelection != null) {
            menu.remove(miClearSelection);
            contextMenuItems.add(miClearSelection);
        }
        if (this.mAreaMode == Mode.POLYGON || this.mAreaMode == Mode.PATH || this.mAreaMode == Mode.LASSO) {
            if (this.mAreaMode == Mode.POLYGON) {
                contextMenuItems.addAll(Arrays.asList(this.mContextMenuPolygonItems));
            } else if (this.mAreaMode == Mode.PATH || this.mAreaMode == Mode.LASSO) {
                contextMenuItems.addAll(Arrays.asList(this.mContextLassoMenuItems));
            }
        }
        contextMenuItems.addAll(AUtil.linkedList((Object[])new JMenuItem[]{this.mUpdateMode, this.mClickSelects, this.mAreaSelectShape, this.mAreaSelectOpt}));
        for (JComponent jComponent : contextMenuItems) {
            if (jComponent == null) {
                this.mContextMenu.insert(new JSeparator(), insertAt);
            } else {
                this.mContextMenu.insert(jComponent, insertAt);
                if (jComponent instanceof AbstractButton) {
                    UIUtil.setUniqueMnemonic((JPopupMenu)this.mContextMenu, (AbstractButton)((AbstractButton)jComponent));
                }
            }
            ++insertAt;
        }
        return super.showContextMenu(menu, loc);
    }

    @Override
    public JPanel getOptionPanel() {
        return mOptionPanel.getContentPane();
    }

    @Override
    protected void paintOverlay(Graphics2D g, Rectangle bounds) {
        super.paintOverlay(g, bounds);
        if (this.mAreaMode == Mode.UNKNOWN || this.mAreaMode == Mode.END_POLYGON) {
            return;
        }
        if (this.mAreaMode == Mode.POLYGON || this.mAreaMode == Mode.LASSO || this.mAreaMode == Mode.PATH) {
            g.setXORMode(Color.WHITE);
            g.setColor(Color.RED);
            Polygon screenPoly = this.getScreenPolygon(this.mSelPolygon);
            if (screenPoly.npoints > 2) {
                g.drawPolyline(screenPoly.xpoints, screenPoly.ypoints, screenPoly.npoints);
                if (this.mAreaMode == Mode.POLYGON || this.mAreaMode == Mode.LASSO) {
                    g.setColor(Color.PINK);
                    g.drawLine(screenPoly.xpoints[0], screenPoly.ypoints[0], screenPoly.xpoints[screenPoly.npoints - 1], screenPoly.ypoints[screenPoly.npoints - 1]);
                    g.setColor(Color.RED);
                }
            } else {
                g.drawLine(screenPoly.xpoints[0], screenPoly.ypoints[0], screenPoly.xpoints[1], screenPoly.ypoints[1]);
            }
            String sign = "Select Poly+";
            if (this.mAreaMode == Mode.LASSO) {
                sign = "Select Lasso+";
            } else if (this.mAreaMode == Mode.PATH) {
                sign = "Select Path+";
            }
            Rectangle2D tb = UIUtil.getTextBounds((Graphics2D)g, (String)sign);
            g.drawString(sign, screenPoly.xpoints[screenPoly.npoints - 1] - (int)tb.getWidth() - 3, screenPoly.ypoints[screenPoly.npoints - 1] - 1);
            return;
        }
        if (this.mSelAreaFrom == null) {
            return;
        }
        if (this.mSelAreaTo == null) {
            this.mSelAreaTo = this.mSelAreaFrom;
        }
        g.setXORMode(Color.WHITE);
        g.setColor(Color.RED);
        ARect worldRect = new ARect(this.mSelAreaFrom, this.mSelAreaFrom);
        worldRect.expand(this.mSelAreaTo);
        g.draw(this.getScreenRect(worldRect));
        Point stPt = this.getScreenPoint(this.mSelAreaTo);
        String desc = "Select " + InteractiveSelectMode.getModifiedSelectionMode(this.mSelFilter.getSelectionMode(), this.getModifiers());
        Rectangle2D tb = UIUtil.getTextBounds((Graphics2D)g, (String)desc);
        g.drawString(desc, stPt.x - (int)tb.getWidth() - 3, stPt.y - 1);
    }

    public static Selection.Mode getModifiedSelectionMode(Selection.Mode m, int modifiers) {
        boolean ctrl = UIUtil.isCtrlDown((int)modifiers);
        boolean shft = UIUtil.isShiftDown((int)modifiers);
        if (!shft && !ctrl) {
            return m;
        }
        if (shft && ctrl) {
            return m;
        }
        int i = m.ordinal();
        if ((i += shft ? 1 : 2) > 2) {
            i -= 3;
        }
        return Selection.Mode.values()[i];
    }

    @Override
    public String getName() {
        return MODE_NAME;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    protected void selectByArea(AGeom worldGeom) {
        DbHistory history = OrbitIO.getCurDb().getHistory();
        try (DbHistory.DbTransaction transaction = history.newDbTransaction("Select By Area");){
            SelectionCriteria criteria = this.mSelFilter.getCriteria();
            Selection.Mode mode = this.mSelFilter.getModifiedSelectionMode(this.getModifiers());
            if (criteria.getPointSelectsSingleItem() && mode == Selection.Mode.Replace && worldGeom instanceof ARect && ((ARect)worldGeom).isPoint()) {
                ARect r = (ARect)worldGeom;
                this.selectCircular(r);
            } else {
                this.mSelFilter.createSelectionCriteria(this.getModifiers(), true);
                this.mSelFilter.selectUsingCurrentCriteria(worldGeom);
            }
        }
    }

    protected List<HierInst<DbObject>> preselectByArea(AGeom worldGeom) {
        Db db = this.getDb();
        SelectionCriteria criteria = this.mSelFilter.getCriteria();
        SelectionContext selCtx = SelectionContext.create((Db)db);
        selCtx.setNetFiltersMatchMapped(criteria.getNetFilterConsidersConnectedNets());
        String limitSubstKey = criteria.getLimitToSubstrate();
        Substrate limitSubst = null;
        if (limitSubstKey != null) {
            limitSubst = (Substrate)db.getByKeyStr(Substrate.class, limitSubstKey);
            if (limitSubst == null) {
                ALog.logWarn((String)"The specified substrate key '%s' is invalid, it is being ignored.", (Object[])new Object[]{limitSubstKey});
            }
            selCtx.setSubstrate(limitSubst);
        }
        Selector selector = criteria.getSelectorDesciptor().createSelector(selCtx);
        return AUtil.arrayList((Iterator)selector.getMatching(worldGeom, criteria.getAreaMode(), criteria.getPropertyFilters(), Selection.Filters.aggregate((Iterable)criteria.getFilters())));
    }

    private void selectCircular(ARect worldPt) {
        this.mSelFilter.createSelectionCriteria(this.getModifiers(), true);
        Db db = this.getDb();
        SelectionCriteria criteria = this.mSelFilter.getCriteria();
        SelectionContext selCtx = SelectionContext.create((Db)db);
        selCtx.setNetFiltersMatchMapped(criteria.getNetFilterConsidersConnectedNets());
        String limitSubstKey = criteria.getLimitToSubstrate();
        Substrate limitSubst = null;
        if (limitSubstKey != null) {
            limitSubst = (Substrate)db.getByKeyStr(Substrate.class, limitSubstKey);
            if (limitSubst == null) {
                ALog.logWarn((String)"The specified substrate key '%s' is invalid, it is being ignored.", (Object[])new Object[]{limitSubstKey});
            }
            selCtx.setSubstrate(limitSubst);
        }
        Selector selector = criteria.getSelectorDesciptor().createSelector(selCtx);
        ArrayList matches = AUtil.arrayList((Iterator)selector.getMatching((AGeom)worldPt, Selection.AreaMode.Touch, criteria.getPropertyFilters(), Selection.Filters.aggregate((Iterable)criteria.getFilters())));
        CpHelper.cpClearSelection();
        if (matches.isEmpty()) {
            return;
        }
        int selIndex = 0;
        boolean inCircular = this.mSelectCircular.in(criteria, worldPt);
        matches.sort((a, b) -> selector.getBetter(a, b, worldPt) == a ? -1 : 1);
        HierInst selObj = null;
        if (inCircular) {
            selIndex = (this.mSelectCircular.getLastIndex() + 1) % matches.size();
            selObj = (HierInst)matches.get(selIndex);
        } else {
            selIndex = 0;
            selObj = (HierInst)matches.get(0);
        }
        this.mSelectCircular.record(criteria, worldPt, selIndex);
        if (selObj != null) {
            Cp.exec((String)"Selection.selectClick(%s);", (Object[])new Object[]{selObj.toCpString()});
        }
    }

    public static void deleteSelections() {
        Db db = OrbitIO.getCurDb();
        Selection sel = Selection.getCurrentSelectionForDb((Db)db);
        if (sel == null) {
            return;
        }
        int selDevices = sel.getCount(db.getDbClass(Device.class));
        int selPins = sel.getCount(db.getDbClass(PinInstance.class));
        int selBundles = sel.getCount(db.getDbClass(Bundle.class));
        int selConnections = sel.getCount(db.getDbClass(Connection.class));
        int selWires = sel.getCount(db.getDbClass(Wire.class));
        int selObstacles = sel.getCount(db.getDbClass(Obstacle.class));
        DesignView2D v2d = (DesignView2D)OrbitIO.getCurView();
        DesignView2D.ViewMode curMode = v2d.getCurMode();
        DbHistory history = OrbitIO.getCurDb().getHistory();
        try (DbHistory.DbTransaction trans = history.newDbTransaction("Delete Selected Objects");){
            if (selBundles > 0) {
                if (RouteQueueDlg.getLastDialog() != null) {
                    RouteQueueDlg.getLastDialog().removeNotify();
                }
                Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.delete()", (Object[])new Object[0]);
            }
            if (selPins > 0) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.DoPin.Start()", (Object[])new Object[0]);
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.deleteSelected()", (Object[])new Object[0]);
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.DoPin.end()", (Object[])new Object[0]);
                v2d.setMode(curMode);
            }
            if (selDevices > 0) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.DoDevice.Start()", (Object[])new Object[0]);
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.deleteSelected()", (Object[])new Object[0]);
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.DoDevice.end()", (Object[])new Object[0]);
                v2d.setMode(curMode);
            }
            if (selConnections > 0) {
                Cp.exec((String)"com.sigrity.orbit.cmd.ConnectionCommands.deleteSelectedConnections(curDb())", (Object[])new Object[0]);
            }
            if (selWires > 0) {
                Cp.exec((String)"com.sigrity.orbit.cmd.WireCommands.delSelWires();", (Object[])new Object[0]);
            }
            if (selObstacles > 0) {
                Cp.exec((String)"com.sigrity.orbit.cmd.ObstacleCmd.deleteSelectedObstacles(curDb());", (Object[])new Object[0]);
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    private static class SelectCircularContext {
        private long mLastTime = 0L;
        private SelectionCriteria mLastCriteria = null;
        private ARect mLastGeom = null;
        private int mIndex = 0;
        private static final long DELAY = 2000L;

        private SelectCircularContext() {
        }

        public void record(SelectionCriteria criteria, ARect worldPt, int index) {
            this.mLastTime = System.currentTimeMillis();
            this.mLastCriteria = criteria;
            this.mLastGeom = worldPt;
            this.mIndex = index;
        }

        public boolean in(SelectionCriteria criteria, ARect worldPt) {
            if (System.currentTimeMillis() - this.mLastTime > 2000L) {
                return false;
            }
            if (this.mLastCriteria == null || this.mLastGeom == null) {
                return false;
            }
            return criteria.equals((Object)this.mLastCriteria) && worldPt.equals((Object)this.mLastGeom);
        }

        public int getLastIndex() {
            return this.mIndex;
        }
    }

    public static enum Mode {
        POINT_RECTANGLE,
        POLYGON,
        UNKNOWN,
        END_POLYGON,
        LASSO,
        PATH;

    }
}

