/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.DefaultCommonDockable;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.SelectionCriteria;
import com.sigrity.acl.db.Selector;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.SubstrateListRenderer;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.ASeparator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.FilterByPropertyNameValuePanel;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.SelectionCriteriaUI;
import com.sigrity.orbit.ui.canvas_modes.InteractiveSelectMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class InteractiveSelectionUI {
    protected static final int DefaultDescriptorSelIdx = 1;
    public static final String AREA_INSIDE = "Inside";
    public static final String AREA_TOUCH = "Touching";
    public static final String CLICKMODE_ALLITEMS = "All items";
    public static final String CLICKMODE_SINGLEITEM = "Single item";
    private static boolean isRegistered = false;
    private static SelectDockPanel thePanel = null;
    private static ViewListener theViewListener = null;
    private static Db.DbListener theDbListener = null;
    public static final String settingNameVisible = "SelectDockPanelVisible";
    private static final SingleCDockableFactory dockableFactory = id -> {
        DefaultSingleCDockable dockable = new DefaultSingleCDockable(id, new CAction[0]);
        dockable.setLocation((CLocation)CLocation.base().normalRectangle(0.95, 0.0, 0.05, 1.0));
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setTitleIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.SELECT, (int)16, (int)16));
        dockable.addFocusListener(new CFocusListener(){

            public void focusGained(CDockable d) {
                OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
                ws.getAction("StartInteractiveSelectMode").actionPerformed(null);
            }

            public void focusLost(CDockable d) {
            }
        });
        return dockable;
    };

    private InteractiveSelectionUI() {
    }

    private static OrbitGuiWS getWorkspace() {
        OrbitIO app = OrbitIO.getApp();
        return app == null ? null : app.getWorkspace();
    }

    public static void notifyViewChange() {
        OrbitGuiWS ws = InteractiveSelectionUI.getWorkspace();
        AAppView view = ws == null ? null : ws.getCurrentView();
        InteractiveSelectionUI.notifyViewChange(view);
    }

    public static void notifyViewChange(AAppView newView) {
        if (thePanel != null) {
            thePanel.setView(newView);
        }
    }

    public static boolean getPanelVisible() {
        return thePanel != null;
    }

    public static void setPanelVisible(boolean show) {
        InteractiveSelectionUI.setPanelVisible(show, false);
    }

    public static void setPanelVisible(boolean show, boolean fromXML) {
        DefaultSingleCDockable dock;
        OrbitGuiWS ws;
        OrbitIO app = OrbitIO.getApp();
        OrbitGuiWS orbitGuiWS = ws = app == null ? null : app.getWorkspace();
        if (ws == null) {
            ALog.logError((String)"Unable to show the View Options Panel, unable to find an OrbitIO GUI workspace.");
            assert (false);
            return;
        }
        if (show && thePanel == null) {
            thePanel = new SelectDockPanel(app.getCurrentDb());
            Db.addDbListener((Db.DbListener)theDbListener);
            ws.addViewListener(theViewListener);
        }
        if (!fromXML) {
            ws.setSingleDockableVisible(thePanel, show, null);
        } else if (thePanel != null && (dock = ws.getSingleDockable(thePanel.getClass().getName())) != null) {
            dock.getContentPane().removeAll();
            dock.getContentPane().add(thePanel);
            dock.setTitleText(thePanel.getName());
        }
        if (!show && thePanel != null) {
            thePanel = null;
        }
    }

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitGuiWS ws = InteractiveSelectionUI.getWorkspace();
        if (ws == null) {
            return;
        }
        CControl dockControl = ws.getDockingController();
        dockControl.addSingleDockableFactory(SelectDockPanel.class.getName(), dockableFactory);
        isRegistered = true;
        Selection.register();
        theViewListener = new ViewAdapter(){

            public void activeViewChanged(AAppView oldView, AAppView newView) {
                InteractiveSelectionUI.notifyViewChange(newView);
            }

            public void viewOpened(AAppView view) {
                InteractiveSelectionUI.notifyViewChange(view);
            }
        };
        theDbListener = new Db.DbListenerAdapter(){

            public void dbObjectListenerStateChange(Db db, boolean listenersEnabled) {
                if (listenersEnabled) {
                    InteractiveSelectionUI.notifyViewChange();
                }
            }

            public void dbLoaded(Db db) {
                InteractiveSelectionUI.notifyViewChange();
            }
        };
        Settings s = Settings.getSettings((String)"GUI");
        boolean b = Boolean.parseBoolean((String)s.getSetting(settingNameVisible, (Object)"true"));
        InteractiveSelectionUI.setPanelVisible(b);
        ws.getMainFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Settings s = Settings.getSettings((String)"GUI");
                s.putSetting(InteractiveSelectionUI.settingNameVisible, (Object)InteractiveSelectionUI.getPanelVisible());
                s.save();
            }
        });
        ws.addViewListener(theViewListener);
        Db.addDbListener((Db.DbListener)theDbListener);
    }

    public static Stream<Dockable> getDockableChildren(DockStation ds) {
        return AIterableItr.itr((int)ds.getDockableCount(), idx -> ds.getDockable(idx)).stream();
    }

    public static Stream<Dockable> getDockableDescendants(DockStation ds) {
        return InteractiveSelectionUI.getDockableChildren(ds).flatMap(d -> {
            DockStation s = d.asDockStation();
            if (s != null) {
                return Stream.concat(Stream.of(d), InteractiveSelectionUI.getDockableDescendants(s));
            }
            return Stream.of(d);
        });
    }

    public static Stream<CStation<?>> getCStations(CContentArea ca) {
        return AIterableItr.itr((Object[])ca.getStations()).stream();
    }

    private static void enableComponents(Container container, boolean enable) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            component.setEnabled(enable);
            if (!(component instanceof Container)) continue;
            InteractiveSelectionUI.enableComponents((Container)component, enable);
        }
    }

    private static void enablePanel(JPanel panel, boolean enable) {
        Component[] components;
        if (panel == null) {
            return;
        }
        for (Component component : components = panel.getComponents()) {
            component.setEnabled(enable);
            if (!(component instanceof Container)) continue;
            InteractiveSelectionUI.enableComponents((Container)component, enable);
        }
    }

    private static void addDeeplyActionListener(Container container, Runnable action) {
        Component[] components;
        for (Component component : components = container.getComponents()) {
            if (component instanceof Container) {
                InteractiveSelectionUI.addDeeplyActionListener((Container)component, action);
            }
            if (component instanceof AbstractButton) {
                ((AbstractButton)component).addActionListener(e -> action.run());
            }
            if (component instanceof ItemSelectable) {
                ((ItemSelectable)((Object)component)).addItemListener(e -> action.run());
            }
            if (!(component instanceof JList)) continue;
            ((JList)component).addListSelectionListener(e -> action.run());
        }
    }

    protected static Vector<String> getElementsOfType(String dbClass) {
        Vector<String> v = new Vector<String>();
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            return v;
        }
        HashSet<String> set = new HashSet<String>();
        for (DbObject o : db.getDbClass(dbClass).getInstances()) {
            Object s = null;
            if (o instanceof Device) {
                s = ((Device)o).getKeyStr();
            } else if (o instanceof Net) {
                s = ((Net)o).getFullPathName();
            } else if (o instanceof PinInstance) {
                s = ((PinInstance)o).getName();
            } else if (o instanceof PinTemplate) {
                String userFunction = ((PinTemplate)o).getUserFunction();
                if (!v.contains(userFunction)) {
                    s = userFunction;
                }
            } else {
                s = o.getKeyStr();
            }
            set.add((String)s);
        }
        v.addAll(set);
        return v;
    }

    public static Vector<String> getPinTemplateTypes() {
        Vector<String> v = new Vector<String>();
        for (PinTemplate.Type t : PinTemplate.Type.values()) {
            v.add(t.name());
        }
        return v;
    }

    protected static Vector<String> getUniquePinTemplateNames() {
        Vector<String> v = new Vector<String>();
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            return v;
        }
        IterableIterator elements = db.getObjects(PinInstance.class);
        while (elements != null && elements.hasNext()) {
            PinInstance dp = (PinInstance)elements.next();
            String dtpname = dp.getPinTemplate().getName();
            if (v.contains(dtpname)) continue;
            v.add(dtpname);
        }
        return v;
    }

    static {
        InteractiveSelectionUI.registerDockingUI();
    }

    protected static class SelectionPanel
    extends JPanel {
        protected Db mDb;
        protected JComboBox<Selection.Mode> mCboMode;
        protected JComboBox<String> mCboSelectorModifier;
        protected JComboBox<Substrate> mCboSubstrate;
        protected FilterByPropertyNameValuePanel mFilterByPropertyValuePanel = null;
        protected JCheckBox mCbNetsConnected;
        protected JCheckBox mCbSelectHidden;
        protected List<Selector.Descriptor<? extends DbObject>> mDescriptors;
        protected List<APair<Selector.Descriptor<? extends DbObject>, JRadioButton>> mDescBtnGroup;
        protected JComboBox<String> mPointSelectionMode;
        protected JComboBox<String> mAreaTouchMode;
        protected JComboBox<String> mGeometryMode;
        protected boolean mOutlineOnlyMode = false;
        protected SelectionCriteria mCurrentCriteria = null;
        protected List<String> mFilterCreationCommands = new ArrayList<String>();
        private boolean mUpdateModeSender = true;
        private Runnable mUpdateModeCriteria = () -> {
            DesignView2D d2d;
            if (!this.mUpdateModeSender) {
                return;
            }
            AAppView view = OrbitIO.getCurView();
            if (view instanceof DesignView2D && (d2d = (DesignView2D)view).getCurMode() instanceof InteractiveSelectMode) {
                SelectionCriteria sc = this.getCriteria();
                InteractiveSelectMode selMode = (InteractiveSelectMode)d2d.getCurMode();
                selMode.setCriteria(sc);
            }
        };
        protected static final String[] mObjectNames = new String[]{"Device", "Bundle", "", "Net", "Connection", "", "Pin", "Wire", "", "Port", "Obstacle", "", "Via", "Shape", "", "Finger", "Term", ""};
        protected static final Map<String, Integer> mDescriptorOrder = AUtil.indexMap((Object[])mObjectNames);
        protected ActionListener mDoObjTypeChanged = e -> {
            if (this.mFilterByPropertyValuePanel != null) {
                this.mFilterByPropertyValuePanel.selectedObjectTypeChanged();
            }
            this.updateModifiers();
            this.updateModeOptions();
        };

        public Selector.Descriptor<? extends DbObject> getSelectedDescriptor() {
            for (APair<Selector.Descriptor<? extends DbObject>, JRadioButton> p : this.mDescBtnGroup) {
                if (!((JRadioButton)p.getSecond()).isSelected()) continue;
                return (Selector.Descriptor)p.getFirst();
            }
            return (Selector.Descriptor)this.mDescBtnGroup.get(0).getFirst();
        }

        public void setOutlineOnlyMode(boolean flag) {
            this.mOutlineOnlyMode = false;
        }

        public String getAreaMode() {
            if (this.getAreaTouchMode().equals(InteractiveSelectionUI.AREA_INSIDE)) {
                return Selection.AreaMode.Contain.toString();
            }
            return Selection.AreaMode.Touch.toString();
        }

        public void setCurrentCriteria(SelectionCriteria sc) {
            this.mCurrentCriteria = sc;
        }

        public void selectUsingCurrentCriteria(AGeom worldGeom) {
            ARect worldRect = null;
            APolygon worldPoly = null;
            if (worldGeom instanceof ARect) {
                worldRect = (ARect)worldGeom;
            } else {
                worldPoly = (APolygon)worldGeom;
            }
            if (worldRect != null) {
                Cp.exec((String)"Selection.setRect(%dL, %dL, %dL, %dL)", (Object[])new Object[]{worldRect.left(), worldRect.bottom(), worldRect.right(), worldRect.top()});
            }
            if (worldPoly != null) {
                Cp.exec((String)"Selection.setPolygonPoint(%dL, %dL, true)", (Object[])new Object[]{worldPoly.getPoint(0).getX(), worldPoly.getPoint(0).getY()});
                for (int i = 1; i < worldPoly.getPointCount(); ++i) {
                    Cp.exec((String)"Selection.setPolygonPoint(%dL, %dL, false)", (Object[])new Object[]{worldPoly.getPoint(i).getX(), worldPoly.getPoint(i).getY()});
                }
            }
            Cp.exec((String)"Selection.select()", (Object[])new Object[0]);
        }

        public void setGeometryMode(String mode) {
            this.mGeometryMode.setSelectedItem(mode);
        }

        public void setAreaTouchMode(String mode) {
            this.mAreaTouchMode.setSelectedItem(mode);
        }

        public void setPointSelectionMode(String mode) {
            this.mPointSelectionMode.setSelectedItem(mode);
        }

        public String getGeometryMode() {
            return (String)this.mGeometryMode.getSelectedItem();
        }

        public String getPointSelectionMode() {
            return (String)this.mPointSelectionMode.getSelectedItem();
        }

        public String getAreaTouchMode() {
            return (String)this.mAreaTouchMode.getSelectedItem();
        }

        public void setSelectedDescriptor(Selector.Descriptor<? extends DbObject> s) {
            for (APair<Selector.Descriptor<? extends DbObject>, JRadioButton> p : this.mDescBtnGroup) {
                if (p.getFirst() != s) continue;
                ((JRadioButton)p.getSecond()).setSelected(true);
            }
        }

        public Selection.Mode getSelectedMode() {
            return (Selection.Mode)this.mCboMode.getSelectedItem();
        }

        public void setSelectedMode(Selection.Mode mode) {
            this.mCboMode.setSelectedItem(mode);
        }

        private JPanel createObjectsPanel() {
            JPanel panel = new JPanel();
            GridBagManager l = new GridBagManager((Container)panel);
            l.add((Component)new ASeparator("Objects"), (GridBagConstraints)GridBagManager.FILLALL.width(2));
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT.anchor(18).width(2).insets(6, 0));
            GridBagManager.GridBagConstraintsEx cbOptConstrain = GridBagManager.LEFT.noInsets();
            this.mDescriptors = AUtil.linkedList(Selector.Registry.getDefault().getDescriptors().iterator());
            this.mDescriptors.sort((x, y) -> Integer.compare(mDescriptorOrder.get(x.getUserName()), mDescriptorOrder.get(y.getUserName())));
            ButtonGroup group = new ButtonGroup();
            this.mDescBtnGroup = new ArrayList<APair<Selector.Descriptor<? extends DbObject>, JRadioButton>>();
            for (Selector.Descriptor<? extends DbObject> d : this.mDescriptors) {
                String text = d.getUserName();
                JRadioButton btn = new JRadioButton(text);
                l.add((Component)btn, (GridBagConstraints)cbOptConstrain);
                this.mDescBtnGroup.add((APair<Selector.Descriptor<? extends DbObject>, JRadioButton>)new APair(d, (Object)btn));
                btn.addActionListener(this.mDoObjTypeChanged);
                if (mObjectNames[mDescriptorOrder.get(d.getUserName()) + 1].isEmpty()) {
                    l.newline();
                }
                group.add(btn);
            }
            if (!this.mDescBtnGroup.isEmpty()) {
                ((JRadioButton)this.mDescBtnGroup.get(0).getSecond()).setSelected(true);
            }
            l.addFillX();
            l.pop();
            l.newline();
            JPanel optContent = l.push((GridBagConstraints)GridBagManager.LEFT);
            l.add("Modifier:", (GridBagConstraints)GridBagManager.LEFT.insets(6, 0));
            this.mCboSelectorModifier = new JComboBox<String>(){
                private boolean layingOut = false;

                @Override
                public void doLayout() {
                    this.layingOut = true;
                    try {
                        super.doLayout();
                    }
                    finally {
                        this.layingOut = false;
                    }
                }

                @Override
                public Dimension getSize() {
                    Dimension dim = super.getSize();
                    if (!this.layingOut) {
                        dim.width = Math.max(dim.width, this.getPreferredSize().width);
                    }
                    return dim;
                }
            };
            this.mCboSelectorModifier.setSize(100, 16);
            l.add(this.mCboSelectorModifier, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.add("Substrate:", (GridBagConstraints)GridBagManager.LEFT.insets(6, 0));
            this.mCboSubstrate = new SubstrateCombo();
            l.add(this.mCboSubstrate, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            Dimension dim = optContent.getPreferredSize();
            dim = new Dimension(208, (int)dim.getHeight());
            optContent.setPreferredSize(dim);
            optContent.setMaximumSize(dim);
            return panel;
        }

        private JPanel createModePanel() {
            JPanel panel = new JPanel();
            GridBagManager l = new GridBagManager((Container)panel);
            l.add((Component)new ASeparator("Mode"), (GridBagConstraints)GridBagManager.FILLALL.noInsets());
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT.anchor(18).noInsets());
            l.add("Tool:", (GridBagConstraints)GridBagManager.LEFT);
            this.mGeometryMode = new JComboBox();
            for (String gm : InteractiveSelectMode.AllGeomModes) {
                this.mGeometryMode.addItem(gm);
            }
            l.add(this.mGeometryMode, (GridBagConstraints)GridBagManager.FILLALL);
            l.newline();
            l.add("Mode:", (GridBagConstraints)GridBagManager.LEFT);
            this.mCboMode = new JComboBox<Selection.Mode>(Selection.Mode.values());
            l.add(this.mCboMode, (GridBagConstraints)GridBagManager.FILLALL);
            l.newline();
            l.add("Area Select:", (GridBagConstraints)GridBagManager.LEFT);
            this.mAreaTouchMode = new JComboBox();
            this.mAreaTouchMode.addItem(InteractiveSelectionUI.AREA_TOUCH);
            this.mAreaTouchMode.addItem(InteractiveSelectionUI.AREA_INSIDE);
            l.add(this.mAreaTouchMode, (GridBagConstraints)GridBagManager.FILLALL);
            l.newline();
            l.add("Click:", (GridBagConstraints)GridBagManager.LEFT);
            this.mPointSelectionMode = new JComboBox();
            this.mPointSelectionMode.addItem(InteractiveSelectionUI.CLICKMODE_SINGLEITEM);
            this.mPointSelectionMode.addItem(InteractiveSelectionUI.CLICKMODE_ALLITEMS);
            l.add(this.mPointSelectionMode, (GridBagConstraints)GridBagManager.FILLALL);
            l.newline();
            this.mCbSelectHidden = new JCheckBox("Select hidden objects");
            this.mCbSelectHidden.setToolTipText("Allow selecting objects that match the specified criteria but are not displayed due to view settings.");
            this.mCbSelectHidden.setSelected(false);
            this.mCbNetsConnected = new JCheckBox("Net filters match mapped nets");
            this.mCbNetsConnected.setToolTipText("When filtering nets, should nets connected via mapping at differing hierarchical levels also allow a match based on the specified criteria");
            this.mCbNetsConnected.setSelected(true);
            return panel;
        }

        private JPanel createAdvancedFilterPanel() {
            JPanel panel = new JPanel();
            GridBagManager l = new GridBagManager((Container)panel);
            l.add((Component)new ASeparator("Advanced Property Filter"), (GridBagConstraints)GridBagManager.FILLALL.noInsets());
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT.anchor(18).noInsets());
            this.mFilterByPropertyValuePanel = new FilterByPropertyNameValuePanel(l, this.mDb, new SelFilterAdapter());
            this.mFilterByPropertyValuePanel.setVisible(true);
            return panel;
        }

        public SelectionPanel(Db db) {
            this.mDb = db;
            JPanel top = new JPanel();
            this.setLayout(new BorderLayout());
            this.add((Component)top, "North");
            GridBagManager l = new GridBagManager((Container)top);
            GridBagManager.GridBagConstraintsEx blockConstraint = GridBagManager.FILLX.anchor(18).insets(6, 0);
            l.add((Component)this.createObjectsPanel(), (GridBagConstraints)blockConstraint);
            l.newline();
            l.add((Component)this.createAdvancedFilterPanel(), (GridBagConstraints)blockConstraint);
            l.newline();
            l.add((Component)this.createModePanel(), (GridBagConstraints)blockConstraint);
            l.newline();
            this.updateModifiers();
            this.mCboMode.setSelectedIndex(2);
            this.mGeometryMode.setSelectedIndex(0);
            this.updateModeOptions();
            if (db != null) {
                this.updateSubstrates(db, null);
            }
            InteractiveSelectionUI.addDeeplyActionListener(top, this.mUpdateModeCriteria);
        }

        private void setUpdateModeSender(boolean enable) {
            this.mUpdateModeSender = enable;
        }

        public void updateSubstrates(Db db, Substrate selected) {
            this.mCboSubstrate.removeAllItems();
            this.mCboSubstrate.addItem(null);
            if (db != null) {
                db.getObjects(Substrate.class).stream().sorted().forEach(this.mCboSubstrate::addItem);
            }
            this.mCboSubstrate.setSelectedItem(selected);
        }

        protected void updateModifiers() {
            LinkedList modifiers = AUtil.linkedList((Iterator)Selection.getModifiers((String)this.getSelectionObjTypeStr()));
            Collections.sort(modifiers);
            this.mCboSelectorModifier.removeAllItems();
            for (String d : modifiers) {
                this.mCboSelectorModifier.addItem(d);
            }
            String defaultSelection = Selection.getDefaultModifier((String)this.getSelectionObjTypeStr());
            if (defaultSelection != null) {
                this.mCboSelectorModifier.setSelectedItem(defaultSelection);
            }
        }

        protected void updateModeOptions() {
            String selectorName = this.getSelectionUserName();
            this.mPointSelectionMode.setSelectedIndex(0);
            this.mAreaTouchMode.setSelectedIndex(1);
            if (selectorName.equals("Wire") || selectorName.equals("Bundle") || selectorName.equals("Connection")) {
                this.mAreaTouchMode.setSelectedIndex(0);
            }
        }

        public Selection.Mode getSelectionMode() {
            return this.getSelectedMode();
        }

        public String getSelectionModeStr() {
            return "" + this.getSelectedMode();
        }

        public String getLimitToSubstrateKey() {
            Substrate s = (Substrate)this.mCboSubstrate.getSelectedItem();
            return s == null ? null : s.getKeyStr();
        }

        public String getNameFilter() {
            return this.mFilterByPropertyValuePanel.getFilterProperty().getName();
        }

        protected String getSelectionObjTypeStr() {
            Selector.Descriptor<? extends DbObject> d = this.getSelectedDescriptor();
            return d == null ? null : d.getSelObjectType().getSimpleName();
        }

        protected String getSelectionUserName() {
            Selector.Descriptor<? extends DbObject> d = this.getSelectedDescriptor();
            return d == null ? null : d.getUserName();
        }

        protected String getSelectorName() {
            Selector.Descriptor<? extends DbObject> d = this.getSelectedDescriptor();
            return d == null ? null : d.getName();
        }

        protected void selectedSelectByPropertyChanged() {
            String objType = this.getSelectionUserName();
            if (this.mFilterByPropertyValuePanel != null) {
                this.mFilterByPropertyValuePanel.selectedSelectByPropertyChanged(objType != null);
            }
        }

        public boolean getSelectHidden() {
            return this.mCbSelectHidden.isSelected();
        }

        public Stream<String> getFilterCreationCmds() {
            return this.mFilterCreationCommands.stream();
        }

        public boolean getFilterNetsConnected() {
            return this.mCbNetsConnected.isSelected();
        }

        public Selection.Mode getModifiedSelectionMode(int modifiers) {
            return InteractiveSelectMode.getModifiedSelectionMode(this.getSelectionMode(), modifiers);
        }

        public IterableIterator<Object> getSelectionItems() {
            return this.mFilterByPropertyValuePanel.getPropValueSelectedItems();
        }

        public String getSelectionFilterProp() {
            return this.mFilterByPropertyValuePanel.getFilterProperty() != null ? this.mFilterByPropertyValuePanel.getFilterProperty().getName() : null;
        }

        public Selector.Property<?> getSelectionFilterProperty() {
            return this.mFilterByPropertyValuePanel.getFilterProperty();
        }

        protected void createSelectionCriteria(int eventModifiers, boolean record) {
            String areaMode = this.getAreaMode();
            if (this.mOutlineOnlyMode) {
                areaMode = Selection.AreaMode.Touch.toString();
                this.mOutlineOnlyMode = false;
            }
            Selection.Mode selMode = this.getModifiedSelectionMode(eventModifiers);
            String objType = this.getSelectionObjTypeStr();
            String selectorName = this.getSelectorName();
            String prop = this.getSelectionFilterProp();
            IterableIterator<Object> filterItems = this.getSelectionItems();
            Cp.exec((boolean)record, (String)"Selection.clearAllCriteria()", (Object[])new Object[0]);
            Cp.exec((boolean)record, (String)"Selection.setMode(\"%s\")", (Object[])new Object[]{selMode});
            String d = (String)this.mCboSelectorModifier.getSelectedItem();
            if (d == null) {
                Cp.exec((boolean)record, (String)"Selection.setCurModifierName(\"%s\");", (Object[])new Object[]{"<NONE>"});
            } else {
                Cp.exec((boolean)record, (String)("Selection.setCurModifierName(\"" + d + "\");"), (Object[])new Object[0]);
            }
            String limitSubst = this.getLimitToSubstrateKey();
            if (this.getLimitToSubstrateKey() != null) {
                Cp.exec((boolean)record, (String)"Selection.setLimitToSubstrate(\"%s\")", (Object[])new Object[]{limitSubst});
            }
            if (!this.getSelectHidden()) {
                Cp.exec((boolean)record, (String)"Selection.addFilter(OrbitIO.getVisibleItemFilter())", (Object[])new Object[0]);
            }
            this.getFilterCreationCmds().forEach(fcc -> Cp.exec((boolean)record, (String)"Selection.addFilter(%s)", (Object[])new Object[]{fcc}));
            if (this.getFilterNetsConnected()) {
                Cp.exec((boolean)record, (String)"Selection.setFilterConnectedNets(true)", (Object[])new Object[0]);
            }
            if (this.getPointSelectionMode().equals(InteractiveSelectionUI.CLICKMODE_SINGLEITEM)) {
                Cp.exec((boolean)record, (String)"Selection.setSingleItem(true)", (Object[])new Object[0]);
            }
            if (objType != null) {
                Cp.exec((boolean)record, (String)"Selection.setDbClass(\"%s\")", (Object[])new Object[]{objType});
            }
            if (selectorName != null) {
                Cp.exec((boolean)record, (String)"Selection.setSelector(\"%s\")", (Object[])new Object[]{selectorName});
            }
            Cp.exec((boolean)record, (String)"Selection.setAreaMode(\"%s\")", (Object[])new Object[]{areaMode});
            Cp.exec((boolean)record, (String)"Selection.setCurFilterOperatorName(\"%s\")", (Object[])new Object[]{this.mFilterByPropertyValuePanel.getFilterOperator().getSelectedItem().toString()});
            if (prop != null) {
                StringBuilder sb = new StringBuilder(1024);
                HashSet<String> alreadyIncluded = new HashSet<String>();
                for (Object s : filterItems) {
                    if (alreadyIncluded.contains(s)) continue;
                    alreadyIncluded.add(s.toString());
                    String f = sb.length() == 0 ? "\"%s\"" : ", \"%s\"";
                    sb.append(String.format(f, s));
                }
                String val = sb.toString();
                if (val.length() == 0) {
                    Selector.Property<?> p = this.getSelectionFilterProperty();
                    String n = p == null ? "" : p.getUserName();
                    ALog.logWarn((String)"Filter by '%s' was selected but no filter values were supplied so the filter is being ignored.", (Object[])new Object[]{n});
                } else {
                    Cp.exec((boolean)record, (String)"Selection.addFilter(\"%s\", %s)", (Object[])new Object[]{prop, sb.toString()});
                }
            }
        }

        public SelectionCriteria getCriteria() {
            String prop;
            SelectionCriteria sc = new SelectionCriteria();
            sc.setMode(this.getSelectedMode());
            sc.setReferenceClass(this.getSelectedDescriptor().getSelObjectType().getName());
            sc.setSelectorName(this.getSelectedDescriptor().getName());
            sc.setModifier((String)this.mCboSelectorModifier.getSelectedItem());
            Substrate limitSubst = (Substrate)this.mCboSubstrate.getSelectedItem();
            sc.setLimitToSubstrate(limitSubst == null ? null : limitSubst.getKeyStr());
            if (!this.mCbSelectHidden.isSelected()) {
                sc.addFilterCreationCmd("OrbitIO.getVisibleItemFilter()");
            }
            this.mFilterCreationCommands.forEach(c -> sc.addFilterCreationCmd(c));
            sc.setNetFilterConsidersConnectedNets(this.mCbNetsConnected.isSelected());
            sc.setPointSelectsSingleItem(this.mPointSelectionMode.getSelectedItem().equals(InteractiveSelectionUI.CLICKMODE_SINGLEITEM));
            sc.setAreaMode(this.getAreaTouchMode().equals(InteractiveSelectionUI.AREA_TOUCH) ? Selection.AreaMode.Touch : Selection.AreaMode.Contain);
            sc.setPropertyFilterOperator((String)this.mFilterByPropertyValuePanel.getFilterOperator().getSelectedItem());
            String string = prop = this.mFilterByPropertyValuePanel.getFilterProperty() != null ? this.mFilterByPropertyValuePanel.getFilterProperty().getName() : null;
            if (prop != null) {
                HashSet<String> alreadyIncluded = new HashSet<String>();
                for (Object s : this.mFilterByPropertyValuePanel.getPropValueSelectedItems()) {
                    if (alreadyIncluded.contains(s)) continue;
                    alreadyIncluded.add(s.toString());
                    sc.addPropertyFilter(prop, s.toString());
                }
            }
            return sc;
        }

        public void setCriteria(SelectionCriteria sc) {
            if (sc == null) {
                return;
            }
            this.setUpdateModeSender(false);
            this.setSelectedMode(sc.getMode());
            this.setSelectedDescriptor((Selector.Descriptor<? extends DbObject>)Selector.Registry.getDefault().getDescriptor(sc.getSelectorName()));
            this.setAreaTouchMode(sc.getAreaMode() == Selection.AreaMode.Touch ? InteractiveSelectionUI.AREA_TOUCH : InteractiveSelectionUI.AREA_INSIDE);
            this.setPointSelectionMode(sc.getPointSelectsSingleItem() ? InteractiveSelectionUI.CLICKMODE_SINGLEITEM : InteractiveSelectionUI.CLICKMODE_ALLITEMS);
            this.mCboSelectorModifier.setSelectedItem(sc.getModifier());
            this.mCboSubstrate.setSelectedItem(sc.getLimitToSubstrate() == null ? "<NONE>" : sc.getLimitToSubstrate());
            this.mCbSelectHidden.setSelected(false);
            this.mFilterByPropertyValuePanel.selectedObjectTypeChanged();
            String oper = sc.getPropertyFilterOperator();
            if (oper != null) {
                this.mFilterByPropertyValuePanel.getFilterOperator().setSelectedItem(oper);
            }
            for (String prop : sc.getPropertyFilters().keySet()) {
                this.mFilterByPropertyValuePanel.setFilterProperty(prop);
                this.mFilterByPropertyValuePanel.clearFilterPropValSelection();
                for (String val : (Set)sc.getPropertyFilters().get(prop)) {
                    this.mFilterByPropertyValuePanel.addFilterPropValSelection(val);
                }
            }
            this.setUpdateModeSender(true);
        }

        public class SelFilterAdapter
        implements FilterByPropertyNameValuePanel.FilterByPropertyListener {
            @Override
            public Selector.Descriptor<?> getDescriptor() {
                return SelectionPanel.this.getSelectedDescriptor();
            }

            @Override
            public String objTypeName() {
                return SelectionPanel.this.getSelectionUserName();
            }

            @Override
            public List<Selector.Property<?>> getOverridePropertyList() {
                return null;
            }

            @Override
            public List<Object> getOverridePropertyValueList(Selector.Property<?> prop) {
                return null;
            }

            @Override
            public Selector.Property<?> getDefaultToSelect() {
                return null;
            }

            @Override
            public boolean onlyShowList() {
                return false;
            }
        }

        private class SubstrateCombo
        extends JComboBox<Substrate> {
            private boolean layingOut = false;

            SubstrateCombo() {
                this.setRenderer(new SubstrateListRenderer("<NONE>"));
                this.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        Substrate preSel = (Substrate)SelectionPanel.this.mCboSubstrate.getSelectedItem();
                        SelectionPanel.this.updateSubstrates(SelectionPanel.this.mDb, preSel);
                    }

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent e) {
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    }
                });
            }

            @Override
            public void doLayout() {
                this.layingOut = true;
                try {
                    super.doLayout();
                }
                finally {
                    this.layingOut = false;
                }
            }

            @Override
            public Dimension getSize() {
                Dimension dim = super.getSize();
                if (!this.layingOut) {
                    dim.width = Math.max(dim.width, this.getPreferredSize().width);
                }
                return dim;
            }
        }
    }

    public static class SelectFilter {
        protected Db mDb;
        protected DesignView2D mView;
        protected SelectionPanel mSelPanel;
        protected SelectDockPanel mSelDockPanel;
        protected ActionListener mGeometryChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignView2D v2d;
                DesignView2D.ViewMode m;
                AAppView v = OrbitIO.getCurView();
                if (v instanceof DesignView2D && (m = (v2d = (DesignView2D)v).getCurMode()) instanceof InteractiveSelectMode) {
                    InteractiveSelectMode ism = (InteractiveSelectMode)m;
                    ism.repaintOverlay();
                }
            }
        };

        protected SelectFilter(DesignView2D v) {
            this.mDb = v.getDb();
            this.mView = v;
            this.init();
        }

        protected void init() {
            CControl dockControl = OrbitIO.getApp().getWorkspace().getDockingController();
            Optional<CDockable> dbSelectDock = InteractiveSelectionUI.getCStations(dockControl.getContentArea()).flatMap(cs -> InteractiveSelectionUI.getDockableDescendants((DockStation)cs.getStation())).filter(d -> d instanceof DefaultCommonDockable).map(d -> ((DefaultCommonDockable)d).getDockable()).filter(d -> d instanceof SelectDockPanel).findFirst();
            if (dbSelectDock.isPresent()) {
                SelectDockPanel prev = (SelectDockPanel)dbSelectDock.get();
                this.mSelPanel = prev.getSelectionPanel();
            }
            if (this.mSelPanel == null) {
                InteractiveSelectionUI.setPanelVisible(true);
                this.mSelPanel = thePanel.getSelectionPanel();
            }
            DesignView2D v = (DesignView2D)OrbitIO.getCurView();
            boolean enablePanel = true;
            if (v == null || !(v.getCurMode() instanceof InteractiveSelectMode)) {
                enablePanel = false;
            }
            this.enableSelectionPanel(enablePanel);
            this.mSelPanel.requestFocus();
        }

        public String getGeometryType() {
            return this.mSelPanel.getGeometryMode();
        }

        public void setOutlineOnlyMode(boolean flag) {
            this.mSelPanel.setOutlineOnlyMode(flag);
        }

        public void selectUsingCurrentCriteria(AGeom worldGeom) {
            this.mSelPanel.selectUsingCurrentCriteria(worldGeom);
        }

        public String getAreaMode() {
            return this.mSelPanel.getAreaMode();
        }

        public String getLimitToSubstrateKey() {
            return this.mSelPanel.getLimitToSubstrateKey();
        }

        public Selection.Mode getSelectionMode() {
            return this.mSelPanel.getSelectionMode();
        }

        public Selection.Mode getModifiedSelectionMode(int modifiers) {
            return InteractiveSelectMode.getModifiedSelectionMode(this.getSelectionMode(), modifiers);
        }

        public boolean getSelectHidden() {
            return this.mSelPanel.mCbSelectHidden.isSelected();
        }

        public Stream<String> getFilterCreationCmds() {
            return this.mSelPanel.mFilterCreationCommands.stream();
        }

        public boolean getFilterNetsConnected() {
            return this.mSelPanel.mCbNetsConnected.isSelected();
        }

        public String getSelectionObjectTypeStr() {
            return this.mSelPanel.getSelectionObjTypeStr();
        }

        public String getSelectorName() {
            return this.mSelPanel.getSelectorName();
        }

        public String getSelectionFilterProp() {
            Selector.Property<?> prop = this.mSelPanel.mFilterByPropertyValuePanel.getFilterProperty();
            return prop != null ? prop.getName() : null;
        }

        public Selector.Property<?> getSelectionFilterProperty() {
            return this.mSelPanel.mFilterByPropertyValuePanel.getFilterProperty();
        }

        public IterableIterator<Object> getSelectionItems() {
            return this.mSelPanel.mFilterByPropertyValuePanel.getPropValueSelectedItems();
        }

        protected SelectionCriteria getCriteria() {
            return this.mSelPanel.getCriteria();
        }

        protected void setCriteria(SelectionCriteria sc) {
            if (sc == null) {
                return;
            }
            this.mSelPanel.setCriteria(sc);
            this.setCurrentCriteria(sc);
        }

        protected void setCurrentCriteria(SelectionCriteria sc) {
            this.mSelPanel.setCurrentCriteria(sc);
        }

        public void setPointSelectionMode(String mode) {
            this.mSelPanel.setPointSelectionMode(mode);
        }

        public String getPointSelectionMode() {
            return this.mSelPanel.getPointSelectionMode();
        }

        public void setGeometryMode(String s) {
            this.mSelPanel.setGeometryMode(s);
        }

        public String getGeometryMode() {
            return this.mSelPanel.getGeometryMode();
        }

        public void setAreaTouchMode(String mode) {
            this.mSelPanel.setAreaTouchMode(mode);
        }

        public String getAreaTouchMode() {
            return this.mSelPanel.getAreaTouchMode();
        }

        public void enableSelectionPanel(boolean enable) {
            InteractiveSelectionUI.enablePanel(this.mSelPanel, enable);
        }

        public void createSelectionCriteria(int modifiers, boolean b) {
            this.mSelPanel.createSelectionCriteria(modifiers, b);
        }
    }

    public static class SelectDockPanel
    extends JPanel {
        protected Db mDb;
        protected SelectionPanel mSelPanel;
        protected JButton mSelectNow;
        protected Action selectNow = new AbstractAction("Select All", UIUtil.getScaledIcon((Icon)UIManager.getIcon("CDNS.selectAllIcon"), (int)16, (int)16)){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OrbitIO.getCurDb() != null) {
                    mSelPanel.createSelectionCriteria(0, true);
                    mSelPanel.selectUsingCurrentCriteria(null);
                }
            }
        };
        protected Action mActionSave = new AbstractAction("Save Criteria...", UIUtil.getScaledIcon((Icon)OrbitIcons.EXPORT, (int)16, (int)16)){

            @Override
            public void actionPerformed(ActionEvent e) {
                mSelPanel.createSelectionCriteria(0, false);
                final SelectionCriteria sc = Selection.getSelectionCriteria();
                if (mSelPanel.mCurrentCriteria != null) {
                    sc.setName(mSelPanel.mCurrentCriteria.getName());
                    sc.setIconSmall(mSelPanel.mCurrentCriteria.getIconSmall());
                }
                final List items = SelectionCriteria.getSavedCriteria();
                SelectionCriteriaUI.EditDialog dlg = new SelectionCriteriaUI.EditDialog(this);
                dlg.setTitle("Save Criteria");
                dlg.setWarnOverwrite(true);
                dlg.showDialog(sc, items, new SelectionCriteriaUI.DialogComplete(){

                    @Override
                    public void oked(SelectionCriteria selected) {
                        SelectionCriteria exist = items.stream().filter(SelectionCriteria.predicateName((String)sc.getName())).findFirst().orElse(null);
                        if (exist != null) {
                            items.remove(exist);
                        }
                        items.add(sc);
                        Collections.sort(items);
                        SelectionCriteria.saveCriteria((List)items);
                        mSelPanel.setCurrentCriteria(sc);
                    }
                });
            }
        };
        protected Action mActionLoad = new AbstractAction("Load Criteria...", UIUtil.getScaledIcon((Icon)OrbitIcons.IMPORT, (int)16, (int)16)){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectionCriteriaUI.SelectionCriteriaList dlg = new SelectionCriteriaUI.SelectionCriteriaList(this);
                dlg.showDialog(new SelectionCriteriaUI.DialogComplete(){

                    @Override
                    public void oked(SelectionCriteria sc) {
                        mSelPanel.setCriteria(sc);
                    }
                });
            }
        };

        public SelectDockPanel(Db db) {
            this.mDb = db;
            this.setName("Selection Filter");
            GridBagManager l = new GridBagManager((Container)this);
            this.mSelPanel = new SelectionPanel(this.mDb);
            JScrollPane scrollPane = new JScrollPane(this.mSelPanel);
            scrollPane.getVerticalScrollBar().setUnitIncrement(16);
            l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL.width(3));
            l.newline();
            JButton saveBtn = new JButton(this.mActionSave);
            JButton loadBtn = new JButton(this.mActionLoad);
            saveBtn.setText("");
            saveBtn.setToolTipText("Save Criteria...");
            loadBtn.setText("");
            loadBtn.setToolTipText("Load Criteria...");
            UIUtil.makeToolBarButton((AbstractButton)saveBtn);
            UIUtil.makeToolBarButton((AbstractButton)loadBtn);
            l.add((Component)saveBtn, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)loadBtn, (GridBagConstraints)GridBagManager.LEFT);
            this.mSelectNow = new JButton(this.selectNow);
            l.add((Component)this.mSelectNow, (GridBagConstraints)GridBagManager.RIGHT);
        }

        public void setView(AAppView view) {
            InteractiveSelectMode mode;
            Db db;
            this.mDb = db = view == null ? null : view.getDb();
            if (this.mDb == null) {
                return;
            }
            this.removeAll();
            GridBagManager l = new GridBagManager((Container)this);
            boolean enable = view instanceof DesignView2D && ((DesignView2D)view).getCurMode() instanceof InteractiveSelectMode;
            SelectionCriteria sc = null;
            if (enable) {
                mode = (InteractiveSelectMode)((DesignView2D)view).getCurMode();
                sc = mode.getCriteria();
            }
            this.mSelPanel = new SelectionPanel(this.mDb);
            InteractiveSelectionUI.enablePanel(this.mSelPanel, enable);
            if (enable) {
                this.mSelPanel.setCriteria(sc);
                mode = (InteractiveSelectMode)((DesignView2D)view).getCurMode();
                mode.setSelectFilter(new SelectFilter((DesignView2D)view));
            }
            JScrollPane scrollPane = new JScrollPane(this.mSelPanel);
            scrollPane.getVerticalScrollBar().setUnitIncrement(16);
            l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL.width(3));
            l.newline();
            JButton saveBtn = new JButton(this.mActionSave);
            JButton loadBtn = new JButton(this.mActionLoad);
            saveBtn.setText("");
            saveBtn.setToolTipText("Save Criteria...");
            loadBtn.setText("");
            loadBtn.setToolTipText("Load Criteria...");
            UIUtil.makeToolBarButton((AbstractButton)saveBtn);
            UIUtil.makeToolBarButton((AbstractButton)loadBtn);
            l.add((Component)saveBtn, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)loadBtn, (GridBagConstraints)GridBagManager.LEFT);
            this.mSelectNow = new JButton(this.selectNow);
            l.add((Component)this.mSelectNow, (GridBagConstraints)GridBagManager.RIGHT);
        }

        public SelectionPanel getSelectionPanel() {
            return this.mSelPanel;
        }
    }
}

