/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.edaMgrs.HConnEngine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class MakeConnectionMode
extends AbstractViewMode {
    public static final String MODE_KEY = "MakeAConnectionMode";
    public static final String MODE_NAME = "Make A Connection";
    private static Double snapDistUser = 100.0;
    protected long snapDistInternal;
    protected Unit unit;
    protected Point mCurLoc = null;
    protected Db mDb = null;
    protected boolean mConnecting = false;
    protected PortGetter mConnectingStart = null;
    protected PortGetter mConnectingEnd = null;
    protected PortGetter mOverPort = null;
    protected int mNthPort = 0;
    protected JDialog mDialog = null;
    protected String mWindowTitle = "Make A Connection";
    protected boolean mWasVisible;
    protected JLabel mFromPinLabel;
    protected JLabel mToPinLabel;
    protected JLabel mFromPinName;
    protected JLabel mFromNetName;
    protected JLabel mToPinName;
    protected JLabel mToNetName;
    protected JLabel mCommonSubstrate;
    protected JTextField mSnapDistance;
    protected JCheckBox mDisconnectPrior;
    protected JCheckBox mRescheduleAfterEach;
    protected HierInst<PortTemplate> mFromPort = null;
    protected LinkedList<HierInst<PortTemplate>> mToPortList = new LinkedList();
    protected LinkedList<SchedConn> dynamicConnections = new LinkedList();
    protected Color mStartColor = Color.red.darker();
    protected Color mEndColor = Color.green.darker();
    protected Color mDoneColor = Color.blue.darker();
    protected static DesignView2D.ViewMode oldMode = null;
    protected Action backMode = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MakeConnectionMode.this.mConnectingStart != null) {
                MakeConnectionMode.this.mConnectingStart = null;
            }
            MakeConnectionMode.this.updateStatus();
        }
    };
    protected Action incrPin = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ++MakeConnectionMode.this.mNthPort;
            MakeConnectionMode.this.mOverPort = new PortGetter(MakeConnectionMode.this.mCurLoc, MakeConnectionMode.this.mNthPort);
            MakeConnectionMode.this.repaintOverlay();
            MakeConnectionMode.this.updateStatus();
        }
    };
    ComponentListener mViewComponentListener = new ComponentAdapter(){

        @Override
        public void componentHidden(ComponentEvent e) {
            MakeConnectionMode.this.mWasVisible = MakeConnectionMode.this.mDialog.isVisible();
            MakeConnectionMode.this.mDialog.setVisible(false);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (MakeConnectionMode.this.mWasVisible) {
                MakeConnectionMode.this.mDialog.setVisible(true);
                MakeConnectionMode.this.refocusView();
            }
        }
    };

    public static void install(DesignView2D view) {
        if (view == null) {
            return;
        }
        view.setMode(new MakeConnectionMode());
    }

    @Override
    public void installMode(DesignView2D view) {
        oldMode = view.getPriorMode();
        super.installMode(view);
    }

    @Override
    public void uninstallMode() {
        oldMode = null;
        this.uninstallMe();
    }

    protected void uninstallMe() {
        if (this.mOverlay != null) {
            this.mView.removeOverlay(this.mOverlay);
        }
        if (this.mDialog != null) {
            UIUtil.closeWindow((Window)this.mDialog);
        }
        super.uninstallMode();
    }

    @Override
    protected void installedMode() {
        if (this.mDialog != null) {
            UIUtil.closeWindow((Window)this.mDialog);
        }
        this.dynamicConnections.clear();
        this.mDb = OrbitIO.getCurDb();
        this.unit = Design.getUnit((Db)this.mDb);
        this.snapDistInternal = this.unit.fromUser(snapDistUser.doubleValue());
        this.mDialog = new JDialog(OrbitIO.getMainWindow(), this.mWindowTitle);
        GridBagManager l = new GridBagManager(this.mDialog.getContentPane());
        l.pushFillX();
        this.mFromPinLabel = new JLabel("From Pin:");
        l.add((Component)this.mFromPinLabel);
        this.mFromPinName = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX);
        this.mFromPinName.setForeground(this.mStartColor);
        l.popNl();
        l.pushFillX();
        l.add("From Net:");
        this.mFromNetName = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX);
        this.mFromNetName.setForeground(this.mStartColor);
        l.popNl();
        l.pushFillX();
        this.mToPinLabel = new JLabel("To Pin:");
        l.add((Component)this.mToPinLabel);
        this.mToPinName = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX);
        this.mToPinName.setForeground(this.mEndColor);
        l.popNl();
        l.pushFillX();
        l.add("To Net:");
        this.mToNetName = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX);
        this.mToNetName.setForeground(this.mEndColor);
        l.popNl();
        l.pushFillX();
        l.add("Snap Distance:");
        this.mSnapDistance = (JTextField)l.add((Component)new JTextField(6), (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.popNl();
        this.mSnapDistance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                snapDistUser = Double.valueOf(MakeConnectionMode.this.mSnapDistance.getText());
                MakeConnectionMode.this.snapDistInternal = MakeConnectionMode.this.unit.fromUser(snapDistUser.doubleValue());
            }
        });
        this.mDisconnectPrior = (JCheckBox)l.add((Component)new JCheckBox("Disconnect TO Pins prior to connection"), (GridBagConstraints)GridBagManager.LEFT);
        this.mDisconnectPrior.setSelected(true);
        l.newline();
        l.newline();
        this.mRescheduleAfterEach = (JCheckBox)l.add((Component)new JCheckBox("Reschedule afer each connection"), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mRescheduleAfterEach.setSelected(false);
        l.addFillY();
        this.updateStatus();
        this.mDialog.pack();
        Rectangle viewBounds = this.mView.getBounds();
        Point p = new Point(viewBounds.x + viewBounds.width / 2 - this.mDialog.getBounds().width / 2, viewBounds.y + viewBounds.height);
        SwingUtilities.convertPointToScreen(p, this.mView.getParent());
        final Settings settings = Settings.getSettings((String)"MakeConnection");
        snapDistUser = (Double)settings.getSetting("SnapDistance", (Object)snapDistUser);
        this.mSnapDistance.setText("" + snapDistUser);
        this.mDialog.setLocation(p);
        this.mDialog.setVisible(true);
        this.mWasVisible = true;
        this.mDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MakeConnectionMode.this.mView.removeComponentListener(MakeConnectionMode.this.mViewComponentListener);
                settings.putSetting("MakeConnection", (Object)snapDistUser);
                settings.save();
                MakeConnectionMode.this.mDialog = null;
                if (oldMode != null) {
                    MakeConnectionMode.this.mView.setMode(oldMode);
                }
                super.windowClosing(e);
            }
        });
        this.mDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
            }
        });
        this.mView.addComponentListener(this.mViewComponentListener);
        this.updateStatus();
        this.createKeyBindings();
        String html = "<html> Click The <font color=\"red\"> From </font>pin and then a <font color=\"green\">To </font>pin.<br>Use 'n' to cycle through overlapping pads. <br>Use ESC to back out of starting pin selection.</html>";
        this.informUser(html, new Object[0]);
    }

    protected void createKeyBindings() {
        ((JComponent)this.getViewComponent()).getActionMap().put("NextPin", this.incrPin);
        this.bindKey("N", "NextPin");
        ((JComponent)this.getViewComponent()).getActionMap().put("BackMode", this.backMode);
        this.bindKey("ESCAPE", "BackMode");
    }

    public void bindKey(String key, String action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key);
        if (keyStroke == null) {
            ALog.logWarn((String)"Invalid key stroke '%s' specified while attempting to bind key stroketo action '%s'.", (Object[])new Object[]{key, action});
            return;
        }
        InputMap inputMap = ((JComponent)this.getViewComponent()).getInputMap(1);
        inputMap.put(keyStroke, action);
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        this.mCurLoc = e.getPoint();
        this.mOverPort = new PortGetter(this.mCurLoc, this.mNthPort);
        if (this.mOverPort.mPortTemplate == null) {
            this.mNthPort = 0;
        }
        this.updateStatus();
        this.repaintOverlay();
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        if (e.isConsumed()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.mouseMoved(e);
        PortGetter c = this.mOverPort;
        if (this.mConnectingStart == null) {
            if (c.mPortTemplate != null) {
                if (!((PortTemplate)c.mPortTemplate.getDbObject()).getPinTemplate().getNet().isUnused()) {
                    this.mConnectingStart = c;
                } else {
                    ALog.logWarn((String)"Can not start a connection from NetUnused");
                }
            }
        } else {
            if (c.mPortTemplate == null) {
                ALog.logWarn((String)"No Pin");
                return;
            }
            this.mConnectingEnd = c;
            SchedConn sc = (SchedConn)Cp.exec((String)"com.sigrity.orbit.ui.canvas_modes.MakeConnectionMode.connect (\"%s\", \"%s\",\"%s\",\"%s\",%b);", (Object[])new Object[]{this.mConnectingStart.getPinPath().toString(), this.mConnectingStart.getPinTemplate().getName(), this.mConnectingEnd.getPinPath().toString(), this.mConnectingEnd.getPinTemplate().getName(), this.mDisconnectPrior.isSelected()});
            if (sc != null) {
                this.dynamicConnections.add(sc);
                this.mConnectingStart = null;
                this.mConnectingEnd = null;
                if (this.mRescheduleAfterEach.isSelected()) {
                    Cp.exec((String)"com.sigrity.orbit.ui.canvas_modes.MakeConnectionMode.reschedule ();", (Object[])new Object[0]);
                }
                OrbitIO.getApp().refreshCurrentView(false);
            }
        }
        this.repaintOverlay();
        this.updateStatus();
    }

    public static void reschedule() {
        Db db = OrbitIO.getCurDb();
        HConnEngine ce = new HConnEngine(db);
        ce.createConnections();
    }

    public static SchedConn connect(String fromPathString, String fromPinTemplateName, String toPathString, String toPinTemplateName, boolean disconnect) {
        Net net;
        Db db = OrbitIO.getCurDb();
        DevicePath fromPath = DevicePath.fromString((Db)db, (String)fromPathString);
        if (fromPath == null) {
            ALog.logWarn((String)(fromPathString + " is not a valid path"));
            return null;
        }
        DevicePath toPath = DevicePath.fromString((Db)db, (String)toPathString);
        if (toPath == null) {
            ALog.logWarn((String)(toPathString + " is not a valid path"));
            return null;
        }
        PinTemplate fromPin = fromPath.getLast().getTemplate().getPinByName(fromPinTemplateName);
        if (fromPin == null) {
            ALog.logWarn((String)(fromPinTemplateName + " is a not a valid pin"));
            return null;
        }
        if (fromPin.getNet().isUnused()) {
            ALog.logWarn((String)"Can not connect from a net unused");
            return null;
        }
        PinTemplate toPin = toPath.getLast().getTemplate().getPinByName(toPinTemplateName);
        if (toPin == null) {
            ALog.logWarn((String)(toPinTemplateName + " is a not a valid pin"));
            return null;
        }
        String netName = NetMap.getTopmostNet((Net)fromPin.getNet(), (DevicePath)fromPath).getName();
        if (disconnect) {
            toPin.setNet(toPin.getDeviceTemplate().getNetUnused());
        }
        if ((net = toPin.getNet()).isUnused()) {
            DeviceTemplate dt = toPin.getDeviceTemplate();
            if (dt.getNet(netName) == null) {
                net = Net.create((DeviceTemplate)dt, (String)netName);
            }
            toPin.setNet(net);
        }
        DeviceTemplate highestCommonTemplate = MakeConnectionMode.highestCommonSubstrate(net.getDb(), fromPath, toPath);
        toPin.mapNetUpPath(toPath, highestCommonTemplate, netName);
        PinInstance pi = toPath.getLast().getPin(toPin);
        pi.setNetSetterType(PinInstance.NetSetterType.CONNECTION_OPT);
        SchedConn sc = new SchedConn();
        sc.setPortA(fromPath, fromPin.getFirstPortTemplate());
        sc.setPortB(toPath, toPin.getFirstPortTemplate());
        return sc;
    }

    public static DeviceTemplate highestCommonSubstrate(Db db, DevicePath from, DevicePath to) {
        ArrayList<DeviceTemplate> fromSubstrates = new ArrayList<DeviceTemplate>();
        ArrayList<DeviceTemplate> toSubstrates = new ArrayList<DeviceTemplate>();
        for (Device d : from) {
            if (!d.getIsSubstrate()) continue;
            fromSubstrates.add(d.getTemplate());
        }
        for (Device d : to) {
            if (!d.getIsSubstrate()) continue;
            toSubstrates.add(d.getTemplate());
        }
        for (int i = 0; i < fromSubstrates.size(); ++i) {
            if (!toSubstrates.contains(fromSubstrates.get(i))) continue;
            return (DeviceTemplate)fromSubstrates.get(i);
        }
        return null;
    }

    @Override
    protected void paintOverlay(Graphics2D g, Rectangle bounds) {
        super.paintOverlay(g, bounds);
        RenderingHints oldRenderinngHints = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g.getColor();
        BasicStroke stroke3 = new BasicStroke(3.0f, 1, 1);
        BasicStroke stroke1 = new BasicStroke(1.0f, 0, 1);
        for (SchedConn sc : this.dynamicConnections) {
            APoint2D from = sc.getDPPA().getWorldLoc();
            APoint2D to = sc.getDPPB().getWorldLoc();
            Point start = this.mView.getCanvas().getXForm().getScreenPt(from);
            Point end = this.mView.getCanvas().getXForm().getScreenPt(to);
            g.setColor(this.mDoneColor);
            g.setStroke(stroke3);
            g.drawLine(start.x, start.y, end.x, end.y);
        }
        Point end = this.mCurLoc;
        if (this.mConnectingStart != null && this.mConnectingEnd == null) {
            Point start = this.mConnectingStart.getScreenSnap();
            AffineTransform oldTransform = g.getTransform();
            g.setStroke(stroke3);
            g.setColor(Color.WHITE);
            if (this.mOverPort.mPortTemplate != null) {
                int circleRad = 10;
                g.translate(end.x - circleRad / 2, end.y - circleRad / 2);
                g.fillArc(0, 0, circleRad, circleRad, 0, 360);
                g.setTransform(oldTransform);
                g.setColor(this.mEndColor);
                g.setStroke(stroke1);
                Point pc = this.mOverPort.getScreenSnap();
                g.drawLine(end.x, end.y, pc.x, pc.y);
            }
            g.setColor(this.mEndColor);
            g.setStroke(stroke3);
            ShowMeTheWay.drawResistorLine(start.x, start.y, end.x, end.y, g);
        } else if (this.mConnectingStart == null && this.mOverPort != null && this.mOverPort.mPortTemplate != null) {
            g.setColor(this.mStartColor);
            g.setStroke(stroke1);
            Point pc = this.mOverPort.getScreenSnap();
            g.drawLine(end.x, end.y, pc.x, pc.y);
        }
        if (this.mCurLoc != null) {
            int rad = this.mView.getCanvas().getXForm().getScreenLength(this.snapDistInternal);
            int x = this.mCurLoc.x;
            int y = this.mCurLoc.y;
            g.setColor(Color.WHITE);
            g.drawArc(x - rad, y - rad, rad * 2, rad * 2, 0, 360);
        }
        g.setPaintMode();
        g.setColor(oldColor);
        g.setRenderingHints(oldRenderinngHints);
    }

    @Override
    public String getName() {
        return MODE_NAME;
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    protected void updateStatus() {
        this.mFromPinLabel.setText("From Pin:");
        this.mToPinLabel.setText("To Pin:");
        if (this.mOverPort != null && this.mOverPort.mPortTemplate != null) {
            PortTemplate pt = (PortTemplate)this.mOverPort.mPortTemplate.second;
            DevicePath path = (DevicePath)this.mOverPort.mPortTemplate.first;
            if (this.mConnectingStart == null) {
                Icon icon = DbExplorerPanel.getIconForPinTemplate(pt.getPinTemplate());
                this.mFromPinName.setText(pt.getPinTemplate().getName() + " on " + path.getLast().getName());
                this.mFromPinName.setIcon(icon);
                Net n = NetMap.getTopmostNet((Net)pt.getPinTemplate().getNet(), (DevicePath)path);
                String fNet = n.getName();
                int numOver = this.mOverPort.getNumPorts();
                if (numOver < 2) {
                    this.mFromPinLabel.setText("From Pin:");
                } else {
                    this.mFromPinLabel.setText("From Pins:(" + numOver + ")");
                }
                this.mFromNetName.setText(fNet);
                this.mToPinName.setText(" ");
                this.mToNetName.setText(" ");
                this.mToPinName.setIcon(null);
            } else {
                this.mFromPinLabel.setText("From Pin:");
                Icon icon = DbExplorerPanel.getIconForPinTemplate(pt.getPinTemplate());
                this.mToPinName.setIcon(icon);
                this.mToPinName.setText(pt.getPinTemplate().getName() + " on " + path.getLast().getName());
                Net n = NetMap.getTopmostNet((Net)pt.getPinTemplate().getNet(), (DevicePath)path);
                String tNet = n.getName();
                this.mToNetName.setText(tNet);
                int numOver = this.mOverPort.getNumPorts();
                if (numOver < 2) {
                    this.mToPinLabel.setText("To Pin:");
                } else {
                    this.mToPinLabel.setText("To Pins:(" + numOver + ")");
                }
            }
        } else if (this.mConnectingStart == null) {
            this.mFromPinName.setText(" ");
            this.mFromNetName.setText(" ");
            this.mFromPinName.setIcon(DBEResources.ICON_UNKNOWN);
        } else {
            this.mToPinName.setText(" ");
            this.mToNetName.setText(" ");
            this.mToPinName.setIcon(DBEResources.ICON_UNKNOWN);
        }
        this.refocusView();
    }

    protected void refocusView() {
        EventQueue.invokeLater(() -> {
            if (this.mDialog.isActive()) {
                UIUtil.getParentWindow((Component)this.mView).setVisible(true);
            }
        });
    }

    protected class PortGetter {
        APoint2D mWorldClick;
        HierInst<PortTemplate> mPortTemplate = null;
        LinkedList<HierInst<PortTemplate>> portsAtLoc = new LinkedList();

        public int getNumPorts() {
            return this.portsAtLoc.size();
        }

        public APoint2D getWorldClick() {
            return this.mWorldClick;
        }

        public Point getScreenSnap() {
            APoint2D w = ((PortTemplate)this.mPortTemplate.getDbObject()).getCenterLoc((DevicePath)this.mPortTemplate.first);
            return MakeConnectionMode.this.mView.getCanvas().getXForm().getScreenPt(w);
        }

        public PinTemplate getPinTemplate() {
            if (this.mPortTemplate != null) {
                return ((PortTemplate)this.mPortTemplate.second).getPinTemplate();
            }
            return null;
        }

        public DevicePath getPinPath() {
            if (this.mPortTemplate != null) {
                return (DevicePath)this.mPortTemplate.first;
            }
            return null;
        }

        public PortGetter(Point screenPt, int nth) {
            this.mWorldClick = MakeConnectionMode.this.mView.getCanvas().getWorldPt(screenPt);
            Db db = MakeConnectionMode.this.mView.getDb();
            Design design = Design.getDesign((Db)db, (boolean)false);
            if (design == null) {
                return;
            }
            this.mPortTemplate = null;
            for (HierInst hdbo : design.getObjectsNear(this.mWorldClick, MakeConnectionMode.this.snapDistInternal)) {
                DevicePath dp = hdbo.getPath();
                DbObject dbo = hdbo.getDbObject();
                if (!(dbo instanceof PortTemplate)) continue;
                PortTemplate portT = (PortTemplate)dbo;
                PinTemplate pinTemplate = portT.getPinTemplate();
                PinInstance pinInstance = dp.getLast().getPin(pinTemplate);
                if (MakeConnectionMode.this.mConnectingStart != null && pinInstance.fixed()) continue;
                this.portsAtLoc.add((HierInst<PortTemplate>)new HierInst(dp, (DbObject)portT));
            }
            if (!this.portsAtLoc.isEmpty()) {
                if (nth < this.portsAtLoc.size()) {
                    this.mPortTemplate = this.portsAtLoc.get(nth);
                } else {
                    if (nth > this.portsAtLoc.size() - 1) {
                        nth %= this.portsAtLoc.size();
                    }
                    this.mPortTemplate = this.portsAtLoc.get(nth);
                }
            }
        }
    }
}

