/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.dbui.MoveAuxiliaryAdapter;
import com.sigrity.acl.dbui.MovingSet;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.eda.NetCutManager;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.BoundsAndOrigin;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.PlaceableItemUI;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MovePlaceableItemMode
extends AbstractViewMode {
    public static final String MODE_KEY = "MovePlaceableItemMode";
    protected static PlaceableItemUI.TypeInfo mPlaceableItemUI = null;
    protected boolean itemOnCursor = false;
    protected boolean startAgainAfterPlacing = false;
    protected HistoryListener mHL = null;
    protected BufferedImage mPlaceableItemImage;
    public static final int IMAGE_MARGIN = 5;
    protected Point mPlaceableItemImageOrigin = new Point();
    protected DesignCanvas2D.XForm mLastDrawnXForm = null;
    protected float mPendingRotation;
    protected boolean mPendingMirrorX;
    protected boolean mPendingMirrorY;
    protected NetCutManager mNCM = null;
    protected ArrayList<Connection> mDynConnections = null;
    protected Point mPrevLoc = new Point();
    protected int mMoveThreshold = -1;
    protected boolean mDrawingCursor = false;
    protected DefaultViewDrawer mViewDrawer = null;
    protected OptionWorkspace mOptionPanel = new OptionWorkspace();

    public static MovePlaceableItemMode install(DesignView2D view, PlaceableItemUI.TypeInfo flag) {
        if (view == null) {
            return null;
        }
        MovePlaceableItemMode ans = new MovePlaceableItemMode(view);
        view.setMode(ans);
        ans.setPlaceableItemMode(flag, true);
        mPlaceableItemUI = flag;
        return ans;
    }

    public MovePlaceableItemMode(DesignView2D view) {
        this.mView = view;
        PlaceableItemUI.init();
        PlaceableItemUI.initKeepInsideParent();
    }

    public void setItemOnCursor(boolean itemOnCursor) {
        this.itemOnCursor = itemOnCursor;
    }

    public void setStartAgainAfterPlacing(boolean flag) {
        this.startAgainAfterPlacing = flag;
    }

    @Override
    protected void installedMode() {
        if (this.mViewDrawer == null) {
            this.mViewDrawer = new DefaultViewDrawer(this.mView.getCanvas());
        }
        this.removePlaceableItemFromCursor();
        mPlaceableItemUI = null;
        DbHistory h = OrbitIO.getCurDb().getHistory();
        this.mHL = new HistoryListener();
        h.addListener((DbHistory.Listener)this.mHL);
        if (this.mView != null) {
            this.mView.getCanvas().getActionMap().put("Move Placeable Mode Action Cancel", new CancelMoveAction());
            this.mView.getCanvas().bindKey("Move Placeable Mode Action Cancel");
        }
    }

    @Override
    protected void removingMode() {
        if (this.mView != null) {
            this.mView.getCanvas().unbindKey(OrbitHotkey.getKeyStrokeStr("Move Placeable Mode Action Cancel"));
            this.mView.getCanvas().getActionMap().remove("Move Placeable Mode Action Cancel");
        }
        if (mPlaceableItemUI != null) {
            Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.moveFinished(true)", (Object[])new Object[0]);
        }
        this.removePlaceableItemFromCursor();
        mPlaceableItemUI = null;
        if (this.mHL != null) {
            DbHistory h;
            Db db = OrbitIO.getCurDb();
            DbHistory dbHistory = h = db == null ? null : db.getHistory();
            if (h != null) {
                h.removeListener((DbHistory.Listener)this.mHL);
            }
        }
    }

    public void setPlaceableItemMode(PlaceableItemUI.TypeInfo flag, boolean initPending) {
        mPlaceableItemUI = flag;
        if (initPending) {
            this.mPendingRotation = 0.0f;
            this.mPendingMirrorX = false;
            this.mPendingMirrorY = false;
        }
        if (mPlaceableItemUI != null) {
            this.mOptionPanel.updateActions(mPlaceableItemUI);
        }
    }

    public boolean isDynamicConnection(Connection c) {
        if (mPlaceableItemUI != null) {
            return mPlaceableItemUI.isDynamicConnection(c);
        }
        return false;
    }

    public void repaint() {
        this.repaintView();
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        if (this.mView == null) {
            return;
        }
        if (e.getButton() != 1 || mPlaceableItemUI == null) {
            return;
        }
        if (!this.itemOnCursor) {
            this.mPendingRotation = 0.0f;
            this.mPendingMirrorX = false;
            this.mPendingMirrorY = false;
            mPlaceableItemUI.startDynamicMoveAt(this.mView, e);
            this.itemOnCursor = true;
        } else if (MovingSet.fireIsValidLoc(PlaceableItemUI.getMovingSet())) {
            PlaceableItemUI.TypeInfo typeInfo = mPlaceableItemUI;
            PlaceableItemUI.endDynamicMoveAt(this.mView, e, this.mPendingRotation, this.mPendingMirrorX, this.mPendingMirrorY);
            if (this.startAgainAfterPlacing) {
                MovePlaceableItemMode mode = MovePlaceableItemMode.install(this.mView, typeInfo);
                mode.startAgainAfterPlacing = true;
            }
        } else {
            MovingSet.fireAdjustLoc(PlaceableItemUI.getMovingSet(), null);
            if (MovingSet.fireIsValidLoc(PlaceableItemUI.getMovingSet())) {
                ALog.logWarn((String)"Invalid location. Try again and wait until the cursor indicates the location is valid.");
            } else {
                PlaceableItemUI.TypeInfo typeInfo = mPlaceableItemUI;
                PlaceableItemUI.endDynamicMoveAt(this.mView, e, this.mPendingRotation, this.mPendingMirrorX, this.mPendingMirrorY);
                if (this.startAgainAfterPlacing) {
                    MovePlaceableItemMode mode = MovePlaceableItemMode.install(this.mView, typeInfo);
                    mode.startAgainAfterPlacing = true;
                }
            }
        }
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        this.repaintOverlay();
    }

    @Override
    protected boolean showContextMenu(JPopupMenu menu, Point loc) {
        if (this.mContextMenu != null && this.itemOnCursor && mPlaceableItemUI != null) {
            mPlaceableItemUI.insertItemsInContextMenu(this.mContextMenu);
        }
        return super.showContextMenu(menu, loc);
    }

    @Override
    public JPanel getOptionPanel() {
        return this.mOptionPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintOverlay(Graphics2D g, Rectangle bounds) {
        super.paintOverlay(g, bounds);
        if (this.mPlaceableItemImage == null || mPlaceableItemUI == null) {
            return;
        }
        Point loc = this.mView.getCanvas().getLastKnownMouseLoc();
        if (loc == null || this.mLastDrawnXForm == null) {
            return;
        }
        DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
        if (!this.mLastDrawnXForm.equals(xform)) {
            this.createCursorContentsImage();
        }
        loc = new Point(loc);
        APoint2D worldPoint = xform.getWorldPt(loc);
        PlaceableItemUI.getMovingSet().setView(this.mView);
        worldPoint = PlaceableItemUI.getMovingSet().setCurLoc(worldPoint);
        loc = xform.getScreenPt(worldPoint);
        loc.translate(-this.mPlaceableItemImageOrigin.x, -this.mPlaceableItemImageOrigin.y);
        MovingSet.fireDrawBackground(PlaceableItemUI.getMovingSet(), g, bounds, this.mView);
        BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{5.0f, 5.0f, 5.0f}, 0.0f);
        g.setStroke(dashed);
        g.setPaint(Color.RED);
        for (MoveAuxiliaryAdapter.AuxiliaryLine axl : MoveAuxiliaryAdapter.getAuxiliary()) {
            Shape shp = axl.getLine().shrink(101.0).transform(xform.getWorldToScreenTransform()).getAwtShape();
            g.setPaint(axl.isPreferred() ? Color.RED : Color.ORANGE);
            g.draw(shp);
        }
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.7f);
        Composite oldComposite = g.getComposite();
        g.setComposite(ac);
        try {
            g.drawImage((Image)this.mPlaceableItemImage, loc.x - 5, loc.y - 5, null);
            boolean drawDynConnsEnabled = (Boolean)Settings.get((String)"UserPreferences", (String)"EnableDrawingDynamicConnections", (Object)true);
            if (drawDynConnsEnabled && MovingSet.fireDrawDynamicConnections()) {
                int dy;
                boolean needResched = true;
                int dx = Math.abs((int)loc.getX() - (int)this.mPrevLoc.getX());
                if (dx + (dy = Math.abs((int)loc.getY() - (int)this.mPrevLoc.getY())) < this.mMoveThreshold) {
                    needResched = false;
                }
                if (this.mDynConnections == null) {
                    this.mNCM = new NetCutManager();
                    this.mNCM.addDynamicForSelSet(PlaceableItemUI.getMovingSelectSet());
                    this.mNCM.deriveNetCutSet();
                    needResched = true;
                }
                Connection.setDynamictransform((AffineTransform)PlaceableItemUI.getMovingSet().getTransformForCurrentLoc(0.0f));
                if (needResched) {
                    this.mDynConnections = this.mNCM.getClosestConnectionSet(worldPoint);
                    this.mPrevLoc = loc;
                }
                if (this.mDynConnections != null) {
                    DefaultViewDrawer.DrawContext dc = new DefaultViewDrawer.DrawContext(this.mView.getCanvas());
                    for (Connection c : this.mDynConnections) {
                        this.mViewDrawer.drawConnection(dc, g, c);
                    }
                }
            }
        }
        finally {
            g.setComposite(oldComposite);
            g.dispose();
        }
    }

    public void dynRotate(float rotation) {
        this.mPendingRotation = (360.0f + this.mPendingRotation + rotation) % 360.0f;
        PlaceableItemUI.getMovingSet().rotateAndMirror(this.mPendingRotation, this.mPendingMirrorX, this.mPendingMirrorY);
        this.createCursorContentsImage();
        this.repaintOverlay();
    }

    public void refreshImage() {
        PlaceableItemUI.getMovingSet().updateBBoxRelativeToZero();
        this.createCursorContentsImage();
        this.repaintOverlay();
    }

    public void dynRotateBest() {
        if (mPlaceableItemUI == null) {
            return;
        }
        float desiredRot = PlaceableItemUI.getBestRotation();
        if (desiredRot != 0.0f) {
            this.dynRotate(desiredRot);
        }
    }

    public void dynMirror(boolean aboutX) {
        if (aboutX) {
            this.mPendingMirrorX = !this.mPendingMirrorX;
        } else {
            this.mPendingMirrorY = !this.mPendingMirrorY;
        }
        PlaceableItemUI.getMovingSet().rotateAndMirror(this.mPendingRotation, this.mPendingMirrorX, this.mPendingMirrorY);
        this.createCursorContentsImage();
        this.repaintOverlay();
    }

    public void dynMirrorX() {
        this.mPendingMirrorX = !this.mPendingMirrorX;
        PlaceableItemUI.getMovingSet().rotateAndMirror(this.mPendingRotation, this.mPendingMirrorX, this.mPendingMirrorY);
        this.createCursorContentsImage();
        this.repaintOverlay();
    }

    public void dynMirrorY() {
        this.mPendingMirrorY = !this.mPendingMirrorY;
        PlaceableItemUI.getMovingSet().rotateAndMirror(this.mPendingRotation, this.mPendingMirrorX, this.mPendingMirrorY);
        this.createCursorContentsImage();
        this.repaintOverlay();
    }

    public void createCursorContentsImage() {
        if (mPlaceableItemUI == null) {
            ALog.logDebug((String)"No placeable item UI, cannot create cursor");
            return;
        }
        DesignCanvas2D canvas = this.mView.getCanvas();
        BoundsAndOrigin boundsAndOrigin = PlaceableItemUI.getPlaceableItemScreenBoundsAndOrigin(this.mView);
        this.mPlaceableItemImageOrigin = boundsAndOrigin.getOrigin();
        this.mPlaceableItemImage = PlaceableItemUI.getImage(this.mView, this.mViewDrawer, boundsAndOrigin);
        if (this.mPlaceableItemImage == null) {
            return;
        }
        if (this.mMoveThreshold < 0) {
            this.mMoveThreshold = Math.min(boundsAndOrigin.getScreenBounds().width, boundsAndOrigin.getScreenBounds().height) * 2;
        }
        this.mLastDrawnXForm = canvas.copyXForm(canvas.getXForm());
    }

    public void clearDynConnections() {
        this.mDynConnections = null;
    }

    public void removePlaceableItemFromCursor() {
        this.mPrevLoc.setLocation(0, 0);
        this.clearDynConnections();
        this.mMoveThreshold = -1;
        if (this.mView != null && this.mView.getBeingMoved() != null && this.mView.getBeingMoved().getObjectsAreCopy()) {
            Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.clearSelSet(false);", (Object[])new Object[0]);
        }
        if (this.itemOnCursor && this.mView != null) {
            this.mView.getCanvas().refresh();
        }
        this.itemOnCursor = false;
        this.mPlaceableItemImage = null;
    }

    @Override
    public String getName() {
        if (PlaceableItemUI.getThePOType() == null) {
            return "Move Device";
        }
        if (PlaceableItemUI.getCopyMode()) {
            return "Copy " + PlaceableItemUI.getThePOType().getType();
        }
        return "Move " + PlaceableItemUI.getThePOType().getType();
    }

    @Override
    public Cursor getCursor() {
        if (PlaceableItemUI.getThePOType() == null) {
            return UIUtil.createCursor((Icon)OrbitIcons.MOVE_DEVICE);
        }
        return PlaceableItemUI.getThePOType().getCursor();
    }

    protected class HistoryListener
    extends DbHistory.ListenerAdapter {
        protected HistoryListener() {
        }

        public void startUndoRedo(boolean isRedo) {
            MovePlaceableItemMode.this.removePlaceableItemFromCursor();
            if (mPlaceableItemUI != null) {
                Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.moveFinished(true)", (Object[])new Object[0]);
            }
            MovePlaceableItemMode.this.mView.setMode(PlaceableItemUI.getPrevMode());
        }
    }

    private class OptionWorkspace
    extends JPanel {
        private OptionWorkspace() {
        }

        public void updateActions(PlaceableItemUI.TypeInfo placeType) {
            this.removeAll();
            GridBagManager l = new GridBagManager((Container)this);
            for (AbstractButton contextBtn : placeType.getToolBarActions()) {
                AbstractButton btn;
                if (contextBtn == null || contextBtn.getAction() == null) continue;
                if (contextBtn instanceof JCheckBoxMenuItem) {
                    btn = new MaskCheckBox((JCheckBoxMenuItem)contextBtn);
                    l.add((Component)btn, (GridBagConstraints)GridBagManager.LEFT.insets(0));
                } else {
                    btn = new JButton(contextBtn.getAction());
                    btn.setToolTipText(contextBtn.getText());
                    UIUtil.makeToolBarButton((AbstractButton)btn);
                    if (btn.getIcon() != null) {
                        l.add((Component)btn, (GridBagConstraints)GridBagManager.LEFT.insets(0));
                    }
                }
                l.newline();
            }
            l.addFillX();
        }
    }

    static class MaskCheckBox
    extends JCheckBox {
        final JCheckBoxMenuItem mMenuItem;

        public MaskCheckBox(JCheckBoxMenuItem btnItem) {
            super(btnItem.getAction());
            this.mMenuItem = btnItem;
            this.setText(btnItem.getText());
            this.setSelected(this.mMenuItem.isSelected());
            this.mMenuItem.addActionListener(e -> this.setSelected(this.mMenuItem.isSelected()));
        }

        @Override
        public boolean isSelected() {
            if (this.mMenuItem == null) {
                return false;
            }
            return this.mMenuItem.isSelected();
        }
    }

    protected static class CancelMoveAction
    extends AbstractAction {
        public static final String KEY = "Move Placeable Mode Action Cancel";

        public CancelMoveAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlaceableItemUI.doneAction();
        }
    }
}

