/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import com.google.common.collect.Lists;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppEnv;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DeviceRegionMap;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AColorChooserDlg;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPortShape;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.DimensionsUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

public class RulerMode
extends AbstractViewMode {
    public static final String MODE_KEY = "RulerMode";
    public static final String MODE_NAME = "Ruler";
    private static Color COLOR_ORTHO = Color.RED;
    private static Color COLOR_ANY = Color.MAGENTA;
    private static Color COLOR_HIGHLIGHT = Color.PINK;
    private final BasicStroke stroke1 = new BasicStroke(1.0f, 0, 1);
    private final BasicStroke stroke3 = new BasicStroke(3.0f, 0, 1);
    private final BasicStroke stroke1Dash = new BasicStroke(1.0f, 0, 1, 45.0f, new float[]{5.0f, 3.0f}, 0.0f);
    private static final Map<DesignView2D, LinkedList<Ruler>> sRulers;
    protected SubMode mSubMode = null;
    protected RULE_MODE mRuleMode = RULE_MODE.SINGLE;
    protected int mCursorLegSize = 8;
    protected int mNearDistScreen = 24;
    protected CursorLoc mCurLoc = null;
    protected boolean mMeasuring = false;
    protected CursorLoc mMeasureStart = null;
    protected CursorLoc mMeasureEnd = null;
    protected LinkedList<CursorLoc> mMeasureMiddles = new LinkedList();
    protected AFloatWindow mWindow;
    protected String mWindowTitle = "Rulers";
    protected boolean mWasVisible;
    protected JCheckBox mSnapDevice = new JCheckBox("Snap to Device", true);
    protected JCheckBox mSnapPin = new JCheckBox("Snap to Pin", true);
    protected JCheckBox mSnapCenter = new JCheckBox("Snap to Center", true);
    protected JCheckBox mSnapEdge = new JCheckBox("Snap to Edge", true);
    protected JCheckBox[] mSnapObjTypes = new JCheckBox[]{this.mSnapDevice, this.mSnapPin};
    protected JCheckBox[] mSnapLocTypes = new JCheckBox[]{this.mSnapCenter, this.mSnapEdge};
    protected JPanel mPnlInteractiveRulerStatus;
    protected JTextField mTxtStart;
    protected JTextField mTxtEnd;
    protected JTextField mTxtDx;
    protected JTextField mTxtDy;
    protected JTextField mTxtDt;
    protected JTextField mTxtDir;
    protected String mFloatDisplayFormat = null;
    protected String mPointDisplayFormat = null;
    protected KeyListener mKeyListener = new RulerKeyListener();
    protected Ruler mFocusRuler = null;
    ComponentListener mViewComponentListener = new ComponentAdapter(){

        @Override
        public void componentHidden(ComponentEvent e) {
            RulerMode.this.mWasVisible = RulerMode.this.mWindow.isVisible();
            RulerMode.this.mWindow.setVisible(false);
        }

        @Override
        public void componentShown(ComponentEvent e) {
            if (RulerMode.this.mWasVisible) {
                RulerMode.this.mWindow.setVisible(true);
                RulerMode.this.refocusView();
            }
        }
    };

    private static void loadDefaultSettings() {
        if (AApp.getApp() != null && AApp.getApp().hasEnv(AAppEnv.UI_THEME_INNOVUS)) {
            COLOR_ORTHO = Color.YELLOW;
            COLOR_ANY = Color.YELLOW;
            COLOR_HIGHLIGHT = Color.ORANGE;
        }
    }

    public static LinkedList<Ruler> getRulers() {
        LinkedList<Ruler> ret = sRulers.get(OrbitIO.getCurView());
        if (ret == null) {
            return new LinkedList<Ruler>();
        }
        return ret;
    }

    public static void resetRulers() {
        RulerMode.getRulers().clear();
    }

    public static void removeLastRuler() {
        if (!RulerMode.getRulers().isEmpty()) {
            RulerMode.getRulers().removeLast();
        }
    }

    public static Ruler addRuler(DesignView2D view, Ruler r) {
        LinkedList ret = sRulers.computeIfAbsent(view, k -> new LinkedList());
        ret.add(r);
        return r;
    }

    @Override
    public void installMode(DesignView2D view) {
        Unit unit = view.getUnit();
        this.mFloatDisplayFormat = "%,.4f";
        if (unit != null) {
            this.mFloatDisplayFormat = unit.getShortFormat();
        }
        super.installMode(view);
        this.mView.getCanvas().addKeyListener(this.mKeyListener);
    }

    @Override
    public void uninstallMode() {
        this.mView.getCanvas().addKeyListener(this.mKeyListener);
        this.mView.removeComponentListener(this.mViewComponentListener);
        super.uninstallMode();
        UIUtil.closeWindow((Window)((Object)this.mWindow));
    }

    @Override
    protected void installedMode() {
        if (this.mWindow != null) {
            UIUtil.closeWindow((Window)((Object)this.mWindow));
        }
        this.mPointDisplayFormat = String.format("(%s, %s)", this.mFloatDisplayFormat, this.mFloatDisplayFormat);
        this.initOptionWindow();
        Rectangle viewBounds = this.mView.getBounds();
        Point p = new Point(viewBounds.x + viewBounds.width / 2 - this.mWindow.getBounds().width / 2, viewBounds.y + viewBounds.height);
        SwingUtilities.convertPointToScreen(p, this.mView.getParent());
        this.mWindow.setLocation(p);
        this.mWindow.setVisible(true);
        this.mWasVisible = true;
        this.mView.addComponentListener(this.mViewComponentListener);
        this.updateStatus();
        this.informUser("<html>Snapping can be modified via the Measure window's Options button.<br/>Hold 'Shift' while moving to temporarily disable snapping.", new Object[0]);
        if (this.mSubMode != null && this.mSubMode.getClass().equals(DimensionsUI.EditDimensionsDlg.class)) {
            this.informUser("<html>Once the 2 end points have been set, right-click on the mouse and select 'End & Commit Dimensions' to save the dimensions.<br/>", new Object[0]);
        }
    }

    private void initOptionWindow() {
        this.mWindow = AFloatWindow.createInstance(UIUtil.getParentWindow((Component)this.mView), this.mWindowTitle, false);
        GridBagManager l = new GridBagManager(this.mWindow.getContentPane());
        this.mWindow.setForcePinned(true);
        this.initOptionToolbar(l);
        this.mPnlInteractiveRulerStatus = l.push("Current Status", (GridBagConstraints)GridBagManager.FILLX.width(2));
        this.mTxtStart = this.addFloatDisplay(l, "Start", 2);
        l.newline();
        this.mTxtEnd = this.addFloatDisplay(l, "End", 2);
        l.newline();
        this.mTxtDx = this.addFloatDisplay(l, "Horizontal", 1);
        l.newline();
        this.mTxtDy = this.addFloatDisplay(l, "Vertical", 1);
        l.newline();
        this.mTxtDt = this.addFloatDisplay(l, "Total", 1);
        l.newline();
        this.mTxtDir = this.addFloatDisplay(l, "Direction", 1);
        l.popNl();
        l.push("Mode", (GridBagConstraints)GridBagManager.FILLALL);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton modeBtn = (JRadioButton)l.add((Component)new JRadioButton("Single Edge"), (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        bg.add(modeBtn);
        modeBtn.addItemListener(e -> {
            this.mRuleMode = RULE_MODE.SINGLE;
        });
        modeBtn.setSelected(true);
        l.newline();
        modeBtn = (JRadioButton)l.add((Component)new JRadioButton("Orthogonal Edges"), (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        bg.add(modeBtn);
        modeBtn.addItemListener(e -> {
            this.mRuleMode = RULE_MODE.ORTHOGONAL;
        });
        l.newline();
        modeBtn = (JRadioButton)l.add((Component)new JRadioButton("Multiple Edges"), (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        modeBtn.addItemListener(e -> {
            this.mRuleMode = RULE_MODE.MULTIPLE;
        });
        bg.add(modeBtn);
        l.newline();
        modeBtn = (JRadioButton)l.add((Component)new JRadioButton("Cross Ruler"), (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        modeBtn.addItemListener(e -> {
            this.mRuleMode = RULE_MODE.CROSS;
        });
        bg.add(modeBtn);
        l.newline();
        modeBtn = (JRadioButton)l.add((Component)new JRadioButton("Circle Ruler"), (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        modeBtn.addItemListener(e -> {
            this.mRuleMode = RULE_MODE.CIRCLE;
        });
        bg.add(modeBtn);
        l.addFillX();
        l.addFillY();
        l.pop();
        l.push("Snap", (GridBagConstraints)GridBagManager.FILLALL);
        this.createOptionsPanel(l);
        l.popNl();
        l.push((GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        JButton colorBtn = new JButton(new ActionChangeColor());
        UIUtil.makeToolBarButton((AbstractButton)colorBtn);
        colorBtn.setIcon((Icon)new AColorIcon(16, 16, COLOR_ANY));
        colorBtn.setText("");
        JButton orthoBtn = new JButton(new ActionChangeOrthoColor());
        UIUtil.makeToolBarButton((AbstractButton)orthoBtn);
        orthoBtn.setIcon((Icon)new AColorIcon(16, 16, COLOR_ORTHO));
        orthoBtn.setText("");
        JButton highlightBtn = new JButton(new ActionChangeHighlightColor());
        UIUtil.makeToolBarButton((AbstractButton)highlightBtn);
        highlightBtn.setIcon((Icon)new AColorIcon(16, 16, COLOR_HIGHLIGHT));
        highlightBtn.setText("");
        l.add((Component)colorBtn, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.add((Component)orthoBtn, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.add((Component)highlightBtn, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.addFillX();
        JButton btnReset = (JButton)l.add((Component)new JButton("Clear All Rulers"), (GridBagConstraints)GridBagManager.RIGHT);
        UIUtil.makeFootButton((AbstractButton)btnReset);
        btnReset.addActionListener(e -> {
            this.resetInteractiveRuler();
            RulerMode.resetRulers();
            this.repaintOverlay();
        });
        l.popNl();
        this.updateStatus();
        this.mWindow.revalidate();
        this.mWindow.pack();
    }

    protected void initOptionToolbar(GridBagManager l) {
        JButton btnRefresh = new JButton(new ActionRefreshStatus());
        UIUtil.makeToolBarButton((AbstractButton)btnRefresh);
        JButton btnPrevFocus = new JButton(new ActionPrevFocus());
        UIUtil.makeToolBarButton((AbstractButton)btnPrevFocus);
        JButton btnNextFocus = new JButton(new ActionNextFocus());
        UIUtil.makeToolBarButton((AbstractButton)btnNextFocus);
        l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.insets(0));
        l.add((Component)btnRefresh, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.add((Component)btnPrevFocus, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.add((Component)btnNextFocus, (GridBagConstraints)GridBagManager.LEFT.insets(0));
        l.addFillX();
        l.pop();
        l.newline();
    }

    @Override
    protected void removingMode() {
        this.mView.removeComponentListener(this.mViewComponentListener);
    }

    @Override
    public void mouseMoved(DesignView2D.MouseAction e) {
        super.mouseMoved(e);
        LinkedList tempDisabled = Lists.newLinkedList();
        if (e.isShiftDown()) {
            for (JCheckBox cb : this.mSnapObjTypes) {
                if (!cb.isSelected()) continue;
                cb.setSelected(false);
                tempDisabled.add(cb);
            }
        }
        this.updateMeasure(e);
        this.updateStatus();
        this.repaintOverlay();
        for (JCheckBox cb : tempDisabled) {
            cb.setSelected(true);
        }
    }

    @Override
    public void mouseClicked(DesignView2D.MouseAction e) {
        super.mouseClicked(e);
        if (e.isConsumed()) {
            return;
        }
        if (e.getButton() != 1) {
            return;
        }
        this.mouseMoved(e);
        if (!this.mMeasuring) {
            this.startMeasure();
            if (!this.mWindow.isVisible()) {
                this.mWindow.setVisible(true);
            }
            this.mMeasuring = true;
        } else if ((this.mRuleMode == RULE_MODE.ORTHOGONAL || this.mRuleMode == RULE_MODE.MULTIPLE) && e.getClickCount() < 2) {
            this.mMeasureMiddles.add(this.mMeasureEnd);
        } else {
            this.endMeasure();
            this.mView.repaint();
        }
        this.repaintOverlay();
        this.updateStatus();
    }

    private void startMeasure() {
        this.mMeasureEnd = this.mMeasureStart = this.mCurLoc;
        if (this.mRuleMode == RULE_MODE.ORTHOGONAL || this.mRuleMode == RULE_MODE.MULTIPLE) {
            this.mMeasureMiddles.clear();
            this.mMeasureMiddles.add(this.mMeasureStart);
        }
    }

    private void endMeasure() {
        this.mMeasureEnd = this.mCurLoc;
        Ruler r = null;
        if (this.mRuleMode == RULE_MODE.SINGLE) {
            if (this.mMeasureStart != null && this.mMeasureEnd != null) {
                r = RulerMode.addRuler(this.mView, new SingleRuler(this.mMeasureStart, this.mMeasureEnd));
            }
        } else if (this.mRuleMode == RULE_MODE.CIRCLE) {
            if (this.mMeasureStart != null && this.mMeasureEnd != null) {
                r = RulerMode.addRuler(this.mView, new CircleRuler(this.mMeasureStart, this.mMeasureEnd));
            }
        } else if (this.mRuleMode == RULE_MODE.ORTHOGONAL || this.mRuleMode == RULE_MODE.MULTIPLE) {
            r = RulerMode.addRuler(this.mView, new ContinuousRuler(this.mMeasureMiddles));
        } else if (this.mRuleMode == RULE_MODE.CROSS) {
            r = RulerMode.addRuler(this.mView, new CrossRuler(this.mMeasureEnd));
        }
        this.mFocusRuler = r;
        this.mMeasureStart = null;
        this.mMeasureEnd = null;
        this.mMeasuring = false;
        this.mMeasureMiddles.clear();
    }

    @Override
    protected void paintOverlay(Graphics2D g, Rectangle bounds) {
        super.paintOverlay(g, bounds);
        RenderingHints oldRenderinngHints = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke oldStroke = g.getStroke();
        Color oldColor = g.getColor();
        if (this.mMeasureStart != null && this.mMeasureEnd != null) {
            Ruler r;
            if (this.mRuleMode == RULE_MODE.SINGLE) {
                this.mFocusRuler = r = new SingleRuler(this.mMeasureStart, this.mMeasureEnd);
                r.paint(g);
            } else if (this.mRuleMode == RULE_MODE.CIRCLE) {
                this.mFocusRuler = r = new CircleRuler(this.mMeasureStart, this.mMeasureEnd);
                r.paint(g);
            } else if (this.mRuleMode == RULE_MODE.ORTHOGONAL || this.mRuleMode == RULE_MODE.MULTIPLE) {
                this.mMeasureMiddles.add(this.mMeasureEnd);
                this.mFocusRuler = r = new ContinuousRuler(this.mMeasureMiddles);
                this.mMeasureMiddles.removeLast();
                r.paint(g);
            } else if (this.mRuleMode == RULE_MODE.CROSS) {
                this.mFocusRuler = r = new CrossRuler(this.mMeasureEnd);
                r.paint(g);
            }
        }
        if (this.mCurLoc != null) {
            int x = this.mCurLoc.getSnapScreen().x;
            int y = this.mCurLoc.getSnapScreen().y;
            g.setStroke(this.stroke3);
            g.setColor(Color.WHITE);
            g.drawLine(x - this.mCursorLegSize, y, x + this.mCursorLegSize, y);
            g.drawLine(x, y - this.mCursorLegSize, x, y + this.mCursorLegSize);
            g.setStroke(oldStroke);
            g.setColor(Color.BLACK);
            g.drawLine(x - this.mCursorLegSize, y, x + this.mCursorLegSize, y);
            g.drawLine(x, y - this.mCursorLegSize, x, y + this.mCursorLegSize);
        }
        g.setPaintMode();
        g.setColor(oldColor);
        g.setRenderingHints(oldRenderinngHints);
    }

    public void startSubMode(SubMode mode) {
        this.endSubmode();
        if (mode != null) {
            this.mSubMode = mode;
        }
    }

    public void endSubmode() {
        if (this.mSubMode != null) {
            this.mSubMode = null;
        }
    }

    protected void concatMenuItems(JPopupMenu menu, Collection<Component> items) {
        for (Component i : items) {
            menu.add(i);
        }
    }

    protected void removeMenuItems(JPopupMenu menu, Collection<Component> items) {
        for (Component i : items) {
            menu.remove(i);
        }
    }

    @Override
    protected boolean showContextMenu(final JPopupMenu menu, Point loc) {
        if (this.mSubMode != null) {
            final List<Component> modeItems = this.mSubMode.getContextMenu(loc);
            menu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    menu.removePopupMenuListener(this);
                    if (modeItems != null) {
                        RulerMode.this.removeMenuItems(menu, modeItems);
                    }
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (modeItems != null) {
                        RulerMode.this.concatMenuItems(menu, modeItems);
                    }
                }
            });
        }
        return super.showContextMenu(menu, loc);
    }

    @Override
    public String getName() {
        return MODE_NAME;
    }

    @Override
    public Cursor getCursor() {
        return UIUtil.createCursor((Icon)OrbitIcons.RULER);
    }

    public boolean getSnapAnyDeviceTypes() {
        for (JCheckBox cb : this.mSnapObjTypes) {
            if (!cb.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean getSnapAnyLocTypes() {
        for (JCheckBox cb : this.mSnapLocTypes) {
            if (!cb.isSelected()) continue;
            return true;
        }
        return false;
    }

    protected void updateMeasure(DesignView2D.MouseAction e) {
        CursorLoc snapRefPt;
        CursorLoc cursorLoc = snapRefPt = this.mMeasuring ? this.mMeasureStart : null;
        if (this.mRuleMode == RULE_MODE.ORTHOGONAL && this.mMeasuring && !this.mMeasureMiddles.isEmpty()) {
            snapRefPt = this.mMeasureMiddles.getLast();
        }
        this.mCurLoc = new CursorLoc(e.getPoint(), snapRefPt);
        if (!this.mMeasuring) {
            return;
        }
        this.mMeasureEnd = this.mCurLoc;
        if (this.mMeasureStart.mSnapPreferred == null) {
            return;
        }
        if (this.mMeasureStart.mSnapPreferred.getGeom() instanceof ACircle) {
            boolean refSameCircle = this.mMeasureStart.snappedToSameGeom(this.mMeasureEnd);
            ACircle c = (ACircle)this.mMeasureStart.mSnapPreferred.getGeom();
            APoint2D relSnapRef = this.mMeasureEnd.getSnap().transform(this.mMeasureStart.mSnapPreferred.getDbObject().getPath().getInverseTransform());
            boolean refInside = c.intersects(relSnapRef);
            if (refSameCircle || this.mMeasureEnd.getSnappedToObj() == null && refInside) {
                assert (this.mMeasureStart.mSnapInitial != null);
                if (this.mMeasureStart.mSnapInitial != null) {
                    this.mMeasureStart.mForceInitialSnap = true;
                    return;
                }
            }
        }
        this.mMeasureStart.mForceInitialSnap = false;
        this.mMeasureStart.mSnapPreferred.updateDynamicSnap(this.mMeasureEnd.getSnap());
    }

    protected IterableIterator<SnapPoint> getSnapPoints(SnapObject snapObj, APoint2D snapRef) {
        return SnapPoint.getFor(snapObj, snapRef, this.mSnapCenter.isSelected(), this.mSnapEdge.isSelected());
    }

    protected void updateStatus() {
        this.setVisible(this.mPnlInteractiveRulerStatus, true);
        Point2D.Double sp = null;
        Point2D.Double ep = null;
        if (this.mMeasureStart != null && this.mMeasureEnd != null) {
            sp = this.mView.getCanvas().worldToUser(this.mMeasureStart.getSnap());
            ep = this.mView.getCanvas().worldToUser(this.mMeasureEnd.getSnap());
        } else {
            SingleRuler sr = null;
            if (this.mFocusRuler instanceof SingleRuler) {
                sr = (SingleRuler)this.mFocusRuler;
            }
            if (sr != null) {
                sp = this.mView.getCanvas().worldToUser(sr.mStart.getSnap());
                ep = this.mView.getCanvas().worldToUser(sr.mEnd.getSnap());
            }
        }
        if (sp != null && ep != null) {
            double dx = ep.x - sp.x;
            double dy = ep.y - sp.y;
            double dt = Math.sqrt(Math.pow(ep.x - sp.x, 2.0) + Math.pow(ep.y - sp.y, 2.0));
            double angle = 0.0;
            if (dx == 0.0 && dy == 0.0) {
                angle = 0.0;
            } else if (dx == 0.0) {
                angle = dy > 0.0 ? 90.0 : 270.0;
            } else if (dy == 0.0) {
                angle = dx > 0.0 ? 0.0 : 180.0;
            } else {
                angle = Math.atan(dy / dx) * 180.0 / Math.PI;
                if (dx < 0.0) {
                    angle += 180.0;
                } else if (dy < 0.0) {
                    angle += 360.0;
                }
            }
            this.mTxtStart.setText(String.format(this.mPointDisplayFormat, sp.x, sp.y));
            this.mTxtEnd.setText(String.format(this.mPointDisplayFormat, ep.x, ep.y));
            this.mTxtDx.setText(String.format(this.mFloatDisplayFormat, dx));
            this.mTxtDy.setText(String.format(this.mFloatDisplayFormat, dy));
            this.mTxtDt.setText(String.format(this.mFloatDisplayFormat, dt));
            this.mTxtDir.setText(String.format("%,.4f", angle));
        }
        if (this.mMeasuring) {
            this.mWindow.setTitle(this.mWindowTitle + " *");
        } else {
            this.mWindow.setTitle(this.mWindowTitle);
        }
        this.refocusView();
    }

    public APoint2D getStartPt() {
        return this.mMeasureStart.getSnap();
    }

    public APoint2D getEndPt() {
        return this.mMeasureEnd.getSnap();
    }

    public AFloatWindow getWindow() {
        return this.mWindow;
    }

    protected void resetInteractiveRuler() {
        this.mMeasuring = false;
        this.mMeasureStart = null;
        this.mMeasureEnd = null;
        this.mTxtStart.setText("");
        this.mTxtEnd.setText("");
        this.mTxtDx.setText("");
        this.mTxtDy.setText("");
        this.mTxtDt.setText("");
        this.mTxtDir.setText("");
    }

    protected JTextField addFloatDisplay(GridBagManager l, String lbl, int floatCount, Integer insetBottom) {
        GridBagManager.GridBagConstraintsEx gbcLbl = GridBagManager.LEFT.insetTop(0);
        if (insetBottom != null) {
            gbcLbl = gbcLbl.insetBottom(insetBottom.intValue());
        }
        l.add(lbl + ": ", (GridBagConstraints)gbcLbl);
        JTextField tf = new JTextField(8 * floatCount);
        tf.setBorder(null);
        tf.setEditable(false);
        UIUtil.addCopySupport((JTextComponent)tf);
        tf.setFont(tf.getFont().deriveFont(1));
        GridBagManager.GridBagConstraintsEx gbcTxt = GridBagManager.FILLX.insetTop(0);
        if (insetBottom != null) {
            gbcTxt = gbcTxt.insetBottom(insetBottom.intValue());
        }
        return (JTextField)l.add((Component)tf, (GridBagConstraints)gbcTxt);
    }

    protected JTextField addFloatDisplay(GridBagManager l, String lbl, int floatCount) {
        return this.addFloatDisplay(l, lbl, floatCount, null);
    }

    private void createOptionsPanel(GridBagManager l) {
        for (JCheckBox cb : this.mSnapObjTypes) {
            l.addNl((Component)cb, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        }
        for (JCheckBox cb : this.mSnapLocTypes) {
            l.addNl((Component)cb, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        }
        l.addFillX();
        l.addFillY();
    }

    protected void setVisible(JComponent c, boolean v) {
        if (c.isVisible() == v) {
            return;
        }
        c.setVisible(v);
        this.mWindow.pack();
    }

    protected void refocusView() {
        EventQueue.invokeLater(() -> {
            Window parentWin;
            if (this.mWindow.isActive() && (parentWin = UIUtil.getParentWindow((Component)this.mView)) != null) {
                parentWin.setVisible(true);
                this.mView.getCanvas().requestFocusInWindow();
            }
        });
    }

    @Override
    protected void loadContextMenu(AbstractViewMode.ContextMenu menu, Point loc) {
        LinkedList<Component> modeItems = this.getContextMenu();
        this.concatMenuItems(menu, modeItems);
        menu.setDelayUpdatedEnabled(false);
        super.loadContextMenu(menu, loc);
    }

    private LinkedList<Component> getContextMenu() {
        LinkedList<Component> menuItems = new LinkedList<Component>();
        menuItems.add(new JMenuItem(new AbstractAction("End & Commit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RulerMode.this.endMeasure();
            }
        }));
        return menuItems;
    }

    static {
        RulerMode.loadDefaultSettings();
        sRulers = new WeakHashMap<DesignView2D, LinkedList<Ruler>>();
    }

    protected class ActionNextFocus
    extends AbstractAction {
        ActionNextFocus() {
            super("", OrbitIcons.SRCH_NEXT);
            this.putValue("ShortDescription", "Focus next ruler");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LinkedList<Ruler> rulers = RulerMode.getRulers();
            if (rulers.isEmpty()) {
                return;
            }
            int i = (rulers.indexOf(RulerMode.this.mFocusRuler) + 1 + rulers.size()) % rulers.size();
            RulerMode.this.mFocusRuler = (Ruler)rulers.get(i);
            RulerMode.this.updateStatus();
            RulerMode.this.repaintOverlay();
        }
    }

    protected class ActionPrevFocus
    extends AbstractAction {
        ActionPrevFocus() {
            super("", OrbitIcons.SRCH_PREV);
            this.putValue("ShortDescription", "Focus previous ruler");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LinkedList<Ruler> rulers = RulerMode.getRulers();
            if (rulers.isEmpty()) {
                return;
            }
            int i = (rulers.indexOf(RulerMode.this.mFocusRuler) - 1 + rulers.size()) % rulers.size();
            if (i < 0) {
                i = 0;
            }
            RulerMode.this.mFocusRuler = (Ruler)rulers.get(i);
            RulerMode.this.updateStatus();
            RulerMode.this.repaintOverlay();
        }
    }

    protected class ActionRefreshStatus
    extends AbstractAction {
        ActionRefreshStatus() {
            super("", OrbitIcons.REFRESH);
            this.putValue("ShortDescription", "Refresh Current Status");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RulerMode.this.updateStatus();
        }
    }

    protected class RulerKeyListener
    implements KeyListener {
        protected RulerKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                RulerMode.this.endMeasure();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    public static class SnapPoint {
        SnapObject mSnapObj;
        Pt mRelPt;

        public static IterableIterator<SnapPoint> getFor(SnapObject snapObj, APoint2D refPt, boolean center, boolean edge) {
            return SnapPoint.getPts(snapObj, refPt, center, edge).mapAndNonNull(pt -> new SnapPoint(snapObj, (Pt)pt));
        }

        public static IterableIterator<Pt> getPts(SnapObject snapObj, APoint2D refPt, boolean center, boolean edges) {
            LinkedList<Pt> pts = new LinkedList<Pt>();
            if (edges) {
                for (Supplier edgeSupplier : snapObj.getEdgeSuppliers()) {
                    AGeom edge = (AGeom)edgeSupplier.get();
                    ALine l = edge.distanceToPoint(refPt, true);
                    if (l == null) continue;
                    boolean isLeft = l.getP0().equals((Object)refPt);
                    pts.add(Pt.dynamic(() -> SnapPoint.lambda$getPts$1((Supplier)edgeSupplier, refPt, isLeft), edgeSupplier));
                }
            }
            if (center) {
                Supplier<APoint2D> cSupplier = snapObj.getCenterSupplier();
                pts.add(Pt.fixed(cSupplier));
            }
            return AIterableItr.itr(pts);
        }

        protected SnapPoint(SnapObject snapObj, Pt pt) {
            this.mSnapObj = snapObj;
            this.mRelPt = pt;
        }

        public HierInst<DbObject> getDbObject() {
            return this.mSnapObj == null ? null : this.mSnapObj.getInst();
        }

        public AGeom getGeom() {
            return this.mSnapObj == null ? null : this.mSnapObj.getGeom();
        }

        public APoint2D getRelPt() {
            return this.mRelPt.getPt();
        }

        public boolean isFixed() {
            return this.mRelPt.isFixed();
        }

        public APoint2D getWorldPt() {
            return this.mRelPt.getPt().transform(this.getDbObject().getPathTransform());
        }

        public void updateDynamicSnap(APoint2D snapRef) {
            if (this.isFixed()) {
                return;
            }
            DevicePath dp = (DevicePath)this.getDbObject().first;
            snapRef = snapRef.transform(dp.getInverseTransform());
            this.mRelPt.dynUpdate(snapRef);
        }

        public SnapPoint copy() {
            return new SnapPoint(this.mSnapObj, this.mRelPt.copy());
        }

        private static /* synthetic */ APoint2D lambda$getPts$1(Supplier edgeSupplier, APoint2D refPt, boolean isLeft) {
            AGeom e = (AGeom)edgeSupplier.get();
            ALine line = e.distanceToPoint(refPt, true);
            return isLeft ? line.getP1() : line.getP0();
        }
    }

    public static class Pt {
        Supplier<APoint2D> mPt;
        Supplier<AGeom> mDynOn;

        public static Pt fixed(Supplier<APoint2D> pt) {
            return new Pt(pt, null);
        }

        public static Pt dynamic(Supplier<APoint2D> pt, Supplier<AGeom> dynOn) {
            return new Pt(pt, dynOn);
        }

        public Pt(Supplier<APoint2D> pt, Supplier<AGeom> dynOn) {
            this.mPt = pt;
            this.mDynOn = dynOn;
        }

        public APoint2D getPt() {
            return this.mPt.get();
        }

        public boolean isFixed() {
            return this.mDynOn == null;
        }

        public void dynUpdate(APoint2D refPt) {
            if (this.mDynOn == null || refPt == null) {
                return;
            }
            ALine l = this.mDynOn.get().distanceToPoint(refPt, true);
            boolean isLeft = l.getP0().equals((Object)refPt);
            this.mPt = () -> {
                ALine line = this.mDynOn.get().distanceToPoint(refPt, true);
                return isLeft ? line.getP1() : line.getP0();
            };
        }

        public Pt copy() {
            return new Pt(this.mPt, this.mDynOn);
        }
    }

    static class SnapObject {
        final HierInst<? extends DbObject> hdbo;

        SnapObject(HierInst<? extends DbObject> hdbo) {
            this.hdbo = hdbo;
        }

        AGeom getGeom() {
            if (this.hdbo.getDbObject() instanceof Device) {
                Device d = (Device)this.hdbo.getDbObject();
                return d.getTemplate().getBounds(true);
            }
            if (HierPortShape.class.isInstance(this.hdbo)) {
                HierPortShape hpshape = (HierPortShape)HierPortShape.class.cast(this.hdbo);
                LayerShape ls = hpshape.getLayerShape();
                PortTemplate portT = (PortTemplate)hpshape.getOwner();
                return ls.getGeom().transform(portT.getTransform());
            }
            assert (false);
            return null;
        }

        IterableIterator<? extends AGeom> getEdges() {
            AGeom g = this.getGeom();
            if (g instanceof ARect) {
                return g.toPoly().getSegments();
            }
            if (g instanceof APath) {
                return g.toPoly().getSegments();
            }
            if (g instanceof APolygon) {
                return ((APolygon)g).getSegments();
            }
            return ASingletonItr.create((Object)g);
        }

        HierInst<DbObject> getInst() {
            return HierInst.cast(this.hdbo);
        }

        public Supplier<APoint2D> getCenterSupplier() {
            return () -> this.getGeom().getBounds().center();
        }

        public IterableIterator<Supplier<AGeom>> getEdgeSuppliers() {
            long n = this.getEdges().count();
            LinkedList<Supplier<AGeom>> suppliers = new LinkedList<Supplier<AGeom>>();
            int i = 0;
            while ((long)i < n) {
                int index = i++;
                suppliers.add(() -> {
                    IterableIterator edges = this.getEdges().skip((long)index);
                    if (!edges.hasNext()) {
                        return null;
                    }
                    return (AGeom)edges.next();
                });
            }
            return AIterableItr.itr(suppliers);
        }
    }

    protected class CursorLoc {
        APoint2D mWorld;
        SnapPoint mSnapInitial = null;
        SnapPoint mSnapPreferred = null;
        boolean mForceInitialSnap = false;

        private CursorLoc(APoint2D world) {
            this.mWorld = world;
        }

        public CursorLoc(Point screenPt, CursorLoc snapReference) {
            HierInst<DbObject> refObj;
            this.mWorld = RulerMode.this.mView.getCanvas().getWorldPt(screenPt);
            if (RulerMode.this.mRuleMode == RULE_MODE.ORTHOGONAL && snapReference != null) {
                int q = this.mWorld.getQuadrant(snapReference.mWorld);
                this.mWorld = q == 0 || q == 2 ? new APoint2D(this.mWorld.getX(), snapReference.mWorld.getY()) : new APoint2D(snapReference.mWorld.getX(), this.mWorld.getY());
            }
            HierInst<DbObject> hierInst = refObj = snapReference == null || snapReference.getSnap() == null ? null : snapReference.getSnappedToObj();
            if (!RulerMode.this.getSnapAnyDeviceTypes() || !RulerMode.this.getSnapAnyLocTypes()) {
                return;
            }
            Db db = RulerMode.this.mView.getDb();
            Design design = Design.getDesign((Db)db, (boolean)false);
            if (design == null) {
                return;
            }
            SnapPoint bestPt = null;
            long bestDist = Long.MAX_VALUE;
            long snapDist = RulerMode.this.mView.getCanvas().getXForm().getWorldLength(RulerMode.this.mNearDistScreen);
            ViewColorizer visibility = RulerMode.this.mView.getColorizer();
            if (snapReference != null) {
                Supplier<AGeom> refDynOn = null;
                refDynOn = snapReference.mSnapInitial == null || snapReference.mSnapInitial.mRelPt == null ? null : snapReference.mSnapInitial.mRelPt.mDynOn;
                if (refDynOn != null && refDynOn.get() instanceof ACircle) {
                    ACircle c = (ACircle)refDynOn.get();
                    ALine l = new ALine(snapReference.mSnapInitial.mRelPt.getPt(), c.getC());
                    l.extendEnds(c.getR());
                    APoint2D oppositePtRel = l.getP1();
                    DevicePath dp = refObj.getPath();
                    APoint2D dpRelCursorPt = this.mWorld.transform(dp.getInverseTransform());
                    long dist = oppositePtRel.distance(dpRelCursorPt);
                    if (dist < snapDist) {
                        this.mSnapPreferred = new SnapPoint(new SnapObject(refObj), Pt.dynamic(() -> {
                            ACircle cc = (ACircle)snapReference.mSnapInitial.mRelPt.mDynOn.get();
                            APoint2D pt = snapReference.mSnapInitial.mRelPt.getPt();
                            ALine ll = new ALine(pt, cc.getC());
                            ll.extendEnds(cc.getR());
                            return ll.getP1();
                        }, refDynOn));
                        this.mSnapInitial = this.mSnapPreferred.copy();
                        this.mForceInitialSnap = true;
                        return;
                    }
                }
            }
            DeviceRegionMap.ObjectFilter filter = new DeviceRegionMap.ObjectFilter();
            filter.addDbClass(db.getDbClass(PortTemplate.class));
            filter.addDbClass(db.getDbClass(Device.class));
            for (HierInst hdbo : design.getObjectsNear(this.mWorld, snapDist, filter)) {
                APoint2D snapRef;
                DevicePath dp = hdbo.getPath();
                DbObject dbo = hdbo.getDbObject();
                LayerShape.Filter visibleShapeFilter = visibility.getVisibleShapesFilter(dp);
                APoint2D dpRelPt = this.mWorld.transform(dp.getInverseTransform());
                APoint2D aPoint2D = snapRef = snapReference == null || hdbo.equals(refObj) ? dpRelPt : snapReference.getSnapPref().transform(dp.getInverseTransform());
                if (RulerMode.this.mSnapPin.isSelected() && dbo instanceof PortTemplate) {
                    PortTemplate portT = (PortTemplate)dbo;
                    for (LayerShape ls : portT.getLayerShapesFiltered(visibleShapeFilter)) {
                        HierPortShape pshape = new HierPortShape(dp, portT, ls);
                        for (SnapPoint pt : RulerMode.this.getSnapPoints(new SnapObject((HierInst<? extends DbObject>)pshape), snapRef)) {
                            long curDist = pt.getRelPt().distance(dpRelPt);
                            if (curDist >= snapDist || curDist >= bestDist) continue;
                            bestDist = curDist;
                            bestPt = pt;
                        }
                    }
                    continue;
                }
                if (!RulerMode.this.mSnapDevice.isSelected() || !(dbo instanceof Device)) continue;
                for (SnapPoint pt : RulerMode.this.getSnapPoints(new SnapObject((HierInst<? extends DbObject>)hdbo), snapRef)) {
                    long curDist = pt.getRelPt().distance(dpRelPt);
                    if (curDist >= snapDist || curDist >= bestDist) continue;
                    bestDist = curDist;
                    bestPt = pt;
                }
            }
            if (bestPt != null) {
                this.mSnapPreferred = bestPt;
                if (this.mSnapPreferred.mRelPt != null && (RulerMode.this.mRuleMode == RULE_MODE.ORTHOGONAL || RulerMode.this.mRuleMode == RULE_MODE.MULTIPLE)) {
                    this.mSnapPreferred.mRelPt.mDynOn = null;
                }
                this.mSnapInitial = this.mSnapPreferred.copy();
            }
        }

        public boolean snappedToSameGeom(CursorLoc other) {
            if (this.mSnapPreferred == null || this.mSnapPreferred.getDbObject() == null || this.mSnapPreferred.getGeom() == null || other.mSnapPreferred == null || other.mSnapPreferred.getDbObject() == null || other.mSnapPreferred.getGeom() == null) {
                return false;
            }
            return this.mSnapPreferred.getDbObject().equals(other.mSnapPreferred.getDbObject()) && this.mSnapPreferred.getGeom().equals((Object)other.mSnapPreferred.getGeom());
        }

        public Point getScreen() {
            return RulerMode.this.mView.getCanvas().getXForm().getScreenPt(this.mWorld);
        }

        public APoint2D getWorld() {
            return this.mWorld;
        }

        public APoint2D getSnap() {
            return this.mForceInitialSnap ? this.getSnapInit() : this.getSnapPref();
        }

        public Point getSnapScreen() {
            return this.mForceInitialSnap ? this.getSnapInitScreen() : this.getSnapPrefScreen();
        }

        public APoint2D getSnapPref() {
            return this.mSnapPreferred == null ? this.mWorld : this.mSnapPreferred.getWorldPt();
        }

        public Point getSnapPrefScreen() {
            return RulerMode.this.mView.getCanvas().getXForm().getScreenPt(this.getSnapPref());
        }

        public APoint2D getSnapInit() {
            return this.mSnapInitial == null ? this.mWorld : this.mSnapInitial.getWorldPt();
        }

        public Point getSnapInitScreen() {
            return RulerMode.this.mView.getCanvas().getXForm().getScreenPt(this.getSnapInit());
        }

        public HierInst<DbObject> getSnappedToObj() {
            return this.mSnapPreferred == null ? null : this.mSnapPreferred.getDbObject();
        }

        public boolean isSnapped() {
            return this.mForceInitialSnap ? this.mSnapInitial != null : this.mSnapPreferred != null;
        }
    }

    private class CrossRuler
    implements Ruler {
        protected final CursorLoc mOrigin;

        CrossRuler(CursorLoc origin) {
            this.mOrigin = origin;
        }

        @Override
        public void update() {
        }

        @Override
        public void paint(Graphics2D g) {
            if (RulerMode.this.mView != OrbitIO.getCurView()) {
                return;
            }
            LinkedList<SingleRuler> list = new LinkedList<SingleRuler>();
            ARect visibleWorld = RulerMode.this.mView.getCanvas().getVisibleBounds();
            APoint2D worldOrigin = this.mOrigin.getSnap();
            CursorLoc far = new CursorLoc(new APoint2D(worldOrigin.getX(), visibleWorld.top())){

                @Override
                public boolean isSnapped() {
                    return true;
                }
            };
            SingleRuler s = new SingleRuler(this.mOrigin, far);
            s.mShowOrigin = true;
            list.add(s);
            far = new CursorLoc(new APoint2D(visibleWorld.right(), worldOrigin.getY())){

                @Override
                public boolean isSnapped() {
                    return true;
                }
            };
            s = new SingleRuler(this.mOrigin, far);
            s.mShowOrigin = false;
            list.add(s);
            far = new CursorLoc(new APoint2D(worldOrigin.getX(), visibleWorld.bottom())){

                @Override
                public boolean isSnapped() {
                    return true;
                }
            };
            s = new SingleRuler(this.mOrigin, far);
            s.mShowOrigin = false;
            list.add(s);
            far = new CursorLoc(new APoint2D(visibleWorld.left(), worldOrigin.getY())){

                @Override
                public boolean isSnapped() {
                    return true;
                }
            };
            s = new SingleRuler(this.mOrigin, far);
            s.mShowOrigin = false;
            list.add(s);
            boolean highlight = this == RulerMode.this.mFocusRuler;
            for (Ruler ruler : list) {
                if (highlight) {
                    RulerMode.this.mFocusRuler = ruler;
                }
                ruler.paint(g);
            }
            if (highlight) {
                RulerMode.this.mFocusRuler = this;
            }
        }
    }

    private class ContinuousRuler
    implements Ruler {
        protected final List<CursorLoc> mPts;
        protected List<Ruler> mSubRulers;
        protected long mDistance;

        ContinuousRuler(List<CursorLoc> pts) {
            this.mPts = new ArrayList<CursorLoc>(pts);
            this.update();
        }

        @Override
        public void update() {
            int n = this.mPts.size();
            this.mSubRulers = new LinkedList<Ruler>();
            this.mDistance = 0L;
            for (int i = 1; i < n; ++i) {
                this.mDistance += this.mPts.get(i - 1).getSnap().distance(this.mPts.get(i).getSnap());
                SingleRuler s = new SingleRuler(this.mPts.get(i - 1), this.mPts.get(i));
                if (i > 1) {
                    s.mShowOrigin = false;
                }
                this.mSubRulers.add(s);
            }
        }

        @Override
        public void paint(Graphics2D g) {
            Unit unit;
            double dist;
            double majorTick;
            double minorTick;
            if (RulerMode.this.mView != OrbitIO.getCurView() || this.mPts.isEmpty()) {
                return;
            }
            boolean highlight = this == RulerMode.this.mFocusRuler;
            for (Ruler r : this.mSubRulers) {
                if (highlight) {
                    RulerMode.this.mFocusRuler = r;
                }
                r.paint(g);
            }
            if (highlight) {
                RulerMode.this.mFocusRuler = this;
            }
            if ((minorTick = (majorTick = Math.pow(10.0, Math.floor(Math.log10(dist = (unit = RulerMode.this.mView.getUnit()).toUser(this.mDistance))))) / 10.0) == 0.0) {
                return;
            }
            while (minorTick < 2.0) {
                minorTick *= 10.0;
                majorTick *= 10.0;
            }
            g = (Graphics2D)g.create();
            Point start = this.mPts.get(this.mPts.size() - 2).getSnapScreen();
            Point end = this.mPts.get(this.mPts.size() - 1).getSnapScreen();
            double nX = end.x - start.x;
            double nY = end.y - start.y;
            double scrLen = Math.hypot(nX, nY);
            nX /= scrLen;
            nY /= scrLen;
            double scrNx = end.y - start.y;
            double scrNy = start.x - end.x;
            scrLen = Math.hypot(scrNx, scrNy);
            g.setColor(COLOR_ORTHO);
            g.drawString("total=" + unit.toUserStr(this.mDistance), (int)((double)end.x + (scrNx /= scrLen) * 40.0 + nX * 20.0), (int)((double)end.y + (scrNy /= scrLen) * 40.0 + nY * 20.0));
        }
    }

    private class CircleRuler
    extends SingleRuler {
        CircleRuler(CursorLoc start, CursorLoc end) {
            super(start, end);
        }

        @Override
        public void paint(Graphics2D g) {
            Color primary;
            APoint2D worldEnd;
            super.paint(g);
            if (RulerMode.this.mView != OrbitIO.getCurView()) {
                return;
            }
            long distance = this.mStart.getSnap().distance(this.mEnd.getSnap());
            DesignCanvas2D.XForm xform = RulerMode.this.mView.getCanvas().getXForm();
            g = (Graphics2D)g.create();
            double scrDiameter = xform.getScreenLength(distance);
            APoint2D worldStart = this.mStart.getSnap();
            double angle = worldStart.getAngleRadians(worldEnd = this.mEnd.getSnap());
            boolean ortho = angle * 2.0 % Math.PI == 0.0;
            Color color = primary = ortho ? COLOR_ORTHO : COLOR_ANY;
            if (this == RulerMode.this.mFocusRuler) {
                primary = COLOR_HIGHLIGHT;
            }
            APoint2D ul = new APoint2D(worldStart.getX() - distance, worldStart.getY() + distance);
            Point start = xform.getScreenPt(ul);
            Ellipse2D.Double shape = new Ellipse2D.Double(start.getX(), start.getY(), scrDiameter * 2.0, scrDiameter * 2.0);
            g.setColor(primary);
            g.draw(shape);
        }
    }

    private class SingleRuler
    implements Ruler {
        protected final CursorLoc mStart;
        protected final CursorLoc mEnd;
        protected boolean mShowOrigin = true;

        SingleRuler(CursorLoc start, CursorLoc end) {
            this.mStart = start;
            this.mEnd = end;
        }

        @Override
        public void update() {
            if (this.mStart.mSnapPreferred != null) {
                this.mStart.mSnapPreferred.updateDynamicSnap(this.mEnd.getSnap());
            }
            if (this.mStart.mSnapInitial != null) {
                this.mStart.mSnapInitial.updateDynamicSnap(this.mEnd.getSnap());
            }
        }

        @Override
        public void paint(Graphics2D g) {
            Color primary;
            APoint2D worldEnd;
            if (RulerMode.this.mView != OrbitIO.getCurView()) {
                return;
            }
            long distance = this.mStart.getSnap().distance(this.mEnd.getSnap());
            DesignCanvas2D.XForm xform = RulerMode.this.mView.getCanvas().getXForm();
            Unit unit = RulerMode.this.mView.getUnit();
            double dist = unit.toUser(distance);
            double majorTick = Math.pow(10.0, Math.floor(Math.log10(dist)));
            double minorTick = majorTick / 10.0;
            if (minorTick == 0.0) {
                return;
            }
            while (minorTick < 2.0) {
                minorTick *= 10.0;
                majorTick *= 10.0;
            }
            g = (Graphics2D)g.create();
            Point start = this.mStart.getSnapScreen();
            Point end = this.mEnd.getSnapScreen();
            APoint2D worldStart = this.mStart.getSnap();
            double angle = worldStart.getAngleRadians(worldEnd = this.mEnd.getSnap());
            boolean ortho = angle * 2.0 % Math.PI == 0.0 || worldStart.getX() == worldEnd.getX() || worldStart.getY() == worldEnd.getY();
            Color color = primary = ortho ? COLOR_ORTHO : COLOR_ANY;
            if (this == RulerMode.this.mFocusRuler) {
                primary = COLOR_HIGHLIGHT;
            }
            double nX = Math.cos(angle + 1.5707963267948966);
            double nY = Math.sin(angle + 1.5707963267948966);
            boolean snapped = this.mStart.isSnapped() && this.mEnd.isSnapped();
            BasicStroke centerStroke = snapped ? RulerMode.this.stroke1 : RulerMode.this.stroke1Dash;
            g.setStroke(centerStroke);
            g.setColor(primary);
            g.drawLine(start.x, start.y, end.x, end.y);
            long dbMajorExt = xform.getWorldLength(10);
            long dbMinorGap = unit.fromUser(minorTick);
            long dbMinorExt = xform.getWorldLength(6);
            if (dbMinorGap == 0L) {
                return;
            }
            long count = distance / dbMinorGap;
            double scrNx = end.y - start.y;
            double scrNy = start.x - end.x;
            double scrLen = Math.hypot(scrNx, scrNy);
            scrNx /= scrLen;
            scrNy /= scrLen;
            if (this.mShowOrigin) {
                g.drawString("0", (int)((double)start.x + scrNx * 20.0), (int)((double)start.y + scrNy * 20.0));
            }
            g.drawString(unit.toUserStr(distance), (int)((double)end.x + scrNx * 20.0), (int)((double)end.y + scrNy * 20.0));
            ALine l = new ALine(worldStart, worldEnd);
            for (long i = 0L; i <= count; ++i) {
                APoint2D t0 = l.fromP1(i * dbMinorGap);
                long d = dbMinorExt;
                if (i % 5L == 0L) {
                    d = dbMajorExt;
                }
                APoint2D t1 = t0.add((long)(nX * (double)d), (long)(nY * (double)d));
                Point p0 = xform.getScreenPt(t0);
                Point p1 = xform.getScreenPt(t1);
                g.drawLine(p0.x, p0.y, p1.x, p1.y);
                if ((i != 10L || count <= 15L) && (i != 50L || count <= 65L)) continue;
                g.drawString(unit.toUserStr(i * dbMinorGap), (int)((double)p0.x + scrNx * 20.0), (int)((double)p0.y + scrNy * 20.0));
            }
        }
    }

    public static class ActionChangeHighlightColor
    extends AbstractAction {
        public ActionChangeHighlightColor() {
            super("Change Highlight Color");
            this.putValue("ShortDescription", "Default ruler color in highlight status");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AColorChooserDlg dlg = AColorChooserDlg.createDialog((Component)OrbitIO.getMainWindow(), "Ruler Highlight Color", COLOR_HIGHLIGHT);
            Color newColor = dlg.doModal();
            if (newColor != null) {
                COLOR_HIGHLIGHT = newColor;
                if (e.getSource() instanceof JButton) {
                    JButton btn = (JButton)e.getSource();
                    btn.setIcon((Icon)new AColorIcon(16, 16, COLOR_HIGHLIGHT));
                    btn.repaint();
                }
            }
        }
    }

    public static class ActionChangeOrthoColor
    extends AbstractAction {
        public ActionChangeOrthoColor() {
            super("Change Orthogonal Color");
            this.putValue("ShortDescription", "Default ruler color in orthogonal status");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AColorChooserDlg dlg = AColorChooserDlg.createDialog((Component)OrbitIO.getMainWindow(), "Ruler Orthogonal Color", COLOR_ORTHO);
            Color newColor = dlg.doModal();
            if (newColor != null) {
                COLOR_ORTHO = newColor;
                if (e.getSource() instanceof JButton) {
                    JButton btn = (JButton)e.getSource();
                    btn.setIcon((Icon)new AColorIcon(16, 16, COLOR_ORTHO));
                    btn.repaint();
                }
            }
        }
    }

    public static class ActionChangeColor
    extends AbstractAction {
        public ActionChangeColor() {
            super("Change Color");
            this.putValue("ShortDescription", "Default ruler color");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AColorChooserDlg dlg = AColorChooserDlg.createDialog((Component)OrbitIO.getMainWindow(), "Ruler Color", COLOR_ANY);
            Color newColor = dlg.doModal();
            if (newColor != null) {
                COLOR_ANY = newColor;
                if (e.getSource() instanceof JButton) {
                    JButton btn = (JButton)e.getSource();
                    btn.setIcon((Icon)new AColorIcon(16, 16, COLOR_ANY));
                    btn.repaint();
                }
            }
        }
    }

    public static class ActionRemoveLastRuler
    extends AbstractAction {
        public ActionRemoveLastRuler() {
            super("Remove Last Ruler");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RulerMode.removeLastRuler();
        }
    }

    public static class ActionClearRulers
    extends AbstractAction {
        public ActionClearRulers() {
            super("Clear Ruler", UIManager.getIcon("CDNS.rulerClearAllIcon"));
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("Clear Ruler"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RulerMode.resetRulers();
        }
    }

    static enum RULE_MODE {
        SINGLE,
        ORTHOGONAL,
        MULTIPLE,
        CROSS,
        CIRCLE;

    }

    public static interface Ruler {
        public void update();

        public void paint(Graphics2D var1);
    }

    public static interface SubMode {
        public List<Component> getContextMenu(Point var1);
    }
}

