/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_modes;

import com.sigrity.acl.AColor;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.LinkedList;

public class SpotLight {
    public static final Color DIM_OVERLAY_COLOR = AColor.withAlpha((Color)Color.BLACK, (int)192);
    protected AGeom mDark = null;
    protected LinkedList<AGeom> mLight = new LinkedList();
    protected DesignCanvas2D.XForm mLastXForm = null;
    protected Area mLastArea = null;

    public static void spotlight(Graphics2D g, Area area) {
        Color oldColor = g.getColor();
        g.setColor(DIM_OVERLAY_COLOR);
        g.fill(area);
        g.setColor(oldColor);
    }

    public static void spotlight(Graphics2D g, ARect dark, AGeom light, DesignCanvas2D.XForm xform) {
        Rectangle d = xform.getScreenRect(dark);
        Area area = new Area(d);
        if (light != null) {
            Area area1 = new Area(xform.getScreenShape(light));
            area.subtract(area1);
        }
        SpotLight.spotlight(g, area);
    }

    public SpotLight() {
        this(null);
    }

    public SpotLight(AGeom dark) {
        this.mDark = dark;
    }

    public void addLight(AGeom geom) {
        this.mLight.add(geom);
        this.mLastXForm = null;
    }

    public void draw(DesignCanvas2D.XForm xform, Graphics2D g) {
        if (this.mLastXForm == null || !this.mLastXForm.equals(xform)) {
            this.mLastXForm = xform;
            AGeom dark = this.mDark != null ? this.mDark : this.mLastXForm.getWorld();
            this.mLastArea = new Area(this.mLastXForm.getScreenShape(dark));
            for (AGeom geom : this.mLight) {
                this.mLastArea.subtract(new Area(this.mLastXForm.getScreenShape(geom)));
            }
        }
        SpotLight.spotlight(g, this.mLastArea);
    }
}

