/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_views;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Dimensions;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.db.std.Scribe;
import com.sigrity.acl.db.std.SealRing;
import com.sigrity.acl.db.std.SiliconRemainder;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.acl.db.std.Text;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomWithCutouts;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.geom.AVector;
import com.sigrity.acl.topology.Binner;
import com.sigrity.acl.topology.SpatialIndex2D;
import com.sigrity.acl.ui.ADraw2D;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPinHull;
import com.sigrity.orbit.HierPinT;
import com.sigrity.orbit.HierShape;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitIOSettings;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.ui.DeviceDimensionUI;
import com.sigrity.orbit.ui.OrbitFonts;
import com.sigrity.orbit.ui.PersonalityMappingMgmt;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.wb_route.RouteQueue;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultDeviceDrawer
implements DefaultViewDrawer.DeviceDrawer {
    static final int MAX_INDICATOR_SIZE_PIXELS = 300;
    static final int MAX_FONT_SIZE = 128;
    static final int MIN_FONT_SIZE = 8;
    static final int MIN_TRUNCATED_NAME_LEN = 3;
    static final String TRUNCATED_NAME_INDICATOR = "...";
    static final AColor COLOR_XAXIS = new AColor(255, 0, 0, 127);
    static final AColor COLOR_YAXIS = new AColor(0, 255, 0, 127);
    public static final double TEXTZOOMFACTOR = 1.0;
    protected final DefaultViewDrawer mViewDrawer;
    protected final DefaultViewDrawer.DrawContext mDrawContext;
    protected final DevicePath mPath;
    protected final Device mDevice;
    protected AffineTransform mTransform;
    protected DrawSettings mSettings;
    protected ARect mLocalWorldBound;
    protected final Selection.SelSet mBeingMoved;
    protected Graphics2D mGraphics;

    public DefaultDeviceDrawer(DefaultViewDrawer viewDrawer, DesignCanvas2D canvas, DevicePath path, AffineTransform inheritedXform, DefaultViewDrawer.DrawContext drawContext) {
        DesignView2D v;
        this.mViewDrawer = viewDrawer;
        this.mDrawContext = drawContext != null ? drawContext : new DefaultViewDrawer.DrawContext(canvas);
        this.mPath = path;
        Device device = this.mDevice = path == null ? null : path.getLast();
        if (inheritedXform == null || this.mPath == null) {
            this.mTransform = new AffineTransform();
        } else {
            this.mTransform = new AffineTransform(inheritedXform);
            this.mTransform.concatenate(this.mPath.getLast().getLocalTransformMatrix());
        }
        this.mSettings = this.mDrawContext.get(DrawSettings.class, DrawSettings.class, DrawSettings::new);
        if (this.mDrawContext.worldDrawBounds != null) {
            this.loadLocalWorldBound();
        }
        this.mBeingMoved = (v = (DesignView2D)UIUtil.getAncestorOfType((Component)this.mDrawContext.canvas, DesignView2D.class)) == null ? null : v.getBeingMoved().getDynamicDrawingSet();
    }

    private void loadLocalWorldBound() {
        try {
            AffineTransform t = this.mTransform.createInverse();
            this.mLocalWorldBound = this.mDrawContext.worldDrawBounds.transform(t).getBounds();
        }
        catch (NoninvertibleTransformException e) {
            ALog.logError((Throwable)e);
        }
    }

    @Override
    public void setGraphics(Graphics2D g) {
        this.mGraphics = g;
    }

    @Override
    public void drawPin(PinInstance pin, boolean cursorDraw) {
        this.drawPinInst(pin, cursorDraw, false);
    }

    @Override
    public void drawWire(Wire wire, boolean cursorDraw) {
        this.drawWire(this.mGraphics, wire, null, false);
    }

    private void drawRough(AGeom worldGeom, Color c, Graphics2D g) {
        g = (Graphics2D)g.create();
        g.setColor((Color)AColor.withAlpha((Color)c, (int)128));
        DesignCanvas2D.drawGeom(g, this.mDrawContext.screenTransform, worldGeom, new AffineTransform(), c, true);
    }

    @Override
    public void draw(boolean cursorDraw) {
        ARect deviceExtent;
        if (!cursorDraw && this.mBeingMoved != null && this.mBeingMoved.contains(this.mPath, (DbObject)this.mPath.getLast())) {
            return;
        }
        if (this.mDevice == null || this.mDevice.getTemplate() == null) {
            return;
        }
        ARect devTExtent = this.mDevice.getTemplate().getExtent();
        ARect aRect = deviceExtent = devTExtent == null ? null : devTExtent.transform(this.mTransform).getBounds();
        if (deviceExtent == null) {
            assert (false);
            return;
        }
        boolean select = this.isSelected(this.mPath.getParent(), (DbObject)this.mDevice);
        Graphics2D g = this.getDrawGraphics(select);
        this.drawDevice(g, cursorDraw, deviceExtent, select);
    }

    protected void drawDevice(Graphics2D g, boolean cursorDraw, ARect deviceBB, boolean select) {
        Rectangle scribeScreenBounds;
        APatternColor colorDevice = this.mDrawContext.colorizer.getColor(this.mPath);
        if (colorDevice == null) {
            return;
        }
        if (this.isDeviceBump() && !this.isBumpVisible()) {
            return;
        }
        AGeom deviceShape = this.getDeviceShape();
        AGeom extentShape = this.getExtentShape();
        Shape screenShape = this.getScreenShape(deviceShape);
        Shape scribeScreenShape = this.getScreenShape(extentShape);
        Rectangle screenBounds = screenShape == null ? null : screenShape.getBounds();
        Rectangle rectangle = scribeScreenBounds = scribeScreenShape == null ? null : scribeScreenShape.getBounds();
        if (screenShape != null && screenBounds.getHeight() > 0.0 && screenBounds.getWidth() > 0.0) {
            this.drawDeviceBackground(g, colorDevice, screenShape, deviceBB, select);
        }
        this.drawLayerShapes();
        this.drawTexts(screenBounds);
        this.drawDimensions(screenBounds);
        if (this.mDrawContext.isSubstrateVisible(this.mDevice.getSubstrate())) {
            this.drawMetals();
            this.drawObstacles();
            this.drawPins();
            this.drawWires();
            this.drawBundles();
        }
        this.drawSchedConns();
        this.drawPersonalityAreas(g);
        this.drawGrid();
        this.drawTerm(screenBounds);
        if (screenBounds != null && (screenBounds.width < 1 || screenBounds.height < 1)) {
            screenBounds = null;
        }
        if (screenBounds != null) {
            if (scribeScreenBounds != null) {
                this.drawBackgroundOutline(g, scribeScreenBounds, scribeScreenShape, false);
            }
            this.drawBackgroundOutline(g, screenBounds, screenShape, select);
            this.drawSymmetryLines(g, screenBounds, screenShape, select);
        }
        this.drawChildren(cursorDraw);
        if (screenBounds != null) {
            Point screenOrigin = this.drawOriginIndicator(g, screenBounds, null);
            this.drawPositionIndicator(g, screenBounds, screenOrigin);
            this.drawNameAndAttributes(g, screenBounds);
        }
        this.drawForegroundOutline(g, screenShape, select);
    }

    protected AGeom getDeviceShape() {
        AGeom deviceShape = this.mDevice.getUntransformedShape();
        if (deviceShape != null && this.mTransform != null) {
            deviceShape = deviceShape.transform(this.mTransform);
        }
        return deviceShape;
    }

    protected AGeom getExtentShape() {
        if (this.mDevice.getTemplate() == null) {
            return null;
        }
        Scribe scribe = this.mDevice.getTemplate().getScribe();
        SealRing ring = this.mDevice.getTemplate().getSealRing();
        SiliconRemainder remainder = this.mDevice.getTemplate().getSiliconRemainder();
        if (scribe == null && ring == null && remainder == null) {
            return null;
        }
        AGeom deviceShape = this.mDevice.getUntransformedShape();
        if (deviceShape != null && this.mTransform != null) {
            if (deviceShape instanceof ARect) {
                ARect rect = (ARect)deviceShape.copy();
                if (scribe != null) {
                    rect.expandBy(scribe.getWest(), scribe.getSouth(), scribe.getEast(), scribe.getNorth());
                }
                if (ring != null) {
                    rect.expandBy(ring.getWest(), ring.getSouth(), ring.getEast(), ring.getNorth());
                }
                if (remainder != null) {
                    rect.expandBy(remainder.getWest(), remainder.getSouth(), remainder.getEast(), remainder.getNorth());
                }
                deviceShape = rect.toPoly();
            }
            deviceShape = deviceShape.transform(this.mTransform);
        }
        return deviceShape;
    }

    protected Shape getScreenShape(AGeom shape) {
        return this.mDrawContext.screenTransform.getScreenShape(shape);
    }

    protected void drawSymmetryLines(Graphics2D g, Rectangle screenBounds, Shape screenShape, boolean select) {
        try {
            APatternColor colorOrigin = this.mDrawContext.colorizer.getSymLineColor(this.mPath);
            if (colorOrigin != null) {
                g.setColor(colorOrigin.getColor());
                int ulX = screenShape.getBounds().x;
                int ulY = screenShape.getBounds().y;
                int height = screenShape.getBounds().height;
                int width = screenShape.getBounds().width;
                int midX = ulX + width / 2;
                int midY = ulY + height;
                Line2D.Double l = new Line2D.Double(midX, ulY, midX, midY);
                g.draw(l);
                midX = ulX + width;
                midY = ulY + height / 2;
                l = new Line2D.Double(ulX, midY, midX, midY);
                g.draw(l);
                if (this.mPath.getBB().height() == this.mPath.getBB().width()) {
                    midX = ulX + width;
                    midY = ulY + height;
                    l = new Line2D.Double(ulX, midY, midX, ulY);
                    g.draw(l);
                    l = new Line2D.Double(ulX, ulY, midX, midY);
                    g.draw(l);
                }
            }
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"An error occured drawing symmetry lines for '%s'.", (Object[])new Object[]{this.mPath.getString()});
        }
    }

    protected void drawNameAndAttributes(Graphics2D g, Rectangle screenBounds) {
        int numRows = 0;
        if (this.mDrawContext.colorizer.getShowTextualTransfom()) {
            ++numRows;
        }
        if (this.mDrawContext.colorizer.getShowDeviceNames()) {
            ++numRows;
        }
        if (numRows == 0) {
            return;
        }
        Rectangle textBox = new Rectangle(screenBounds);
        if (this.mDrawContext.colorizer.getUseClassicTheme()) {
            g.setFont(OrbitFonts.WORK_SANS_THIN);
            g.setColor(new Color(255, 255, 255, 200));
            textBox = this.getScreenShape(this.getDeviceShape()).getBounds();
        }
        int h = textBox.height;
        h = h / numRows - 1;
        if (this.mDrawContext.colorizer.getShowDeviceNames() && this.mDevice.getType() != DeviceTemplate.Type.PERSONALITY) {
            textBox.height = h;
            this.drawName(g, textBox);
            textBox.y += h + 1;
        }
        this.drawDefXformName(g, textBox);
    }

    protected void drawDefXformName(Graphics2D g, Rectangle screenBounds) {
        if (!this.mDrawContext.colorizer.getShowTextualTransfom()) {
            return;
        }
        if (screenBounds.width < 12 || screenBounds.height < 12) {
            return;
        }
        DevicePath parentPath = this.mPath.getParent();
        DevicePath dp = parentPath.pathToSubstrate();
        if (dp == null || dp.isEmpty()) {
            return;
        }
        DevicePath mySubstratePath = this.mPath.getRelativePathFromAnchor(dp.getLast().getTemplate());
        if (mySubstratePath == null || mySubstratePath.isEmpty()) {
            return;
        }
        float rot = mySubstratePath.getRot();
        boolean mirror = mySubstratePath.getMirror();
        DeviceTemplate.DefTransform devOrient = IOView.createOrientForOrbit(rot, mirror);
        String rotString = devOrient.name();
        Rectangle orientRect = null;
        int w = screenBounds.width;
        int h = screenBounds.height;
        orientRect = new Rectangle(screenBounds.x + w / 4, screenBounds.y + h / 4, w / 4, h / 2);
        g.setColor(Color.WHITE);
        this.drawName(g, rotString, orientRect);
    }

    protected Rectangle drawName(Graphics2D g, Rectangle screenBounds) {
        if (!this.mDrawContext.colorizer.getShowDeviceNames()) {
            return null;
        }
        if (screenBounds.width <= 12 || screenBounds.height <= 12) {
            return null;
        }
        String name = this.mDevice.getName();
        if (name != null) {
            if (this.mDevice.isOnBottomSide()) {
                name = AUtil.reverse((String)name);
            }
            if (!this.mDrawContext.mInnovusTheme) {
                return this.drawName(g, name, screenBounds);
            }
            g.setFont(g.getFont().deriveFont(16.0f));
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout tl = new TextLayout(name, g.getFont(), frc);
            Rectangle textBounds = tl.getPixelBounds(frc, 0.0f, 0.0f);
            if (screenBounds.getWidth() < textBounds.getWidth()) {
                return null;
            }
            g = (Graphics2D)g.create();
            g.setColor((Color)AColor.getComplementary((Color)this.mDrawContext.colorizer.getColor(null, (ViewColorizer.Key)ViewColorizer.KDesignCanvas).getColor()));
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setStroke(new BasicStroke(2.0f));
            Point loc = new Point((int)screenBounds.getMinX() + textBounds.x + 2, (int)screenBounds.getMaxY() - textBounds.height - textBounds.y);
            g.drawString(name, loc.x, loc.y);
        }
        return null;
    }

    protected void drawForegroundOutline(Graphics2D g, Shape screenShape, boolean select) {
        if (select && screenShape != null) {
            g = (Graphics2D)g.create();
            g.setStroke(DefaultViewDrawer.DASHED);
            g.setColor(Color.WHITE);
            g.draw(screenShape);
        }
    }

    protected void drawBackgroundOutline(Graphics2D g, Rectangle screenBounds, Shape screenShape, boolean select) {
        Object drawColor;
        boolean outline;
        if (select) {
            return;
        }
        boolean bl = outline = !this.isDeviceInterface() && !this.isDeviceGroup() && screenBounds.width > 3 && screenBounds.height > 3;
        if (!outline) {
            return;
        }
        g = (Graphics2D)g.create();
        if (this.isDeviceBump()) {
            g.setStroke(DefaultViewDrawer.DASHED);
            drawColor = AColor.withAlpha((Color)Color.BLACK, (int)32);
        } else if (this.mDrawContext.colorizer.getUseClassicTheme()) {
            APatternColor c = this.mDrawContext.colorizer.getColor(this.mPath);
            drawColor = AColor.withAlpha((Color)c.getColor(), (int)255);
        } else {
            drawColor = Color.BLACK;
        }
        g.setColor((Color)drawColor);
        g.draw(screenShape);
    }

    protected void drawPositionIndicator(Graphics2D g, Rectangle screenBounds, Point screenOrigin) {
        if (!this.mDrawContext.colorizer.getShowRotationIndicators()) {
            return;
        }
        if (screenBounds.width < 24 || screenBounds.height < 24) {
            return;
        }
        if (screenOrigin == null) {
            screenOrigin = this.getScreenOrigin();
        }
        ARect templBounds = this.mDevice.getTemplate().getBB();
        Rectangle scrTmplBB = this.mDrawContext.screenTransform.getScreenRect(templBounds);
        int dx = scrTmplBB.width / 12;
        int dy = scrTmplBB.height / 12;
        int lineWidth = Math.max(1, (dx + dy) / 24);
        int headSize = Math.max(2, (dx + dy) / 8);
        AffineTransform oldTransform = g.getTransform();
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(lineWidth, 1, 1));
        AffineTransform t = AffineTransform.getTranslateInstance(screenOrigin.x, screenOrigin.y);
        t.concatenate(ATransformUtil.createTransform((double)0.0, (double)0.0, (float)this.mPath.getRot(), (boolean)this.mPath.getMirror()));
        t.preConcatenate(oldTransform);
        g.setTransform(t);
        g.setColor((Color)COLOR_XAXIS);
        ADraw2D.drawArrow(g, 0, 0, dx, 0, headSize);
        g.setColor((Color)COLOR_YAXIS);
        ADraw2D.drawArrow(g, 0, 0, 0, 0 - dy, headSize);
        g.setStroke(oldStroke);
        g.setTransform(oldTransform);
    }

    protected Point drawOriginIndicator(Graphics2D g, Rectangle screenBounds, Point screenOrigin) {
        APatternColor colorOrigin = this.mDrawContext.colorizer.getOriginColor(this.mPath);
        if (colorOrigin != null && screenBounds.width > 6 && screenBounds.height > 6) {
            if (screenOrigin == null) {
                screenOrigin = this.getScreenOrigin();
            }
            g.setColor(colorOrigin.getColor());
            g.drawLine(screenOrigin.x - 2, screenOrigin.y, screenOrigin.x + 2, screenOrigin.y);
            g.drawLine(screenOrigin.x, screenOrigin.y - 2, screenOrigin.x, screenOrigin.y + 2);
        }
        return screenOrigin;
    }

    protected void drawDeviceBackground(Graphics2D g, APatternColor color, Shape screenShape, ARect deviceBB, boolean select) {
        boolean fill;
        if (this.isDeviceGroup()) {
            return;
        }
        if (select && this.mDrawContext.colorizer.getUseSelectionColors()) {
            Color startColor = color.getColor();
            Color endColor = Color.WHITE;
            if (!this.isSelected(this.mPath.getParent(), (DbObject)this.mDevice)) {
                Color t = endColor;
                endColor = startColor;
                startColor = t;
            }
            Rectangle screenBB = screenShape.getBounds();
            GradientPaint gradient = new GradientPaint(screenBB.x, screenBB.y, startColor, (float)screenBB.x + (float)screenBB.width / 2.0f, (float)screenBB.y + (float)screenBB.height / 2.0f, endColor, true);
            g.setPaint(gradient);
        } else {
            g.setPaint(color.getPaint());
        }
        boolean bl = fill = !this.isDeviceInterface();
        if (fill && this.isDeviceBump() && !select) {
            fill = false;
        }
        if (this.mDrawContext.colorizer.getUseClassicTheme()) {
            Color c = g.getColor();
            g.setPaint(APatternColor.copy((Color)new Color(c.getRed(), c.getGreen(), c.getBlue(), 64), (APatternColor)color).getPaint());
        }
        if (this.mDrawContext.colorizer.getHollowDevices()) {
            fill = false;
        }
        if (fill) {
            g.fill(screenShape);
        } else {
            g.draw(screenShape);
        }
        if (this.mDevice.getIsFixed() && this.mDrawContext.colorizer.getShowFixedMarkers()) {
            this.drawFixedSymbol(g, deviceBB);
        }
        if (this.mDevice.getSynthesized() && this.mDrawContext.colorizer.getShowSynthMarkers()) {
            this.drawSynthesizedSymbol(g, deviceBB);
        }
    }

    public void drawChildren(boolean cursorDraw) {
        assert (this.mDevice != null);
        if (this.mViewDrawer == null) {
            return;
        }
        APair<List<Device>, List<AGeom>> deviceInView = this.getChildren();
        List children = (List)deviceInView.getFirst();
        DefaultViewDrawer.sortDrawDevices(children);
        APatternColor roughDeviceColor = this.mDrawContext.colorizer.findColor(this.mPath, (ViewColorizer.Key)ViewColorizer.KDevice);
        if (roughDeviceColor != null) {
            for (AGeom roughGeom : (List)deviceInView.second) {
                roughGeom = roughGeom.getBounds().transform(this.mTransform).getBounds();
                this.drawRough(roughGeom, roughDeviceColor.getColor(), this.getDrawGraphics(false));
            }
        }
        if (children.isEmpty()) {
            return;
        }
        DevicePath childPath = new DevicePath(this.mPath, (Device)children.get(0));
        for (Device child : children) {
            childPath.removeLast();
            childPath.add(child);
            DefaultViewDrawer.DeviceDrawer drawer = this.mViewDrawer.getDeviceDrawer(childPath, this.mTransform, this.mDrawContext);
            if (drawer == null) continue;
            if (this.mGraphics != null) {
                drawer.setGraphics(this.mGraphics);
            }
            try {
                drawer.draw(cursorDraw);
            }
            catch (Exception e) {
                ALog.logWarn((Throwable)e, (String)"Internal error drawing device '%s', display may be inaccurate.", (Object[])new Object[]{childPath.escapedString()});
            }
        }
    }

    private APair<List<Device>, List<AGeom>> getChildren() {
        if (this.mLocalWorldBound == null) {
            return new APair((Object)AUtil.arrayList((Iterator)this.mDevice.getChildren()), Collections.emptyList());
        }
        return this.getChildrenInView();
    }

    private APair<List<Device>, List<AGeom>> getChildrenInView() {
        ArrayList<Device> devices = new ArrayList<Device>();
        ArrayList ignoredGeom = new ArrayList();
        SpatialIndex2D deviceIndex = this.mDevice.getChildSpatialIndex();
        for (Device child : deviceIndex.intersects(this.mLocalWorldBound, rect -> {
            if (!this.mDrawContext.isSmallerThanMinDrawSize(rect.width()) || !this.mDrawContext.isSmallerThanMinDrawSize(rect.height())) {
                return true;
            }
            ignoredGeom.add(rect);
            return false;
        })) {
            if (child.getParent() != this.mDevice.getTemplate()) continue;
            devices.add(child);
        }
        return new APair(devices, ignoredGeom);
    }

    protected void drawPins() {
        DeviceTemplate t = this.mDevice.getTemplate();
        if (t == null) {
            return;
        }
        APatternColor roughPinColor = this.mDrawContext.colorizer.findColor(this.mPath, (ViewColorizer.Key)ViewColorizer.KDevicePort);
        if (roughPinColor == null) {
            return;
        }
        APatternColor viaColor = this.mDrawContext.colorizer.findColor(this.mPath, (ViewColorizer.Key)ViewColorizer.KVia);
        boolean hollow = this.mDrawContext.colorizer.getHollowPins();
        APair<List<PinInstance>, List<AGeom>> pinsInView = this.getPins();
        for (AGeom roughGeom : (List)pinsInView.second) {
            this.drawRough(roughGeom, roughPinColor.getColor(), this.getDrawGraphics(false));
        }
        if (viaColor != null) {
            for (PinInstance pinInst : (List)pinsInView.first) {
                if (!Selectors.VIA_PIN_TYPE.contains(pinInst.getType())) continue;
                this.drawPinInst(pinInst, false, hollow);
            }
        }
        for (PinInstance pinInst : (List)pinsInView.first) {
            if (Selectors.VIA_PIN_TYPE.contains(pinInst.getType())) continue;
            this.drawPinInst(pinInst, false, hollow);
        }
    }

    private APair<List<PinInstance>, List<AGeom>> getPins() {
        if (this.mLocalWorldBound == null) {
            return APair.create((Object)AUtil.arrayList((Iterator)this.mDevice.getPins()), Collections.emptyList());
        }
        return this.getPinsInView();
    }

    private APair<List<PinInstance>, List<AGeom>> getPinsInView() {
        SpatialIndex2D pinIndex = this.mDevice.getPinSpatialIndex();
        DbHistory history = this.mDevice.getDb().getHistory();
        ArrayList<PinInstance> pinsInView = new ArrayList<PinInstance>();
        ArrayList ignoredGeom = new ArrayList();
        try (DbHistory.DbTransaction transaction = history.newDbTransaction("[Auto] Create PinInstance for Display");){
            for (PinTemplate pt : pinIndex.intersects(this.mLocalWorldBound, rect -> {
                if (!this.mDrawContext.isSmallerThanMinDrawSize(rect.width()) || !this.mDrawContext.isSmallerThanMinDrawSize(rect.height())) {
                    return true;
                }
                ignoredGeom.add(rect.transform(this.mTransform));
                return false;
            })) {
                if (pt.getDeviceTemplate() != this.mDevice.getTemplate()) continue;
                pinsInView.add(PinInstance.getPinInstance((Device)this.mDevice, (PinTemplate)pt));
            }
        }
        return APair.create(pinsInView, ignoredGeom);
    }

    protected boolean isSelected(DbObject dbo) {
        return this.mDrawContext.selected != null && this.mDrawContext.selected.contains(dbo);
    }

    protected boolean isSelected(DevicePath path, DbObject dbo) {
        return this.mDrawContext.selected != null && this.mDrawContext.selected.contains(path, dbo);
    }

    protected void drawPinInst(PinInstance pinInst, boolean cursorDraw, boolean hollow) {
        PinTemplate pinTmplt = pinInst.getPinTemplate();
        if (pinTmplt == null || pinTmplt.getType() == PinTemplate.Type.TOPOLOGYPOINT) {
            return;
        }
        if (!cursorDraw && this.mBeingMoved != null && (this.mBeingMoved.contains(this.mPath, (DbObject)pinInst) || this.mBeingMoved.contains((DbObject)pinTmplt) || this.mBeingMoved.contains((DbObject)pinInst))) {
            return;
        }
        boolean pinSelect = this.isSelected((DbObject)pinInst) || this.isSelected((DbObject)pinTmplt);
        boolean pathSelected = pinSelect && (this.isSelected(this.mPath, (DbObject)pinInst) || this.isSelected(this.mPath, (DbObject)pinTmplt));
        LinkedHashMap<Layer, APatternColor> colorTable = new LinkedHashMap<Layer, APatternColor>();
        for (PortTemplate portTmplt : pinTmplt.getPortTemplates()) {
            PadTemplate pt = portTmplt.getPadTemplate();
            if (pt == null || pt.getLayerShapeCount() == 0) continue;
            AffineTransform xform = portTmplt.getTransform();
            xform.preConcatenate(this.mTransform);
            List<Layer> layers = this.mDrawContext.getDrawOrder(pt);
            boolean portSelect = pinSelect || this.isSelected((DbObject)portTmplt);
            boolean portPathSelect = portSelect && (pathSelected || this.isSelected(this.mPath, (DbObject)portTmplt));
            for (Layer l : layers) {
                if (!colorTable.containsKey(l)) {
                    APatternColor pcolor = this.mDrawContext.colorizer.getColor(this.mPath, pinInst, pinTmplt, l);
                    colorTable.put(l, pcolor == null ? null : pcolor);
                }
                APatternColor lcolor = (APatternColor)colorTable.get(l);
                this.drawPortPad(pinInst, portTmplt, pt, l, lcolor, cursorDraw, xform, portSelect, portPathSelect, hollow);
            }
        }
    }

    private void drawPortText(PinInstance pinInst, PortTemplate portTmplt, Rectangle screenBounds, Graphics2D g, boolean cursorDraw) {
        String custPinText;
        Net pinNet;
        if (screenBounds == null || screenBounds.width <= 8 || screenBounds.height <= 8) {
            return;
        }
        int numPinTextLines = 0;
        if (this.mDrawContext.colorizer.getShowPinNames()) {
            ++numPinTextLines;
        }
        if (this.mDrawContext.colorizer.getShowPinNetNames()) {
            ++numPinTextLines;
        }
        if (this.mDrawContext.colorizer.getShowPinTopmostNetNames()) {
            ++numPinTextLines;
        }
        if (this.mDrawContext.colorizer.getShowCustomPinText()) {
            ++numPinTextLines;
        }
        int curWidth = screenBounds.width;
        int newWidth = (int)((double)screenBounds.width * 1.0);
        screenBounds.x -= (newWidth - curWidth) / 2;
        screenBounds.width = newWidth;
        Rectangle textArea = new Rectangle(screenBounds);
        if (numPinTextLines > 1) {
            textArea.height = textArea.height / numPinTextLines - 1;
        }
        Rectangle textRect = null;
        g = (Graphics2D)g.create();
        if (this.mDrawContext.colorizer.getUseClassicTheme()) {
            g.setFont(OrbitFonts.WORK_SANS_THIN);
        } else {
            g.setFont(new Font("SansSerif", 0, 16));
        }
        g.setColor(Color.WHITE);
        if (this.mDrawContext.colorizer.getShowPinNames()) {
            textRect = this.drawName(g, pinInst.getName(), textArea);
        }
        PinTemplate pinTmplt = pinInst.getPinTemplate();
        if (this.mDrawContext.colorizer.getShowPinNetNames()) {
            pinNet = pinInst.getNet();
            if (pinNet.isUnused() || this.isFloorplanPinThatIsBeingMoved(pinTmplt, cursorDraw, this.mBeingMoved)) {
                if (this.mSettings.mNetUnusedOpt != OrbitIOSettings.NetDisplayTextOpt.Hide) {
                    g.setFont(this.mSettings.mNetUnusedFont);
                    g.setColor(this.mSettings.mNetUnusedColor);
                    if (textRect != null) {
                        textArea.y = textRect.y + textRect.height + 1;
                    }
                    textRect = this.drawName(g, this.mSettings.mNetUnusedText, textArea);
                }
            } else {
                boolean substNet = true;
                Net n = NetMap.getSubstrateNet((Net)pinNet, (DevicePath)this.mPath, (boolean)true);
                if (n == null) {
                    substNet = false;
                    n = NetMap.getTopmostNet((Net)pinInst.getNet(), (DevicePath)this.mPath);
                }
                if (n != null) {
                    String name = n.getName();
                    if (textRect != null) {
                        textArea.y = textRect.y + textRect.height + 1;
                    }
                    if (substNet) {
                        textRect = this.drawName(g, name, textArea);
                    } else {
                        g.setFont(this.mSettings.mNetUnconnFont);
                        g.setColor(this.mSettings.mNetUnconnColor);
                        switch (this.mSettings.mNetUnconnOpt) {
                            case Hide: {
                                break;
                            }
                            case StaticText: {
                                textRect = this.drawName(g, this.mSettings.mNetUnconnText, textArea);
                                break;
                            }
                            case TopmostNetName: {
                                textRect = this.drawName(g, name, textArea);
                            }
                        }
                    }
                }
            }
        }
        if (this.mDrawContext.colorizer.getShowPinTopmostNetNames()) {
            pinNet = pinInst.getNet();
            if (pinNet.isUnused() || this.isFloorplanPinThatIsBeingMoved(pinTmplt, cursorDraw, this.mBeingMoved)) {
                if (this.mSettings.mNetUnusedOpt != OrbitIOSettings.NetDisplayTextOpt.Hide) {
                    g.setFont(this.mSettings.mNetUnusedFont);
                    g.setColor(this.mSettings.mNetUnusedColor);
                    if (textRect != null) {
                        textArea.y = textRect.y + textRect.height + 1;
                    }
                    textRect = this.drawName(g, this.mSettings.mNetUnusedText, textArea);
                }
            } else {
                Net n = NetMap.getTopmostNet((Net)pinInst.getNet(), (DevicePath)this.mPath);
                if (n != null) {
                    String name = n.getName();
                    if (textRect != null) {
                        textArea.y = textRect.y + textRect.height + 1;
                    }
                    g.setFont(this.mSettings.mNetUnconnFont);
                    g.setColor(this.mSettings.mNetUnconnColor);
                    textRect = this.drawName(g, name, textArea);
                }
            }
        }
        if (this.mDrawContext.colorizer.getShowCustomPinText() && (custPinText = this.mDrawContext.colorizer.getTextForPin(portTmplt, pinInst, this.mPath)) != null) {
            if (textRect != null) {
                textArea.y = textRect.y + textRect.height + 1;
            }
            g.setColor(Color.WHITE);
            this.drawName(g, custPinText, textArea);
        }
    }

    private void drawPortPad(PinInstance pinInst, PortTemplate portTmplt, PadTemplate padTmplt, Layer layer, APatternColor pcolor, boolean cursorDraw, AffineTransform xform, boolean portSelect, boolean pathSelected, boolean hollow) {
        if (pcolor == null) {
            return;
        }
        Color color = pcolor.getColor();
        Binner<LayerShape> shapeIndex = this.mDrawContext.getPadIndex(padTmplt, layer);
        ARect padLocalBound = null;
        if (this.mLocalWorldBound != null) {
            padLocalBound = this.mLocalWorldBound.transform(ATransformUtil.inverse((AffineTransform)portTmplt.getLocalTransform())).getBounds();
        }
        LinkedList ignoredGeom = new LinkedList();
        LinkedList<LayerShape> lsInView = new LinkedList<LayerShape>();
        for (LayerShape ls : shapeIndex.intersects(padLocalBound, rect -> {
            if (this.mDrawContext.screenTransform.getScreenLength(Math.min(rect.width(), rect.height())) == 0) {
                ignoredGeom.add(rect);
                return false;
            }
            if (!this.mDrawContext.isSmallerThanMinDrawSize(rect.width()) || !this.mDrawContext.isSmallerThanMinDrawSize(rect.height())) {
                return true;
            }
            ignoredGeom.add(rect);
            return false;
        })) {
            lsInView.add(ls);
        }
        for (AGeom r : ignoredGeom) {
            this.drawRough(r.transform(xform), color, this.getDrawGraphics(false));
        }
        for (LayerShape ls : lsInView) {
            AGeom geom = ls.getGeom();
            if (geom == null) continue;
            boolean shapeSelected = this.isSelected((DbObject)ls);
            boolean shapePathSelected = shapeSelected && this.mDrawContext.selected.contains((HierInst)new HierShape(this.mPath, (DbObject)portTmplt, ls));
            Graphics2D g = (Graphics2D)this.getDrawGraphics(pathSelected || shapePathSelected).create();
            Color alt = null;
            Color outline = color;
            if (portSelect && this.mDrawContext.colorizer.getUseSelectionColors()) {
                alt = AUtil.findComplimentColor((Color)color);
                if (!pathSelected) {
                    alt = AColor.mix((Color)color, (Color)alt, (float)0.9f);
                }
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, color, 2.0f, 2.0f, alt, true);
                g.setPaint(gradient);
                outline = alt;
            } else {
                g.setPaint(pcolor.getPaint());
            }
            if (shapeSelected && this.mDrawContext.colorizer.getUseSelectionColors()) {
                Color selBrightColor = Color.WHITE;
                outline = !shapePathSelected ? AColor.mix((Color)color, (Color)selBrightColor, (float)0.4f) : selBrightColor;
            }
            Rectangle r = this.drawPad(g, xform, ls, outline, null, hollow);
            if (hollow && alt != null) {
                g.setStroke(DefaultViewDrawer.DASHED);
                this.drawPad(g, xform, ls, alt, null, hollow);
            }
            if (r == null) continue;
            if (pinInst.fixed() && this.mDrawContext.colorizer.getShowFixedMarkers()) {
                this.drawFixedSymbol(g, (int)((double)r.width * 1.0), new Point(r.x + r.width / 2, r.y + r.height / 2));
            }
            if (ls.isPreferredAttachment()) {
                int w = r.width / 4;
                int h = r.height / 4;
                g.setColor(Color.WHITE);
                g.fillOval(r.x + w, r.y + h, w * 2, h * 2);
            }
            this.drawPortText(pinInst, portTmplt, r, g, cursorDraw);
        }
    }

    private boolean isFloorplanPinThatIsBeingMoved(PinTemplate pinTmplt, boolean cursorDraw, Selection.SelSet beingMoved) {
        FloorplanPin fpp;
        boolean isFpPinBeingMoved = false;
        if (!cursorDraw && beingMoved != null && (fpp = pinTmplt.findFloorplanPin(this.mPath)) != null && beingMoved.contains((DbObject)fpp.getOwner())) {
            isFpPinBeingMoved = true;
        }
        return isFpPinBeingMoved;
    }

    protected void drawBundles() {
        DeviceTemplate t = this.mDevice.getTemplate();
        if (t == null) {
            return;
        }
        for (Bundle bundle : t.getBundles()) {
            if (!this.mDrawContext.colorizer.isVisible(this.mPath, (DbObject)bundle)) continue;
            APatternColor bundleColor = this.mDrawContext.colorizer.getColor(this.mPath, bundle);
            boolean select = this.isSelected((DbObject)bundle);
            Graphics2D g = this.getDrawGraphics(select);
            this.drawBundleSides(bundle, bundleColor, g);
            if (select && this.mDrawContext.colorizer.getUseSelectionColors()) {
                Color startColor = bundleColor.getColor();
                Object endColor = AColor.getComplementary((Color)bundleColor.getColor());
                if (!this.isSelected(this.mPath, (DbObject)bundle)) {
                    endColor = AColor.mix((Color)bundleColor.getColor(), (Color)endColor, (float)0.4f);
                }
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, startColor, 2.0f, 2.0f, (Color)endColor, true);
                g.setPaint(gradient);
            } else if (this.mDrawContext.colorizer.getUseClassicTheme()) {
                Color c = bundleColor.getColor();
                g.setPaint(APatternColor.copy((Color)new Color(c.getRed(), c.getGreen(), c.getBlue(), 160), (APatternColor)bundleColor).getPaint());
            } else {
                g.setPaint(bundleColor.getPaint());
            }
            this.drawBundlePath(bundle, g);
            this.drawBundleName(bundle, bundleColor, g);
        }
    }

    protected void drawBundlePath(Bundle bundle, Graphics2D gOrigin) {
        APath path = bundle.getPath();
        Graphics2D g = (Graphics2D)gOrigin.create();
        int screenWidth = this.mDrawContext.screenTransform.getScreenLength(bundle.bundleWidth());
        if (screenWidth == 0) {
            screenWidth = 5;
        }
        GeneralPath screenPath = new GeneralPath();
        for (APoint2D pt : path.getPoints()) {
            APoint2D worldPoint = pt.transform(this.mTransform);
            Point screenPt = this.mDrawContext.screenTransform.getScreenPt(worldPoint);
            if (screenPath.getCurrentPoint() == null) {
                screenPath.moveTo(screenPt.x, screenPt.y);
                continue;
            }
            screenPath.lineTo(screenPt.x, screenPt.y);
        }
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(screenWidth, 0, 1));
        g.draw(screenPath);
        g.setStroke(oldStroke);
        int side = this.mDrawContext.screenTransform.getScreenLength(bundle.bundleWidth());
        if (side > 1 && path.getPointCount() > 1) {
            Color oldColor = g.getColor();
            AffineTransform oldT = g.getTransform();
            g.setColor((Color)AColor.getComplementary((Color)oldColor));
            APoint2D first = path.getFirstPoint();
            APoint2D second = path.getPoint(1);
            AVector v = new AVector(first.getX(), first.getY(), second.getX(), second.getY());
            double angle = -v.angle() + 1.5707963267948966 - Math.toRadians(this.mDevice.getRotate());
            AffineTransform t = new AffineTransform(oldT);
            Point screenLoc = this.mDrawContext.screenTransform.getScreenPt(first.transform(this.mTransform));
            t.translate(screenLoc.x, screenLoc.y);
            t.rotate(-angle);
            g.setTransform(t);
            ADraw2D.drawTriangle(g, 0, side / 2, side, side / 2, 1);
            first = path.getPoint(path.getPointCount() - 2);
            second = path.getLastPoint();
            v = new AVector(first.getX(), first.getY(), second.getX(), second.getY());
            angle = -v.angle() + 1.5707963267948966 - Math.toRadians(this.mDevice.getRotate());
            t = new AffineTransform(oldT);
            screenLoc = this.mDrawContext.screenTransform.getScreenPt(second.transform(this.mTransform));
            t.translate(screenLoc.x, screenLoc.y);
            t.rotate(-angle);
            g.setTransform(t);
            ADraw2D.drawTriangle(g, -side / 2, side / 2, side, side / 2, 1);
            g.setColor(oldColor);
            g.setTransform(oldT);
            g.setPaintMode();
        }
    }

    protected void drawBundleRake(ArrayList<APair<APoint2D, HierPin>> rake, APatternColor bundleColor, boolean isFixed, Graphics2D g) {
        g = (Graphics2D)g.create();
        Point prevPoint = null;
        for (APair<APoint2D, HierPin> e : rake) {
            PinInstance pin;
            GeneralPath spider = new GeneralPath();
            APoint2D rakePoint = (APoint2D)e.getFirst();
            HierPin pinA = (HierPin)e.getSecond();
            Personality personality = PersonalityMappingMgmt.getConnectedPersonality((Net)pinA.getNet(), (DevicePath)pinA.getPath());
            if (personality != null) {
                g.setColor(personality.getColor());
            } else {
                g.setColor(bundleColor.getColor());
            }
            HierInst hPinT = HierInst.create((DevicePath)((DevicePath)pinA.first), (DbObject)((PinInstance)pinA.second).getPinTemplate());
            PinInstance pinInstance = pin = hPinT.getPath().isEmpty() ? PinInstance.getPinInstance((Device)this.mDevice, (PinTemplate)((PinTemplate)hPinT.getDbObject())) : PinInstance.getPinInstance((HierInst)hPinT);
            assert (pin != null);
            if (pin == null) continue;
            HierPin hpAux = new HierPin(hPinT.getPath(), pin);
            APoint2D p0 = hpAux.getWorldLoc().transform(this.mTransform);
            APoint2D p1 = rakePoint;
            p1 = p1.transform(this.mTransform);
            Point screenPt0 = this.mDrawContext.screenTransform.getScreenPt(p0);
            Point screenPt1 = this.mDrawContext.screenTransform.getScreenPt(p1);
            spider.moveTo(screenPt0.x, screenPt0.y);
            spider.lineTo(screenPt1.x, screenPt1.y);
            g.draw(spider);
            if (prevPoint != null) {
                Line2D.Float fromLine = new Line2D.Float(screenPt1, prevPoint);
                if (!this.mDrawContext.colorizer.getUseClassicTheme()) {
                    if (isFixed) {
                        g.setColor(Color.RED);
                    } else {
                        g.setColor(Color.GREEN);
                    }
                }
                g.draw(fromLine);
            }
            prevPoint = screenPt1;
        }
    }

    protected void drawBundleSides(Bundle bundle, APatternColor bundleColor, Graphics2D gOrigin) {
        Graphics2D g = (Graphics2D)gOrigin.create();
        Color rakeColor = new Color(255, 0, 0);
        if (this.mDrawContext.colorizer.getUseClassicTheme()) {
            g.setStroke(new BasicStroke(1.0f));
        } else {
            g.setStroke(new BasicStroke(3.0f, 1, 1));
        }
        g.setColor(rakeColor);
        ArrayList listIn = bundle.getRakePattern(true);
        if (listIn != null) {
            ArrayList<APair<APoint2D, HierPin>> fixedRakes = new ArrayList<APair<APoint2D, HierPin>>();
            int i = 0;
            for (SchedConn sc : bundle.getSchedConn()) {
                HierPin hp = sc.getDPPA();
                if (hp == null || !sc.isValidBoth()) continue;
                if (!RouteQueue.hasARouteFromBundle(bundle, hp)) {
                    if (i < listIn.size()) {
                        fixedRakes.add((APair<APoint2D, HierPin>)new APair((Object)((APoint2D)listIn.get(i)), (Object)hp));
                    } else {
                        ALog.logDebug((String)"Lost Fixed End Rake Point at %s.", (Object[])new Object[]{bundle});
                    }
                }
                ++i;
            }
            this.drawBundleRake(fixedRakes, bundleColor, true, g);
        }
        HierPinHull hph = new HierPinHull();
        ArrayList listOut = bundle.getRakePattern(false);
        if (listOut != null) {
            ArrayList<APair<APoint2D, HierPin>> freeRakes = new ArrayList<APair<APoint2D, HierPin>>();
            int i = 0;
            for (SchedConn sc : bundle.getSchedConn()) {
                HierPin hp = sc.getDPPB();
                if (hp == null) continue;
                FloorplanPin fpin = ((PinInstance)hp.second).getPinTemplate().findFloorplanPin((DevicePath)hp.first);
                if (fpin == null) {
                    hph.add(new HierPinT((DevicePath)hp.first, (PinInstance)hp.second));
                }
                if (!RouteQueue.hasARouteFromBundle(bundle, hp)) {
                    if (i < listOut.size()) {
                        freeRakes.add((APair<APoint2D, HierPin>)new APair((Object)((APoint2D)listOut.get(i)), (Object)hp));
                    } else {
                        ALog.logDebug((String)"Lost Free End Rake Point at %s.", (Object[])new Object[]{bundle});
                    }
                }
                ++i;
            }
            this.drawBundleRake(freeRakes, bundleColor, false, g);
        }
        if (listOut != null && !listOut.isEmpty()) {
            APoint2D midSeqBar = bundle.getRakePtsCentroid(false);
            Point midSeqBarScreenPt = this.mDrawContext.screenTransform.getScreenPt(midSeqBar.transform(this.mTransform));
            Point lastPt = this.mDrawContext.screenTransform.getScreenPt(bundle.getPath().getLastPoint().transform(this.mTransform));
            if (lastPt != null && midSeqBarScreenPt != null) {
                Line2D.Float fromLine = new Line2D.Float(midSeqBarScreenPt, lastPt);
                g.setColor(Color.GREEN);
                g.draw(fromLine);
            }
        }
        Color c = new Color(bundleColor.getRed(), bundleColor.getGreen(), bundleColor.getBlue(), 128);
        g.setColor(c);
        DefaultViewDrawer.paintGeom(g, hph.getGeom(this.mTransform), this.mDrawContext.screenTransform, true, true);
    }

    protected void drawBundleName(Bundle b, APatternColor bundleColor, Graphics2D gOrigin) {
        Graphics2D g = (Graphics2D)gOrigin.create();
        APath path = b.getPath();
        String bundleName = b.getName();
        if (this.mDrawContext.colorizer.getUseClassicTheme()) {
            Color oldColor = g.getColor();
            Stroke oldStroke = g.getStroke();
            bundleName = bundleName.toUpperCase();
            g.setFont(new Font("SansSerif", 0, 16));
            Font oldFont = g.getFont();
            for (ALine line : path.getSegments()) {
                APoint2D first = line.getP0();
                APoint2D second = line.getP1();
                if (first.getX() > second.getX()) {
                    APoint2D temp = first;
                    first = second;
                    second = temp;
                }
                long length = first.distance(second);
                long height = b.bundleWidth();
                ARect r = new ARect(0L, 0L, length, height / 2L);
                APoint2D center = line.center();
                Point screenLoc = this.mDrawContext.screenTransform.getScreenPt(first.transform(this.mTransform));
                r.moveCenterTo(center);
                Rectangle rect = this.mDrawContext.screenTransform.getScreenRect(r);
                float fsize = UIUtil.getFontSizeToFitText((Graphics2D)g, (String)bundleName, (Rectangle2D)rect);
                if (fsize > 1024.0f || fsize < 1.0f) {
                    return;
                }
                Font f = oldFont.deriveFont(fsize);
                g.setFont(f);
                FontRenderContext frc = g.getFontRenderContext();
                TextLayout tl = new TextLayout(bundleName, g.getFont(), frc);
                Rectangle textBounds = tl.getPixelBounds(frc, 0.0f, 0.0f);
                AffineTransform oldT = g.getTransform();
                AVector v = new AVector(first.getX(), first.getY(), second.getX(), second.getY());
                ALine l = new ALine(first, second);
                double normalAngle = l.getAngle() - 90.0;
                normalAngle = Math.toRadians(normalAngle);
                int halfHeight = textBounds.height / 2;
                double dx = Math.cos(normalAngle) * (double)halfHeight;
                double dy = Math.sin(normalAngle) * (double)halfHeight;
                double angle = -v.angle() + 1.5707963267948966;
                AffineTransform t = new AffineTransform(oldT);
                int excessW = (rect.width - textBounds.width) / 2;
                t.translate((double)screenLoc.x + dx, (double)screenLoc.y - dy);
                t.rotate(-angle);
                t.translate(excessW, 0.0);
                TextLayout textTl = new TextLayout(bundleName, f, frc);
                Shape outline = textTl.getOutline(null);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setFont(f);
                g.setTransform(t);
                g.setStroke(new BasicStroke(2.0f));
                g.draw(outline);
                g.setColor((Color)AColor.getComplementary((Color)oldColor));
                g.drawString(bundleName, 0, 0);
                g.setStroke(oldStroke);
                g.setFont(oldFont);
                g.setColor(oldColor);
                g.setTransform(oldT);
                g.setPaintMode();
            }
            return;
        }
        ARect wr = this.mDrawContext.canvas.getVisibleBounds();
        ALine seg = path.getLongestSegment(wr, this.mTransform);
        if (seg == null) {
            return;
        }
        APoint2D first = seg.getP0();
        APoint2D second = seg.getP1();
        if (first.getX() > second.getX()) {
            APoint2D temp = first;
            first = second;
            second = temp;
        }
        long length = first.distance(second);
        long height = b.bundleWidth();
        ARect r = new ARect(0L, 0L, length, height / 2L);
        APoint2D center = seg.center();
        Point screenLoc = this.mDrawContext.screenTransform.getScreenPt(first.transform(this.mTransform));
        r.moveCenterTo(center);
        Rectangle rect = this.mDrawContext.screenTransform.getScreenRect(r);
        if (Math.min(rect.getWidth(), rect.getHeight()) < 8.0) {
            return;
        }
        float fsize = UIUtil.getFontSizeToFitText((Graphics2D)g, (String)bundleName, (Rectangle2D)rect);
        if ((fsize = Math.min(128.0f, fsize)) < 8.0f) {
            return;
        }
        Font f = new Font("SansSerif", 0, (int)Math.ceil(fsize));
        g.setFont(f);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout tl = new TextLayout(bundleName, g.getFont(), frc);
        Rectangle textBounds = tl.getPixelBounds(frc, 0.0f, 0.0f);
        AffineTransform oldT = g.getTransform();
        AVector v = new AVector(first.getX(), first.getY(), second.getX(), second.getY());
        ALine l = new ALine(first, second);
        double normalAngle = Math.toRadians(l.getAngle() - 90.0);
        int halfHeight = textBounds.height / 2;
        double dx = Math.cos(normalAngle) * (double)halfHeight;
        double dy = Math.sin(normalAngle) * (double)halfHeight;
        double angle = -v.angle() + 1.5707963267948966;
        AffineTransform t = new AffineTransform(oldT);
        int excessW = (rect.width - textBounds.width) / 2;
        t.translate((double)screenLoc.x + dx, (double)screenLoc.y - dy);
        t.rotate(-angle);
        t.translate(excessW, 0.0);
        TextLayout textTl = new TextLayout(bundleName, f, frc);
        Shape outline = textTl.getOutline(null);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setFont(f);
        g.setTransform(t);
        g.setStroke(new BasicStroke(2.0f));
        g.draw(outline);
        g.setColor((Color)AColor.getComplementary((Color)bundleColor.getColor()));
        g.drawString(bundleName, 0, 0);
    }

    protected void drawSchedConns() {
        DeviceTemplate t = this.mDevice.getTemplate();
        if (t == null) {
            return;
        }
        if (!this.mDrawContext.colorizer.getShowSchedConns()) {
            return;
        }
        for (SchedConn sc : t.getRelated("SchedConn-owner", SchedConn.class)) {
            this.drawSchedConn(sc);
        }
    }

    protected void drawSchedConn(SchedConn sc) {
        APatternColor color = this.mDrawContext.colorizer.getColor(this.mPath, sc);
        if (color == null) {
            return;
        }
        Graphics2D g = this.getDrawGraphics(false);
        if (sc.getPortA() == null || sc.getPortB() == null) {
            return;
        }
        ALine line = sc.getLine();
        if (line == null) {
            return;
        }
        g.setColor(color.getColor());
        Point p0 = this.mDrawContext.screenTransform.getScreenPt(line.getP0());
        Point p1 = this.mDrawContext.screenTransform.getScreenPt(line.getP1());
        g.drawLine(p0.x, p0.y, p1.x, p1.y);
    }

    private IterableIterator<Wire> getWires() {
        return this.mLocalWorldBound == null ? this.mDevice.getTemplate().getWires() : this.getWiresInView();
    }

    private IterableIterator<Wire> getWiresInView() {
        SpatialIndex2D wireIndex = this.mDevice.getTemplate().getWireSpatialIndex();
        return wireIndex.intersects(this.mLocalWorldBound, rect -> !this.mDrawContext.isSmallerThanMinDrawSize(rect.width()) || !this.mDrawContext.isSmallerThanMinDrawSize(rect.height()));
    }

    protected void drawWires() {
        DeviceTemplate t = this.mDevice.getTemplate();
        if (t == null) {
            return;
        }
        boolean hollow = this.mDrawContext.colorizer.getHollowWires();
        boolean showVertices = this.mDrawContext.colorizer.getShowWireVertices();
        LinkedList<Wire> wires = new LinkedList<Wire>();
        for (Wire wire : this.getWires()) {
            if (this.mDrawContext.isSmallerThanMinDrawSize((AGeom)wire.getPath())) continue;
            wires.add(wire);
        }
        Collections.sort(wires, (w1, w2) -> Layer.OrderComparator.compare(w1.getLayer(), w2.getLayer()));
        for (Wire wire : wires) {
            APatternColor color = this.mDrawContext.colorizer.getColor(this.mPath, wire);
            if (color == null) continue;
            Color outline = color.getColor();
            boolean select = this.isSelected(this.mPath, (DbObject)wire);
            Graphics2D g = this.getDrawGraphics(select);
            if (select && this.mDrawContext.colorizer.getUseSelectionColors()) {
                Color startColor = Color.RED;
                Color endColor = Color.YELLOW;
                if (!this.isSelected(this.mPath, (DbObject)wire)) {
                    endColor = AColor.mix((Color)color.getColor(), (Color)endColor, (float)0.4f);
                }
                GradientPaint gradient = new GradientPaint(0.0f, 0.0f, startColor, 2.0f, 2.0f, endColor, true);
                g.setPaint(gradient);
                outline = startColor;
            } else {
                g.setPaint(color.getPaint());
            }
            APath path = wire.getPath();
            boolean drawn = this.drawWire(g, wire, outline, hollow);
            if (!drawn || !showVertices || this.mDrawContext.screenTransform.toScreenDist(path.getWidth()) <= 3) continue;
            this.drawVertices(g, path);
        }
    }

    protected boolean drawWire(Graphics2D g, Wire w, Color outline, boolean hollow) {
        APath path = w.getPath();
        if (path == null) {
            return false;
        }
        DesignCanvas2D.drawPath(g, this.mDrawContext.screenTransform, path, this.mTransform, outline, !hollow);
        return true;
    }

    protected void drawThisGrid(NamedGrid ng) {
        Graphics2D g;
        Graphics2D graphics2D = g = this.mGraphics != null ? this.mGraphics : this.mDrawContext.gMain;
        if (g == null) {
            return;
        }
        if (ng == null || !ng.isValid()) {
            return;
        }
        AGrid screenGrid = ng.getGrid().transform(this.mDrawContext.screenTransform.getWorldToScreenTransform());
        if (screenGrid == null || screenGrid.getDeltaX() < 5L || screenGrid.getDeltaY() < 5L) {
            return;
        }
        this.drawGridInArea(ng, g, this.mLocalWorldBound, this.mPath.getOrigin(), this.mDrawContext.screenTransform);
    }

    protected void drawGridInArea(NamedGrid ng, Graphics2D g, ARect bounds, APoint2D origin, DesignCanvas2D.XForm xform) {
        APatternColor gColor = this.mDrawContext.colorizer.getColor(this.mPath, ng);
        if (gColor == null) {
            return;
        }
        AGrid grid = ng.getGrid();
        APoint2D ll = grid.snapToGrid(bounds.getLL());
        int major = ng.getMajor();
        if (major <= 0) {
            major = 10;
        }
        long yMajor = 0L;
        long xMajor = 0L;
        for (long y = ll.getY(); y < bounds.top(); y += grid.getDeltaY()) {
            ++yMajor;
            if (y < bounds.bottom()) continue;
            for (long x = ll.getX(); x < bounds.right(); x += grid.getDeltaX()) {
                ++xMajor;
                if (x < bounds.left()) continue;
                if (x == origin.getX() && y == origin.getY()) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(gColor.getColor());
                }
                APoint2D loc = new APoint2D(x, y);
                loc = loc.transform(this.mTransform);
                int sx = xform.getScreenX(loc.getX());
                int sy = xform.getScreenY(loc.getY());
                if (xMajor % (long)major == 0L && yMajor % (long)major == 0L) {
                    g.drawLine(sx - 1, sy, sx + 1, sy);
                    g.drawLine(sx, sy - 1, sx, sy + 1);
                    continue;
                }
                g.drawLine(sx, sy, sx, sy);
            }
        }
    }

    protected void drawGrid() {
        DeviceTemplate t = this.mDevice.getTemplate();
        if (t == null || !this.mDevice.getIsSubstrate()) {
            return;
        }
        Substrate s = this.mDevice.getSubstrate();
        if (s == null) {
            return;
        }
        NamedGrid ng = NamedGrid.get((Substrate)s, (String)"Pin Grid");
        if (ng == null) {
            ng = NamedGrid.get((Substrate)s, (String)"Manufacturing Grid");
        }
        if (ng != null) {
            this.drawThisGrid(ng);
        }
    }

    protected void drawTerm(Rectangle screenBounds) {
        if (this.mDevice == null) {
            return;
        }
        if (!this.mDrawContext.colorizer.getDisplay(this.mPath, (ViewColorizer.Key)ViewColorizer.KTerm)) {
            return;
        }
        if (this.mDevice.getType() == DeviceTemplate.Type.BUMP) {
            this.drawBumpTerm(screenBounds);
        }
        if (this.mDevice.getType() == DeviceTemplate.Type.DIE) {
            this.drawDieTerm(screenBounds);
        }
    }

    protected void drawBumpTerm(Rectangle screenBounds) {
        if (this.mDevice.getTemplate().getTermCount() == 0L) {
            return;
        }
        for (Term term : this.mDevice.getTerms()) {
            if (TermMap.getParentNet((Device)this.mDevice, (Term)term) != null) continue;
            return;
        }
        boolean hasIn = false;
        boolean hasSelectedIn = false;
        boolean hasOut = false;
        boolean hasSelectedOut = false;
        for (Term term : this.mDevice.getTerms()) {
            if (term.getType() == Term.Type.IN) {
                hasIn = true;
                if (!this.isSelected(this.mPath, (DbObject)term)) continue;
                hasSelectedIn = true;
                continue;
            }
            if (term.getType() == Term.Type.OUT) {
                hasOut = true;
                if (!this.isSelected(this.mPath, (DbObject)term)) continue;
                hasSelectedOut = true;
                continue;
            }
            if (term.getType() != Term.Type.INOUT) continue;
            hasIn = true;
            hasOut = true;
            if (!this.isSelected(this.mPath, (DbObject)term)) continue;
            hasSelectedIn = true;
            hasSelectedOut = true;
        }
        this.drawTermSymbol(hasIn, hasSelectedIn, hasOut, hasSelectedOut, screenBounds);
    }

    protected void drawDieTerm(Rectangle screenBounds) {
        if (this.mDevice.getTemplate().getTermCount() == 0L) {
            return;
        }
        boolean hasIn = false;
        boolean hasSelectedIn = false;
        boolean hasOut = false;
        boolean hasSelectedOut = false;
        for (Term term : this.mDevice.getTerms()) {
            if (term.getNet() != null && TermMap.getChildHierNets((DevicePath)this.mPath, (Net)term.getNet()).hasNext()) continue;
            if (term.getType() == Term.Type.IN) {
                hasIn = true;
                if (!this.isSelected(this.mPath, (DbObject)term)) continue;
                hasSelectedIn = true;
                continue;
            }
            if (term.getType() == Term.Type.OUT) {
                hasOut = true;
                if (!this.isSelected(this.mPath, (DbObject)term)) continue;
                hasSelectedOut = true;
                continue;
            }
            if (term.getType() != Term.Type.INOUT) continue;
            hasIn = true;
            hasOut = true;
            if (!this.isSelected(this.mPath, (DbObject)term)) continue;
            hasSelectedOut = true;
            hasSelectedIn = true;
        }
        this.drawTermSymbol(hasIn, hasSelectedIn, hasOut, hasSelectedOut, screenBounds);
    }

    protected void drawTermSymbol(boolean hasIn, boolean hasSelectedIn, boolean hasOut, boolean hasSelectedOut, Rectangle screenBounds) {
        APatternColor c = this.mDrawContext.colorizer.getTermColor(this.mPath);
        int base = 6;
        int height = 6;
        int locX = (int)screenBounds.getMinX();
        int locY = (int)screenBounds.getMaxY();
        if (hasIn && !hasOut) {
            Graphics2D g = this.getDrawGraphics(hasSelectedIn);
            g = (Graphics2D)g.create();
            if (hasSelectedIn) {
                g.setPaint(c.getColorContrasting().getPaint());
            } else {
                g.setPaint(c.getPaint());
            }
            ADraw2D.drawTriangleVert(g, locX, locY - height, base, height * 2, 1);
        } else if (hasOut && !hasIn) {
            Graphics2D g = this.getDrawGraphics(hasSelectedIn);
            g = (Graphics2D)g.create();
            if (hasSelectedOut) {
                g.setPaint(c.getColorContrasting().getPaint());
            } else {
                g.setPaint(c.getPaint());
            }
            ADraw2D.drawTriangleVert(g, locX, locY - height, base, height * 2, -1);
        } else if (hasOut && hasIn) {
            Graphics2D g = this.getDrawGraphics(hasSelectedIn);
            g = (Graphics2D)g.create();
            if (hasSelectedOut) {
                g.setPaint(c.getColorContrasting().getPaint());
            } else {
                g.setPaint(c.getPaint());
            }
            ADraw2D.drawTriangleVert(g, locX, locY, base, height, 1);
            ADraw2D.drawTriangleVert(g, locX, locY, base, height, -1);
        }
    }

    private IterableIterator<Obstacle> getObstacles() {
        return this.mLocalWorldBound == null ? this.mDevice.getTemplate().getObstacles() : this.getObstaclesInView();
    }

    private IterableIterator<Obstacle> getObstaclesInView() {
        SpatialIndex2D obsIndex = this.mDevice.getTemplate().getObstacleSpatialIndex();
        return obsIndex.intersects(this.mLocalWorldBound, rect -> !this.mDrawContext.isSmallerThanMinDrawSize(rect.width()) || !this.mDrawContext.isSmallerThanMinDrawSize(rect.height()));
    }

    protected void drawObstacles() {
        DeviceTemplate t = this.mDevice.getTemplate();
        if (t == null) {
            return;
        }
        for (Obstacle obstacle : this.getObstacles()) {
            boolean select = this.isSelected(this.mPath, (DbObject)obstacle);
            Graphics2D g = this.getDrawGraphics(select);
            for (LayerShape ls : obstacle.getLayerShapes()) {
                APatternColor c;
                if (this.mDrawContext.isSmallerThanMinDrawSize(ls) || (c = this.mDrawContext.colorizer.getColor(this.mPath, obstacle, ls.getLayer())) == null) continue;
                Color outline = null;
                if (select && this.mDrawContext.colorizer.getUseSelectionColors()) {
                    c = c.getColorContrasting();
                    outline = Color.RED;
                }
                this.drawObstacleShape(g, obstacle, ls, c, outline);
            }
        }
    }

    protected void drawObstacleShape(Graphics2D g, Obstacle obstacle, LayerShape ls) {
        this.drawObstacleShape(g, obstacle, ls, null, null);
    }

    protected void drawObstacleShape(Graphics2D g, Obstacle obstacle, LayerShape ls, APatternColor c, Color outline) {
        if (c == null) {
            return;
        }
        AGeom shape = ls.getGeom();
        ARect bound = shape.getBounds();
        boolean rough = this.mDrawContext.screenTransform.getScreenLength(bound.width()) < 2 || this.mDrawContext.screenTransform.getScreenLength(bound.height()) < 2;
        g = (Graphics2D)g.create();
        if (!rough) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (ls.getLayer() != null && ls.getLayer().getOrder() % 2 == 0) {
                g.setPaint(c.getPaint());
            } else {
                g.setPaint(c.getFlipPatternPaint());
            }
            DesignCanvas2D.drawGeom(g, this.mDrawContext.screenTransform, shape, this.mTransform, outline == null ? Color.BLACK : outline);
            DesignCanvas2D.drawGeom(g, this.mDrawContext.screenTransform, shape, this.mTransform, c.getColor(), false);
        } else {
            DesignCanvas2D.drawGeom(g, this.mDrawContext.screenTransform, shape, this.mTransform, c.getColor(), true);
        }
    }

    protected void drawLayerShapes() {
        DeviceTemplate t = this.mDevice.getTemplate();
        if (t == null) {
            return;
        }
        t.getLayerShapes().sorted().forEach(this::drawLayerShape);
    }

    protected void drawLayerShape(LayerShape ls) {
        Layer layer = ls.getLayer();
        AGeom geom = ls.getGeom();
        if (layer == null || geom == null) {
            return;
        }
        APatternColor color = this.mDrawContext.colorizer.getColor(this.mPath, layer);
        if (color == null) {
            return;
        }
        Graphics2D g = this.getDrawGraphics(false);
        g.setColor(color.getColor());
        DesignCanvas2D.drawGeom(g, this.mDrawContext.screenTransform, geom, this.mTransform, null, false);
    }

    protected void drawDimensions(Rectangle screenBounds) {
        DeviceTemplate t = this.mDevice.getTemplate();
        if (t == null) {
            return;
        }
        this.mDevice.getDimensions().forEach(dim -> this.drawDimensions((Dimensions)dim, screenBounds, false));
    }

    public void drawDimensions(Dimensions dim, Rectangle screenBounds, boolean cursorDraw) {
        if (!this.mDrawContext.colorizer.isVisible(this.mPath, (DbObject)dim.getLayer())) {
            return;
        }
        AAppView view = OrbitIO.getCurView();
        Graphics2D g = this.getDrawGraphics(false);
        AffineTransform oldTransform = g.getTransform();
        Font oldFont = g.getFont();
        Color color = Dimensions.getColor((Dimensions)dim);
        int size = Dimensions.getSize((Dimensions)dim);
        Font newFont = size == 0 ? null : new Font("Serif", 0, size);
        DevicePath path = this.mDevice.getADevicePath();
        AffineTransform transform = path.getTransform();
        if (dim.getDimensionsType() == Dimensions.DimensionsType.Device) {
            DeviceDimensionUI ui = DeviceDimensionUI.getDimensionUI(view, this.mDevice);
            if (ui == null) {
                DeviceDimensionUI.createInstance(view, this.mDevice);
            }
            ARect bb = this.mDevice.getUntransformedShape().getBounds();
            DeviceDimensionUI.DimensionMode2D.drawDimLine(g, transform, bb.getLL(), new APoint2D(bb.left(), bb.top()), (DesignView2D)view, this.mDevice.getDb(), false, color, newFont);
            DeviceDimensionUI.DimensionMode2D.drawDimLine(g, transform, bb.getLL(), new APoint2D(bb.right(), bb.bottom()), (DesignView2D)view, this.mDevice.getDb(), false, color, newFont);
        } else {
            APair pts = dim.getPoints();
            if (pts == null) {
                return;
            }
            APoint2D startPt = (APoint2D)pts.first;
            APoint2D endPt = (APoint2D)pts.second;
            if (startPt == null || endPt == null) {
                return;
            }
            DeviceDimensionUI.DimensionMode2D.drawDimLine(g, null, startPt, endPt, (DesignView2D)view, this.mDevice.getDb(), true, color, newFont);
        }
        g.setTransform(oldTransform);
        g.setFont(oldFont);
    }

    protected void drawTexts(Rectangle screenBounds) {
        if (!this.mDrawContext.colorizer.getShowTexts()) {
            return;
        }
        DeviceTemplate t = this.mDevice.getTemplate();
        if (t == null) {
            return;
        }
        long textsDrawn = t.getTexts().map(text -> this.drawText((Text)text, screenBounds, false)).filter(Boolean::booleanValue).count();
        if ((textsDrawn += this.mDevice.getTexts().map(text -> this.drawText((Text)text, screenBounds, false)).filter(Boolean::booleanValue).count()) > 0L && screenBounds != null && !screenBounds.contains(this.mDrawContext.canvas.getBounds())) {
            Graphics2D g = this.getDrawGraphics(false);
            Stroke oldStroke = g.getStroke();
            BasicStroke dashed = new BasicStroke(3.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f);
            g.setStroke(dashed);
            Rectangle r2 = new Rectangle((int)screenBounds.getMinX() - 2, (int)screenBounds.getMinY() - 2, screenBounds.width + 4, screenBounds.height + 4);
            g.draw(r2);
            g.setStroke(oldStroke);
        }
    }

    @Override
    public void drawText(Text text, boolean cursorDraw) {
        this.drawText(text, null, cursorDraw);
    }

    protected boolean drawText(Text text, Rectangle screenBounds, boolean cursorDraw) {
        if (text.getPlaceType() == Text.PlacementType.FitToSize && screenBounds == null) {
            return false;
        }
        Layer layer = text.getLayer();
        APatternColor vis = this.mDrawContext.colorizer.getColor(this.mPath, layer);
        if (vis == null) {
            return false;
        }
        if (!cursorDraw && this.mBeingMoved != null && this.mBeingMoved.contains((DbObject)text)) {
            return false;
        }
        Graphics2D g = this.getDrawGraphics(false);
        Font oldFont = g.getFont();
        AffineTransform oldTransform = g.getTransform();
        Object oldAntiAliasing = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        String str = Text.removeHtml((String)text.getText());
        if (layer == null || str == null || str.isEmpty()) {
            return false;
        }
        Color color = Text.getColor((Text)text);
        if (color == null) {
            color = this.mDrawContext.colorizer.getColor(this.mPath, layer).getColor();
        }
        g.setColor(color);
        ARect textBoundsInternalUnits = null;
        if (text.getPlaceType() == Text.PlacementType.FitToSize) {
            int count = 0;
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != '\n') continue;
                ++count;
            }
            Rectangle textBox = new Rectangle(screenBounds);
            int numRows = count == 0 ? 1 : count + 2;
            int h = textBox.height;
            textBox.height = h = h / numRows - 1;
            if (this.mDevice.isOnBottomSide()) {
                str = AUtil.reverse((String)str);
            }
            float fsize = UIUtil.getFontSizeToFitText((Graphics2D)g, (String)str, (Rectangle2D)textBox);
            fsize = Math.min(128.0f, fsize);
            int style = 0;
            if (Text.isBold((Text)text)) {
                style |= 1;
            }
            if (Text.isItalic((Text)text)) {
                style |= 2;
            }
            Font newFont = oldFont.deriveFont(style, fsize);
            g.setFont(newFont);
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout tl = new TextLayout(str, g.getFont(), frc);
            Rectangle textBounds = tl.getPixelBounds(frc, 0.0f, 0.0f);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Point loc = new Point((int)textBox.getCenterX() - textBounds.width / 2 - textBounds.x + 1, (int)textBox.getCenterY() - textBounds.height / 2 - textBounds.y);
            String[] outputs = str.split("\n");
            for (int i = 0; i < outputs.length; ++i) {
                g.drawString(outputs[i], loc.x, loc.y);
                Rectangle2D bounds = tl.getBounds();
                if (textBoundsInternalUnits == null) {
                    textBoundsInternalUnits = this.mDrawContext.screenTransform.getWorldRect(bounds.getBounds());
                } else {
                    textBoundsInternalUnits.expand(this.mDrawContext.screenTransform.getWorldRect(bounds.getBounds()));
                }
                loc.y += newFont.getSize();
            }
        } else {
            Font font = Text.getFont((Text)text);
            g.setFont(font);
            APoint2D wloc = text.getLoc();
            wloc = wloc.transform(this.mTransform);
            Point loc = this.mDrawContext.screenTransform.getScreenPt(wloc);
            AffineTransform at = new AffineTransform(oldTransform);
            double rot = Math.toRadians(this.mPath.getRot() + text.getRotate());
            at.rotate(rot);
            g.setTransform(at);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            int dx = (int)((double)loc.x * Math.cos(rot) + (double)loc.y * Math.sin(rot));
            int dy = (int)((double)loc.x * -Math.sin(rot) + (double)loc.y * Math.cos(rot));
            String[] outputs = str.split("\n");
            for (int i = 0; i < outputs.length; ++i) {
                g.drawString(outputs[i], dx, dy);
                TextLayout txt = new TextLayout(outputs[i], font, g.getFontRenderContext());
                Rectangle2D bounds = txt.getBounds();
                textBoundsInternalUnits = textBoundsInternalUnits == null ? this.mDrawContext.screenTransform.getWorldRect(bounds.getBounds()) : textBoundsInternalUnits.expandBy(this.mDrawContext.screenTransform.getWorldRect(bounds.getBounds()));
                dy += font.getSize();
            }
        }
        if (textBoundsInternalUnits != null) {
            text.setLastBoundsDisplayed(textBoundsInternalUnits.width(), textBoundsInternalUnits.height());
        }
        g.setTransform(oldTransform);
        g.setFont(oldFont);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAliasing);
        return true;
    }

    protected void drawMetals() {
        DeviceTemplate t = this.mDevice.getTemplate();
        if (t == null) {
            return;
        }
        List metals = this.getMetals().stream().collect(Collectors.toList());
        metals.sort((m1, m2) -> {
            Layer l1 = m1.getLayer();
            Layer l2 = m2.getLayer();
            if (l1 == null && l2 == null) {
                return 0;
            }
            if (l1 == null) {
                return -1;
            }
            return l1.compareTo((DbObject)l2);
        });
        for (Metal metal : metals) {
            this.drawMetal(metal);
        }
    }

    private IterableIterator<Metal> getMetals() {
        return this.mLocalWorldBound == null ? this.mDevice.getTemplate().getMetals() : this.getMetalsInView();
    }

    private IterableIterator<Metal> getMetalsInView() {
        SpatialIndex2D metalIndex = this.mDevice.getMetalSpatialIndex();
        return metalIndex.intersects(this.mLocalWorldBound, rect -> !this.mDrawContext.isSmallerThanMinDrawSize(rect.width()) || !this.mDrawContext.isSmallerThanMinDrawSize(rect.height()));
    }

    protected void drawMetal(Metal metal) {
        boolean hollow;
        AGeom geom = metal.getGeom();
        if (this.mDrawContext.isSmallerThanMinDrawSize(geom)) {
            return;
        }
        APatternColor color = this.mDrawContext.colorizer.getColor(this.mPath, metal);
        if (color == null) {
            return;
        }
        boolean select = this.isSelected((DbObject)metal);
        Graphics2D g = this.getDrawGraphics(select);
        if (select && this.mDrawContext.colorizer.getUseSelectionColors()) {
            Color startColor = color.getColor();
            Color endColor = Color.WHITE;
            if (!this.isSelected(this.mPath, (DbObject)metal)) {
                endColor = AColor.mix((Color)color.getColor(), (Color)endColor, (float)0.4f);
            }
            GradientPaint gradient = new GradientPaint(0.0f, 0.0f, startColor, 2.0f, 2.0f, endColor, true);
            g.setPaint(gradient);
        } else {
            g.setPaint(color.getPaint());
        }
        if (this.mDrawContext.colorizer.getUseClassicTheme()) {
            Color c = g.getColor();
            g.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 160));
        }
        if ((hollow = this.mDrawContext.colorizer.getHollowMetals()) && geom instanceof AGeomWithCutouts) {
            AGeomWithCutouts cutout = (AGeomWithCutouts)geom;
            DesignCanvas2D.drawGeom(g, this.mDrawContext.screenTransform, cutout.getOuter(), this.mTransform, null, false);
            DesignCanvas2D.drawGeom(g, this.mDrawContext.screenTransform, cutout.getCutout(), this.mTransform, null, false);
        } else {
            DesignCanvas2D.drawGeom(g, this.mDrawContext.screenTransform, geom, this.mTransform, null, !hollow);
        }
    }

    protected void drawPersonalityAreas(Graphics2D g) {
        if (!this.mDevice.getIsSubstrate()) {
            return;
        }
        Db db = this.mDevice.getDb();
        DeviceTemplate devT = this.mDevice.getTemplate();
        Personality.getPersonalities((DeviceTemplate)devT, (Personality.Type)Personality.Type.FC).forEach(pers -> {
            AGeom rg = (AGeom)Constraint.getValue((Db)db, (DbObject)pers, (Constraint.Descriptor)Constraint.ROUTE_AREA);
            if (rg != null) {
                APolygon poly = (APolygon)rg;
                Color color = Color.RED;
                g.setColor((Color)AColor.withAlpha((Color)color, (int)64));
                Polygon screenPoly = this.mDrawContext.screenTransform.getScreenPolygon(poly);
                g.fillPolygon(screenPoly);
            }
        });
        Personality.getPersonalities((DeviceTemplate)devT, (Personality.Type)Personality.Type.DEVICE).forEach(pers -> {
            ARect r;
            Boolean dm = (Boolean)Constraint.getValue((Db)db, (DbObject)pers, (Constraint.Descriptor)Constraint.DEVICE_MANAGED);
            if (!(dm != null && dm.booleanValue() || (r = (ARect)Constraint.getValue((Db)db, (DbObject)pers, (Constraint.Descriptor)Constraint.PLACE_AREA)) == null)) {
                Color color = pers.getColor();
                g.setColor((Color)AColor.withAlpha((Color)color, (int)128));
                ARect rnew = r.transform(this.mPath.getTransform()).getBounds();
                Rectangle rs = this.mDrawContext.screenTransform.getScreenRect(rnew);
                g.fillRect(rs.x, rs.y, rs.width, rs.height);
            }
        });
    }

    protected Rectangle drawPad(Graphics2D g, AffineTransform xform, LayerShape ls, Color outline, AGeom overrideGeom, boolean hollow) {
        return DesignCanvas2D.drawGeom(g, this.mDrawContext.screenTransform, overrideGeom == null ? ls.getGeom() : overrideGeom, xform, outline, !hollow);
    }

    protected Rectangle drawName(Graphics2D gOrigin, String text, Rectangle bounds) {
        if (text == null || ((String)text).length() == 0) {
            return null;
        }
        Graphics2D g = (Graphics2D)gOrigin.create();
        double pinWidth = bounds.getBounds2D().getWidth();
        double pinHeight = bounds.getBounds2D().getHeight();
        if (pinWidth <= 10.0 || pinHeight <= 10.0) {
            return null;
        }
        float fsize = UIUtil.getFontSizeToFitText((Graphics2D)g, (String)text, (Rectangle2D)bounds);
        if (this.mDrawContext.colorizer.getUseClassicTheme()) {
            if ((fsize = (float)Math.round(fsize * 0.8f)) > 1024.0f) {
                return null;
            }
            g.setPaintMode();
        } else {
            fsize = Math.min(128.0f, fsize);
            g.setXORMode(Color.BLACK);
        }
        Font oldFont = g.getFont();
        Font newFont = oldFont.deriveFont(fsize);
        if (fsize >= 8.0f) {
            g.setFont(newFont);
        } else {
            if (((String)text).length() <= 3) {
                return null;
            }
            fsize = 8.0f;
            Font f = newFont.deriveFont(fsize);
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics();
            String origText = text;
            int truncateLoc = 1;
            int minTextLen = TRUNCATED_NAME_INDICATOR.length() + 3;
            while (((String)(text = TRUNCATED_NAME_INDICATOR + origText.substring(truncateLoc++))).length() >= minTextLen && (double)fm.stringWidth((String)text) > pinWidth) {
            }
            if (((String)text).length() < minTextLen) {
                g.setFont(oldFont);
                return null;
            }
        }
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout tl = new TextLayout((String)text, g.getFont(), frc);
        Rectangle textBounds = tl.getPixelBounds(frc, 0.0f, 0.0f);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Point loc = new Point((int)bounds.getCenterX() - textBounds.width / 2 - textBounds.x + 1, (int)bounds.getCenterY() - textBounds.height / 2 - textBounds.y);
        if (this.mDrawContext.colorizer.getUseClassicTheme()) {
            Shape outline = tl.getOutline(AffineTransform.getTranslateInstance(loc.x, loc.y));
            Color c = g.getColor();
            g.setStroke(new BasicStroke(2.0f));
            g.setColor((Color)AColor.getComplementary((Color)c));
            g.draw(outline);
            g.setColor(c);
        }
        g.drawString((String)text, loc.x, loc.y);
        return new Rectangle(loc.x, loc.y + textBounds.y, (int)textBounds.getWidth(), (int)textBounds.getHeight());
    }

    protected void drawPath(Graphics2D g, APath path) {
        int screenWidth = this.mDrawContext.screenTransform.getScreenLength(path.getWidth());
        if (screenWidth == 0) {
            screenWidth = 1;
        }
        GeneralPath screenPath = new GeneralPath();
        for (APoint2D pt : path.getPoints()) {
            APoint2D worldPoint = pt.transform(this.mTransform);
            Point screenPt = this.mDrawContext.screenTransform.getScreenPt(worldPoint);
            if (screenPath.getCurrentPoint() == null) {
                screenPath.moveTo(screenPt.x, screenPt.y);
                continue;
            }
            screenPath.lineTo(screenPt.x, screenPt.y);
        }
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(screenWidth, 1, 1));
        g.draw(screenPath);
        g.setStroke(oldStroke);
    }

    protected void drawVertices(Graphics2D g, APath path) {
        g.setXORMode(Color.WHITE);
        g.setColor(Color.BLACK);
        for (APoint2D pt : path.getPoints()) {
            APoint2D worldPoint = pt.transform(this.mTransform);
            Point screenPt = this.mDrawContext.screenTransform.getScreenPt(worldPoint);
            g.drawLine(screenPt.x - 2, screenPt.y, screenPt.x + 2, screenPt.y);
            g.drawLine(screenPt.x, screenPt.y - 2, screenPt.x, screenPt.y + 2);
        }
        g.setPaintMode();
    }

    protected void drawSynthesizedSymbol(Graphics2D g, ARect deviceBB) {
        long diameter = Math.min(deviceBB.width(), deviceBB.height()) / 2L;
        this.drawSynthesizedSymbol(g, diameter, deviceBB.center());
    }

    protected void drawSynthesizedSymbol(Graphics2D g, long size, APoint2D center) {
        Color startColor = Color.green;
        Color endColor = Color.white;
        Point pScreen = this.mDrawContext.screenTransform.getScreenPt(center);
        int width = this.mDrawContext.screenTransform.toScreenDist(size);
        if (width > 300) {
            width = 300;
        }
        GradientPaint gradient = new GradientPaint(pScreen.x, pScreen.y, startColor, (float)pScreen.x - (float)width / 2.0f, (float)pScreen.y - (float)width / 2.0f, endColor);
        g.setPaint(gradient);
        Polygon p = new Polygon();
        p.addPoint(pScreen.x - width / 2, pScreen.y - width / 2);
        p.addPoint(pScreen.x + width / 2, pScreen.y - width / 2);
        p.addPoint(pScreen.x, pScreen.y);
        g.fillPolygon(p);
        g.setColor(Color.WHITE);
        g.drawPolygon(p);
    }

    protected void drawFixedSymbol(Graphics2D g, ARect deviceBB) {
        long diameter = Math.min(deviceBB.width(), deviceBB.height()) / 2L;
        this.drawFixedSymbol(g, diameter, deviceBB.center());
    }

    protected void drawFixedSymbol(Graphics2D g, long size, APoint2D center) {
        Point pScreen = this.mDrawContext.screenTransform.getScreenPt(center);
        int width = this.mDrawContext.screenTransform.toScreenDist(size);
        if (width > 300) {
            width = 300;
        }
        this.drawFixedSymbol(g, width, pScreen);
    }

    protected void drawFixedSymbol(Graphics2D g, int width, Point pScreen) {
        g.setColor(Color.red);
        GeneralPath screenPath = new GeneralPath();
        screenPath.moveTo(pScreen.x, pScreen.y);
        screenPath.lineTo(pScreen.x + (width /= 2), pScreen.y + width);
        g.draw(screenPath);
        screenPath.moveTo(pScreen.x, pScreen.y);
        screenPath.lineTo(pScreen.x + width, pScreen.y - width);
        g.draw(screenPath);
        screenPath.moveTo(pScreen.x, pScreen.y);
        screenPath.lineTo(pScreen.x - width, pScreen.y - width);
        g.draw(screenPath);
        screenPath.moveTo(pScreen.x, pScreen.y);
        screenPath.lineTo(pScreen.x - width, pScreen.y + width);
        g.draw(screenPath);
    }

    protected Graphics2D getDrawGraphics(boolean selected) {
        if (this.mGraphics != null) {
            return this.mGraphics;
        }
        return selected ? this.mDrawContext.gSelected : this.mDrawContext.gMain;
    }

    protected Point getScreenOrigin() {
        APoint2D loc = new APoint2D();
        loc = loc.transform(this.mTransform);
        return this.mDrawContext.screenTransform.getScreenPt(loc);
    }

    protected boolean isDeviceInterface() {
        return false;
    }

    protected boolean isDeviceBump() {
        return this.mDevice.getType() == DeviceTemplate.Type.BUMP;
    }

    private boolean isBumpVisible() {
        boolean any = false;
        for (PinInstance pt : this.mDevice.getPins()) {
            if (pt.getLayersInUse().anyMatch(l -> this.mDrawContext.colorizer.isVisible(this.mPath, (DbObject)l))) {
                return true;
            }
            any = true;
        }
        return !any;
    }

    protected boolean isDeviceGroup() {
        return this.mDevice.isGroup();
    }

    protected static class DrawSettings {
        protected OrbitIOSettings.NetDisplayTextOpt mNetUnusedOpt = (OrbitIOSettings.NetDisplayTextOpt)Settings.get((String)"NetDisplay", (String)"NetUnusedTextOpt", (Object)OrbitIOSettings.NetDisplayTextOpt.StaticText);
        protected String mNetUnusedText = (String)Settings.get((String)"NetDisplay", (String)"NetUnusedText", (Object)"NetUnused");
        protected Font mNetUnusedFont = Font.decode((String)Settings.get((String)"NetDisplay", (String)"NetUnusedFont", (Object)""));
        protected Color mNetUnusedColor = AColor.decode((String)((String)Settings.get((String)"NetDisplay", (String)"NetUnusedColor", (Object)"")), (Color)OrbitIOSettings.ND_NETUNUSED_COLOR_DFLT);
        protected OrbitIOSettings.NetDisplayTextOpt mNetUnconnOpt = (OrbitIOSettings.NetDisplayTextOpt)Settings.get((String)"NetDisplay", (String)"NetUnconnectedTextOpt", (Object)OrbitIOSettings.NetDisplayTextOpt.StaticText);
        protected String mNetUnconnText = (String)Settings.get((String)"NetDisplay", (String)"NetUnconnectedText", (Object)"- NC -");
        protected Font mNetUnconnFont = Font.decode((String)Settings.get((String)"NetDisplay", (String)"NetUnconnectedFont", (Object)""));
        protected Color mNetUnconnColor = AColor.decode((String)((String)Settings.get((String)"NetDisplay", (String)"NetUnconnectedColor", (Object)"")), (Color)OrbitIOSettings.ND_UNCONNECTED_COLOR_DFLT);

        protected DrawSettings() {
        }
    }
}

