/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_views;

import com.google.common.collect.HashMultimap;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppEnv;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Text;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ABezierCurve;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.topology.Binner;
import com.sigrity.acl.topology.SpatialIndex2D;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIOEnv;
import com.sigrity.orbit.ui.canvas_modes.MovePlaceableItemMode;
import com.sigrity.orbit.ui.canvas_views.DefaultDeviceDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DefaultViewDrawer
implements DesignCanvas2D.ViewDrawer {
    public static final String NAME = "Default View";
    public static final APoint2D ORIGIN = new APoint2D();
    public static final Shape SYMLINE = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    public static final Stroke DASHED = new BasicStroke(1.0f, 2, 2, 1.0f, new float[]{5.0f}, 0.0f);
    protected DesignCanvas2D mCanvas;
    protected boolean mDrawNotInHierarchy = false;
    final BasicStroke highlightStroke = new BasicStroke(3.0f, 1, 1);
    public static final DesignCanvas2D.ViewDrawerFactory Factory = new DesignCanvas2D.ViewDrawerFactory(){

        @Override
        public String getName() {
            return DefaultViewDrawer.NAME;
        }

        @Override
        public boolean isAvailable(DesignCanvas2D canvas) {
            return canvas != null;
        }

        @Override
        public DesignCanvas2D.ViewDrawer create(DesignCanvas2D canvas) {
            return this.isAvailable(canvas) ? new DefaultViewDrawer(canvas) : null;
        }
    };

    public DesignCanvas2D getCanvas() {
        return this.mCanvas;
    }

    public DefaultViewDrawer(DesignCanvas2D canvas) {
        this.mCanvas = canvas;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void installDrawer(DesignCanvas2D canvas) {
    }

    @Override
    public void uninstallDrawer() {
    }

    @Override
    public void draw() {
        DrawContext context = new DrawContext(this.mCanvas);
        Db db = context.db;
        if (db != null) {
            DbHistory history = db.getHistory();
            try (DbHistory.DbTransaction transaction = history.newDbTransaction("[Auto] Canvas Drawer");
                 OrbitApp.ChangeWarningSilencer cm = OrbitApp.suppressDbChangeMonitorWarnings();){
                this.drawDevices(context);
                this.drawInterfaces(context);
                this.drawConnections(context);
                this.drawDesign(context);
                this.drawDiffPairs(context);
            }
        }
    }

    public DeviceDrawer getDeviceDrawer(DevicePath devicePath, AffineTransform parentTransform) {
        return this.getDeviceDrawer(devicePath, parentTransform, null);
    }

    public DeviceDrawer getDeviceDrawer(DevicePath devicePath, AffineTransform parentTransform, DrawContext ctx) {
        return new DefaultDeviceDrawer(this, this.mCanvas, devicePath, parentTransform, ctx);
    }

    protected void drawDesign(DrawContext context) {
        if (!context.colorizer.getShowDesignBounds()) {
            return;
        }
        if (context.design == null) {
            return;
        }
        ARect geom = context.canvas.getWorldBounds();
        if (geom == null) {
            return;
        }
        APatternColor pcolor = context.colorizer.getOriginColor(null);
        context.gMain.setColor(pcolor == null ? null : pcolor.getColor());
        Stroke oldStroke = context.gMain.getStroke();
        context.gMain.setStroke(DASHED);
        DefaultViewDrawer.paintGeom(context.gMain, (AGeom)geom, context.screenTransform, true, false);
        context.gMain.setStroke(oldStroke);
        context.gMain.setPaintMode();
    }

    public static void sortDrawDevices(List<Device> devices) {
        devices.sort((d1, d2) -> {
            int c = DeviceTemplate.CompareType.compare(d1.getTemplate(), d2.getTemplate());
            if (c != 0) {
                return c;
            }
            double r1 = d1.getTemplate().getBounds(true).getArea();
            double r2 = d2.getTemplate().getBounds(true).getArea();
            c = Double.compare(r2, r1);
            if (c != 0) {
                return c;
            }
            return d1.getName().compareTo(d2.getName());
        });
    }

    protected void drawDevices(DrawContext context) {
        boolean drawNotInHierarchy = this.mDrawNotInHierarchy || context.design == null;
        DeviceSet inHierarchy = new DeviceSet();
        if (context.design == null) {
            drawNotInHierarchy = true;
        } else {
            AffineTransform designXform = new AffineTransform();
            SpatialIndex2D childIndex = context.design.getChildSpatialIndex();
            List<Device> devices = childIndex.intersects(context.worldDrawBounds).stream().collect(Collectors.toList());
            DefaultViewDrawer.sortDrawDevices(devices);
            for (Device d : devices) {
                this.drawDevice(d, designXform, context);
                if (!drawNotInHierarchy) continue;
                inHierarchy.addHierarchy(d);
            }
        }
        if (drawNotInHierarchy) {
            DeviceSet drawnNotInHierarchy = new DeviceSet();
            boolean warningDisplayed = false;
            for (Device d : context.db.getObjects(Device.class)) {
                if (inHierarchy.contains(d) || drawnNotInHierarchy.contains(d)) continue;
                if (!warningDisplayed) {
                    ALog.logWarn((String)"Drawing devices not in the design hierarchy.");
                    warningDisplayed = true;
                }
                this.drawDevice(d, null, context);
                drawnNotInHierarchy.addHierarchy(d);
            }
        }
    }

    protected void drawDevice(Device d, AffineTransform designXform, DrawContext ctx) {
        try {
            DeviceDrawer drawer = this.getDeviceDrawer(new DevicePath(d), designXform, ctx);
            if (drawer != null) {
                drawer.draw(false);
            }
        }
        catch (Throwable t) {
            ALog.logError((Throwable)t, (String)"Failed to draw device '%s'.", (Object[])new Object[]{d.getKeyStr()});
        }
    }

    protected void drawInterfaces(DrawContext context) {
        for (Interface intf : context.db.getObjects(Interface.class)) {
            if (intf.getParent() != null) continue;
            this.drawInterface(context, intf);
        }
    }

    public void drawFloorplan(DrawContext context, Floorplan fp, DevicePath devPath, AffineTransform xForm, boolean includeNonIoPins, boolean cursorDraw) {
        DesignView2D v = (DesignView2D)UIUtil.getAncestorOfType((Component)this.mCanvas, DesignView2D.class);
        Selection.SelSet beingMoved = v.getBeingMoved().getDynamicDrawingSet();
        Interface intf = fp.getMyInterface();
        if (!cursorDraw && beingMoved != null && beingMoved.contains(devPath, (DbObject)fp)) {
            return;
        }
        if (!(intf.getIsHighlighted() || fp.getIsHighlighted() || context.colorizer.getShowInterfaces())) {
            return;
        }
        Graphics2D g = (Graphics2D)context.gMain.create();
        AGeom hull = fp.getHull(devPath, includeNonIoPins);
        Stroke defaultStroke = g.getStroke();
        if (hull == null) {
            return;
        }
        if (xForm != null) {
            hull = hull.transform(xForm);
        }
        hull = hull.transform(context.screenTransform.getWorldToScreenTransform());
        if (intf.getIsHighlighted() || fp.getIsHighlighted()) {
            g.setStroke(this.highlightStroke);
            g.setColor(intf.getColor());
            g.draw(hull.getAwtShape());
            g.setStroke(defaultStroke);
            g.setColor((Color)intf.getHullColor());
            g.fill(hull.getAwtShape());
        } else {
            g.setColor((Color)intf.getHullColor());
            if (this.mCanvas.getColorizer().getUseClassicTheme()) {
                BasicStroke dashed = new BasicStroke(4.0f, 0, 0, 10.0f, new float[]{10.0f, 2.0f}, 0.0f);
                g.setStroke(dashed);
                g.draw(hull.getAwtShape());
            } else {
                g.fill(hull.getAwtShape());
            }
        }
    }

    public void drawFloorplan(DrawContext context, Floorplan fp, boolean cursorDraw) {
        if (fp.getDeviceTemplate() == null) {
            return;
        }
        for (DevicePath devPath : fp.getDeviceTemplate().getHierarchicalInstances()) {
            this.drawFloorplan(context, fp, devPath, null, true, cursorDraw);
        }
    }

    public void drawInterface(DrawContext context, Interface intf) {
        if (intf.getColor() == null) {
            return;
        }
        if (intf.getVisibleOnScreen()) {
            for (Floorplan fp : intf.getFloorplans()) {
                this.drawFloorplan(context, fp, false);
            }
        } else {
            for (Floorplan fp : intf.getFloorplans()) {
                if (!fp.getIsHighlighted()) continue;
                this.drawFloorplan(context, fp, false);
            }
        }
        for (Interface cur : intf.getChildren()) {
            this.drawInterface(context, cur);
        }
    }

    protected void drawConnections(DrawContext context) {
        MovePlaceableItemMode mdm = null;
        DesignView2D v = (DesignView2D)UIUtil.getAncestorOfType((Component)this.mCanvas, DesignView2D.class);
        if (v != null) {
            DesignView2D.ViewMode vm = v.getMode("MovePlaceableItemMode");
            mdm = (MovePlaceableItemMode)vm;
        }
        for (Connection c : context.db.getObjects(Connection.class)) {
            if (mdm != null && mdm.isDynamicConnection(c)) continue;
            this.drawConnection(context, c);
        }
    }

    public void drawConnection(DrawContext context, Connection c) {
        this.drawConnection(context, null, c);
    }

    public void drawConnection(DrawContext context, Graphics2D graphics, Connection c) {
        if (c.getPortA() == null || c.getPortB() == null) {
            return;
        }
        APatternColor color = context.colorizer.getColor(c);
        if (color == null) {
            return;
        }
        ALine l = c.getLine();
        if (l == null) {
            return;
        }
        Graphics2D g = graphics != null ? graphics : (!context.selected.contains((DbObject)c) ? context.gMain : context.gSelected);
        g.setColor(color.getColor());
        DesignCanvas2D.XForm xForm = context.screenTransform;
        if (OrbitApp.getApp().hasEnv(OrbitIOEnv.DISPLAY_CONN_CURVE)) {
            ABezierCurve worldCurve = c.getBezierCurve();
            ABezierCurve screenCurve = worldCurve.transformBezierCurve(xForm.getWorldToScreenTransform());
            g.draw(screenCurve.getAwtShape());
            return;
        }
        Point p0 = xForm.getScreenPt(l.getP0());
        Point p1 = xForm.getScreenPt(l.getP1());
        g.drawLine(p0.x, p0.y, p1.x, p1.y);
    }

    public static List<APair<HierPin, HierPin>> getDiffPairs(Db db, Personality personality) {
        if (!personality.isDiffPairPersonality()) {
            return Collections.emptyList();
        }
        HashMap<Iterator, Net> netToNet = new HashMap<Iterator, Net>();
        HashMultimap dtToNets = HashMultimap.create();
        HashSet<DeviceTemplate> templatesWithDiffPairs = new HashSet<DeviceTemplate>();
        HashMultimap c = HashMultimap.create();
        block0: for (HierInst hNet : new StreamIterableIterator(personality.getObjects(Net.class))) {
            while (hNet != null) {
                DeviceTemplate dt = hNet.getPath().getDeviceTemplate();
                c.put((Object)dt, (Object)((Net)hNet.getDbObject()));
                HierInst topNet = NetMap.getTop((DevicePath)hNet.getPath(), (Net)((Net)hNet.getDbObject()));
                if (topNet == null || topNet.getDbObject() == hNet.getDbObject()) continue block0;
                hNet = topNet;
            }
        }
        for (DeviceTemplate dt : c.keySet()) {
            templatesWithDiffPairs.add(dt);
            Collection netSet = c.get((Object)dt);
            if (netSet.size() != 2) continue;
            LinkedList netList = new LinkedList(netSet);
            Iterator pNet = (Net)netList.get(0);
            Net nNet = (Net)netList.get(1);
            dtToNets.put((Object)dt, (Object)pNet);
            dtToNets.put((Object)dt, (Object)nNet);
            netToNet.put(pNet, nNet);
        }
        HashSet<Net> ignoredNets = new HashSet<Net>();
        HashMultimap netToPins = HashMultimap.create();
        for (DeviceTemplate dt : templatesWithDiffPairs) {
            for (DevicePath dp : dt.getHierarchicalInstances()) {
                block5: for (Net n : AUtil.linkedList((Collection)dtToNets.get((Object)dt))) {
                    int pinCount = 0;
                    for (HierPin hp : NetMap.getConnectedDevicePathPorts((Net)n, (DevicePath)dp)) {
                        PinTemplate pt = ((PinInstance)hp.second).getPinTemplate();
                        if (pt.getType() == PinTemplate.Type.CONTACT || pt.getType() == PinTemplate.Type.WIREEND || pt.getType() == PinTemplate.Type.TOPOLOGYPOINT) continue;
                        if (++pinCount > 32) {
                            Net topNet = NetMap.getTopmostNet((Net)hp.getNet(), (DevicePath)hp.getPath());
                            if (!ignoredNets.contains(topNet)) {
                                ALog.flogWarn((String)"DiffPair drawing: Ignoring Net '%s' on DeviceTemplate '%s' with more than %d connected pins.", (Object[])new Object[]{topNet.getName(), topNet.getDeviceTemplate().getName(), pinCount - 1});
                                ignoredNets.add(topNet);
                            }
                            netToPins.removeAll((Object)n);
                            continue block5;
                        }
                        netToPins.put((Object)n, (Object)hp);
                    }
                }
            }
        }
        LinkedList<APair<HierPin, HierPin>> result = new LinkedList<APair<HierPin, HierPin>>();
        for (Map.Entry entry : netToNet.entrySet()) {
            Net pNet = (Net)entry.getKey();
            Net nNet = (Net)entry.getValue();
            Collection nPins = netToPins.get((Object)nNet);
            Collection pPins = netToPins.get((Object)pNet);
            LinkedList<APair<HierPin, HierPin>> closePairs = DefaultViewDrawer.findClosePairs(nPins, pPins);
            result.addAll(closePairs);
        }
        return result;
    }

    protected void drawDiffPairs(DrawContext context) {
        if (context == null || context.db == null) {
            return;
        }
        if (context.colorizer == null || !context.colorizer.getShowDiffPair()) {
            return;
        }
        if (context.gMain == null) {
            return;
        }
        if (this.mCanvas == null) {
            return;
        }
        Graphics2D g = (Graphics2D)context.gMain.create();
        ViewColorizer colorizer = this.mCanvas.getColorizer();
        DesignCanvas2D.XForm xform = this.mCanvas.getXForm();
        BasicStroke stroke = new BasicStroke(1.0f, 1, 1);
        g.setStroke(stroke);
        for (Personality p : context.db.getObjects(Personality.class)) {
            g.setColor(p.getColor());
            for (APair<HierPin, HierPin> pinPair : DefaultViewDrawer.getDiffPairs(context.db, p)) {
                HierPin nHP = (HierPin)pinPair.first;
                HierPin pHP = (HierPin)pinPair.second;
                if (nHP.getSubstrate() != pHP.getSubstrate() || !colorizer.isVisible((HierInst)nHP) || !colorizer.isVisible((HierInst)pHP)) continue;
                ARect nRect = nHP.getWorldBounds();
                ARect pRect = pHP.getWorldBounds();
                if (nRect == null || pRect == null) continue;
                Rectangle rn = xform.getScreenRect(nRect);
                Rectangle rp = xform.getScreenRect(pRect);
                if (rn.width <= 2) continue;
                Point p1 = xform.getScreenPt(nHP.getWorldLoc());
                Point p2 = xform.getScreenPt(pHP.getWorldLoc());
                g.draw(rn);
                g.draw(rp);
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
            }
        }
    }

    protected static LinkedList<APair<HierPin, HierPin>> findClosePairs(Collection<HierPin> nPins, Collection<HierPin> pPins) {
        LinkedList<APair<HierPin, HierPin>> result = new LinkedList<APair<HierPin, HierPin>>();
        if (nPins.isEmpty() || pPins.isEmpty()) {
            return result;
        }
        HashSet<HierPin> usedPPins = new HashSet<HierPin>();
        for (HierPin nPin : nPins) {
            HierPin closestPin = null;
            long bestDist = 0L;
            for (HierPin pPin : pPins) {
                if (usedPPins.contains(pPin) || nPin.getPin().getType() != pPin.getPin().getType()) continue;
                long dist = nPin.dist(pPin);
                if (closestPin != null && dist >= bestDist) continue;
                closestPin = pPin;
                bestDist = dist;
            }
            if (closestPin == null) continue;
            result.add((APair<HierPin, HierPin>)new APair((Object)nPin, closestPin));
            usedPPins.add(closestPin);
        }
        return result;
    }

    public static Rectangle paintGeom(Graphics2D g, AGeom geom, DesignCanvas2D.XForm screenXform, boolean draw, boolean fill) {
        return DesignCanvas2D.drawGeom(g, screenXform, geom, new AffineTransform(), g.getColor(), fill);
    }

    protected static class DeviceSet
    extends HashSet<Device> {
        protected DeviceSet() {
        }

        public boolean addHierarchy(Device d) {
            this.add(d);
            for (Device child : d.getChildren()) {
                this.addHierarchy(child);
            }
            return true;
        }
    }

    public static class DrawContext {
        Db db;
        Design design;
        DesignCanvas2D canvas;
        Graphics2D gMain;
        Graphics2D gSelected;
        DesignCanvas2D.XForm screenTransform;
        ARect worldDrawBounds;
        ViewColorizer colorizer;
        Selection selected;
        HashMap<LayerShape, Boolean> layerShapesFilter;
        Map<Substrate, Boolean> substrateVisibility = new HashMap<Substrate, Boolean>();
        Map<Layer, Boolean> layerVisibility = new HashMap<Layer, Boolean>();
        Map<PadTemplate, List<Layer>> padDrawOrder = new HashMap<PadTemplate, List<Layer>>();
        Map<PadTemplate, Map<Layer, Binner<LayerShape>>> padLayerIndex = new HashMap<PadTemplate, Map<Layer, Binner<LayerShape>>>();
        protected HashMap<Object, Object> mProps = new HashMap();
        protected final long mWorldMinDrawSize;
        protected boolean mInnovusTheme = false;

        public DrawContext(DesignCanvas2D canvas) {
            this.canvas = canvas;
            this.db = canvas == null ? null : canvas.getDb();
            this.design = this.db == null ? null : Design.getDesign((Db)this.db);
            this.gMain = canvas.getGraphicsMain();
            this.gSelected = canvas.getGraphicsSelected();
            this.screenTransform = canvas.getXForm();
            this.colorizer = canvas.getColorizer();
            this.selected = canvas.getSelected();
            this.worldDrawBounds = canvas.getWorldDrawBounds();
            this.layerShapesFilter = new HashMap();
            this.mInnovusTheme = AApp.getApp().hasEnv(AAppEnv.UI_THEME_INNOVUS);
            int screenMinDrawSize = this.colorizer.getMinDrawSize();
            this.mWorldMinDrawSize = this.screenTransform.getWorldLength(screenMinDrawSize);
        }

        public void setGMain(Graphics2D val) {
            this.gMain = val;
        }

        public Object put(Object key, Object value) {
            return this.mProps.put(key, value);
        }

        public boolean containsKey(Object key) {
            return this.mProps.containsKey(key);
        }

        public Object get(Object key) {
            return this.mProps.get(key);
        }

        public <T> Optional<T> get(Object key, Class<T> type) {
            Object val = this.mProps.get(key);
            if (val == null || !type.isInstance(val)) {
                return Optional.empty();
            }
            return Optional.of(type.cast(val));
        }

        public <T> T get(Object key, Class<T> type, Supplier<T> supplier) {
            return (T)this.get(key, type).orElseGet(() -> {
                Object val = supplier.get();
                this.put(key, val);
                return val;
            });
        }

        public boolean isSubstrateVisible(Substrate s) {
            return this.substrateVisibility.computeIfAbsent(s, k -> {
                for (Layer l : k.getLayers()) {
                    if (!this.colorizer.isVisible(new DevicePath((DeviceTemplate)this.design), (DbObject)l)) continue;
                    return true;
                }
                return false;
            });
        }

        public boolean isLayerVisible(Layer l) {
            return this.layerVisibility.computeIfAbsent(l, k -> this.colorizer.isVisible(new DevicePath((DeviceTemplate)this.design), (DbObject)l));
        }

        public List<Layer> getDrawOrder(PadTemplate pt) {
            return this.padDrawOrder.computeIfAbsent(pt, k -> pt.getLayers().stream().filter(this::isLayerVisible).sorted(Layer.OrderComparator).collect(Collectors.toList()));
        }

        public Binner<LayerShape> getPadIndex(PadTemplate padTmplt, Layer layer) {
            Map index = this.padLayerIndex.computeIfAbsent(padTmplt, k -> new HashMap());
            return index.computeIfAbsent(layer, k -> {
                Binner b = new Binner();
                b.setWorld(padTmplt.getBounds(layer));
                for (LayerShape ls : padTmplt.getLayerShapes(layer)) {
                    b.insert((Object)ls, ls.getBounds());
                }
                return b;
            });
        }

        protected boolean isSmallerThanMinDrawSize(LayerShape layerShape) {
            if (this.layerShapesFilter == null) {
                return true;
            }
            if (this.mWorldMinDrawSize == 0L) {
                return false;
            }
            Boolean isSmaller = this.layerShapesFilter.get(layerShape);
            if (isSmaller != null) {
                return isSmaller;
            }
            boolean drawLayerShape = this.isSmallerThanMinDrawSize(layerShape.getGeom());
            this.layerShapesFilter.put(layerShape, drawLayerShape);
            return drawLayerShape;
        }

        protected boolean isSmallerThanMinDrawSize(AGeom geom) {
            long diameter;
            if (geom instanceof APath) {
                APath path = (APath)geom;
                diameter = Math.max(path.getLength(), path.getWidth());
            } else {
                ARect geomBounds = geom.getBounds();
                long absHeight = Math.abs(geomBounds.height());
                long absWidth = Math.abs(geomBounds.width());
                diameter = Math.max(absHeight, absWidth);
            }
            return this.isSmallerThanMinDrawSize(diameter);
        }

        protected boolean isSmallerThanMinDrawSize(long diameter) {
            if (this.mWorldMinDrawSize == 0L) {
                return false;
            }
            return diameter < this.mWorldMinDrawSize;
        }
    }

    public static interface DeviceDrawer {
        public void setGraphics(Graphics2D var1);

        public void draw(boolean var1);

        public void drawPin(PinInstance var1, boolean var2);

        public void drawWire(Wire var1, boolean var2);

        public void drawText(Text var1, boolean var2);
    }
}

