/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_views;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.ui.canvas_views.DefaultDeviceDrawer;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import java.awt.geom.AffineTransform;

public class InterfaceViewDrawer
extends DefaultViewDrawer {
    public static final String NAME = "Interface View";
    public static final DesignCanvas2D.ViewDrawerFactory Factory = new DesignCanvas2D.ViewDrawerFactory(){

        @Override
        public String getName() {
            return InterfaceViewDrawer.NAME;
        }

        @Override
        public boolean isAvailable(DesignCanvas2D canvas) {
            return canvas != null;
        }

        @Override
        public DesignCanvas2D.ViewDrawer create(DesignCanvas2D canvas) {
            return this.isAvailable(canvas) ? new InterfaceViewDrawer(canvas) : null;
        }
    };

    public InterfaceViewDrawer(DesignCanvas2D canvas) {
        super(canvas);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DefaultViewDrawer.DeviceDrawer getDeviceDrawer(DevicePath devicePath, AffineTransform parentTransform, DefaultViewDrawer.DrawContext ctx) {
        return new InterfaceViewDeviceDrawer(devicePath, parentTransform, ctx);
    }

    public static boolean isInterface(Device device) {
        return device.getTemplate().getType() == DeviceTemplate.Type.PERSONALITY;
    }

    protected class InterfaceViewDeviceDrawer
    extends DefaultDeviceDrawer {
        public InterfaceViewDeviceDrawer(DevicePath devicePath, AffineTransform parentTransform, DefaultViewDrawer.DrawContext ctx) {
            super(InterfaceViewDrawer.this, InterfaceViewDrawer.this.mCanvas, devicePath, parentTransform, ctx);
        }

        @Override
        public void draw(boolean cursorDraw) {
            if (!cursorDraw && !InterfaceViewDrawer.isInterface(this.mDevice)) {
                this.drawChildren(cursorDraw);
            } else {
                super.draw(cursorDraw);
            }
        }
    }
}

