/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_views;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ui.canvas_views.DefaultDeviceDrawer;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class PadRingViewDrawer
extends DefaultViewDrawer {
    public static final String NAME = "PadRing View";
    protected HashSet<DevicePath> mDevicePaths = new HashSet();
    protected HashSet<HierInst<Layer>> mLayers = new HashSet();
    public static final DesignCanvas2D.ViewDrawerFactory Factory = new DesignCanvas2D.ViewDrawerFactory(){

        @Override
        public String getName() {
            return PadRingViewDrawer.NAME;
        }

        @Override
        public boolean isAvailable(DesignCanvas2D canvas) {
            return canvas != null;
        }

        @Override
        public DesignCanvas2D.ViewDrawer create(DesignCanvas2D canvas) {
            if (!this.isAvailable(canvas)) {
                return null;
            }
            return new PadRingViewDrawer(canvas);
        }
    };

    public PadRingViewDrawer(DesignCanvas2D canvas) {
        super(canvas);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DefaultViewDrawer.DeviceDrawer getDeviceDrawer(DevicePath devicePath, AffineTransform parentTransform, DefaultViewDrawer.DrawContext ctx) {
        return new RoutingViewDeviceDrawer(devicePath, parentTransform, ctx);
    }

    public void setLayers(Iterator<HierInst<Layer>> layers) {
        this.mDevicePaths.clear();
        this.mLayers.clear();
        if (layers == null) {
            return;
        }
        while (layers.hasNext()) {
            this.addLayer(layers.next(), true);
        }
    }

    public void addLayer(HierInst<Layer> hl, boolean descendantDevices) {
        this.mDevicePaths.add(hl.getPath());
        this.mLayers.add(hl);
        if (!descendantDevices) {
            return;
        }
        for (DevicePath child : hl.getPath().getChildren()) {
            if (child.getSubstrate() != hl.getPath().getSubstrate()) continue;
            this.addLayer((HierInst<Layer>)new HierInst(child, (DbObject)((Layer)hl.getDbObject())), true);
        }
    }

    public void addLayer(String devicePath, String layerName) {
        if (this.mCanvas == null) {
            ALog.logError((String)"RoutingViewDrawer: Not currently associated with a DesignCanvas2D.");
            return;
        }
        Db db = this.mCanvas.getDb();
        if (db == null) {
            ALog.logError((String)"RoutingViewDrawer: Unable to get a Db from the canvas.");
            return;
        }
        DevicePath dp = DevicePath.fromString((Db)db, (String)devicePath);
        if (dp == null || dp.isEmpty()) {
            ALog.logError((String)"RoutingViewDrawer: Invalid DevicePath '%s'.", (Object[])new Object[]{devicePath});
            return;
        }
        Substrate substrate = dp.getLast().getSubstrate();
        if (substrate == null) {
            ALog.logError((String)"RoutingViewDrawer: The specified DevicePath '%s' has no susbstrate.", (Object[])new Object[]{devicePath});
            return;
        }
        Layer layer = substrate.getLayer(layerName);
        if (layer == null) {
            ALog.logError((String)"RoutingViewDrawer: The Substrate '%s' for DevicePath '%s' does not contain a Layer named '%s'.", (Object[])new Object[]{substrate.getName(), devicePath, layerName});
            return;
        }
        this.addLayer((HierInst<Layer>)new HierInst(dp, (DbObject)layer), true);
    }

    protected class RoutingViewDeviceDrawer
    extends DefaultDeviceDrawer {
        protected HashMap<Layer, Boolean> mDrawLayers;

        public RoutingViewDeviceDrawer(DevicePath devicePath, AffineTransform parentTransform, DefaultViewDrawer.DrawContext ctx) {
            super(PadRingViewDrawer.this, PadRingViewDrawer.this.mCanvas, devicePath, parentTransform, ctx);
            this.mDrawLayers = new HashMap();
        }

        protected void drawMyPins() {
            DeviceTemplate t = this.mDevice.getTemplate();
            if (t != null) {
                for (PinInstance p : this.mDevice.getPins()) {
                    PinTemplate.Type type = p.getPinTemplate().getType();
                    if (type != PinTemplate.Type.BUMPPAD && type != PinTemplate.Type.IOPAD) continue;
                    this.drawPinInst(p, false, false);
                }
            }
        }

        @Override
        protected void drawDevice(Graphics2D g, boolean cursorDraw, ARect deviceBB, boolean select) {
            APatternColor colorDevice;
            Rectangle screenBounds;
            this.drawChildren(cursorDraw);
            AGeom deviceShape = this.getDeviceShape();
            Shape screenShape = this.getScreenShape(deviceShape);
            Rectangle rectangle = screenBounds = screenShape == null ? null : screenShape.getBounds();
            if (select) {
                g.setColor(Color.WHITE);
                g.draw(screenShape);
            }
            if ((colorDevice = this.mDrawContext.colorizer.getColor(this.mPath)) == null) {
                return;
            }
            this.drawDeviceBackground(g, colorDevice, screenShape, deviceBB, select);
            this.drawGrid();
            this.drawBackgroundOutline(g, screenBounds, screenShape, select);
            this.drawMyPins();
            this.drawWires();
        }

        protected boolean drawLayer(Layer l) {
            return true;
        }

        @Override
        protected Rectangle drawPad(Graphics2D g, AffineTransform xform, LayerShape ls, Color outline, AGeom geom, boolean hollow) {
            return this.drawLayer(ls.getLayer()) ? super.drawPad(g, xform, ls, outline, geom, hollow) : null;
        }
    }
}

