/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.canvas_views;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.dbui.render.LayerListRenderer;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ui.DevicePathChooser;
import com.sigrity.orbit.ui.canvas_views.DefaultDeviceDrawer;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class RoutingViewDrawer
extends DefaultViewDrawer {
    public static final String NAME = "Routing View";
    protected HashSet<DevicePath> mDevicePaths = new HashSet();
    protected HashSet<HierInst<Layer>> mLayers = new HashSet();
    public static final DesignCanvas2D.ViewDrawerFactory Factory = new DesignCanvas2D.ViewDrawerFactory(){

        @Override
        public String getName() {
            return RoutingViewDrawer.NAME;
        }

        @Override
        public boolean isAvailable(DesignCanvas2D canvas) {
            return canvas != null;
        }

        @Override
        public DesignCanvas2D.ViewDrawer create(DesignCanvas2D canvas) {
            if (!this.isAvailable(canvas)) {
                return null;
            }
            RoutingViewDrawer rvd = new RoutingViewDrawer(canvas);
            Iterator<HierInst<Layer>> layers = LayerChooser.getLayers(canvas, canvas.getDb());
            if (layers == null) {
                return null;
            }
            rvd.setLayers(layers);
            return rvd;
        }
    };

    public RoutingViewDrawer(DesignCanvas2D canvas) {
        super(canvas);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DefaultViewDrawer.DeviceDrawer getDeviceDrawer(DevicePath devicePath, AffineTransform parentTransform, DefaultViewDrawer.DrawContext ctx) {
        return new RoutingViewDeviceDrawer(devicePath, parentTransform, ctx);
    }

    public void setLayers(Iterator<HierInst<Layer>> layers) {
        this.mDevicePaths.clear();
        this.mLayers.clear();
        if (layers == null) {
            return;
        }
        while (layers.hasNext()) {
            this.addLayer(layers.next(), true);
        }
    }

    public void addLayer(HierInst<Layer> hl, boolean descendantDevices) {
        this.mDevicePaths.add(hl.getPath());
        this.mLayers.add(hl);
        if (!descendantDevices) {
            return;
        }
        for (DevicePath child : hl.getPath().getChildren()) {
            if (child.getSubstrate() != hl.getPath().getSubstrate()) continue;
            this.addLayer((HierInst<Layer>)new HierInst(child, (DbObject)((Layer)hl.getDbObject())), true);
        }
    }

    public void addLayer(String devicePath, String layerName) {
        if (this.mCanvas == null) {
            ALog.logError((String)"RoutingViewDrawer: Not currently associated with a DesignCanvas2D.");
            return;
        }
        Db db = this.mCanvas.getDb();
        if (db == null) {
            ALog.logError((String)"RoutingViewDrawer: Unable to get a Db from the canvas.");
            return;
        }
        DevicePath dp = DevicePath.fromString((Db)db, (String)devicePath);
        if (dp == null || dp.isEmpty()) {
            ALog.logError((String)"RoutingViewDrawer: Invalid DevicePath '%s'.", (Object[])new Object[]{devicePath});
            return;
        }
        Substrate substrate = dp.getSubstrate();
        if (substrate == null) {
            ALog.logError((String)"RoutingViewDrawer: The specified DevicePath '%s' has no susbstrate.", (Object[])new Object[]{devicePath});
            return;
        }
        Layer layer = substrate.getLayer(layerName);
        if (layer == null) {
            ALog.logError((String)"RoutingViewDrawer: The Substrate '%s' for DevicePath '%s' does not contain a Layer named '%s'.", (Object[])new Object[]{substrate.getName(), devicePath, layerName});
            return;
        }
        this.addLayer((HierInst<Layer>)new HierInst(dp, (DbObject)layer), true);
    }

    public static class LayerChooser
    extends ADialog {
        protected DevicePathChooser.Panel mDeviceChooser;
        protected JList<Layer> mLstLayers;
        protected JList<HierInst<Layer>> mLstSelectedLayers;
        protected boolean userOked = false;
        protected Substrate mCurSubstrate = null;
        protected DevicePathChooser.Panel.ChooserListener mDevicePathListener = new DevicePathChooser.Panel.ChooserListener(){

            @Override
            public void pathSelected(DevicePath p) {
                Substrate newSubst = p.getDevice().getSubstrate();
                if (newSubst == null || newSubst == mCurSubstrate) {
                    mLstLayers.clearSelection();
                    return;
                }
                DefaultListModel layers = (DefaultListModel)mLstLayers.getModel();
                layers.clear();
                for (Layer layer : newSubst.getLayers(Layer.TopFirstSort)) {
                    layers.addElement(layer);
                }
            }

            @Override
            public void pathActivated(DevicePath p) {
            }
        };
        protected MouseAdapter mLayerMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2 || e.getButton() != 1 || e.isPopupTrigger()) {
                    return;
                }
                DevicePath curDevPath = mDeviceChooser.getSelectedPath();
                if (curDevPath == null) {
                    return;
                }
                for (Layer layer : mLstLayers.getSelectedValuesList()) {
                    HierInst hl = new HierInst(curDevPath, (DbObject)layer);
                    DefaultListModel selLayers = (DefaultListModel)mLstSelectedLayers.getModel();
                    if (!selLayers.contains(hl)) {
                        selLayers.addElement(hl);
                    }
                    mLstSelectedLayers.setSelectedValue(hl, true);
                }
            }
        };
        protected DefaultListCellRenderer mSelLayerListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                HierInst hl = (HierInst)value;
                String s = String.format("%s/%s", hl.getPath().toString(), ((Layer)hl.getDbObject()).getName());
                this.setText(s);
                return this;
            }
        };
        protected MouseAdapter mSelLayerMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2 || e.getButton() != 1 || e.isPopupTrigger()) {
                    return;
                }
                for (HierInst<Layer> hl : mLstSelectedLayers.getSelectedValuesList()) {
                    ((DefaultListModel)mLstSelectedLayers.getModel()).removeElement(hl);
                }
            }
        };

        public static Iterator<HierInst<Layer>> getLayers(Component owner, Db db) {
            LayerChooser dlg = new LayerChooser(owner, db);
            dlg.setVisible(true);
            List<HierInst<Layer>> selLayers = dlg.getSelectedLayers();
            if (selLayers == null) {
                return null;
            }
            return selLayers.iterator();
        }

        public LayerChooser(Component owner, Db db) {
            super(owner);
            this.setTitle("Select Device Layers");
            this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            ASplitPane outerSplit = (ASplitPane)l.add((Component)new ASplitPane(0), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            ASplitPane innerSplit = new ASplitPane();
            outerSplit.setTopComponent(innerSplit);
            this.mDeviceChooser = new DevicePathChooser.Panel(db);
            innerSplit.setLeftComponent(new JScrollPane(this.mDeviceChooser));
            this.mLstLayers = new JList(new DefaultListModel());
            innerSplit.setRightComponent(new JScrollPane(this.mLstLayers));
            this.mLstLayers.setCellRenderer(new LayerListRenderer());
            this.mLstLayers.addMouseListener(this.mLayerMouseAdapter);
            JPanel btm = new JPanel();
            outerSplit.setBottomComponent(btm);
            GridBagManager lBtm = GridBagManager.layout((Container)btm);
            lBtm.addNl("Selected Device Layers:");
            this.mLstSelectedLayers = new JList(new DefaultListModel());
            lBtm.add((Component)new JScrollPane(this.mLstSelectedLayers), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLstSelectedLayers.setCellRenderer(this.mSelLayerListCellRenderer);
            this.mLstSelectedLayers.addMouseListener(this.mSelLayerMouseAdapter);
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            this.mDeviceChooser.setDb(db);
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (mLstSelectedLayers.getModel().getSize() == 0) {
                        JOptionPane.showMessageDialog((Component)((Object)this), "At least one layer must be selected", this.getTitle(), 1);
                        return;
                    }
                    userOked = true;
                    UIUtil.closeWindow((Window)((Object)this));
                }
            });
        }

        public void addNotify() {
            super.addNotify();
            this.mDeviceChooser.addChooserListener(this.mDevicePathListener);
        }

        public List<HierInst<Layer>> getSelectedLayers() {
            if (!this.userOked) {
                return null;
            }
            LinkedList<HierInst<Layer>> result = new LinkedList<HierInst<Layer>>();
            ListModel<HierInst<Layer>> lm = this.mLstSelectedLayers.getModel();
            for (int i = 0; i < lm.getSize(); ++i) {
                result.add(lm.getElementAt(i));
            }
            return result;
        }
    }

    protected class RoutingViewDeviceDrawer
    extends DefaultDeviceDrawer {
        protected HashMap<Layer, Boolean> mDrawLayers;

        public RoutingViewDeviceDrawer(DevicePath devicePath, AffineTransform parentTransform, DefaultViewDrawer.DrawContext ctx) {
            super(RoutingViewDrawer.this, RoutingViewDrawer.this.mCanvas, devicePath, parentTransform, ctx);
            this.mDrawLayers = new HashMap();
        }

        @Override
        protected void drawDevice(Graphics2D g, boolean cursorDraw, ARect deviceBB, boolean select) {
            APatternColor colorDevice;
            Rectangle screenBounds;
            if (RoutingViewDrawer.this.mDevicePaths.contains(this.mPath)) {
                this.drawMetals();
                this.drawObstacles();
                this.drawPins();
                this.drawWires();
            }
            this.drawChildren(cursorDraw);
            AGeom deviceShape = this.getDeviceShape();
            Shape screenShape = this.getScreenShape(deviceShape);
            Rectangle rectangle = screenBounds = screenShape == null ? null : screenShape.getBounds();
            if (select) {
                g.setColor(Color.WHITE);
                g.draw(screenShape);
            }
            if ((colorDevice = this.mDrawContext.colorizer.getColor(this.mPath)) == null) {
                return;
            }
            this.drawGrid();
            this.drawBackgroundOutline(g, screenBounds, screenShape, select);
        }

        @Override
        protected void drawMetal(Metal metal) {
            if (this.drawLayer(metal.getLayer())) {
                super.drawMetal(metal);
            }
        }

        @Override
        protected void drawObstacles() {
            DeviceTemplate t = this.mDevice.getTemplate();
            if (t == null) {
                return;
            }
            for (Obstacle obstacle : t.getObstacles()) {
                for (LayerShape ls : obstacle.getLayerShapes()) {
                    APatternColor c;
                    if (!this.drawLayer(ls.getLayer()) || (c = this.mDrawContext.colorizer.getColor(this.mPath, obstacle, ls.getLayer())) == null) continue;
                    boolean select = this.isSelected((DbObject)obstacle) || this.isSelected((DbObject)ls);
                    Graphics2D g = this.getDrawGraphics(select);
                    super.drawObstacleShape(g, obstacle, ls);
                }
            }
        }

        protected boolean drawLayer(Layer l) {
            if (!this.mDrawLayers.containsKey(l)) {
                this.mDrawLayers.put(l, RoutingViewDrawer.this.mLayers.contains(new HierInst(this.mPath, (DbObject)l)));
            }
            Boolean b = this.mDrawLayers.get(l);
            assert (b != null);
            return b;
        }

        @Override
        protected Rectangle drawPad(Graphics2D g, AffineTransform xform, LayerShape ls, Color outline, AGeom geom, boolean hollow) {
            return this.drawLayer(ls.getLayer()) ? super.drawPad(g, xform, ls, outline, geom, hollow) : null;
        }

        @Override
        protected boolean drawWire(Graphics2D g, Wire w, Color outline, boolean hollow) {
            if (!this.drawLayer(w.getLayer())) {
                return false;
            }
            return super.drawWire(g, w, outline, hollow);
        }
    }
}

