/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.common;

import com.google.common.collect.Lists;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.DevicePath;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceTree
extends JTree {
    protected PopupMenuHandler mPopupMenuHandler = null;
    protected MouseListener mMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DeviceTree.this.popupMenu(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DeviceTree.this.popupMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DeviceTree.this.popupMenu(e);
            }
        }
    };

    public DeviceTree(Design d) {
        super((TreeModel)((Object)new Model(d)));
        this.init();
        UIUtil.expandTreeLevels((JTree)this, (int)1);
    }

    public DeviceTree(DevicePath path) {
        super((TreeModel)((Object)new Model(path)));
        this.init();
        UIUtil.expandTreeAll((JTree)this);
    }

    protected void init() {
        this.setCellRenderer((TreeCellRenderer)((Object)new CellRenderer()));
        this.setShowsRootHandles(true);
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(this.mMouseListener);
    }

    public Model getModel() {
        return (Model)((Object)super.getModel());
    }

    public TreePath getTreePath(DevicePath path) {
        if (path.getRoot() != this.getModel().getRoot().getRoot()) {
            return null;
        }
        TreePath tp = new TreePath((Object)this.getModel().getRoot());
        for (Device d : path) {
            AbstractNode n = (AbstractNode)((Object)tp.getLastPathComponent());
            DeviceNode childNode = n.getChild(d);
            if (childNode == null) {
                return null;
            }
            tp = tp.pathByAddingChild((Object)childNode);
        }
        return tp;
    }

    public Model getDeviceTreeModel() {
        return this.getModel();
    }

    public void setSelectedDevicePath(DevicePath path) {
        TreePath tp = this.getTreePath(path);
        this.setSelectionPath(tp);
    }

    public DevicePath getSelectedDevicePath() {
        TreePath tp = this.getSelectionPath();
        if (tp == null) {
            return null;
        }
        DevicePath res = new DevicePath(((RootNode)((Object)tp.getPathComponent((int)0))).mRoot);
        for (int i = 1; i < tp.getPathCount(); ++i) {
            Object o = tp.getPathComponent(i);
            if (!(o instanceof DeviceNode)) continue;
            res.add(((DeviceNode)((Object)o)).mDevice);
        }
        return res;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (d != null) {
            d = new Dimension(this.getPreferredWidth(d.width), d.height);
        }
        return d;
    }

    protected int getPreferredWidth(int defWidth) {
        RootNode root = this.getModel().getRoot();
        if (root instanceof RootNode && root.mPath == null) {
            return 2 * defWidth;
        }
        return defWidth;
    }

    public void setPopupMenuHandler(PopupMenuHandler h) {
        this.mPopupMenuHandler = h;
    }

    protected void popupMenu(MouseEvent e) {
        int row = this.getRowForLocation(e.getX(), e.getY());
        this.setSelectionRow(row);
        if (this.mPopupMenuHandler != null) {
            this.mPopupMenuHandler.handlePopup(e.getX(), e.getY());
        }
    }

    public static class CellRenderer
    extends ATreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, null, sel, expanded, leaf, row, hasFocus);
            AbstractNode node = (AbstractNode)((Object)value);
            this.setText(node.getText());
            this.setIcon(node.getIcon());
            this.setToolTipText(node.getToolTipText());
            return this;
        }
    }

    public static class DeviceNode
    extends AbstractNode {
        Device mDevice;
        DevicePath mPath = null;

        public DeviceNode(AbstractNode parent, Device device) {
            super((ATreeNode)parent);
            this.mDevice = device;
        }

        public DeviceNode(AbstractNode parent, DevicePath path) {
            super((ATreeNode)parent);
            this.mDevice = path.isEmpty() ? null : path.getFirst();
            this.mPath = path;
        }

        public Device getDevice() {
            return this.mDevice;
        }

        public Icon getIcon() {
            return DbExplorerPanel.getIconForDevice(this.getDevice());
        }

        public String getText() {
            Device d = this.getDevice();
            return d == null ? null : d.getName();
        }

        @Override
        public String getToolTipText() {
            Device d = this.getDevice();
            return d == null ? null : String.format("%s (%s)", d.getName(), d.getTemplate().getName());
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList children = Lists.newArrayList();
            if (this.mPath != null) {
                if (this.mPath.size() > 1) {
                    children.add(new DeviceNode((AbstractNode)this, this.mPath.getSubPath(1, this.mPath.size())));
                }
            } else {
                for (Device d : this.mDevice.getChildren()) {
                    children.add(new DeviceNode((AbstractNode)this, d));
                }
            }
            return children;
        }
    }

    public static class RootNode
    extends AbstractNode {
        DeviceTemplate mRoot;
        DevicePath mPath = null;

        public RootNode(Model model, DeviceTemplate root) {
            super(model);
            this.mRoot = root;
        }

        public RootNode(Model model, DevicePath path) {
            super(model);
            this.mRoot = path.getRoot();
            this.mPath = path;
        }

        public DeviceTemplate getRoot() {
            return this.mRoot;
        }

        public Icon getIcon() {
            return DbExplorerPanel.getIconForTemplate(this.mRoot);
        }

        public String getText() {
            return this.mRoot.getName();
        }

        @Override
        public String getToolTipText() {
            if (this.mRoot instanceof Design) {
                return this.mRoot.getDb().getDescription(true);
            }
            return String.format("DeviceTemplate: %s", this.mRoot.getName());
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList children = Lists.newArrayList();
            if (this.mPath != null) {
                children.add(new DeviceNode((AbstractNode)this, this.mPath));
            } else {
                for (Device d : this.mRoot.getChildren()) {
                    children.add(new DeviceNode((AbstractNode)this, d));
                }
            }
            return children;
        }
    }

    public class BondFingersNode
    extends AbstractNode {
        public static final String NodeName = "Bond Fingers";
        protected int mRing;
        protected int mQuad;
        protected ArrayList<ATreeNode> mLocalChildren;

        public BondFingersNode topNode(ATreeNode parent) {
            return new BondFingersNode(parent, null, null);
        }

        public BondFingersNode forRing(ATreeNode parent, int ring) {
            return new BondFingersNode(parent, ring, null);
        }

        public BondFingersNode forQuad(ATreeNode parent, int quad) {
            return new BondFingersNode(parent, null, quad);
        }

        public BondFingersNode forRingQuad(ATreeNode parent, int ring, int quad) {
            return new BondFingersNode(parent, ring, quad);
        }

        protected BondFingersNode(ATreeNode parent, Integer ring, Integer quad) {
            super(parent);
            this.mRing = Integer.MIN_VALUE;
            this.mQuad = Integer.MIN_VALUE;
            this.mLocalChildren = Lists.newArrayList();
            if (ring != null) {
                this.mRing = ring;
            }
            if (quad != null) {
                this.mQuad = quad;
            }
        }

        public void addChild(ATreeNode child) {
            this.mLocalChildren.add(child);
        }

        public Icon getIcon() {
            return DBEResources.ICON_BONDFINGERS;
        }

        public String getText() {
            String t = "";
            if (this.mRing != Integer.MIN_VALUE) {
                t = AUtil.appendTextWithSep((String)t, (String)" ", (String)("Ring " + this.mRing));
            }
            if (this.mQuad != Integer.MIN_VALUE) {
                t = AUtil.appendTextWithSep((String)t, (String)" ", (String)AGeomUtil.quadToSideString((int)this.mQuad));
            }
            if (t.length() == 0) {
                t = NodeName;
            }
            return t;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            return this.mLocalChildren;
        }
    }

    public static abstract class AbstractNode
    extends ALazyTreeNode {
        public AbstractNode(Model model) {
            super((ATreeModel)model);
        }

        public AbstractNode(ATreeNode parent) {
            super(parent);
        }

        public Model getTreeModel() {
            return (Model)super.getTreeModel();
        }

        public abstract String getToolTipText();

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public DeviceNode getChild(Device d) {
            this.populateChildrenAsNeeded();
            for (ATreeNode n : this.mChildren) {
                if (!(n instanceof DeviceNode) || ((DeviceNode)n).getDevice() != d) continue;
                return (DeviceNode)n;
            }
            return null;
        }
    }

    public static class Model
    extends ATreeModel {
        public Model(Design d) {
            this.setRoot((TreeNode)((Object)new RootNode(this, (DeviceTemplate)d)));
        }

        public Model(DevicePath path) {
            this.setRoot((TreeNode)((Object)new RootNode(this, path)));
        }

        public RootNode getRoot() {
            return (RootNode)((Object)super.getRoot());
        }
    }

    public static interface PopupMenuHandler {
        public void handlePopup(int var1, int var2);
    }
}

