/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.common;

import com.google.common.collect.Lists;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.APair;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AggregateIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.NestedIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATree;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.DevicePath;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HierarchyChooser
extends JPanel {
    private Db mDb;
    protected Tree mTree;
    protected HashSet<DevicePath> mSelected = new HashSet();

    public HierarchyChooser(Design design) {
        this.mDb = design.getDb();
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mTree = new Tree(design);
        JScrollPane sp = new JScrollPane((Component)((Object)this.mTree));
        l.add((Component)sp, (GridBagConstraints)GridBagManager.FILLALL);
    }

    public IterableIterator<DevicePath> getSelectedPaths() {
        RootNode r = (RootNode)((Object)this.mTree.getModel().getRoot());
        APair<Integer, Integer> ds = HierarchyChooser.getDescendantsAndSelectedCount((JTree)((Object)this.mTree), r);
        if (((Integer)ds.first).equals(ds.second)) {
            return null;
        }
        if ((Integer)ds.second == 0) {
            return AEmptyItr.create();
        }
        AEmptyItr rootItr = r.getSelected() ? new ASingletonItr((Object)Design.getDesignPath((Db)this.mDb)) : AEmptyItr.create();
        ProcessingIterator<Node, DevicePath> descendantItr = new ProcessingIterator<Node, DevicePath>(HierarchyChooser.getDescendants((JTree)((Object)this.mTree), r)){

            protected DevicePath process(Node o) {
                if (!(o instanceof DevNode)) {
                    return null;
                }
                if (!o.getSelected()) {
                    return null;
                }
                return ((DevNode)o).getPath();
            }
        };
        return new AggregateIterator((Iterator)rootItr, (Iterator)descendantItr);
    }

    public static IterableIterator<Node> getChildren(final JTree tree, final Node node) {
        return new IterableIterator<Node>(){
            int next = 0;
            int count = tree.getModel().getChildCount((Object)node);

            public boolean hasNext() {
                return this.next < this.count;
            }

            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return (Node)((Object)tree.getModel().getChild((Object)node, this.next++));
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Iterator<Node> iterator() {
                return this;
            }
        };
    }

    public static IterableIterator<Node> getDescendants(final JTree tree, Node node) {
        IterableIterator<Node> i1 = HierarchyChooser.getChildren(tree, node);
        NestedIterator<Node, Node> i2 = new NestedIterator<Node, Node>(HierarchyChooser.getChildren(tree, node)){

            public Iterator<Node> getLowerIterator(Node upper) {
                return HierarchyChooser.getDescendants(tree, upper);
            }
        };
        return new AggregateIterator(i1, (Iterator)i2);
    }

    public static APair<Integer, Integer> getDescendantsAndSelectedCount(JTree tree, Node node) {
        TreeModel model = tree.getModel();
        int descendants = 0;
        int selected = 0;
        for (int i = 0; i < model.getChildCount((Object)node); ++i) {
            Node child = (Node)((Object)model.getChild((Object)node, i));
            if (child.getSelectable()) {
                ++descendants;
                if (child.getSelected()) {
                    ++selected;
                }
            }
            APair<Integer, Integer> ds = HierarchyChooser.getDescendantsAndSelectedCount(tree, child);
            descendants += ((Integer)ds.first).intValue();
            selected += ((Integer)ds.second).intValue();
        }
        return new APair((Object)descendants, (Object)selected);
    }

    public static void setDescendantsSelected(JTree tree, Node node, boolean selected, boolean includeNode) {
        if (includeNode) {
            node.setSelected(selected);
        }
        TreeModel model = tree.getModel();
        for (int i = 0; i < model.getChildCount((Object)node); ++i) {
            Node child = (Node)((Object)model.getChild((Object)node, i));
            HierarchyChooser.setDescendantsSelected(tree, child, selected, true);
        }
        tree.repaint();
    }

    public static void setChildrenSelected(JTree tree, Node node, boolean selected) {
        TreeModel model = tree.getModel();
        for (int i = 0; i < model.getChildCount((Object)node); ++i) {
            Node child = (Node)((Object)model.getChild((Object)node, i));
            child.setSelected(selected);
        }
        tree.repaint();
    }

    public static Icon getIcon(String name) {
        return UIUtil.getIcon(HierarchyChooser.class, (String)name);
    }

    public static class CellRenderer
    extends JPanel
    implements TreeCellRenderer {
        protected Icon mSelectionOverlay = null;
        protected ATreeCellRenderer mDelegate = new ATreeCellRenderer(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (mSelectionOverlay != null && !mCheckBox.isVisible()) {
                    int x = this.getX();
                    int y = this.getY() + this.getHeight() - mSelectionOverlay.getIconHeight();
                    mSelectionOverlay.paintIcon((Component)((Object)this), g, x, y);
                }
            }
        };
        protected JCheckBox mCheckBox = new JCheckBox(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (mSelectionOverlay != null) {
                    int x = mCheckBox.getX() + mCheckBox.getWidth() - mSelectionOverlay.getIconWidth();
                    int y = mCheckBox.getY() + mCheckBox.getHeight() - mSelectionOverlay.getIconHeight();
                    mSelectionOverlay.paintIcon(mCheckBox, g, x, y);
                }
            }
        };
        protected final Icon ICONOVERLAY_SELECTED = HierarchyChooser.getIcon("res/idecorSel.png");
        protected final Icon ICONOVERLAY_ALLSELECTED = HierarchyChooser.getIcon("res/idecorAll.png");
        protected final Icon ICONOVERLAY_SOMESELECTED = HierarchyChooser.getIcon("res/idecorSome.png");
        protected final Icon ICONOVERLAY_NONESELECTED = HierarchyChooser.getIcon("res/idecorNone.png");

        public CellRenderer() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.setBackground(new Color(0, 0, 0, 0));
            this.mCheckBox.setOpaque(false);
            this.mCheckBox.setBackground(new Color(0, 0, 0, 0));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component renderer = this.mDelegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Node node = (Node)((Object)value);
            boolean nodeSel = node.getSelected();
            this.mCheckBox.setSelected(nodeSel);
            this.mCheckBox.setEnabled(node.getSelectable());
            this.mCheckBox.setVisible(node.getSelectable());
            APair<Integer, Integer> ds = HierarchyChooser.getDescendantsAndSelectedCount(tree, node);
            this.mSelectionOverlay = !nodeSel && (Integer)ds.second == 0 ? null : ((Integer)ds.first == 0 ? (nodeSel ? this.ICONOVERLAY_SELECTED : null) : (((Integer)ds.first).equals(ds.second) ? this.ICONOVERLAY_ALLSELECTED : ((Integer)ds.second > 0 ? this.ICONOVERLAY_SOMESELECTED : this.ICONOVERLAY_NONESELECTED)));
            this.removeAll();
            this.add((Component)this.mCheckBox, "West");
            this.add(renderer, "Center");
            return this;
        }
    }

    public static class BondFingersNode
    extends Node {
        protected int mRing = Integer.MIN_VALUE;
        protected int mQuad = Integer.MIN_VALUE;
        protected ArrayList<ATreeNode> mLocalChildren = Lists.newArrayList();

        public BondFingersNode(Node parent, Integer ring, Integer quad) {
            super((ATreeNode)parent);
            if (ring != null) {
                this.mRing = ring;
            }
            if (quad != null) {
                this.mQuad = quad;
            }
        }

        public void addChild(ATreeNode child) {
            this.mLocalChildren.add(child);
        }

        public Icon getIcon() {
            return DBEResources.ICON_BONDFINGERS;
        }

        public String getText() {
            String t = "";
            if (this.mRing != Integer.MIN_VALUE) {
                t = AUtil.appendTextWithSep((String)t, (String)" ", (String)("Ring " + this.mRing));
            }
            if (this.mQuad != Integer.MIN_VALUE) {
                t = AUtil.appendTextWithSep((String)t, (String)" ", (String)AGeomUtil.quadToSideString((int)this.mQuad));
            }
            return t;
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            return this.mLocalChildren;
        }

        @Override
        public boolean getSelectable() {
            return false;
        }

        @Override
        public boolean getSelected() {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ATreeNode o = this.getChildAt(i);
                if (!(o instanceof Node) || ((Node)o).getSelected()) continue;
                return false;
            }
            return true;
        }
    }

    public static class DevNode
    extends Node {
        protected DevicePath mPath;

        public DevNode(ATreeNode parent, DevicePath path) {
            super(parent);
            this.mPath = path;
        }

        public DevicePath getPath() {
            return this.mPath;
        }

        public Device getDevice() {
            return this.mPath == null ? null : this.mPath.getLast();
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList c = Lists.newArrayList();
            for (Device d : this.mPath.getLast().getChildren()) {
                c.add(new DevNode((ATreeNode)this, new DevicePath(this.mPath, d)));
            }
            Collections.sort(c);
            return c;
        }

        public String getText() {
            return this.mPath.toString();
        }

        public Icon getIcon() {
            return DbExplorerPanel.getIconForDevice(this.mPath.getLast());
        }
    }

    public static class RootNode
    extends Node {
        public RootNode(Model m) {
            super(m);
        }

        public ArrayList<? extends ATreeNode> populateChildren() {
            ArrayList c = Lists.newArrayList();
            for (Device d : this.getModel().getDesign().getChildren()) {
                c.add(new DevNode((ATreeNode)this, new DevicePath(d)));
            }
            Collections.sort(c);
            return c;
        }

        public String getText() {
            return this.getModel().getDesign().getName();
        }

        public Icon getIcon() {
            return DbExplorerPanel.getIconForTemplate((DeviceTemplate)this.getModel().getDesign());
        }
    }

    public static abstract class Node
    extends ALazyTreeNode {
        protected boolean mSelected = true;

        public Node(ATreeModel owner) {
            super(owner);
            this.setSortChildren(false);
        }

        public Node(ATreeNode parent) {
            super(parent);
            this.setSortChildren(false);
        }

        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public void setSelected(boolean s) {
            this.mSelected = s;
        }

        public boolean getSelected() {
            return this.mSelected;
        }

        public Model getModel() {
            return (Model)this.getTreeModel();
        }

        public boolean getSelectable() {
            return true;
        }
    }

    public static class Model
    extends ATreeModel {
        protected Design mDesign;

        public Model(Design d) {
            this.mDesign = d;
            this.setRoot((TreeNode)((Object)new RootNode(this)));
        }

        public Design getDesign() {
            return this.mDesign;
        }
    }

    public static class Tree
    extends ATree {
        protected Action mSelectAll = new AbstractAction("Select All"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootNode r = (RootNode)((Object)this.getModel().getRoot());
                if (r != null) {
                    HierarchyChooser.setDescendantsSelected((JTree)((Object)this), r, true, true);
                }
            }
        };
        protected Action mDeselectAll = new AbstractAction("Deselect All"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootNode r = (RootNode)((Object)this.getModel().getRoot());
                if (r != null) {
                    HierarchyChooser.setDescendantsSelected((JTree)((Object)this), r, false, true);
                }
            }
        };

        public Tree(Design design) {
            super((ATreeModel)new Model(design));
            this.setCellRenderer(new CellRenderer());
            this.getSelectionModel().setSelectionMode(1);
        }

        public Model getModel() {
            return (Model)super.getModel();
        }

        protected void processMouseEvent(MouseEvent e) {
            TreePath path = this.getPathForLocation(e.getX(), e.getY());
            if (path != null) {
                Rectangle pb = this.getPathBounds(path);
                Point rendererPoint = new Point(e.getX() - pb.x, e.getY() - pb.y);
                CellRenderer cr = (CellRenderer)this.getCellRenderer();
                if (cr.mCheckBox.contains(rendererPoint) && this.processCbMouseEvent(path, e)) {
                    return;
                }
            }
            super.processMouseEvent(e);
            if (e.isPopupTrigger()) {
                TreePath p = this.getPathForLocation(e.getX(), e.getY());
                Node n = p == null ? null : (Node)((Object)p.getLastPathComponent());
                LinkedList<JMenuItem> menuItems = new LinkedList<JMenuItem>();
                menuItems.add(new JMenuItem(this.mSelectAll));
                menuItems.add(new JMenuItem(this.mDeselectAll));
                if (n != null) {
                    int childCount = n.getChildCount();
                    APair<Integer, Integer> ds = HierarchyChooser.getDescendantsAndSelectedCount((JTree)((Object)this), n);
                    if ((Integer)ds.first > childCount) {
                        menuItems.add(this.createNodeMenuItem(n, "Select All Descendants", node -> HierarchyChooser.setDescendantsSelected((JTree)((Object)this), node, true, false)));
                        menuItems.add(this.createNodeMenuItem(n, "Deselect All Descendants", node -> HierarchyChooser.setDescendantsSelected((JTree)((Object)this), node, false, false)));
                    }
                    if (childCount > 0) {
                        menuItems.add(this.createNodeMenuItem(n, "Select All Children", node -> HierarchyChooser.setChildrenSelected((JTree)((Object)this), node, true)));
                        menuItems.add(this.createNodeMenuItem(n, "Deselect All Children", node -> HierarchyChooser.setChildrenSelected((JTree)((Object)this), node, false)));
                    }
                }
                if (!menuItems.isEmpty()) {
                    JPopupMenu m = new JPopupMenu();
                    for (JMenuItem mi : menuItems) {
                        if (mi == null) {
                            m.addSeparator();
                            continue;
                        }
                        m.add(mi);
                        UIUtil.setUniqueMnemonic((JPopupMenu)m, (AbstractButton)mi);
                    }
                    m.show((Component)((Object)this), e.getX(), e.getY());
                }
            }
        }

        protected Action createNodeAction(final Node n, String name, final NodeRunnable r) {
            return new AbstractAction(name){

                @Override
                public void actionPerformed(ActionEvent e) {
                    r.run(n);
                }
            };
        }

        protected JMenuItem createNodeMenuItem(Node n, String name, NodeRunnable r) {
            return new JMenuItem(this.createNodeAction(n, name, r));
        }

        protected boolean processCbMouseEvent(TreePath path, MouseEvent me) {
            int meId = me.getID();
            int meButton = me.getButton();
            int clicks = me.getClickCount();
            if (meId == 500 && meButton == 1) {
                Node node = (Node)((Object)path.getLastPathComponent());
                if (clicks == 1) {
                    node.setSelected(!node.getSelected());
                }
                if (clicks == 2 || clicks == 1 && (me.getModifiersEx() & 0x80) != 0) {
                    boolean sel = node instanceof BondFingersNode ? !node.getSelected() : node.getSelected();
                    HierarchyChooser.setDescendantsSelected((JTree)((Object)this), node, sel, false);
                }
                this.repaint();
                return true;
            }
            return meId == 501 && meButton == 1;
        }

        public static interface NodeRunnable {
            public void run(Node var1);
        }
    }
}

