/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.common;

import com.sigrity.acl.ui.ADialog;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class KeyBindingUI {
    private KeyBindingUI() {
    }

    public static void showUI() {
        KeyBindingMenu kbm = new KeyBindingMenu(OrbitIO.getMainWindow(), "Show Active Key Bindings");
        kbm.setVisible(true);
        kbm.setLocationByPreferWindow();
    }

    static void addKeyList(InputMap map, KeyStroke[] keys, TreeMap<String, HashSet<KeyStroke>> keySet) {
        if (keys == null) {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            while (map.get(keys[i]) == null) {
                map = map.getParent();
            }
            if (!(map.get(keys[i]) instanceof String)) continue;
            String actionName = (String)map.get(keys[i]);
            HashSet<KeyStroke> kss = keySet.get(actionName);
            if (kss == null) {
                kss = new HashSet();
            }
            kss.add(keys[i]);
            keySet.put(actionName, kss);
        }
    }

    static String keyStroke2String(KeyStroke key) {
        ArrayList<Object> t = new ArrayList<Object>();
        int m = key.getModifiers();
        if ((m & 0x82) != 0) {
            t.add("Ctrl");
        }
        if ((m & 0x208) != 0) {
            t.add("Alt");
        }
        if ((m & 0x104) != 0) {
            t.add("Meta");
        }
        if ((m & 0x41) != 0) {
            t.add("Shift");
        }
        switch (key.getKeyEventType()) {
            case 400: {
                t.add("" + key.getKeyChar());
                break;
            }
            case 401: {
                t.add(KeyEvent.getKeyText(key.getKeyCode()));
                break;
            }
            case 402: {
                t.add(KeyBindingUI.getKeyText(key.getKeyChar()));
                break;
            }
        }
        return String.join((CharSequence)" + ", t);
    }

    static String getKeyText(int keyCode) {
        if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
            return String.valueOf((char)keyCode);
        }
        switch (keyCode) {
            case 44: {
                return "COMMA";
            }
            case 46: {
                return ".";
            }
            case 47: {
                return "SLASH";
            }
            case 59: {
                return "SEMICOLON";
            }
            case 61: {
                return "EQUALS";
            }
            case 91: {
                return "OPEN_BRACKET";
            }
            case 92: {
                return "BACK_SLASH";
            }
            case 93: {
                return "CLOSE_BRACKET";
            }
            case 10: {
                return "ENTER";
            }
            case 8: {
                return "BACK_SPACE";
            }
            case 9: {
                return "TAB";
            }
            case 3: {
                return "CANCEL";
            }
            case 12: {
                return "CLEAR";
            }
            case 16: {
                return "SHIFT";
            }
            case 17: {
                return "CONTROL";
            }
            case 18: {
                return "ALT";
            }
            case 19: {
                return "PAUSE";
            }
            case 20: {
                return "CAPS_LOCK";
            }
            case 27: {
                return "ESCAPE";
            }
            case 32: {
                return "SPACE";
            }
            case 33: {
                return "PAGE_UP";
            }
            case 34: {
                return "PAGE_DOWN";
            }
            case 35: {
                return "END";
            }
            case 36: {
                return "HOME";
            }
            case 37: {
                return "LEFT";
            }
            case 38: {
                return "UP";
            }
            case 39: {
                return "RIGHT";
            }
            case 40: {
                return "DOWN";
            }
            case 106: {
                return "MULTIPLY";
            }
            case 107: {
                return "ADD";
            }
            case 108: {
                return "SEPARATOR";
            }
            case 109: {
                return "SUBTRACT";
            }
            case 110: {
                return "DECIMAL";
            }
            case 111: {
                return "DIVIDE";
            }
            case 127: {
                return "DELETE";
            }
            case 144: {
                return "NUM_LOCK";
            }
            case 145: {
                return "SCROLL_LOCK";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 61440: {
                return "F13";
            }
            case 61441: {
                return "F14";
            }
            case 61442: {
                return "F15";
            }
            case 61443: {
                return "F16";
            }
            case 61444: {
                return "F17";
            }
            case 61445: {
                return "F18";
            }
            case 61446: {
                return "F19";
            }
            case 61447: {
                return "F20";
            }
            case 61448: {
                return "F21";
            }
            case 61449: {
                return "F22";
            }
            case 61450: {
                return "F23";
            }
            case 61451: {
                return "F24";
            }
            case 154: {
                return "PRINTSCREEN";
            }
            case 155: {
                return "INSERT";
            }
            case 156: {
                return "HELP";
            }
            case 157: {
                return "META";
            }
            case 192: {
                return "BACK_QUOTE";
            }
            case 222: {
                return "QUOTE";
            }
            case 224: {
                return "KP_UP";
            }
            case 225: {
                return "KP_DOWN";
            }
            case 226: {
                return "KP_LEFT";
            }
            case 227: {
                return "KP_RIGHT";
            }
            case 128: {
                return "DEAD_GRAVE";
            }
            case 129: {
                return "DEAD_ACUTE";
            }
            case 130: {
                return "DEAD_CIRCUMFLEX";
            }
            case 131: {
                return "DEAD_TILDE";
            }
            case 132: {
                return "DEAD_MACRON";
            }
            case 133: {
                return "DEAD_BREVE";
            }
            case 134: {
                return "DEAD_ABOVEDOT";
            }
            case 135: {
                return "DEAD_DIAERESIS";
            }
            case 136: {
                return "DEAD_ABOVERING";
            }
            case 137: {
                return "DEAD_DOUBLEACUTE";
            }
            case 138: {
                return "DEAD_CARON";
            }
            case 139: {
                return "DEAD_CEDILLA";
            }
            case 140: {
                return "DEAD_OGONEK";
            }
            case 141: {
                return "DEAD_IOTA";
            }
            case 142: {
                return "DEAD_VOICED_SOUND";
            }
            case 143: {
                return "DEAD_SEMIVOICED_SOUND";
            }
            case 150: {
                return "AMPERSAND";
            }
            case 151: {
                return "ASTERISK";
            }
            case 152: {
                return "QUOTEDBL";
            }
            case 153: {
                return "LESS";
            }
            case 160: {
                return "GREATER";
            }
            case 161: {
                return "BRACELEFT";
            }
            case 162: {
                return "BRACERIGHT";
            }
            case 512: {
                return "AT";
            }
            case 513: {
                return "COLON";
            }
            case 514: {
                return "CIRCUMFLEX";
            }
            case 515: {
                return "DOLLAR";
            }
            case 516: {
                return "EURO_SIGN";
            }
            case 517: {
                return "EXCLAMATION_MARK";
            }
            case 518: {
                return "INVERTED_EXCLAMATION_MARK";
            }
            case 519: {
                return "LEFT_PARENTHESIS";
            }
            case 520: {
                return "NUMBER_SIGN";
            }
            case 45: {
                return "MINUS";
            }
            case 521: {
                return "PLUS";
            }
            case 522: {
                return "RIGHT_PARENTHESIS";
            }
            case 523: {
                return "UNDERSCORE";
            }
            case 24: {
                return "FINAL";
            }
            case 28: {
                return "CONVERT";
            }
            case 29: {
                return "NONCONVERT";
            }
            case 30: {
                return "ACCEPT";
            }
            case 31: {
                return "MODECHANGE";
            }
            case 21: {
                return "KANA";
            }
            case 25: {
                return "KANJI";
            }
            case 240: {
                return "ALPHANUMERIC";
            }
            case 241: {
                return "KATAKANA";
            }
            case 242: {
                return "HIRAGANA";
            }
            case 243: {
                return "FULL_WIDTH";
            }
            case 244: {
                return "HALF_WIDTH";
            }
            case 245: {
                return "ROMAN_CHARACTERS";
            }
            case 256: {
                return "ALL_CANDIDATES";
            }
            case 257: {
                return "PREVIOUS_CANDIDATE";
            }
            case 258: {
                return "CODE_INPUT";
            }
            case 259: {
                return "JAPANESE_KATAKANA";
            }
            case 260: {
                return "JAPANESE_HIRAGANA";
            }
            case 261: {
                return "JAPANESE_ROMAN";
            }
            case 262: {
                return "KANA_LOCK";
            }
            case 263: {
                return "INPUT_METHOD_ON_OFF";
            }
            case 65481: {
                return "AGAIN";
            }
            case 65483: {
                return "UNDO";
            }
            case 65485: {
                return "COPY";
            }
            case 65487: {
                return "PASTE";
            }
            case 65489: {
                return "CUT";
            }
            case 65488: {
                return "FIND";
            }
            case 65482: {
                return "PROPS";
            }
            case 65480: {
                return "STOP";
            }
            case 65312: {
                return "COMPOSE";
            }
            case 65406: {
                return "ALT_GRAPH";
            }
        }
        if (keyCode >= 96 && keyCode <= 105) {
            char c = (char)(keyCode - 96 + 48);
            return "NUMPAD" + c;
        }
        return "unknown(0x" + Integer.toString(keyCode, 16) + ")";
    }

    public static class KeyBindingMenu
    extends ADialog {
        protected JTable mTable;
        protected JScrollPane mScrollPane;

        public KeyBindingMenu(Window owner, String title) {
            super(owner, title);
            this.setLayout(new BorderLayout());
            this.mTable = new JTable();
            this.mScrollPane = new JScrollPane(this.mTable);
            this.add(this.mScrollPane, "Center");
            this.add(new JLabel("<html><i>Custom key bindings not supported</i></html>"), "South");
            this.setPreferredSize(new Dimension(300, 400));
            this.setSize(300, 400);
            this.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.setVisible(false);
                }
            });
            this.refresh();
        }

        public void setLocationByPreferWindow() {
            Window owner = this.getOwner();
            Point pt = owner.getGraphicsConfiguration().getBounds().getLocation();
            Rectangle dim = owner.getGraphicsConfiguration().getBounds();
            this.setLocation((int)((double)pt.x + dim.getWidth() - (double)this.getWidth()), (int)((double)pt.y + dim.getHeight() - (double)this.getHeight()));
        }

        protected void refreshTable(TreeMap<String, HashSet<KeyStroke>> keySet) {
            Object[][] data = new String[keySet.size()][2];
            Object[] column = new String[]{"Action", "Key Binding"};
            int index = 0;
            for (Map.Entry<String, HashSet<KeyStroke>> e : keySet.entrySet()) {
                data[index][0] = e.getKey();
                HashSet<KeyStroke> kss = e.getValue();
                StringBuilder s = new StringBuilder();
                boolean first = true;
                for (KeyStroke ks : kss) {
                    if (!first) {
                        s.append(", ");
                    }
                    first = false;
                    s.append(KeyBindingUI.keyStroke2String(ks));
                }
                data[index][1] = s.toString();
                ++index;
            }
            this.remove(this.mScrollPane);
            this.mTable = new JTable(data, column);
            this.mTable.setEnabled(false);
            this.mTable.setDragEnabled(false);
            this.mTable.setTableHeader(null);
            this.mScrollPane = new JScrollPane(this.mTable);
            this.add(this.mScrollPane, "Center");
            this.setUndecorated(true);
            this.revalidate();
            this.repaint();
        }

        private void loadInputMap(TreeMap<String, HashSet<KeyStroke>> keySet, JComponent c) {
            InputMap im = c.getInputMap(2);
            KeyBindingUI.addKeyList(im, im.allKeys(), keySet);
            im = c.getInputMap(1);
            KeyBindingUI.addKeyList(im, im.allKeys(), keySet);
            im = c.getInputMap(2);
            if (im != null) {
                KeyBindingUI.addKeyList(im, im.allKeys(), keySet);
            }
            if ((im = c.getInputMap(1)) != null) {
                KeyBindingUI.addKeyList(im, im.allKeys(), keySet);
            }
        }

        public void refresh() {
            TreeMap<String, HashSet<KeyStroke>> keySet = new TreeMap<String, HashSet<KeyStroke>>();
            this.loadInputMap(keySet, (JComponent)OrbitIO.getApp().getWorkspace().getMainFrame().getContentPane());
            DesignView2D view = (DesignView2D)OrbitIO.getCurView();
            if (view != null) {
                this.loadInputMap(keySet, view);
                DesignCanvas2D canvas = view.getCanvas();
                if (canvas != null) {
                    this.loadInputMap(keySet, canvas);
                }
            }
            this.refreshTable(keySet);
        }
    }
}

