/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.common;

import com.sigrity.acl.AStream;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.ui.ACheckBoxList2;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PinTypeSelector
extends JPanel {
    protected Set<PinTemplate.Type> mSelectedTypes;
    protected JLabel mTxtPinTypes;
    public int pinTypesDiplayMax = 3;

    public PinTypeSelector(Set<PinTemplate.Type> initialSelection) {
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mSelectedTypes = new HashSet<PinTemplate.Type>(initialSelection);
        this.mTxtPinTypes = l.add("Selected Pin Types", (GridBagConstraints)GridBagManager.FILLX);
        JButton btnChangePinTypes = (JButton)l.add((Component)new JButton("Change..."));
        UIUtil.makeSmallButton((JButton)btnChangePinTypes);
        this.updateSelectedPinTypes();
        btnChangePinTypes.addActionListener(e -> this.selectPinTypes());
    }

    public Set<PinTemplate.Type> getSelectedTypes() {
        return this.mSelectedTypes;
    }

    protected void updateSelectedPinTypes() {
        Object pinTypesTxt = this.mSelectedTypes.stream().map(t -> t.name()).sorted().limit(this.pinTypesDiplayMax).collect(Collectors.joining(", "));
        if (this.mSelectedTypes.size() > this.pinTypesDiplayMax) {
            pinTypesTxt = (String)pinTypesTxt + String.format(", + %d more", this.mSelectedTypes.size() - this.pinTypesDiplayMax);
        }
        this.mTxtPinTypes.setText((String)pinTypesTxt);
        String pinTypesTxtLong = this.mSelectedTypes.stream().map(t -> t.name()).collect(Collectors.joining(", "));
        this.mTxtPinTypes.setToolTipText(pinTypesTxtLong);
    }

    protected void selectPinTypes() {
        HashSet<PinTemplate.Type> dlgPinTypes = new HashSet<PinTemplate.Type>(this.mSelectedTypes);
        Frame owner = (Frame)UIUtil.getAncestorOfType((Component)this, Frame.class);
        JDialog dlg = new JDialog(owner, true);
        GridBagManager dl = GridBagManager.layout((JDialog)dlg);
        ACheckBoxList2<PinTemplate.Type> cbPinTypes = new ACheckBoxList2<PinTemplate.Type>((Stream<PinTemplate.Type>)AStream.of((Object[])PinTemplate.Type.values()), pt -> dlgPinTypes.contains(pt), (pt, check) -> {
            if (check.booleanValue()) {
                dlgPinTypes.add((PinTemplate.Type)pt);
            } else {
                dlgPinTypes.remove(pt);
            }
        });
        dl.add((Component)new JScrollPane(cbPinTypes), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        dl.newline();
        dl.addFillX();
        JButton btnOk = (JButton)dl.add((Component)new JButton("OK"));
        JButton btnCancel = (JButton)dl.add((Component)new JButton("Cancel"));
        btnOk.addActionListener(e2 -> {
            this.mSelectedTypes.clear();
            this.mSelectedTypes.addAll(dlgPinTypes);
            this.updateSelectedPinTypes();
            UIUtil.closeWindow((Window)dlg);
        });
        UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOk);
        dlg.pack();
        UIUtil.center((Component)dlg);
        dlg.setVisible(true);
    }
}

