/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.constraint;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.util.ArrayList;
import java.util.List;

public class ConstraintItem {
    protected static final String NULL_RULESET_NAME = "DEFAULT";
    protected final DeviceTemplate mDevT;
    protected final DbObject mDbObject;
    protected final RuleSet.RULECLASS mRuleClz;

    public ConstraintItem(DeviceTemplate template, DbObject object, RuleSet.RULECLASS ruleClass) {
        this.mDevT = template;
        this.mDbObject = object;
        this.mRuleClz = ruleClass;
    }

    public DbObject getDbObject() {
        return this.mDbObject;
    }

    public String getTypeName() {
        if (this.mDbObject == null || this.mDbObject.getDb() == null) {
            return "<invalid>";
        }
        if (this.mDbObject instanceof Layer) {
            return "layer";
        }
        if (this.mDbObject instanceof DeviceTemplate) {
            return "template";
        }
        if (this.mDbObject instanceof Net) {
            return "net";
        }
        return "?";
    }

    public String getObjetName() {
        if (this.mDbObject == null || this.mDbObject.getDb() == null) {
            return "<invalid>";
        }
        if (this.mDbObject instanceof Layer) {
            return ((Layer)this.mDbObject).getName();
        }
        if (this.mDbObject instanceof DeviceTemplate) {
            return ((DeviceTemplate)this.mDbObject).getName();
        }
        if (this.mDbObject instanceof Net) {
            return ((Net)this.mDbObject).getName();
        }
        return "?";
    }

    public String getConstraintValue(Constraint.Descriptor<?> constraints) {
        RuleSet rs = RuleSetMgr.getRuleSet((DbObject)this.mDbObject, (RuleSet.RULECLASS)this.mRuleClz);
        if (rs == null) {
            rs = this.getReferencedSet();
        }
        if (rs == null) {
            return null;
        }
        Constraint c = RuleSetMgr.getConstraint((RuleSet)rs, constraints);
        if (c == null) {
            return null;
        }
        Object value = c.getValue();
        if (value != null) {
            return "" + value;
        }
        return null;
    }

    public boolean isOverrideConstraintValue(Constraint.Descriptor<?> constraints) {
        RuleSet rs = RuleSetMgr.getRuleSet((DbObject)this.mDbObject, (RuleSet.RULECLASS)this.mRuleClz);
        if (rs == null) {
            return false;
        }
        Db db = this.mDbObject.getDb();
        Constraint c = Constraint.getConstraint((Db)db, (DbObject)rs, constraints);
        return c != null;
    }

    private RuleSet getOrCreateRuleSet() {
        if (this.mDbObject instanceof DeviceTemplate) {
            return RuleSetMgr.getMyRuleSet((DbObject)((DeviceTemplate)this.mDbObject));
        }
        if (this.mDbObject instanceof Net) {
            Net net = (Net)this.mDbObject;
            RuleSet refRs = this.getReferencedSet();
            if (refRs == null) {
                return null;
            }
            RuleSet overrideRs = RuleSetMgr.getRuleSet((DbObject)net, (RuleSet.RULECLASS)this.mRuleClz);
            if (overrideRs == null) {
                overrideRs = (RuleSet)Cp.exec((String)"com.sigrity.orbit.RuleSetMgr.ccreate(%s, %s)", (Object[])new Object[]{CpHelper.getObjCmdStr(net), CpHelper.getObjCmdStr(refRs)});
            }
            return overrideRs;
        }
        if (this.mDbObject instanceof Layer) {
            Layer l = (Layer)this.mDbObject;
            RuleSet refRs = this.getReferencedSet();
            if (refRs == null) {
                return null;
            }
            for (RuleSet childRs : RuleSetMgr.getChildRuleSets((RuleSet)refRs)) {
                if (childRs.getContext() != l) continue;
                return childRs;
            }
            return (RuleSet)Cp.exec((String)"com.sigrity.orbit.RuleSetMgr.create(%s, %s)", (Object[])new Object[]{CpHelper.getObjCmdStr(l), CpHelper.getObjCmdStr(refRs)});
        }
        return null;
    }

    public boolean setConstraintValue(Constraint.Descriptor<?> constraints, String value) {
        RuleSet rs = this.getOrCreateRuleSet();
        if (rs == null) {
            ALog.logWarn((String)"Cannot find target rule set.");
            return false;
        }
        if (value == null || value.isEmpty()) {
            return (Boolean)Cp.exec((String)"com.sigrity.acl.db.std.Constraint.removeConstraint(curDb(), %s, \"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(rs), constraints.getName()});
        }
        Constraint res = (Constraint)Cp.exec((String)"com.sigrity.acl.db.std.Constraint.setConstraintValue(curDb(), \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{rs.getDbClass().getName(), rs.getKeyStr(), constraints.getName(), value});
        return res != null;
    }

    private static String getReadableReferencedName(RuleSet rs) {
        assert (rs.getContext() instanceof DeviceTemplate);
        String name = rs.getName();
        int index = name.indexOf(95, name.indexOf(95) + 1) + 1;
        name = name.substring(index);
        return name;
    }

    private static RuleSet getReferencedSet(RuleSet.RULECLASS ruleType, DeviceTemplate devT, String name) {
        if (devT == null) {
            return null;
        }
        for (RuleSet rs : RuleSetMgr.getRuleSets((DeviceTemplate)devT, (RuleSet.RULECLASS)ruleType)) {
            if (!ConstraintItem.getReadableReferencedName(rs).equals(name)) continue;
            return rs;
        }
        return null;
    }

    public List<String> getReferencedSetOptionList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(NULL_RULESET_NAME);
        if (this.mDevT == null) {
            return list;
        }
        if (this.mDbObject instanceof Layer) {
            RuleSet rs = RuleSetMgr.getMyRuleSet((DbObject)this.mDevT);
            if (rs != null) {
                list.clear();
                list.add(ConstraintItem.getReadableReferencedName(rs));
            }
            return list;
        }
        for (RuleSet rs : RuleSetMgr.getRuleSets((DeviceTemplate)this.mDevT, (RuleSet.RULECLASS)this.mRuleClz)) {
            list.add(ConstraintItem.getReadableReferencedName(rs));
        }
        return list;
    }

    public RuleSet getReferencedSet() {
        if (this.mDbObject instanceof DeviceTemplate) {
            return RuleSetMgr.getMyRuleSet((DbObject)this.mDbObject);
        }
        if (this.mDbObject instanceof Net) {
            RuleSet rs = RuleSetMgr.getRuleSet((DbObject)this.mDbObject, (RuleSet.RULECLASS)this.mRuleClz);
            if (rs == null) {
                return null;
            }
            return rs.getParent();
        }
        if (this.mDbObject instanceof Layer) {
            return RuleSetMgr.getMyRuleSet((DbObject)this.mDevT);
        }
        ALog.logWarn((Throwable)new Exception("Unsupport"), (String)"Unsupport referenced", (Object[])new Object[0]);
        return null;
    }

    public String getReferencedSetString() {
        RuleSet rs = this.getReferencedSet();
        if (rs != null) assert (rs.getContext() instanceof DeviceTemplate);
        return rs == null ? NULL_RULESET_NAME : ConstraintItem.getReadableReferencedName(rs);
    }

    public boolean setReferencedSet(String name) {
        RuleSet parentRs = ConstraintItem.getReferencedSet(this.mRuleClz, this.mDevT, name);
        if (parentRs == null) {
            return false;
        }
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)parentRs.getDb(), (String)"Assign Referenced Set");){
            boolean bl = (Boolean)Cp.exec((String)"com.sigrity.orbit.RuleSetMgr.setReferencedSet(%s, %s)", (Object[])new Object[]{CpHelper.getObjCmdStr(parentRs), CpHelper.getObjCmdStr(this.mDbObject)});
            return bl;
        }
    }

    public boolean isDeviceTemplate() {
        return this.mDbObject instanceof DeviceTemplate;
    }

    public boolean canGroup() {
        return this.mDbObject instanceof Net;
    }
}

