/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.constraint;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.constraint.ConstraintMgrTable;
import com.sigrity.orbit.ui.constraint.RuleSetPane;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.swing.Icon;

public class ConstraintMgrDialog
extends AJFXDesignDialog {
    protected ConstraintMgrDialog(Db db, Window owner, String title) {
        super(db, owner, title);
        this.init();
        this.setModal(false);
    }

    protected AJFXPanel createJfxPanel() {
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Prepare Constraint Managr");){
            Cp.exec((String)"com.sigrity.orbit.RuleSetMgr.prepareRuleSet(curDb())", (Object[])new Object[0]);
        }
        return new CMainPanel();
    }

    private class CMainPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 1024;
        private static final int PANEL_HEIGHT = 600;
        protected ComboBox<Substrate> mCboSub;
        protected ListView<DeviceTemplate> mListDev;
        protected ConstraintMgrTable mTable;
        protected List<RuleSetPane> mRuleSetPaneList = new ArrayList<RuleSetPane>();
        protected RuleSetPane.ConstraintSupport mLastSelectSupport;

        public CMainPanel() {
            this.setPreferredSize(new Dimension(1024, 600));
        }

        protected Parent initSceneGraph() {
            BorderPane root = new BorderPane();
            VBox topContainer = new VBox();
            MenuBar mainMenu = this.createMenuBar();
            ToolBar toolBar = this.createToolBar();
            Pane sidePane = this.createMainPane();
            topContainer.getChildren().add((Object)mainMenu);
            topContainer.getChildren().add((Object)toolBar);
            root.setTop((Node)topContainer);
            root.setCenter((Node)sidePane);
            return root;
        }

        private MenuBar createMenuBar() {
            MenuBar menubar = new MenuBar();
            menubar.getMenus().add((Object)new Menu("File"));
            return menubar;
        }

        protected ToolBar createToolBar() {
            ToolBar toolbar = new ToolBar();
            Button btnRefresh = new Button();
            btnRefresh.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)OrbitIcons.REFRESH)));
            btnRefresh.setOnAction(e -> this.mTable.refresh());
            toolbar.getItems().add((Object)btnRefresh);
            return toolbar;
        }

        protected Pane createMainPane() {
            BorderPane pane = new BorderPane();
            SplitPane splitPane = new SplitPane();
            Pane tablePane = this.createTablePane();
            Pane rulePane = this.createRuleClassChooser();
            Pane devicePane = this.createDeviceChooser();
            splitPane.getItems().addAll((Object[])new Node[]{devicePane, rulePane, tablePane});
            pane.setCenter((Node)splitPane);
            splitPane.setPrefSize(1024.0, 500.0);
            splitPane.setDividerPositions(new double[]{0.15, 0.35});
            return pane;
        }

        protected Pane createDeviceChooser() {
            VBox top = new VBox(5.0);
            this.mListDev = new ListView();
            this.mListDev.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DeviceTemplate>(){

                public void changed(ObservableValue<? extends DeviceTemplate> ov, DeviceTemplate oldVal, DeviceTemplate newVal) {
                    for (RuleSetPane pane : CMainPanel.this.mRuleSetPaneList) {
                        pane.setDeviceTemplate(newVal);
                    }
                    if (CMainPanel.this.mLastSelectSupport != null) {
                        CMainPanel.this.mTable.setConstraintItems(CMainPanel.this.mLastSelectSupport.getRows(), CMainPanel.this.mLastSelectSupport.getColumns(), CMainPanel.this.mLastSelectSupport.getRuleClass(), newVal);
                    }
                }
            });
            this.mListDev.setCellFactory((Callback)new Callback<ListView<DeviceTemplate>, ListCell<DeviceTemplate>>(){

                public ListCell<DeviceTemplate> call(ListView<DeviceTemplate> param) {
                    return new DeviceTemplateCell();
                }
            });
            this.mCboSub = new ComboBox();
            Substrate defSub = null;
            for (Substrate sub : ConstraintMgrDialog.this.mDb.getObjects(Substrate.class)) {
                this.mCboSub.getItems().add((Object)sub);
                if (defSub != null) continue;
                defSub = sub;
            }
            this.mCboSub.setCellFactory((Callback)new Callback<ListView<Substrate>, ListCell<Substrate>>(){

                public ListCell<Substrate> call(ListView<Substrate> param) {
                    return new SubstrateCell();
                }
            });
            this.mCboSub.setButtonCell((ListCell)new SubstrateCell());
            this.mCboSub.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Substrate>(){

                public void changed(ObservableValue<? extends Substrate> ov, Substrate oldVal, Substrate newVal) {
                    if (newVal != null) {
                        CMainPanel.this.mListDev.getItems().clear();
                        for (DeviceTemplate devT : newVal.getDeviceTemplates()) {
                            CMainPanel.this.mListDev.getItems().add((Object)devT);
                        }
                        CMainPanel.this.mListDev.getSelectionModel().select(0);
                    }
                }
            });
            this.mCboSub.setValue((Object)defSub);
            HBox.setHgrow(this.mCboSub, (Priority)Priority.ALWAYS);
            VBox.setVgrow(this.mListDev, (Priority)Priority.ALWAYS);
            top.getChildren().addAll((Object[])new Node[]{this.mCboSub, this.mListDev});
            top.setPrefWidth(50.0);
            return top;
        }

        protected Pane createRuleClassChooser() {
            this.mRuleSetPaneList.clear();
            VBox top = new VBox(5.0);
            RuleSetPane electRulePane = new RuleSetPane(RuleSet.RULECLASS.ELECTRICAL);
            RuleSetPane physicalRulePane = new RuleSetPane(RuleSet.RULECLASS.PHYSICAL);
            RuleSetPane spaceRulePane = new RuleSetPane(RuleSet.RULECLASS.SPACING);
            RuleSetPane propRulePane = new RuleSetPane(RuleSet.RULECLASS.PROPERTY);
            this.mRuleSetPaneList.add(electRulePane);
            this.mRuleSetPaneList.add(physicalRulePane);
            this.mRuleSetPaneList.add(spaceRulePane);
            this.mRuleSetPaneList.add(propRulePane);
            for (RuleSetPane rsPane : this.mRuleSetPaneList) {
                rsPane.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<String>>(){

                    public void changed(ObservableValue<? extends TreeItem<String>> ov, TreeItem<String> oldVal, TreeItem<String> newVal) {
                        if (newVal instanceof RuleSetPane.ConstraintSupport) {
                            RuleSetPane.ConstraintSupport cs;
                            CMainPanel.this.mLastSelectSupport = cs = (RuleSetPane.ConstraintSupport)newVal;
                            CMainPanel.this.mTable.setConstraintItems(cs.getRows(), cs.getColumns(), cs.getRuleClass(), cs.getTemplate());
                        }
                    }
                });
            }
            electRulePane.selectDefaultItem();
            TitledPane electricalPane = new TitledPane("Electrical", (Node)electRulePane);
            electricalPane.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)UIUtil.getScaledIcon((Icon)OrbitIcons.CONS_ELECTRICAL, (int)16, (int)16))));
            TitledPane physicalPane = new TitledPane("Physical", (Node)physicalRulePane);
            physicalPane.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)UIUtil.getScaledIcon((Icon)OrbitIcons.CONS_PHYSICAL, (int)16, (int)16))));
            TitledPane spacingPane = new TitledPane("Spacing", (Node)spaceRulePane);
            spacingPane.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)UIUtil.getScaledIcon((Icon)OrbitIcons.CONS_SPACING, (int)16, (int)16))));
            TitledPane propertyPane = new TitledPane("Property", (Node)propRulePane);
            propertyPane.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)UIUtil.getScaledIcon((Icon)OrbitIcons.CONS_PROPERTY, (int)16, (int)16))));
            Accordion accordion = new Accordion();
            accordion.getPanes().addAll((Object[])new TitledPane[]{electricalPane, physicalPane, spacingPane, propertyPane});
            accordion.setExpandedPane(electricalPane);
            top.getChildren().add((Object)accordion);
            return top;
        }

        protected Pane createTablePane() {
            VBox box = new VBox(5.0);
            this.mTable = new ConstraintMgrTable();
            box.getChildren().add((Object)this.mTable);
            VBox.setVgrow((Node)this.mTable, (Priority)Priority.ALWAYS);
            return box;
        }

        private class DeviceTemplateCell
        extends ListCell<DeviceTemplate> {
            private DeviceTemplateCell() {
            }

            public void updateItem(DeviceTemplate item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText(item.getName());
                    Image icon = JFXUtil.getFxImage((Icon)DbExplorerPanel.getIconForDbObject((DbObject)item));
                    this.setGraphic((Node)new ImageView(icon));
                } else {
                    this.setText(null);
                    this.setGraphic(null);
                }
            }
        }

        private class SubstrateCell
        extends ListCell<Substrate> {
            private SubstrateCell() {
            }

            public void updateItem(Substrate item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText(item.getName());
                    Image icon = JFXUtil.getFxImage((Icon)DbExplorerPanel.getIconForDbObject((DbObject)item));
                    this.setGraphic((Node)new ImageView(icon));
                } else {
                    this.setText(null);
                }
            }
        }
    }
}

