/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.constraint;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.constraint.ConstraintItem;
import com.sigrity.orbit.ui.constraint.ConstraintMgrUI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javax.swing.Icon;

public class ConstraintMgrTable
extends TableView<ConstraintItem> {
    private static final String TEXT_INHERIT = "**";
    private DeviceTemplate mDevTemplate;
    private RuleSet.RULECLASS mRuleType;
    protected ContextMenu mContextMenu = new ContextMenu();

    public void setConstraintItems(List<ConstraintItem> rows, List<Object> columns, RuleSet.RULECLASS type, DeviceTemplate template) {
        this.getColumns().clear();
        this.mDevTemplate = template;
        this.mRuleType = type;
        TableColumn objectCol = new TableColumn("Objects");
        TableColumn objTypeCol = new TableColumn("Type");
        TableColumn objNameCol = new TableColumn("Name");
        objTypeCol.setPrefWidth(60.0);
        objTypeCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(((ConstraintItem)param.getValue()).getTypeName()));
        objTypeCol.setCellFactory(column -> this.getTypeCellFactory());
        objNameCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(((ConstraintItem)param.getValue()).getObjetName()));
        objNameCol.setCellFactory(column -> this.getNameCellFactory());
        objectCol.getColumns().addAll((Object[])new TableColumn[]{objTypeCol, objNameCol});
        TableColumn refCol = new TableColumn("Referenced Set");
        refCol.setCellValueFactory(param -> new SimpleObjectProperty((Object)((ConstraintItem)param.getValue())));
        refCol.setCellFactory(column -> this.getRefCellFactory());
        refCol.setPrefWidth(120.0);
        this.getColumns().addAll((Object[])new TableColumn[]{objectCol, refCol});
        for (Object obj : columns) {
            this.getDynamicColumn(obj, 0);
        }
        ObservableList infos = FXCollections.observableArrayList(rows);
        this.setItems(infos);
        this.setEditable(true);
        this.getSelectionModel().setCellSelectionEnabled(true);
        this.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.getSelectionModel().selectedIndexProperty().addListener((obs, oldItem, newItem) -> {
            Set selectRows = this.getSelectionModel().getSelectedCells().stream().map(t -> t.getRow()).collect(Collectors.toCollection(TreeSet::new));
            List<ConstraintItem> items = selectRows.stream().map(index -> (ConstraintItem)this.getItems().get(index.intValue())).collect(Collectors.toList());
            this.updateMenu(this.mContextMenu, items);
        });
        this.updateMenu(this.mContextMenu, Collections.emptyList());
        this.setContextMenu(this.mContextMenu);
    }

    private void updateMenu(ContextMenu menu, List<ConstraintItem> items) {
        menu.getItems().clear();
        boolean hasDesign = items.stream().anyMatch(ConstraintItem::isDeviceTemplate);
        boolean canGroup = items.stream().anyMatch(ConstraintItem::canGroup);
        MenuItem itemRefresh = new MenuItem("Refresh Table");
        itemRefresh.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)OrbitIcons.REFRESH)));
        itemRefresh.setOnAction(e -> this.refresh());
        menu.getItems().add((Object)itemRefresh);
        if (hasDesign) {
            if (menu.getItems().size() > 0) {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            DeviceTemplate devT = items.stream().filter(ConstraintItem::isDeviceTemplate).map(item -> (DeviceTemplate)item.getDbObject()).findAny().orElse(null);
            MenuItem itemCreate = new MenuItem("Create Constraint Set...");
            itemCreate.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)OrbitIcons.EMPTY16x16)));
            itemCreate.setOnAction(ConstraintMgrUI.getCreateConstraintSetHandler(this.mRuleType, devT));
            menu.getItems().add((Object)itemCreate);
        }
        if (canGroup) {
            if (menu.getItems().size() > 0) {
                menu.getItems().add((Object)new SeparatorMenuItem());
            }
            menu.getItems().add((Object)new MenuItem(String.format("Group (%d)", items.size())));
        }
    }

    private TableColumn getDynamicColumn(Object obj, int dep) {
        if (obj instanceof RuleSetMgr.ConstraintGroup) {
            RuleSetMgr.ConstraintGroup cg = (RuleSetMgr.ConstraintGroup)obj;
            TableColumn consCol = new TableColumn(cg.getName());
            for (RuleSetMgr.ConstraintGroup c : cg.getChildren()) {
                TableColumn cCol = this.getDynamicColumn(c, dep + 1);
                if (c.getConstraints() != null) {
                    cCol.setCellValueFactory(item -> {
                        SimpleObjectProperty property = new SimpleObjectProperty();
                        property.setValue((Object)new ConstraintValue((ConstraintItem)item.getValue(), c.getConstraints()));
                        return property;
                    });
                    cCol.setCellFactory(column -> this.getContraintCellFactory());
                    cCol.setEditable(true);
                    Label label = new Label(cCol.getText());
                    label.setTooltip(new Tooltip(c.getConstraints().getDesc()));
                    cCol.setGraphic((Node)label);
                }
                if (dep == 0) {
                    this.getColumns().add((Object)cCol);
                }
                if (dep <= 0) continue;
                consCol.getColumns().add((Object)cCol);
            }
            return consCol;
        }
        ALog.logWarn((String)"Unsupport column %s", (Object[])new Object[]{obj});
        return null;
    }

    private TableCell<ConstraintItem, ConstraintItem> getRefCellFactory() {
        ComboBox comboBox = new ComboBox();
        TableCell c = new TableCell();
        c.itemProperty().addListener((obs, oldVal, newVal) -> {
            comboBox.getItems().clear();
            if (newVal != null) {
                for (String s : newVal.getReferencedSetOptionList()) {
                    comboBox.getItems().add((Object)s);
                }
                String used = newVal.getReferencedSetString();
                comboBox.getSelectionModel().select((Object)used);
            }
        });
        comboBox.getSelectionModel().selectedItemProperty().addListener((obs, oldVal, newVal) -> {
            ConstraintItem item = (ConstraintItem)c.getItem();
            if (item != null) {
                item.setReferencedSet((String)newVal);
            }
        });
        c.graphicProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)c.emptyProperty()).then((Object)null).otherwise((Object)comboBox));
        return c;
    }

    private TableCell<ConstraintItem, String> getTypeCellFactory() {
        return new TableCell<ConstraintItem, String>(){

            protected void updateItem(String r, boolean empty) {
                super.updateItem((Object)r, empty);
                if (empty) {
                    this.setText(null);
                } else {
                    this.setText(r);
                }
                this.setAlignment(Pos.BOTTOM_LEFT);
            }
        };
    }

    private TableCell<ConstraintItem, String> getNameCellFactory() {
        return new TableCell<ConstraintItem, String>(){

            protected void updateItem(String r, boolean empty) {
                super.updateItem((Object)r, empty);
                if (empty) {
                    this.setText(null);
                } else {
                    this.setText(r);
                }
                this.setAlignment(Pos.BOTTOM_LEFT);
            }
        };
    }

    private TableCell<ConstraintItem, ConstraintValue> getContraintCellFactory() {
        return new EditingConstraintCell();
    }

    private class EditingConstraintCell
    extends TableCell<ConstraintItem, ConstraintValue> {
        private TextField mTextField;

        private EditingConstraintCell() {
        }

        public void startEdit() {
            if (!this.isEmpty()) {
                super.startEdit();
                this.createTextField();
                this.setText(null);
                this.setGraphic((Node)this.mTextField);
                this.mTextField.selectAll();
            }
        }

        public void cancelEdit() {
            super.cancelEdit();
            this.setText(((ConstraintValue)this.getItem()).getText());
            this.setGraphic(null);
        }

        public void updateItem(ConstraintValue item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.mTextField != null) {
                    this.mTextField.setText(item.getText());
                }
                this.setText(null);
                this.setGraphic((Node)this.mTextField);
            } else {
                this.setGraphic(null);
                boolean isOverride = item.item.isOverrideConstraintValue(item.descriptor);
                if (!isOverride) {
                    this.setStyle("-fx-font-style: italic; -fx-text-fill: slategray;");
                } else {
                    this.setStyle("-fx-font-style: normal;");
                }
                this.setText(item.getText());
                this.setAlignment(Pos.CENTER_RIGHT);
            }
        }

        private void createTextField() {
            this.mTextField = new TextField(((ConstraintValue)this.getItem()).getText());
            this.mTextField.setAlignment(Pos.CENTER_RIGHT);
            this.mTextField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.mTextField.focusedProperty().addListener((ov, oldVal, newVal) -> {
                if (!newVal.booleanValue()) {
                    if (this.getItem() != null) {
                        ((ConstraintValue)this.getItem()).commit(this.mTextField.getText());
                    }
                    this.commitEdit((ConstraintValue)this.getItem());
                }
            });
            this.mTextField.setOnKeyPressed(e -> {
                if (e.getCode().equals((Object)KeyCode.ENTER)) {
                    if (this.getItem() != null) {
                        ((ConstraintValue)this.getItem()).commit(this.mTextField.getText());
                    }
                    this.commitEdit((ConstraintValue)this.getItem());
                }
            });
        }
    }

    private class ConstraintValue {
        ConstraintItem item;
        Constraint.Descriptor<?> descriptor;

        public ConstraintValue(ConstraintItem item, Constraint.Descriptor<?> descriptor) {
            this.item = item;
            this.descriptor = descriptor;
        }

        public String getText() {
            String text = this.item.getConstraintValue(this.descriptor);
            if (text == null) {
                text = ConstraintMgrTable.TEXT_INHERIT;
            }
            return text;
        }

        public boolean commit(String value) {
            return this.item.setConstraintValue(this.descriptor, value);
        }
    }
}

