/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.constraint;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitIOEnv;
import com.sigrity.orbit.ui.constraint.ConstraintMgrDialog;
import com.sigrity.orbit.ui.constraint.CreateConstraintSetDialog;
import java.awt.event.ActionEvent;
import javafx.event.EventHandler;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class ConstraintMgrUI {
    private ConstraintMgrUI() {
    }

    public static Action getAction() {
        if (!OrbitIO.getApp().hasEnv(OrbitIOEnv.DB_CONSTRAINT_MGR)) {
            return null;
        }
        return new AbstractAction("Constraint (pre-alpha)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConstraintMgrUI.showConstraintMgrUI();
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    private static void showConstraintMgrUI() {
        if (OrbitIO.getCurDb() == null) {
            ALog.logWarn((String)"Cannot find active database.");
            return;
        }
        ConstraintMgrDialog dialog = new ConstraintMgrDialog(OrbitIO.getCurDb(), OrbitIO.getMainWindow(), "Constraint Management");
        dialog.setVisible(true);
    }

    private static void showConstraintSetCreationUI(RuleSet.RULECLASS ruleType, DeviceTemplate devT) {
        CreateConstraintSetDialog dialog = new CreateConstraintSetDialog(OrbitIO.getCurDb(), OrbitIO.getMainWindow(), "Constraint Set Creation", devT, ruleType);
        dialog.setVisible(true);
    }

    static EventHandler<javafx.event.ActionEvent> getCreateConstraintSetHandler(final RuleSet.RULECLASS ruleType, final DeviceTemplate devT) {
        return new EventHandler<javafx.event.ActionEvent>(){

            public void handle(javafx.event.ActionEvent e) {
                SwingUtilities.invokeLater(() -> ConstraintMgrUI.showConstraintSetCreationUI(ruleType, devT));
            }
        };
    }
}

