/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.constraint;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Dimension;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.Icon;

public class CreateConstraintSetDialog
extends AJFXDesignDialog {
    private final DeviceTemplate mDevTemplate;
    private final RuleSet.RULECLASS mRuleType;

    protected CreateConstraintSetDialog(Db db, Window owner, String title, DeviceTemplate devT, RuleSet.RULECLASS type) {
        super(db, owner, title);
        this.mDevTemplate = devT;
        this.mRuleType = type;
        this.init();
        this.setModal(true);
        this.setResizable(false);
    }

    protected AJFXPanel createJfxPanel() {
        return new CMainPanel();
    }

    private class CMainPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 400;
        private static final int PANEL_HEIGHT = 300;
        private TextField mNameField;
        EventHandler<ActionEvent> mOkHandler = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                DbHistory history = CreateConstraintSetDialog.this.getDb().getHistory();
                try (DbHistory.DbTransaction transaction = history.newDbTransaction("Create Constraint Set");){
                    this.cpCreateConstraintSet();
                }
                UIUtil.closeWindow((Window)((Object)CreateConstraintSetDialog.this));
            }

            private void cpCreateConstraintSet() {
                String name = CMainPanel.this.mNameField.getText();
                Cp.exec((String)"com.sigrity.orbit.RuleSetMgr.create(%s, %s.%s, \"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(CreateConstraintSetDialog.this.mDevTemplate), CreateConstraintSetDialog.this.mRuleType.getClass().getName(), CreateConstraintSetDialog.this.mRuleType, name});
            }
        };

        public CMainPanel() {
            this.setPreferredSize(new Dimension(400, 300));
        }

        protected Parent initSceneGraph() {
            BorderPane top = new BorderPane();
            VBox main = new VBox(10.0);
            TitledPane configPane = new TitledPane("Config", (Node)this.createConfigPane());
            configPane.setCollapsible(false);
            TitledPane previewPane = new TitledPane("Preview", (Node)new Label("None"));
            previewPane.setCollapsible(false);
            main.getChildren().addAll((Object[])new Node[]{configPane, previewPane});
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)CreateConstraintSetDialog.this), this.mOkHandler);
            top.setTop((Node)main);
            top.setBottom((Node)okCancelHBox);
            return top;
        }

        protected Pane createConfigPane() {
            GridPane pane = new GridPane();
            pane.setAlignment(Pos.TOP_LEFT);
            pane.setHgap(10.0);
            pane.setVgap(10.0);
            pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            ColumnConstraints column1 = new ColumnConstraints(80.0);
            ColumnConstraints column2 = new ColumnConstraints(120.0);
            column2.setHgrow(Priority.ALWAYS);
            pane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
            pane.add((Node)new Label("Type:"), 0, 0);
            Button fieldType = new Button();
            fieldType.setDisable(true);
            fieldType.setMaxWidth(Double.MAX_VALUE);
            fieldType.setText(CreateConstraintSetDialog.this.mRuleType.getUserName());
            GridPane.setFillWidth((Node)fieldType, (Boolean)true);
            pane.add((Node)fieldType, 1, 0);
            pane.add((Node)new Label("Template:"), 0, 1);
            Button fieldTemplate = new Button();
            fieldTemplate.setDisable(true);
            fieldTemplate.setText(CreateConstraintSetDialog.this.mDevTemplate.getName());
            fieldTemplate.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)DbExplorerPanel.getIconForDbObject((DbObject)CreateConstraintSetDialog.this.mDevTemplate))));
            fieldTemplate.setMaxWidth(Double.MAX_VALUE);
            GridPane.setFillWidth((Node)fieldTemplate, (Boolean)true);
            pane.add((Node)fieldTemplate, 1, 1);
            this.mNameField = new TextField();
            pane.add((Node)new Label("Set Name:"), 0, 2);
            pane.add((Node)this.mNameField, 1, 2);
            return pane;
        }
    }
}

