/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.constraint;

import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.constraint.ConstraintItem;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;
import javax.swing.Icon;

public class RuleSetPane
extends VBox {
    protected DeviceTemplate mDevT = null;
    protected RuleSet.RULECLASS mRuleType;
    protected TreeView<String> mTreeView;
    protected TreeItem<String> mDefaultSelectItem;

    public RuleSetPane(RuleSet.RULECLASS type) {
        super(5.0);
        this.mRuleType = type;
        this.mTreeView = new TreeView((TreeItem)new RuleTreeRoot(type.getUserName()));
        this.mTreeView.setShowRoot(false);
        this.getChildren().add(this.mTreeView);
    }

    public MultipleSelectionModel<TreeItem<String>> getSelectionModel() {
        return this.mTreeView.getSelectionModel();
    }

    public void setDeviceTemplate(DeviceTemplate devT) {
        this.mDevT = devT;
    }

    public void selectDefaultItem() {
        if (this.mDefaultSelectItem != null) {
            this.mTreeView.getSelectionModel().select(this.mDefaultSelectItem);
        }
    }

    protected class RuleObjectSetNode
    extends TreeItem<String>
    implements ConstraintSupport {
        protected RuleObject mObjectType;

        public RuleObjectSetNode(RuleObject obj) {
            super((Object)obj.getUserName());
            this.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER, (int)14, (int)14))));
            this.mObjectType = obj;
        }

        @Override
        public List<ConstraintItem> getRows() {
            if (RuleSetPane.this.mDevT == null) {
                return Collections.emptyList();
            }
            if (this.mObjectType == RuleObject.LAYER) {
                return RuleSetPane.this.mDevT.getSubstrate().getLayers().stream().map(l -> new ConstraintItem(RuleSetPane.this.mDevT, (DbObject)l, this.getRuleClass())).collect(Collectors.toList());
            }
            if (this.mObjectType == RuleObject.NET) {
                return RuleSetPane.this.mDevT.getNets().stream().map(net -> new ConstraintItem(RuleSetPane.this.mDevT, (DbObject)net, this.getRuleClass())).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        @Override
        public List<Object> getColumns() {
            RuleSetMgr.ConstraintGroup cg = RuleSetMgr.getConstraintGroup((RuleSet.RULECLASS)RuleSetPane.this.mRuleType);
            return List.of(cg);
        }

        @Override
        public RuleSet.RULECLASS getRuleClass() {
            return RuleSetPane.this.mRuleType;
        }

        @Override
        public DeviceTemplate getTemplate() {
            return RuleSetPane.this.mDevT;
        }
    }

    protected class RuleSetNode
    extends TreeItem<String>
    implements ConstraintSupport {
        public RuleSetNode() {
            super((Object)(RuleSetPane.this.mRuleType.getUserName() + " Constraint Set"));
            this.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER, (int)14, (int)14))));
        }

        @Override
        public List<ConstraintItem> getRows() {
            if (RuleSetPane.this.mDevT == null) {
                return Collections.emptyList();
            }
            return List.of(new ConstraintItem(RuleSetPane.this.mDevT, (DbObject)RuleSetPane.this.mDevT, this.getRuleClass()));
        }

        @Override
        public List<Object> getColumns() {
            RuleSetMgr.ConstraintGroup cg = RuleSetMgr.getConstraintGroup((RuleSet.RULECLASS)RuleSetPane.this.mRuleType);
            return List.of(cg);
        }

        @Override
        public RuleSet.RULECLASS getRuleClass() {
            return RuleSetPane.this.mRuleType;
        }

        @Override
        public DeviceTemplate getTemplate() {
            return RuleSetPane.this.mDevT;
        }
    }

    protected class RuleTreeRoot
    extends TreeItem<String>
    implements ConstraintSupport {
        public RuleTreeRoot(String name) {
            RuleSetNode rsNode;
            super((Object)name);
            RuleSetPane.this.mDefaultSelectItem = rsNode = new RuleSetNode();
            this.getChildren().add((Object)rsNode);
            for (RuleObject obj : RuleObject.values()) {
                this.getChildren().add((Object)new RuleObjectSetNode(obj));
            }
            this.setExpanded(true);
        }

        @Override
        public List<ConstraintItem> getRows() {
            return Collections.emptyList();
        }

        @Override
        public List<Object> getColumns() {
            return Collections.emptyList();
        }

        @Override
        public RuleSet.RULECLASS getRuleClass() {
            return RuleSetPane.this.mRuleType;
        }

        @Override
        public DeviceTemplate getTemplate() {
            return RuleSetPane.this.mDevT;
        }
    }

    protected static interface ConstraintSupport {
        public List<ConstraintItem> getRows();

        public List<Object> getColumns();

        public RuleSet.RULECLASS getRuleClass();

        public DeviceTemplate getTemplate();
    }

    public static enum RuleObject {
        LAYER("Layer"),
        NET("Net");

        String mName;

        private RuleObject(String name) {
            this.mName = name;
        }

        public String getUserName() {
            return this.mName;
        }
    }
}

