/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.contact_oriented_netlist;

import com.sigrity.acl.AFile;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.jfxui.AJFXAlerts;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXFileChooser;
import com.sigrity.acl.jfxui.AJFXFileChooserControl;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.swing.SwingUtilities;

public class ContactOrientedNetlistEngineUI
extends AJFXDesignDialog {
    private static final String TITLE = "Generate Netlist by Contact";

    public static ContactOrientedNetlistEngineUI createDialog(Window owner, Db db) {
        if (db == null) {
            return null;
        }
        ContactOrientedNetlistEngineUI dlg = new ContactOrientedNetlistEngineUI(owner, db);
        dlg.setVisible(true);
        return dlg;
    }

    private ContactOrientedNetlistEngineUI(Window owner, Db db) {
        super(db, (Component)owner, TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new ContactDevPanel();
    }

    private class ContactDevPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 600;
        private static final int PANEL_HEIGHT = 250;
        private ContactDevInfoBox mDevTAPanel;
        private ContactDevInfoBox mDevTBPanel;
        private ConfigCsvPane mConfigCsvPane;
        private EventHandler<ActionEvent> mOkHandler = e -> {
            if (!this.isReadyToRun()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)ContactOrientedNetlistEngineUI.this.getDb(), (String)"Generate netlist");){
                    this.cpGenerateNetlist();
                }
                ALog.logInfo((String)"Generate netlist by contact complete.");
                UIUtil.closeWindow((Window)((Object)ContactOrientedNetlistEngineUI.this));
            });
        };

        public ContactDevPanel() {
            this.setPreferredSize(new Dimension(600, 250));
        }

        protected Parent initSceneGraph() {
            BorderPane pane = new BorderPane();
            VBox mainBox = new VBox(5.0);
            this.mDevTAPanel = new ContactDevInfoBox("Device Template A");
            HBox.setHgrow((Node)this.mDevTAPanel, (Priority)Priority.ALWAYS);
            this.mDevTBPanel = new ContactDevInfoBox("Device Template B");
            HBox.setHgrow((Node)this.mDevTBPanel, (Priority)Priority.ALWAYS);
            HBox devInfosHBox = new HBox(10.0, new Node[]{this.mDevTAPanel, this.mDevTBPanel});
            devInfosHBox.setAlignment(Pos.CENTER);
            devInfosHBox.setPadding(new Insets(10.0));
            mainBox.getChildren().add((Object)devInfosHBox);
            this.mConfigCsvPane = new ConfigCsvPane();
            this.mConfigCsvPane.setPadding(new Insets(10.0));
            mainBox.getChildren().add((Object)this.mConfigCsvPane);
            pane.setTop((Node)mainBox);
            OkCancelHBox okCancelBox = new OkCancelHBox((Window)((Object)ContactOrientedNetlistEngineUI.this), this.mOkHandler);
            pane.setBottom((Node)okCancelBox);
            return pane;
        }

        private boolean isReadyToRun() {
            DeviceTemplate selectedDevTA = this.mDevTAPanel.getSelectedDevT();
            DeviceTemplate selectedDevTB = this.mDevTBPanel.getSelectedDevT();
            if (!this.checkDevTSelected("A", selectedDevTA) || !this.checkDevTSelected("B", selectedDevTB)) {
                return false;
            }
            String termMapCsvStr = this.mConfigCsvPane.getTermMapCsv();
            String instPairCsvStr = this.mConfigCsvPane.getInstPairCsv();
            return this.checkFileReadable("Term Map", termMapCsvStr) && this.checkFileReadable("Instance Pair", instPairCsvStr);
        }

        private void cpGenerateNetlist() {
            Cp.exec((String)"unset(\"_engine\");", (Object[])new Object[0]);
            DeviceTemplate selectedDevTA = this.mDevTAPanel.getSelectedDevT();
            DeviceTemplate selectedDevTB = this.mDevTBPanel.getSelectedDevT();
            Cp.exec((String)"_engine = new com.sigrity.orbit.automation.contact_oriented_netlist.ContactOrientedNetlistEngine(%s, %s);", (Object[])new Object[]{CpHelper.getObjCmdStr(selectedDevTA), CpHelper.getObjCmdStr(selectedDevTB)});
            String termMapCsv = this.mConfigCsvPane.getTermMapCsv();
            Cp.exec((String)"_engine.setConnectionCsv(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)termMapCsv)});
            String instPairCsv = this.mConfigCsvPane.getInstPairCsv();
            Cp.exec((String)"_engine.setInstancePairCsv(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)instPairCsv)});
            Cp.exec((String)"_engine.execute();", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_engine\");", (Object[])new Object[0]);
        }

        private boolean checkDevTSelected(String name, DeviceTemplate devT) {
            if (devT != null) {
                return true;
            }
            String headerTxt = "Device Template not defined";
            String contactTxt = String.format("Device Template %s is not defined.%nChoose a device template.", name);
            this.showErrorAlert(headerTxt, contactTxt);
            return false;
        }

        private boolean checkFileReadable(String fileName, String filePathStr) {
            File file = new File(filePathStr);
            if (AFile.isFileReadable((File)file)) {
                return true;
            }
            String headerTxt = String.format("%s not defined", fileName);
            String contactTxt = String.format("%s file '%s' is not exist. Choose a %s file", fileName, filePathStr, fileName);
            this.showErrorAlert(headerTxt, contactTxt);
            return false;
        }

        private void showErrorAlert(String headerTxt, String contactTxt) {
            AJFXAlerts.showErrorAlert((Window)((Object)ContactOrientedNetlistEngineUI.this), (String)ContactOrientedNetlistEngineUI.TITLE, (String)headerTxt, (String)contactTxt);
        }

        private class ConfigCsvPane
        extends GridPane {
            private AJFXFileChooserControl mTermMapFileChooserControl;
            private AJFXFileChooserControl mInstPairFileChooserControl;

            public ConfigCsvPane() {
                this.setHgap(10.0);
                this.setVgap(5.0);
                Label termMapCsvLabel = new Label("Term Map");
                this.add((Node)termMapCsvLabel, 0, 0);
                this.mTermMapFileChooserControl = this.createCsvFileControlChooser();
                this.add((Node)this.mTermMapFileChooserControl, 1, 0);
                Label instPairCsvLabel = new Label("Instance Pair");
                this.add((Node)instPairCsvLabel, 0, 1);
                this.mInstPairFileChooserControl = this.createCsvFileControlChooser();
                this.add((Node)this.mInstPairFileChooserControl, 1, 1);
            }

            public String getTermMapCsv() {
                return this.mTermMapFileChooserControl.getPath();
            }

            public String getInstPairCsv() {
                return this.mInstPairFileChooserControl.getPath();
            }

            private AJFXFileChooserControl createCsvFileControlChooser() {
                AJFXFileChooserControl mTermMapCsvFileChooserControl = new AJFXFileChooserControl((Window)((Object)ContactOrientedNetlistEngineUI.this));
                mTermMapCsvFileChooserControl.addChoosableFileFilter(AJFXFileChooser.CSV_FILE_FILTER);
                mTermMapCsvFileChooserControl.setUseSaveChooser(false);
                GridPane.setHgrow((Node)mTermMapCsvFileChooserControl, (Priority)Priority.ALWAYS);
                return mTermMapCsvFileChooserControl;
            }
        }

        private class ContactDevInfoBox
        extends TitledPane {
            private ComboBox<Substrate> mSubstrateComboBox;
            private ComboBox<DeviceTemplate> mTemplateComboBox;

            protected ContactDevInfoBox(String title) {
                this.setText(title);
                this.initDevInfoPane();
                this.setMinWidth(250.0);
            }

            private void initDevInfoPane() {
                GridPane gridPane = new GridPane();
                gridPane.setHgap(10.0);
                gridPane.setVgap(5.0);
                Label mSubstrateLabel = new Label("Substrate: ");
                mSubstrateLabel.setMinWidth(Double.NEGATIVE_INFINITY);
                gridPane.add((Node)mSubstrateLabel, 0, 0);
                this.mSubstrateComboBox = this.createSubstrateComboBox();
                GridPane.setHgrow(this.mSubstrateComboBox, (Priority)Priority.ALWAYS);
                gridPane.add(this.mSubstrateComboBox, 1, 0);
                Label mTemplateLabel = new Label("Template: ");
                mTemplateLabel.setMinWidth(Double.NEGATIVE_INFINITY);
                gridPane.add((Node)mTemplateLabel, 0, 1);
                this.mTemplateComboBox = this.createTemplateComboBox();
                GridPane.setHgrow(this.mTemplateComboBox, (Priority)Priority.ALWAYS);
                gridPane.add(this.mTemplateComboBox, 1, 1);
                this.mSubstrateComboBox.getSelectionModel().selectedItemProperty().addListener((options, oldValue, newValue) -> {
                    if (oldValue != newValue) {
                        this.mTemplateComboBox.getItems().clear();
                        Substrate selectedSubstrate = this.getSelectedSubstrate();
                        if (selectedSubstrate != null) {
                            selectedSubstrate.getDeviceTemplates().forEach(devT -> this.mTemplateComboBox.getItems().add(devT));
                        }
                        this.mTemplateComboBox.getSelectionModel().clearAndSelect(0);
                    }
                });
                this.setContent((Node)gridPane);
            }

            public DeviceTemplate getSelectedDevT() {
                return (DeviceTemplate)this.mTemplateComboBox.getSelectionModel().getSelectedItem();
            }

            private ComboBox<Substrate> createSubstrateComboBox() {
                ComboBox comboBox = new ComboBox();
                Substrate.getSubstrates((Db)ContactOrientedNetlistEngineUI.this.mDb).forEach(s -> comboBox.getItems().add(s));
                StringConverter<Substrate> converter = new StringConverter<Substrate>(){

                    public String toString(Substrate i) {
                        return i == null ? "" : i.getName();
                    }

                    public Substrate fromString(String string) {
                        throw new UnsupportedOperationException();
                    }
                };
                comboBox.setConverter((StringConverter)converter);
                comboBox.getSelectionModel().select(0);
                comboBox.setMaxWidth(Double.MAX_VALUE);
                return comboBox;
            }

            private ComboBox<DeviceTemplate> createTemplateComboBox() {
                ComboBox comboBox = new ComboBox();
                Substrate selectedSubstrate = this.getSelectedSubstrate();
                if (selectedSubstrate != null) {
                    selectedSubstrate.getDeviceTemplates().forEach(devT -> comboBox.getItems().add(devT));
                }
                StringConverter<DeviceTemplate> converter = new StringConverter<DeviceTemplate>(){

                    public String toString(DeviceTemplate i) {
                        return i == null ? "" : i.getName();
                    }

                    public DeviceTemplate fromString(String string) {
                        throw new UnsupportedOperationException();
                    }
                };
                comboBox.setConverter((StringConverter)converter);
                comboBox.getSelectionModel().select(0);
                comboBox.setMaxWidth(Double.MAX_VALUE);
                return comboBox;
            }

            private Substrate getSelectedSubstrate() {
                return (Substrate)this.mSubstrateComboBox.getSelectionModel().getSelectedItem();
            }
        }
    }
}

