/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.AImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class CadenceMenuBar
extends JMenuBar {
    protected JLabel mLogo = null;
    protected Component mFillX = Box.createHorizontalGlue();
    protected boolean mInAddImpl = false;

    public CadenceMenuBar() {
        this.updateLogo();
        Color red = new Color(204, 0, 0);
        this.setBorder(new CompoundBorder(this.getBorder(), new AColorBorder(red, 0, 0, 4, 0)));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int curExtraSpace = CadenceMenuBar.this.mFillX.getWidth();
                if (!CadenceMenuBar.this.mLogo.isVisible()) {
                    curExtraSpace -= CadenceMenuBar.this.mLogo.getPreferredSize().width;
                }
                CadenceMenuBar.this.mLogo.setVisible(curExtraSpace > 0);
            }
        });
    }

    public void updateLogo() {
        File imagePath = new File((String)Settings.get((String)"GUI", (String)"MainMenuBarLogo", (Object)"res/img/iconCadenceMenuBar.png"));
        try {
            AImageIcon imageIcon;
            if (!imagePath.isAbsolute()) {
                imagePath = new File(AApp.getInstallDir(), imagePath.getPath());
            }
            if ((imageIcon = new AImageIcon(imagePath.toURI().toURL())).getIconWidth() < 0) {
                throw new FileNotFoundException(imagePath.getAbsolutePath());
            }
            if (this.mLogo == null) {
                this.mLogo = new JLabel((Icon)imageIcon);
            } else {
                this.mLogo.setIcon((Icon)imageIcon);
            }
            this.mLogo.setBorder(new EmptyBorder(0, 0, 0, 6));
        }
        catch (Exception e) {
            ALog.logWarn((Throwable)e, (String)"Error loading logo.", (Object[])new Object[0]);
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.mInAddImpl) {
            super.addImpl(comp, constraints, index);
            return;
        }
        this.mInAddImpl = true;
        if (this.mLogo != null) {
            this.remove(this.mLogo);
            this.remove(this.mFillX);
        }
        super.addImpl(comp, constraints, index);
        if (this.mLogo != null) {
            this.add(this.mFillX);
            this.add((Component)this.mLogo, -1);
        }
        this.mInAddImpl = false;
    }

    public static class AColorBorder
    extends EmptyBorder {
        protected Color mColor;

        public AColorBorder(Color color, int top, int left, int bottom, int right) {
            super(top, left, bottom, right);
            this.mColor = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(this.mColor);
            if (this.top > 0) {
                g.fillRect(x, y, width, this.top);
            }
            if (this.left > 0) {
                g.fillRect(x, y, this.left, height);
            }
            if (this.bottom > 0) {
                g.fillRect(x, y + height - this.bottom, width, this.bottom);
            }
            if (this.right > 0) {
                g.fillRect(x + width - this.right, y, this.right, height);
            }
            g.setColor(oldColor);
        }
    }
}

