/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.AColor;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AThread;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Stopwatch;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbDoctor;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AArc;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.APolyline;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.acl.xml.AXmlUtil;
import com.sigrity.orbit.DesignSettings;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPortShape;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.canvas_views.DefaultViewDrawer;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.InnovusViewColorizer;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.orbit.ui.core.RegionShapeFactory;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import rx.Observable;
import rx.subjects.PublishSubject;

public class DesignCanvas2D
extends JComponent {
    public static final int BORDER_SIZE_DEFAULT = 1;
    public static final String XMLCFG_ELEM_ROOT = DesignCanvas2D.class.getSimpleName();
    public static final String FILENAME_CONFIG = DesignCanvas2D.class.getSimpleName() + ".xml";
    public static final String FLDNAME_LASTZOOM = String.format("%s.LastZoom", DesignCanvas2D.class.getName());
    public static final String PROP_COLORIZER = "Colorizer";
    public static boolean _DisableDrawing = false;
    protected Db mDb;
    protected Rectangle mBufferBounds;
    protected Image mMainBuffer;
    protected Image mHighlightBuffer;
    protected boolean mLargeBuffer = true;
    protected float mUnhighlightAlpha = 1.0f;
    protected float mSelectionColorsThreshold = 0.0f;
    protected XForm mScreenTransform = new XForm();
    protected boolean inUndoRedo = false;
    protected int mScreenUndone = 0;
    protected LinkedList<XForm> mScreenHistory = new LinkedList();
    protected Point mMouseLoc = null;
    protected MouseEvent mLastMouseEvent = null;
    protected ViewColorizer mColorizer;
    protected Graphics2D mGMain = null;
    protected Graphics2D mGSelected = null;
    protected Design mDesign = null;
    protected Selection mSelected = null;
    protected ARect mWorldDrawBounds = null;
    protected ArrayList<JMenuItem> mViewMenu;
    protected TransformListener mWorldListener = new TransformListener(){
        protected int mProcessedChanges = 0;

        @Override
        public void transformPreChange(XForm newXForm) {
        }

        @Override
        public void transformChanged(XForm newXForm) {
            if (newXForm.mWorld != null && newXForm.mScreen != null && !DesignCanvas2D.this.inUndoRedo) {
                while (DesignCanvas2D.this.mScreenHistory.size() >= 50) {
                    DesignCanvas2D.this.mScreenHistory.removeFirst();
                }
                DesignCanvas2D.this.truncateView();
                DesignCanvas2D.this.mScreenHistory.add(new XForm(newXForm));
            }
            if (this.mProcessedChanges < 2) {
                ++this.mProcessedChanges;
            } else {
                if (OrbitIO.getApp().getWorkspace() == null) {
                    return;
                }
                Design design = Design.getDesign((Db)DesignCanvas2D.this.mDb, (boolean)false);
                if (design != null) {
                    try (OrbitApp.ChangeWarningSilencer cm = OrbitApp.suppressDbChangeMonitorWarnings();){
                        DbHistory history = DesignCanvas2D.this.mDb.getHistory();
                        try (DbHistory.DbTransaction transaction = history.newDbTransaction("Save Zoom");){
                            design.getDbClass().getField(FLDNAME_LASTZOOM).setCache(true);
                            design.setValue(FLDNAME_LASTZOOM, (Object)DesignCanvas2D.this.mScreenTransform.getWorld());
                        }
                    }
                    OrbitIO.getApp().getWorkspace().refreshTitles();
                }
            }
        }
    };
    protected MyBorder mBorder = new MyBorder();
    protected FocusListener mFocusHandler = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
            DesignCanvas2D.this.repaintBorder();
        }

        @Override
        public void focusLost(FocusEvent e) {
            DesignCanvas2D.this.repaintBorder();
        }
    };
    protected boolean mReimagePending = false;
    public static final double ZOOM_FACTOR = 1.5;
    protected MouseInputAdapter mMouseHandler = new MouseInputAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            DesignCanvas2D.this.mLastMouseEvent = e;
            DesignCanvas2D.this.mMouseLoc = e.getPoint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DesignCanvas2D.this.mLastMouseEvent = e;
            DesignCanvas2D.this.mMouseLoc = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            DesignCanvas2D.this.mLastMouseEvent = e;
            DesignCanvas2D.this.mMouseLoc = e.getPoint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DesignCanvas2D.this.mLastMouseEvent = e;
            DesignCanvas2D.this.mMouseLoc = e.getPoint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!DesignCanvas2D.this.isFocusOwner()) {
                DesignCanvas2D.this.requestFocusInWindow();
            }
            DesignCanvas2D.this.mLastMouseEvent = e;
            DesignCanvas2D.this.mMouseLoc = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DesignCanvas2D.this.mLastMouseEvent = e;
            DesignCanvas2D.this.mMouseLoc = e.getPoint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DesignCanvas2D.this.mLastMouseEvent = e;
            DesignCanvas2D.this.mMouseLoc = e.getPoint();
        }
    };
    public static boolean _TimeRedraws = false;
    protected boolean mIsDrawing = false;
    protected PublishSubject<Boolean> mDrawingActiveSubject = PublishSubject.create();
    protected boolean mTransforming = false;
    protected LinkedHashSet<TransformListener> mXFormListeners = new LinkedHashSet();
    protected PublishSubject<Void> mReimageSubject = PublishSubject.create();
    @Deprecated
    protected HashSet<DbRepaintedListener> mDbRepainedtedListeners = new HashSet();
    static ViewDrawerRegistry gViewDrawRegistry = new ViewDrawerRegistry();
    protected ViewDrawer mViewDrawer = gViewDrawRegistry.getDefault().create(this);
    protected ViewDrawer mViewDrawerPrior;
    protected static final Point2D.Double IdentityScale = new Point2D.Double(1.0, 1.0);
    protected Point2D.Double mBaseScale;
    protected static boolean mAppFixBlurry = (Boolean)Settings.getSettings((String)"UserPreferences").getSetting("UserFixHDPI", (Object)false);

    public static void applyDefaultTheme() {
        Db db = OrbitIO.getCurDb();
        if (!(OrbitIO.getCurView() instanceof DesignView2D)) {
            ALog.flogError((String)"Please change to 2D viewer", (Object[])new Object[0]);
            return;
        }
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        if (v == null) {
            return;
        }
        DesignCanvas2D c = v.getCanvas();
        if (!c.mColorizer.getUseClassicTheme()) {
            return;
        }
        c.setViewSettings(new ViewColorizer(Design.getDesignPath((Db)db), c.mColorizer));
        c.mColorizer.setUseClassicTheme(false);
        OrbitIO.getApp().refreshCurrentView();
    }

    public static void applyClassicTheme() {
        Db db = OrbitIO.getCurDb();
        if (!(OrbitIO.getCurView() instanceof DesignView2D)) {
            ALog.flogError((String)"Please change to 2D viewer", (Object[])new Object[0]);
            return;
        }
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        if (v == null) {
            return;
        }
        DesignCanvas2D c = v.getCanvas();
        if (c.mColorizer.getUseClassicTheme()) {
            return;
        }
        c.setViewSettings(new ViewColorizer(Design.getDesignPath((Db)db), c.mColorizer));
        c.mColorizer.setColor(Design.getDesignPath((Db)db), (ViewColorizer.Key)ViewColorizer.KDesignCanvas, Color.BLACK);
        c.mColorizer.setColor(Design.getDesignPath((Db)db), (ViewColorizer.Key)ViewColorizer.KConnection, Color.WHITE);
        c.mColorizer.setColor(Design.getDesignPath((Db)db), (ViewColorizer.Key)ViewColorizer.KDeviceDie, Color.WHITE);
        c.mColorizer.setColor(Design.getDesignPath((Db)db), (ViewColorizer.Key)ViewColorizer.KDevicePackageDie, Color.WHITE);
        c.mColorizer.setColor(Design.getDesignPath((Db)db), (ViewColorizer.Key)ViewColorizer.KDevice, Color.WHITE);
        c.mColorizer.setHollowPins(true);
        c.mColorizer.setHollowWires(true);
        c.mColorizer.setHollowFloorplans(true);
        c.mColorizer.setHollowDevices(true);
        c.mColorizer.setHollowMetals(true);
        c.mColorizer.setUseClassicTheme(true);
        OrbitIO.getApp().refreshCurrentView();
    }

    public static void applyInnovusTheme() {
        Db db = OrbitIO.getCurDb();
        if (!(OrbitIO.getCurView() instanceof DesignView2D)) {
            ALog.flogError((String)"Please change to 2D viewer", (Object[])new Object[0]);
            return;
        }
        DesignView2D v = (DesignView2D)OrbitIO.getCurView();
        if (v == null) {
            return;
        }
        DesignCanvas2D c = v.getCanvas();
        c.setViewSettings((ViewColorizer)new InnovusViewColorizer(Design.getDesignPath((Db)db), c.mColorizer));
        OrbitIO.getApp().refreshCurrentView();
    }

    public DesignCanvas2D(Db db) {
        if (_TimeRedraws) {
            ALog.logDebug((String)"Using default ViewDrawer: %s", (Object[])new Object[]{this.mViewDrawer});
        }
        this.mViewDrawerPrior = null;
        this.mBaseScale = IdentityScale;
        this.setDoubleBuffered(false);
        this.setBorder(this.mBorder);
        this.addFocusListener(this.mFocusHandler);
        this.addTransformListener(this.mWorldListener);
        this.mDb = db;
        this.mViewMenu = new ArrayList();
        this.initColorizer();
        this.setOpaque(true);
        this.setFocusable(true);
        this.addMouseMotionListener(this.mMouseHandler);
        this.addMouseListener(this.mMouseHandler);
        this.loadConfig();
        this.loadDefaults();
        this.initActions();
        this.bindKeys();
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        if (((Boolean)userPrefs.getSetting("RestoreLastDesignZoomOnOpen", (Object)true)).booleanValue()) {
            ARect rectLastZoom;
            Design design = Design.getDesign((Db)this.mDb, (boolean)false);
            ARect aRect = rectLastZoom = design == null ? null : (ARect)design.getValue(FLDNAME_LASTZOOM, ARect.class);
            if (rectLastZoom != null) {
                this.zoomTo(rectLastZoom);
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EventQueue.invokeLater(() -> {
            if (this.getParent() != null) {
                return;
            }
            this.deinitialize();
        });
    }

    public void deinitialize() {
        this.mDb = null;
        this.mColorizer = null;
        this.removeFocusListener(this.mFocusHandler);
        this.removeTransformListener(this.mWorldListener);
        this.removeMouseMotionListener(this.mMouseHandler);
        this.removeMouseListener(this.mMouseHandler);
        this.mViewMenu.clear();
        this.getActionMap().clear();
        this.getInputMap(2).clear();
        this.getInputMap(1).clear();
    }

    public Db getDb() {
        return this.mDb;
    }

    public Point getMouseLoc() {
        return this.mMouseLoc;
    }

    public Point getLastKnownMouseLoc() {
        if (this.mMouseLoc != null) {
            return this.mMouseLoc;
        }
        if (this.mLastMouseEvent != null) {
            return this.mLastMouseEvent.getPoint();
        }
        return null;
    }

    private void setViewSettings(ViewColorizer colorizer) {
        this.mColorizer = colorizer;
        this.putClientProperty(PROP_COLORIZER, this.mColorizer);
        Design design = Design.getDesign((Db)this.mDb, (boolean)false);
        if (design != null) {
            DesignSettings.set((Design)design, (String)"ViewColorizer", (Object)this.mColorizer);
        }
        this.refresh();
    }

    public void resetViewSettings() {
        if (Design.getDesign((Db)this.mDb, (boolean)false) != null) {
            this.setViewSettings(ViewColorizer.createViewColorizer((Db)this.mDb, (DevicePath)Design.getDesignPath((Db)this.mDb)));
        }
    }

    protected void loadConfig() {
        block5: {
            File f = Settings.findConfigFile((String)FILENAME_CONFIG);
            if (f == null) {
                return;
            }
            Element xdoc = AXDomUtil.getDocumentElement((File)f);
            if (xdoc == null || !xdoc.getTagName().equals(XMLCFG_ELEM_ROOT)) {
                return;
            }
            Element elBorder = AXDomUtil.getFirstChildElement((Node)xdoc, (String)"Border");
            if (elBorder != null) {
                try {
                    int s = AXDomUtil.getIntAttribute((Element)elBorder, (String)"size", (int)1, (boolean)true);
                    this.mBorder.setSize(s);
                }
                catch (AXmlUtil.AXmlException e) {
                    if (e.getCause() instanceof AXmlUtil.NoSuchAttrException) break block5;
                    ALog.logWarn((Throwable)e, (String)"Error reading file '%s' elment 'Border' attribute 'size'. %s", (Object[])new Object[]{f.getAbsolutePath(), e.getMessage()});
                }
            }
        }
    }

    protected void initColorizer() {
        this.mColorizer = DesignSettings.getViewColorizer((Db)this.mDb);
        if (this.mColorizer != null) {
            this.putClientProperty(PROP_COLORIZER, this.mColorizer);
        } else {
            this.resetViewSettings();
        }
    }

    private XForm getNextUndo() {
        int txn = this.mScreenHistory.size() - this.mScreenUndone - 2;
        if (txn < 0 || txn >= this.mScreenHistory.size()) {
            return null;
        }
        return this.mScreenHistory.get(txn);
    }

    private XForm getNextRedo() {
        int txn = this.mScreenHistory.size() - this.mScreenUndone;
        if (txn < 0 || txn >= this.mScreenHistory.size()) {
            return null;
        }
        return this.mScreenHistory.get(txn);
    }

    public void zoomPrevious() {
        XForm x = this.getNextUndo();
        if (x == null) {
            ALog.logWarn((String)"There is nothing to previous view.");
            return;
        }
        this.inUndoRedo = true;
        this.mScreenTransform.setXForm(x);
        this.refresh();
        ++this.mScreenUndone;
        this.inUndoRedo = false;
    }

    public void zoomNext() {
        XForm x = this.getNextRedo();
        if (x == null) {
            ALog.logWarn((String)"There is nothing to next view.");
            return;
        }
        this.inUndoRedo = true;
        this.mScreenTransform.setXForm(x);
        this.refresh();
        --this.mScreenUndone;
        this.inUndoRedo = false;
    }

    public void truncateView() {
        while (this.mScreenUndone > 0) {
            this.mScreenHistory.removeLast();
            --this.mScreenUndone;
        }
    }

    protected void repaintBorder() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        this.mBorder.paintBorder(this, g, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        g.dispose();
    }

    @Override
    public boolean isValid() {
        return this.mScreenTransform != null && this.mScreenTransform.isWorldValid();
    }

    public synchronized void refresh() {
        if (this.mReimagePending) {
            return;
        }
        this.mReimagePending = true;
        EventQueue.invokeLater(() -> {
            if (!this.mReimagePending) {
                return;
            }
            if (Design.getDesign((Db)this.mDb, (boolean)false) != null) {
                this.reimageFromDb();
                this.repaint();
            }
        });
    }

    public void refreshNow() {
        Container topAncestor = this.getTopLevelAncestor();
        if (topAncestor != null) {
            topAncestor.validate();
        }
        this.reimageFromDb();
        this.paintImmediately(this.getBounds());
    }

    public APoint2D getWorldPt(Point screenPt) {
        return this.mScreenTransform.getWorldPt(screenPt);
    }

    public Point2D.Double screenToUser(Point p) {
        if (this.mScreenTransform == null) {
            return new Point2D.Double();
        }
        APoint2D worldPoint = this.mScreenTransform.getWorldPt(p);
        Design design = Design.getDesign((Db)this.mDb, (boolean)false);
        if (design == null) {
            return new Point2D.Double(p.getX(), p.getY());
        }
        double ux = design.getUser(worldPoint.getX());
        double uy = design.getUser(worldPoint.getY());
        return new Point2D.Double(ux, uy);
    }

    public Double worldToUserDist(long worldDist) {
        Design design = Design.getDesign((Db)this.mDb, (boolean)false);
        if (design == null) {
            return 0.0;
        }
        return design.getUser(worldDist);
    }

    public Point2D.Double worldToUser(APoint2D p) {
        Design design = Design.getDesign((Db)this.mDb, (boolean)false);
        if (design == null) {
            return new Point2D.Double(p.getX(), p.getY());
        }
        return new Point2D.Double(design.getUser(p.getX()), design.getUser(p.getY()));
    }

    public ARect getWorldBounds() {
        Design design = Design.getDesign((Db)this.mDb, (boolean)false);
        if (design != null) {
            return design.getExtent().copy();
        }
        ARect bounds = null;
        for (Device d : this.mDb.getObjects(Device.class)) {
            if (d.getParent() != null) continue;
            if (bounds == null) {
                bounds = new ARect(d.getBB());
                continue;
            }
            bounds.expand(bounds);
        }
        if (bounds != null) {
            return bounds;
        }
        return new ARect();
    }

    public ARect getWorldDrawBounds() {
        return this.mWorldDrawBounds;
    }

    public Selection getSelected() {
        return this.mSelected;
    }

    public Graphics2D getGraphicsMain() {
        return this.mGMain;
    }

    public Graphics2D getGraphicsSelected() {
        return this.mGSelected;
    }

    public XForm getXForm() {
        return this.mScreenTransform;
    }

    public XForm copyXForm(XForm src) {
        return new XForm(src);
    }

    public void setXForm(XForm xform) {
        this.fireTransformPreChange(xform);
        this.mScreenTransform = xform;
        this.fireTransformChanged(xform);
    }

    public Image getImage() {
        return this.getImage(false);
    }

    public Image getImage(boolean oversize) {
        return this.getImage(oversize, -1, -1);
    }

    public Image getImage(boolean oversize, int width, int height) {
        if (this.mMainBuffer == null) {
            return null;
        }
        int dx = this.mMainBuffer.getWidth(null);
        int dy = this.mMainBuffer.getHeight(null);
        if (!oversize && this.mLargeBuffer) {
            dx /= 3;
            dy /= 3;
        }
        boolean userSize = width > 0 && height > 0;
        BufferedImage img = new BufferedImage(userSize ? width : dx, userSize ? height : dy, 1);
        Graphics2D g = (Graphics2D)((Image)img).getGraphics();
        DesignCanvas2D.prepareGraphics(g);
        g.setColor(this.getBackgroundColor());
        g.fillRect(0, 0, userSize ? width : dx, userSize ? height : dy);
        Composite oldComposite = g.getComposite();
        if (this.mUnhighlightAlpha > 0.0f) {
            if (this.mUnhighlightAlpha >= 1.0f) {
                g.setComposite(AlphaComposite.SrcOver);
            } else {
                g.setComposite(AlphaComposite.getInstance(3, this.mUnhighlightAlpha));
            }
            if (!oversize && this.mLargeBuffer) {
                g.drawImage(this.mMainBuffer, 0, 0, userSize ? width : dx, userSize ? height : dy, dx, dy, dx * 2, dy * 2, null);
            } else {
                g.drawImage(this.mMainBuffer, 0, 0, null);
            }
        }
        g.setComposite(AlphaComposite.SrcOver);
        if (!oversize && this.mLargeBuffer) {
            g.drawImage(this.mHighlightBuffer, 0, 0, userSize ? width : dx, userSize ? height : dy, dx, dy, dx * 2, dy * 2, null);
        } else {
            g.drawImage(this.mHighlightBuffer, 0, 0, null);
        }
        g.setComposite(oldComposite);
        g.dispose();
        return img;
    }

    public boolean hasLargeBuffer() {
        return this.mLargeBuffer;
    }

    public void setUnhighlightAlpha(float a) {
        if (this.mUnhighlightAlpha == (a = Math.max(0.0f, Math.min(1.0f, a)))) {
            return;
        }
        this.mUnhighlightAlpha = a;
        this.updateSelectionColors();
        this.repaint();
    }

    public float getUnhighlightAlpha() {
        return this.mUnhighlightAlpha;
    }

    public void setUseSelectionColorThreshold(float t) {
        if (this.mSelectionColorsThreshold == t) {
            return;
        }
        this.mSelectionColorsThreshold = t;
        this.updateSelectionColors();
    }

    public void updateSelectionColors() {
        boolean useSelColors;
        boolean bl = useSelColors = this.mUnhighlightAlpha >= this.mSelectionColorsThreshold;
        if (useSelColors != this.mColorizer.getUseSelectionColors()) {
            this.mColorizer.setUseSelectionColors(useSelColors);
        }
    }

    public float getUseSelectionColorsThreshold() {
        return this.mSelectionColorsThreshold;
    }

    public void addAction(Action a) {
        if (this.getActionMap().get(a.getValue("Name")) != null) {
            ALog.logDebug((String)"Duplicate Action Setting in Design Canvas");
        }
        this.getActionMap().put(a.getValue("Name"), a);
    }

    public void removeAction(Action a) {
        this.getActionMap().remove(a.getValue("Name"));
    }

    public void bindKeyGlobal(String action) {
        this.bindKey(action, true);
    }

    public void bindKey(String action) {
        this.bindKey(action, false);
    }

    public void bindKey(String action, boolean global) {
        KeyStroke keyStroke = OrbitHotkey.getKeyStroke(action);
        if (keyStroke == null) {
            return;
        }
        InputMap inputMap = this.getInputMap(global ? 2 : 1);
        inputMap.put(keyStroke, action);
    }

    public void unbindKeyGlobal(String key) {
        this.unbindKey(key, true);
    }

    public void unbindKey(String key) {
        this.unbindKey(key, false);
    }

    public void unbindKey(String key, boolean global) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key);
        if (keyStroke == null) {
            ALog.logWarn((String)"Invalid key stroke '%s' specified while attempting to unbind key stroke.", (Object[])new Object[]{key});
            return;
        }
        InputMap inputMap = this.getInputMap(global ? 2 : 1);
        inputMap.remove(keyStroke);
    }

    public MouseEvent getLastMouseEvent() {
        return this.mLastMouseEvent;
    }

    public ViewColorizer getColorizer() {
        return this.mColorizer;
    }

    public void saveDefaults() {
        this.getColorizer().saveAsDefaults();
    }

    public void loadDefaults() {
    }

    public static void resetDefaults() {
        ViewColorizer.resetDefaults();
    }

    public Unit getUnit() {
        Design d = Design.getDesign((Db)this.mDb, (boolean)false);
        if (d != null) {
            return d.getUnit();
        }
        return null;
    }

    public boolean setWorldRectToDesignBounds() {
        ARect world = this.getWorldBounds();
        if (world == null) {
            this.mScreenTransform.invalidateWorld();
            return false;
        }
        world.expand(0.05);
        this.mScreenTransform.setWorld(world);
        return true;
    }

    public void zoomOut() {
        if (!this.mScreenTransform.isWorldValid()) {
            return;
        }
        APoint2D about = this.mMouseLoc == null ? null : this.mScreenTransform.getWorldPt(this.mMouseLoc);
        Cp.exec((String)"%s.zoom(%f, %s)", (Object[])new Object[]{UserCommands.class.getName(), 1.5, APoint2D.getAsStringArg((APoint2D)about)});
    }

    public void zoomIn() {
        if (!this.mScreenTransform.isWorldValid()) {
            return;
        }
        APoint2D about = this.mMouseLoc == null ? null : this.mScreenTransform.getWorldPt(this.mMouseLoc);
        Cp.exec((String)"%s.zoom(%f, %s)", (Object[])new Object[]{UserCommands.class.getName(), 0.6666666666666666, APoint2D.getAsStringArg((APoint2D)about)});
    }

    public void zoomFit() {
        if (this.setWorldRectToDesignBounds()) {
            this.refresh();
        }
    }

    public void zoomSelected() {
        ARect rc = this.getBBOfSelected();
        if (rc != null && rc.width() == 0L && rc.height() == 0L) {
            long min = Design.micronToInternal((Db)this.mDb, (double)1.0);
            rc.grow(min);
        }
        if (rc != null) {
            Db db = OrbitIO.getCurDb();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Zoom To");){
                Cp.exec((String)"%s.zoomTo(%s)", (Object[])new Object[]{UserCommands.class.getName(), rc.getAsStringArg()});
            }
        }
    }

    public boolean scale(double factor, APoint2D about) {
        if (!this.mScreenTransform.scale(factor, about)) {
            return false;
        }
        this.refresh();
        return true;
    }

    public void pan(int xDir, int yDir) {
        if (!this.mScreenTransform.isWorldValid()) {
            return;
        }
        Rectangle b = this.getPaintBounds();
        Point center = new Point((int)b.getCenterX(), (int)b.getCenterY());
        if (xDir != 0) {
            center.x += (int)(((double)b.width / 2.0 - 10.0) * (double)Math.signum(xDir));
        }
        if (yDir != 0) {
            center.y += (int)(((double)b.height / 2.0 - 10.0) * (double)Math.signum(yDir));
        }
        this.mScreenTransform.recenter(center);
        this.refresh();
    }

    public void zoomTo(ARect worldRect) {
        if (worldRect != null) {
            this.mScreenTransform.setWorld(worldRect);
            this.refresh();
        }
    }

    public void zoomTo(long llx, long lly, long urx, long ury) {
        ARect worlRect = new ARect(llx, lly, urx, ury);
        this.zoomTo(worlRect);
    }

    public void zoomToUser(double llx, double lly, double urx, double ury) {
        Design design = Design.getDesign((Db)this.mDb, (boolean)false);
        if (design == null) {
            ALog.logError((String)"Unable to get Design for view, cannot zoom using user coordinates.");
            return;
        }
        Unit.Distance unit = design.getUnit();
        ARect worldRect = new ARect(unit.fromUser(llx), unit.fromUser(lly), unit.fromUser(urx), unit.fromUser(ury));
        this.zoomTo(worldRect);
    }

    public void zoomToUser(Rectangle2D.Double userRect) {
        this.zoomToUser(userRect.x, userRect.y, userRect.x + userRect.width, userRect.y + userRect.height);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        Composite oldComposite = g.getComposite();
        try (BaseScale scale = this.openIdentityScale(g);){
            Rectangle viewBounds = this.getPaintBounds();
            Rectangle bufferBounds = this.getBufferBounds(viewBounds);
            if (this.mMainBuffer == null || !this.mScreenTransform.isWorldValid() || bufferBounds.width != this.mMainBuffer.getWidth(null) || bufferBounds.height != this.mMainBuffer.getHeight(null)) {
                this.reimageFromDb();
                return;
            }
            g.setColor(this.getBackgroundColor());
            g.fillRect(viewBounds.x, viewBounds.y, viewBounds.width, viewBounds.height);
            if (this.mUnhighlightAlpha > 0.0f) {
                if (this.mUnhighlightAlpha >= 1.0f) {
                    g.setComposite(AlphaComposite.SrcOver);
                } else {
                    g.setComposite(AlphaComposite.getInstance(3, this.mUnhighlightAlpha));
                }
                if (this.mLargeBuffer) {
                    g.drawImage(this.mMainBuffer, viewBounds.x, viewBounds.y, viewBounds.x + viewBounds.width, viewBounds.y + viewBounds.height, viewBounds.width, viewBounds.height, viewBounds.width + viewBounds.width, viewBounds.height + viewBounds.height, null);
                } else {
                    g.drawImage(this.mMainBuffer, viewBounds.x, viewBounds.y, null);
                }
            }
            g.setComposite(AlphaComposite.SrcOver);
            if (this.mLargeBuffer) {
                g.drawImage(this.mHighlightBuffer, viewBounds.x, viewBounds.y, viewBounds.x + viewBounds.width, viewBounds.y + viewBounds.height, viewBounds.width, viewBounds.height, viewBounds.width + viewBounds.width, viewBounds.height + viewBounds.height, null);
            } else {
                g.drawImage(this.mHighlightBuffer, viewBounds.x, viewBounds.y, null);
            }
            g.setComposite(oldComposite);
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Error painting 2D design view.", (Object[])new Object[0]);
        }
    }

    public static Rectangle scaleRect(Rectangle r, Point2D.Double scale) {
        return new Rectangle(r.x, r.y, (int)((double)r.width * scale.x), (int)((double)r.height * scale.y));
    }

    protected static Dimension scaleDim(Dimension r, Point2D.Double scale) {
        return new Dimension((int)((double)r.width * scale.x), (int)((double)r.height * scale.y));
    }

    public Rectangle getPaintBounds() {
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        size = DesignCanvas2D.scaleDim(size, this.getScale((Graphics2D)this.getGraphics()));
        return new Rectangle(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
    }

    protected Rectangle getBufferBounds() {
        if (this.mBufferBounds != null) {
            return this.mBufferBounds;
        }
        return this.getBufferBounds(null);
    }

    public Rectangle getBufferBounds(Rectangle viewBounds) {
        Rectangle bufferBounds;
        Rectangle rectangle = bufferBounds = viewBounds == null ? this.getPaintBounds() : new Rectangle(viewBounds);
        if (this.mLargeBuffer) {
            bufferBounds.x -= bufferBounds.width;
            bufferBounds.width *= 3;
            bufferBounds.y -= bufferBounds.height;
            bufferBounds.height *= 3;
        }
        return bufferBounds;
    }

    protected void reimageFromDb() {
        if (_DisableDrawing) {
            return;
        }
        if (this.mDb == null || this.mDb.closed()) {
            return;
        }
        Stopwatch timer = _TimeRedraws ? new Stopwatch() : null;
        this._reimageFromDb();
        if (timer != null) {
            ALog.logInfo((String)"Redraw %s", (Object[])new Object[]{timer.elapsedStr()});
        }
        this.mReimagePending = false;
    }

    protected void _reimageFromDb() {
        Rectangle bufferBounds;
        Rectangle visibleBounds = this.getPaintBounds();
        this.mBufferBounds = bufferBounds = this.getBufferBounds(visibleBounds);
        if (visibleBounds.width <= 0 || visibleBounds.height <= 0) {
            this.mMainBuffer = null;
            return;
        }
        if (this.mMainBuffer == null || this.mMainBuffer.getWidth(null) != bufferBounds.width || this.mMainBuffer.getHeight(null) != bufferBounds.height || this.mHighlightBuffer == null || this.mHighlightBuffer.getWidth(null) != bufferBounds.width || this.mHighlightBuffer.getHeight(null) != bufferBounds.height) {
            GraphicsConfiguration gc = this.getGraphicsConfiguration();
            this.mMainBuffer = gc.createCompatibleImage(bufferBounds.width, bufferBounds.height, 3);
            this.mHighlightBuffer = gc.createCompatibleImage(bufferBounds.width, bufferBounds.height, 3);
            this.mScreenTransform.setScreen(visibleBounds);
        }
        if (this.mMainBuffer == null || this.mHighlightBuffer == null) {
            ALog.logError((String)"Error allocating drawing buffers, unable to draw design.");
            return;
        }
        if (!this.mScreenTransform.isWorldValid()) {
            this.setWorldRectToDesignBounds();
            if (!this.mScreenTransform.isWorldValid()) {
                ALog.logError((String)"Error setting world to screen transform.");
                return;
            }
            this.repaint(visibleBounds);
        }
        this.mGMain = (Graphics2D)this.mMainBuffer.getGraphics();
        DesignCanvas2D.prepareGraphics(this.mGMain);
        this.mGSelected = (Graphics2D)this.mHighlightBuffer.getGraphics();
        DesignCanvas2D.prepareGraphics(this.mGSelected);
        this.mDesign = Design.getDesign((Db)this.mDb);
        if (this.mDesign != null) {
            this.mSelected = this.mDesign.getCurSelection();
        }
        this.mGSelected.setBackground(AColor.CLEAR);
        this.mGSelected.clearRect(0, 0, bufferBounds.width, bufferBounds.height);
        this.mGMain.setColor(this.getBackgroundColor());
        this.mGMain.fillRect(0, 0, bufferBounds.width, bufferBounds.height);
        if (this.mLargeBuffer) {
            int dx = this.mMainBuffer.getWidth(null) / 3;
            int dy = this.mMainBuffer.getHeight(null) / 3;
            this.mGMain.translate(dx, dy);
            this.mGSelected.translate(dx, dy);
        }
        this.mWorldDrawBounds = this.mScreenTransform.getWorldRect(bufferBounds);
        Stopwatch timer = _TimeRedraws ? new Stopwatch() : null;
        Runnable onComplete = () -> {
            if (_TimeRedraws) {
                AThread.print((String)"Drawing complete", (Object[])new Object[0]);
            }
            this.setDrawing(false);
            this.fireDbRepainted();
            this.mWorldDrawBounds = null;
            this.mGMain.dispose();
            this.mGMain = null;
            this.mGSelected.dispose();
            this.mGSelected = null;
            this.repaint();
            if (timer != null) {
                ALog.logInfo((String)"ViewDrawer.draw() %s", (Object[])new Object[]{timer.elapsedStr()});
            }
        };
        if (this.mViewDrawer instanceof ViewDrawer2) {
            ((ViewDrawer2)this.mViewDrawer).draw(onComplete);
            this.setDrawing(true);
            if (_TimeRedraws) {
                AThread.print((String)"Drawing started", (Object[])new Object[0]);
            }
        } else {
            if (_TimeRedraws) {
                AThread.print((String)"Drawing started", (Object[])new Object[0]);
            }
            this.setDrawing(true);
            this.mViewDrawer.draw();
            onComplete.run();
        }
    }

    public static void prepareGraphics(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public Color getBackgroundColor() {
        APatternColor c = this.mColorizer.getCanvasColor();
        return c != null ? c.getColor() : Color.WHITE;
    }

    public boolean isDrawing() {
        return this.mIsDrawing;
    }

    public PublishSubject<Boolean> drawingActive() {
        return this.mDrawingActiveSubject;
    }

    protected void setDrawing(boolean b) {
        this.mIsDrawing = b;
        this.mDrawingActiveSubject.onNext((Object)b);
    }

    protected void initActions() {
        this.mViewMenu.clear();
        JMenu zoom = new JMenu("Zoom");
        AbstractAction a = new ActionZoomIn();
        this.addAction(a);
        JMenuItem mi = new JMenuItem(a);
        mi.setText("In");
        zoom.add(mi);
        a = new ActionZoomOut();
        this.addAction(a);
        mi = new JMenuItem(a);
        mi.setText("Out");
        zoom.add(mi);
        a = new ActionZoomSelected();
        this.addAction(a);
        mi = new JMenuItem(a);
        mi.setText("Selected");
        zoom.add(mi);
        a = new ActionZoomPrevious();
        this.addAction(a);
        mi = new JMenuItem(a);
        mi.setText("Previous");
        zoom.add(mi);
        a = new ActionZoomNext();
        this.addAction(a);
        mi = new JMenuItem(a);
        mi.setText("Next");
        zoom.add(mi);
        a = new ActionZoomFit();
        this.addAction(a);
        mi = new JMenuItem(a);
        mi.setText("Fit");
        zoom.add(mi);
        this.mViewMenu.add(zoom);
        JMenu pan = new JMenu("Pan");
        a = new ActionPanDirection(PAN_DIR.RIGHT);
        this.addAction(a);
        pan.add(a);
        a = new ActionPanDirection(PAN_DIR.LEFT);
        this.addAction(a);
        pan.add(a);
        a = new ActionPanDirection(PAN_DIR.UP);
        this.addAction(a);
        pan.add(a);
        a = new ActionPanDirection(PAN_DIR.DOWN);
        this.addAction(a);
        pan.add(a);
        this.mViewMenu.add(pan);
        this.mViewMenu.add(null);
        a = new ActionRefresh();
        this.addAction(a);
        this.mViewMenu.add(new JMenuItem(a));
        a = new ActionRefreshCache();
        this.addAction(a);
        this.mViewMenu.add(new JMenuItem(a));
        a = new AbstractAction("Refresh Now", OrbitIcons.REFRESH){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignCanvas2D.this.refreshNow();
            }
        };
        this.addAction(a);
        a = new AbstractAction("Focus Canvas"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignCanvas2D.this.requestFocusInWindow();
            }
        };
        this.addAction(a);
    }

    protected void bindKeys() {
        this.bindKeyGlobal("Focus Canvas");
        this.bindKeyGlobal("Refresh");
        this.bindKeyGlobal("Force Refresh Cache");
        this.bindKey("Zoom In");
        this.bindKey("Zoom Out");
        this.bindKey("Zoom Fit");
        this.bindKey("Zoom Selected");
        this.bindKey("Zoom Previous");
        this.bindKey("Pan Up");
        this.bindKey("Pan Down");
        this.bindKey("Pan Left");
        this.bindKey("Pan Right");
    }

    public List<JMenuItem> getViewMenu() {
        return this.mViewMenu;
    }

    public <T extends DbObject> ARect getBBOfSelected(Class<T> dbObjectType) {
        Selection sel = this.mSelected;
        ARect selBB = null;
        for (HierInst selObj : sel.getSelectedHierInsts(dbObjectType)) {
            ARect bb = null;
            if (HierPortShape.class.isInstance(selObj)) {
                HierPortShape hierPort = (HierPortShape)HierPortShape.class.cast(selObj);
                bb = hierPort.getWorldBB();
            } else {
                bb = selObj.getPath().getBBOfChildObj(selObj.getDbObject(), false);
            }
            if (bb == null) continue;
            if (selBB == null) {
                selBB = new ARect(bb);
                continue;
            }
            selBB.expand(bb);
        }
        if (dbObjectType == Connection.class) {
            for (Connection c : sel.get(Connection.class)) {
                if (selBB == null) {
                    selBB = c.getBounds();
                    continue;
                }
                selBB.expand(c.getBounds());
            }
        }
        return selBB;
    }

    public ARect getBBOfSelected() {
        ARect[] bbs = new ARect[]{this.getBBOfSelected(Device.class), this.getBBOfSelected(Connection.class), this.getBBOfSelected(PinTemplate.class), this.getBBOfSelected(PinInstance.class), this.getBBOfSelected(LayerShape.class), this.getBBOfSelected(Obstacle.class), this.getBBOfSelected(Wire.class), this.getBBOfSelected(Metal.class), this.getBBOfSelected(Bundle.class)};
        ARect result = null;
        for (ARect bb : bbs) {
            if (bb == null) continue;
            if (result == null) {
                result = bb;
                continue;
            }
            result.expand(bb);
        }
        return result;
    }

    public ARect getVisibleBounds() {
        Rectangle paintBounds = this.getPaintBounds();
        long llx = this.mScreenTransform.getWorldX(paintBounds.x);
        long lly = this.mScreenTransform.getWorldY(paintBounds.y + paintBounds.height);
        long urx = this.mScreenTransform.getWorldX(paintBounds.x + paintBounds.width);
        long ury = this.mScreenTransform.getWorldY(paintBounds.y);
        return new ARect(llx, lly, urx, ury);
    }

    public boolean addTransformListener(TransformListener l) {
        return this.mXFormListeners.add(l);
    }

    public boolean removeTransformListener(TransformListener l) {
        return this.mXFormListeners.remove(l);
    }

    protected void fireTransformPreChange(XForm newXForm) {
        for (TransformListener l : this.mXFormListeners) {
            l.transformPreChange(newXForm);
        }
    }

    protected void fireTransformChanged(XForm newXForm) {
        for (TransformListener l : this.mXFormListeners) {
            l.transformChanged(newXForm);
        }
    }

    public Observable<Void> observeReimage() {
        return this.mReimageSubject;
    }

    @Deprecated
    public boolean addDbRepaintedListener(DbRepaintedListener l) {
        return this.mDbRepainedtedListeners.add(l);
    }

    @Deprecated
    public boolean removeDbRepaintedListener(DbRepaintedListener l) {
        return this.mDbRepainedtedListeners.remove(l);
    }

    @Deprecated
    protected void fireDbRepainted() {
        this.mReimageSubject.onNext(null);
        for (DbRepaintedListener l : this.mDbRepainedtedListeners) {
            l.dbRepainted();
        }
    }

    public static void drawArrow(DesignView2D view, Graphics2D g, Point point, AGeomUtil.Orient direction) {
        DesignCanvas2D.drawArrow(view, g, point, direction, g.getColor(), g.getColor());
    }

    public static void drawArrow(DesignView2D view, Graphics2D g, Point point, AGeomUtil.Orient direction, Color lineColor, Color splitColor) {
        int x;
        Polygon pol = new Polygon();
        ALine lineSplit = null;
        ALine lineArrow = null;
        int lenAW = 6;
        int lenAH = lenAW * 3;
        int lenLine = lenAW * 4;
        int arrowWidth = lenAW * 2 + 1;
        int arrowLineWidth = lenAH + lenLine;
        if (direction == AGeomUtil.Orient.E) {
            x = (int)(point.getX() - (double)lenAH);
            pol.addPoint(x, (int)point.getY() + lenAW);
            pol.addPoint(x, (int)point.getY() - lenAW);
            pol.addPoint((int)point.getX(), (int)point.getY());
            lineSplit = new ALine((long)point.getX(), (long)(point.getY() - (double)arrowWidth), (long)point.getX(), (long)(point.getY() + (double)arrowWidth));
            x = (int)(point.getX() - (double)arrowLineWidth);
            lineArrow = new ALine((long)x, (long)point.getY(), (long)(x + lenLine), (long)point.getY());
        } else if (direction == AGeomUtil.Orient.W) {
            x = (int)(point.getX() + (double)lenAH);
            pol.addPoint(x, (int)point.getY() + lenAW);
            pol.addPoint(x, (int)point.getY() - lenAW);
            pol.addPoint((int)point.getX(), (int)point.getY());
            lineSplit = new ALine((long)point.getX(), (long)(point.getY() - (double)arrowWidth), (long)point.getX(), (long)(point.getY() + (double)arrowWidth));
            x = (int)(point.getX() + (double)arrowLineWidth);
            lineArrow = new ALine((long)x, (long)point.getY(), (long)(x - lenLine), (long)point.getY());
        } else assert (false);
        g.fillPolygon(pol);
        Color oldColor = g.getColor();
        if (splitColor != null) {
            g.setColor(splitColor);
            g.drawLine((int)lineSplit.getP0().getX(), (int)lineSplit.getP0().getY(), (int)lineSplit.getP1().getX(), (int)lineSplit.getP1().getY());
        }
        if (lineColor != null) {
            g.setColor(lineColor);
            g.drawLine((int)lineArrow.getP0().getX(), (int)lineArrow.getP0().getY(), (int)lineArrow.getP1().getX(), (int)lineArrow.getP1().getY());
        }
        g.setColor(oldColor);
    }

    public static Rectangle drawLine(Graphics2D g, XForm screenXform, ALine line, AffineTransform xform, Color outline, boolean fill) {
        line = line.transform(xform);
        Line2D shape = screenXform.getScreenLine(line);
        boolean screenWidth = true;
        g.setStroke(new BasicStroke((float)screenWidth, 1, 1));
        g.draw(shape);
        return shape.getBounds();
    }

    public static Rectangle drawPath(Graphics2D g, XForm screenXform, APath path, AffineTransform xform, Color outline, boolean fill) {
        int screenWidth = Math.max(screenXform.getScreenLength(path.getWidth()), 1);
        g = (Graphics2D)g.create();
        Rectangle bounds = screenXform.getScreenRect(path.transform(xform).getBounds());
        if (screenWidth <= 3) {
            Stroke pathStroke = DesignCanvas2D.getAPathStroke(path, screenWidth);
            g.setStroke(pathStroke);
            GeneralPath screenPath = new GeneralPath();
            for (APoint2D pt : path.getPoints()) {
                APoint2D worldPoint = pt.transform(xform);
                Point screenPt = screenXform.getScreenPt(worldPoint);
                if (screenPath.getCurrentPoint() == null) {
                    screenPath.moveTo(screenPt.x, screenPt.y);
                    continue;
                }
                screenPath.lineTo(screenPt.x, screenPt.y);
            }
            if (outline != null) {
                g.setColor(outline);
            }
            g.draw(screenPath);
        } else {
            AffineTransform trans = new AffineTransform(xform);
            trans.preConcatenate(screenXform.getWorldToScreenTransform());
            path = path.transform(trans);
            Shape area = path.getAwtShape();
            if (fill) {
                g.fill(area);
            }
            if (outline != null) {
                g.setColor(outline);
            }
            g.draw(area);
        }
        return bounds;
    }

    public static Rectangle drawGeom(Graphics2D g, XForm screenXform, AGeom geom, AffineTransform xform, Color outline) {
        return DesignCanvas2D.drawGeom(g, screenXform, geom, xform, outline, true);
    }

    public static Rectangle drawGeom(Graphics2D g, XForm screenXform, AGeom geom, AffineTransform xform, Color outline, boolean fill) {
        g = (Graphics2D)g.create();
        Shape shape = null;
        Rectangle bounds = null;
        if (geom instanceof APath) {
            return DesignCanvas2D.drawPath(g, screenXform, (APath)geom, xform, outline, fill);
        }
        if (geom instanceof ALine) {
            return DesignCanvas2D.drawLine(g, screenXform, (ALine)geom, xform, outline, fill);
        }
        if (!fill && geom instanceof ACompositeGeom) {
            ACompositeGeom cg = (ACompositeGeom)geom;
            for (AGeom child : cg.getChildren()) {
                Rectangle r = DesignCanvas2D.drawGeom(g, screenXform, child, xform, outline, fill);
                if (bounds == null) {
                    bounds = r;
                    continue;
                }
                if (r == null) continue;
                bounds.add(r);
            }
            return bounds;
        }
        shape = RegionShapeFactory.getShape(screenXform, geom, xform, false);
        if (shape == null) {
            return null;
        }
        bounds = shape.getBounds();
        if (bounds.width <= 1 || bounds.height <= 1) {
            if (outline != null) {
                g.setColor(outline);
            }
            g.fill(new Rectangle2D.Double(bounds.x, bounds.y, Math.max(1, bounds.width), Math.max(1, bounds.height)));
            return bounds;
        }
        if (fill) {
            g.fill(shape);
            if (outline != null) {
                g.setColor(outline);
                g.draw(shape);
            }
        } else if (outline == null) {
            g.draw(shape);
        } else {
            g.setColor(outline);
            g.draw(shape);
        }
        return bounds;
    }

    public static Stroke getAPathStroke(APath path, int screenWidth) {
        int join = 1;
        int cap = 2;
        APath.ExtStyle capStroke = path.getExtStyle();
        APath.StrokeType stroke = path.getStrokeType();
        if (capStroke == APath.ExtStyle.NONE) {
            cap = 0;
        } else if (capStroke == APath.ExtStyle.SQUARE) {
            cap = 2;
        } else if (capStroke == APath.ExtStyle.ROUND) {
            cap = 1;
        } else assert (false);
        if (stroke == APath.StrokeType.DEFAULT) {
            join = 1;
        } else if (stroke == APath.StrokeType.OCTAGON) {
            join = 2;
        } else assert (false);
        return new BasicStroke(screenWidth, cap, join);
    }

    public static Stroke getWireStroke(Wire w, int screenWidth) {
        int join = 1;
        int cap = 2;
        Long extension = w.getExtension();
        if (extension != null && extension == 0L) {
            cap = 0;
        } else {
            Constraint.EndCapType capType = w.getEndCapType();
            switch (capType) {
                case NONE: {
                    cap = 0;
                    break;
                }
                case ROUND: {
                    cap = 1;
                    break;
                }
            }
        }
        return new BasicStroke(screenWidth, cap, join);
    }

    public static ViewDrawerRegistry getViewDrawerRegistry() {
        return gViewDrawRegistry;
    }

    public ViewDrawer getCurDrawer() {
        return this.mViewDrawer;
    }

    public ViewDrawer getPriorDrawer() {
        return this.mViewDrawerPrior;
    }

    public void setDrawer(ViewDrawer drawer) {
        if (drawer == null) {
            ViewDrawerFactory dfltFactory = DesignCanvas2D.getViewDrawerRegistry().getDefault();
            if (dfltFactory == null) {
                ALog.logError((String)"Unable to obtain a default ViewDrawerFactory.");
                return;
            }
            drawer = dfltFactory.create(this);
            if (drawer == null) {
                ALog.logError((String)"Unable to create a default ViewDrawer.");
                return;
            }
        }
        if (drawer == this.mViewDrawer || drawer.equals(this.mViewDrawer)) {
            return;
        }
        if (this.mViewDrawer != null) {
            this.mViewDrawerPrior = this.mViewDrawer;
        }
        if (this.mViewDrawer != null) {
            this.mViewDrawer.uninstallDrawer();
        }
        this.mViewDrawer = drawer;
        drawer.installDrawer(this);
        if (_TimeRedraws) {
            ALog.logDebug((String)"Drawer set to '%s'.", (Object[])new Object[]{drawer.getName()});
        }
        this.refresh();
    }

    public static void resetCanvasViewSettings() {
        DesignView2D view = (DesignView2D)OrbitIO.getCurView();
        DesignCanvas2D canvas = view.getCanvas();
        canvas.resetViewSettings();
    }

    public static void setAppFixBlurry(boolean b) {
        mAppFixBlurry = b;
    }

    public Point2D.Double getScale(Graphics2D g) {
        if (!mAppFixBlurry) {
            return IdentityScale;
        }
        if (g == null) {
            g = (Graphics2D)this.getGraphics();
        }
        if (g == null) {
            return IdentityScale;
        }
        AffineTransform transform = g.getTransform();
        if (transform.getScaleX() == 1.0 || transform.getScaleY() == 1.0) {
            return IdentityScale;
        }
        return new Point2D.Double(transform.getScaleX(), transform.getScaleY());
    }

    public BaseScale openIdentityScale(Graphics2D g) {
        return new BaseScale(g);
    }

    public class BaseScale
    implements Closeable {
        protected Graphics2D mG2d;
        protected AffineTransform mOldTransform;
        protected Point2D.Double mScale;
        protected AffineTransform mFixup = null;

        protected BaseScale(Graphics2D g) {
            this.mG2d = g;
            this.mOldTransform = g.getTransform();
            this.mScale = DesignCanvas2D.this.getScale(g);
            if (!this.mScale.equals(IdentityScale) && mAppFixBlurry) {
                assert (DesignCanvas2D.this.mBaseScale == IdentityScale);
                DesignCanvas2D.this.mBaseScale = this.mScale;
                g.scale(1.0 / this.mScale.getX(), 1.0 / this.mScale.getY());
            }
        }

        public Point2D.Double getScale() {
            return this.mScale;
        }

        @Override
        public void close() {
            if (mAppFixBlurry) {
                this.mG2d.setTransform(this.mOldTransform);
                DesignCanvas2D.this.mBaseScale = IdentityScale;
            }
        }

        public AffineTransform getFixup() {
            if (!mAppFixBlurry) {
                return AffineTransform.getScaleInstance(1.0, 1.0);
            }
            if (this.mFixup == null) {
                this.mFixup = AffineTransform.getScaleInstance(this.mScale.x, this.mScale.y);
            }
            return this.mFixup;
        }
    }

    public static interface ViewDrawer2
    extends ViewDrawer {
        @Override
        default public void draw() {
            this.draw(() -> {});
        }

        public void draw(Runnable var1);
    }

    public static interface ViewDrawer {
        public String getName();

        public void installDrawer(DesignCanvas2D var1);

        public void uninstallDrawer();

        public void draw();
    }

    public static interface ViewDrawerFactory {
        public String getName();

        public boolean isAvailable(DesignCanvas2D var1);

        public ViewDrawer create(DesignCanvas2D var1);
    }

    public static class ViewDrawerRegistry {
        protected LinkedList<ViewDrawerFactory> mFactories = new LinkedList();

        public ViewDrawerRegistry() {
            this.setDefault(DefaultViewDrawer.Factory);
            this.loadConfig();
        }

        public void setDefault(ViewDrawerFactory f) {
            this.mFactories.remove(f);
            this.mFactories.add(0, f);
        }

        public void add(ViewDrawerFactory f) {
            if (!this.mFactories.contains(f)) {
                this.mFactories.add(f);
            }
        }

        public ViewDrawerFactory getDefault() {
            return this.mFactories.isEmpty() ? null : this.mFactories.get(0);
        }

        public IterableIterator<ViewDrawerFactory> getAll() {
            return AIterableItr.itr(this.mFactories);
        }

        public boolean remove(ViewDrawerFactory f) {
            if (this.mFactories.size() == 1) {
                ALog.logWarn((String)"Attempt to remove the only registered drawer '%s' from the ViewDrawerRegistry, the drawer is not being removed.", (Object[])new Object[]{this.mFactories.get(0).getName()});
                return false;
            }
            return this.mFactories.remove(f);
        }

        protected void loadConfig() {
            AtomicBoolean defViewDrawerSet = new AtomicBoolean(false);
            Settings.findConfigFiles((String)FILENAME_CONFIG).stream().map(f -> AXDomUtil.getDocumentElement((File)f)).filter(Objects::nonNull).flatMap(xdoc -> AXDomUtil.getElements((Element)xdoc, (String)"ViewDrawers/ViewDrawer").stream()).forEach(elViewDrawer -> {
                ViewDrawerFactory factory = null;
                String strFactory = elViewDrawer.getAttribute("factory");
                Object o = null;
                try {
                    o = Cp.getCp().getInterpreter().eval(strFactory);
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"The factory '%s' specified for a ViewDrawer in '%s' is invalid.", (Object[])new Object[]{strFactory, elViewDrawer.getOwnerDocument().getBaseURI()});
                    return;
                }
                if (!(o instanceof ViewDrawerFactory)) {
                    ALog.logError((String)"The factory '%s' specified for a ViewDrawer in '%s' does not implement '%s'.", (Object[])new Object[]{strFactory, elViewDrawer.getOwnerDocument().getBaseURI(), ViewDrawerFactory.class.getName()});
                    return;
                }
                factory = (ViewDrawerFactory)o;
                boolean dflt = false;
                if (!defViewDrawerSet.get() && (dflt = AXDomUtil.getBooleanAttribute((Element)elViewDrawer, (String)"default"))) {
                    defViewDrawerSet.set(true);
                }
                if (dflt) {
                    this.setDefault(factory);
                } else {
                    this.add(factory);
                }
            });
        }
    }

    @Deprecated
    public static interface DbRepaintedListener {
        public void dbRepainted();
    }

    public static interface TransformListener {
        public void transformPreChange(XForm var1);

        public void transformChanged(XForm var1);
    }

    public class XForm {
        protected double mM = 1.0;
        protected double mAx = 0.0;
        protected double mAy = 0.0;
        protected ARect mWorld = null;
        protected Rectangle mScreen = null;
        protected double mS = 1.0;

        public XForm() {
        }

        public XForm(XForm src) {
            this.mM = src.mM;
            this.mAx = src.mAx;
            this.mAy = src.mAy;
            this.mS = src.mS;
            if (src.mScreen != null) {
                this.mScreen = new Rectangle(src.mScreen);
            }
            if (src.mWorld != null) {
                this.mWorld = new ARect(src.mWorld);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XForm)) {
                return false;
            }
            XForm other = (XForm)obj;
            return this.mM == other.mM && this.mAx == other.mAx && this.mAy == other.mAy && AUtil.equals((Object)this.mWorld, (Object)other.mWorld) && AUtil.equals((Object)this.mScreen, (Object)other.mScreen);
        }

        public int hashCode() {
            return Double.hashCode(this.mM) ^ Double.hashCode(this.mAx) ^ Double.hashCode(this.mAy) ^ this.mWorld.hashCode() ^ this.mScreen.hashCode();
        }

        public String toString() {
            return String.format("XForm[mWorld=%s,mScreen=%s,%f,%f,%f]", this.mWorld, this.mScreen, this.mM, this.mAx, this.mAy);
        }

        public XForm copy() {
            return new XForm(this);
        }

        public AffineTransform getWorldToScreenTransform() {
            AffineTransform xform = AffineTransform.getScaleInstance(this.mM, this.mM);
            xform.preConcatenate(AffineTransform.getTranslateInstance(this.mAx, this.mAy));
            if (this.mScreen != null) {
                xform.preConcatenate(AffineTransform.getScaleInstance(1.0, -1.0));
                xform.preConcatenate(AffineTransform.getTranslateInstance(0.0, this.mScreen.y + (this.mScreen.height + this.mScreen.y)));
            }
            return xform;
        }

        public AffineTransform apply(Graphics2D g) {
            AffineTransform orig = g.getTransform();
            g.translate(this.mAx, (double)(this.mScreen.y + this.mScreen.height) - this.mAy);
            g.scale(this.mM, -this.mM);
            return orig;
        }

        public boolean isWorldValid() {
            return this.mWorld != null;
        }

        public void invalidateWorld() {
            this.mWorld = null;
        }

        public ARect getWorld() {
            return this.mWorld;
        }

        public boolean isScreenValid() {
            return this.mScreen != null;
        }

        public Rectangle getScreen() {
            return this.mScreen;
        }

        public void setScreen(Rectangle r) {
            this.preupdate();
            this.mScreen = r;
            this.update();
        }

        public void setWorld(ARect r) {
            this.preupdate();
            this.mWorld = r;
            this.update();
        }

        public void setXForm(XForm src) {
            this.preupdate();
            this.mM = src.mM;
            this.mAx = src.mAx;
            this.mAy = src.mAy;
            this.mS = src.mS;
            if (src.mScreen != null) {
                this.mScreen = new Rectangle(src.mScreen);
            }
            if (src.mWorld != null) {
                this.mWorld = new ARect(src.mWorld);
            }
            this.update();
        }

        public int getScreenX(long worldX) {
            return (int)Math.round((double)worldX * this.mM + this.mAx);
        }

        public int getScreenY(long worldY) {
            int y = (int)Math.round((double)worldY * this.mM + this.mAy);
            if (this.mScreen != null) {
                return this.mScreen.y + (this.mScreen.height + this.mScreen.y) - y;
            }
            return 0;
        }

        public long getWorldX(int screenX) {
            if (this.mM == 0.0) {
                return 0L;
            }
            return (long)(((double)screenX * this.mS + 1.0 - this.mAx) / this.mM);
        }

        public long getWorldY(int screenY) {
            if (this.mM == 0.0 || this.mScreen == null) {
                return 0L;
            }
            double y = (double)this.mScreen.height - ((double)screenY * this.mS - (double)this.mScreen.y);
            return (long)((y - this.mAy) / this.mM);
        }

        public Point getScreenPt(APoint2D worldPoint) {
            return new Point(this.getScreenX(worldPoint.getX()), this.getScreenY(worldPoint.getY()));
        }

        public APoint2D getWorldPt(Point screenPoint) {
            if (screenPoint == null) {
                return new APoint2D();
            }
            return new APoint2D(this.getWorldX(screenPoint.x), this.getWorldY(screenPoint.y));
        }

        public Rectangle getScreenRect(ARect worldRect) {
            Point p0 = this.getScreenPt(worldRect.getLL());
            Point p1 = this.getScreenPt(worldRect.getUR());
            return new Rectangle(p0.x, p1.y, p1.x - p0.x, p0.y - p1.y);
        }

        public Polygon getScreenPolygon(APolygon worldPoly) {
            Polygon p = new Polygon();
            for (APoint2D pt : worldPoly.getPoints()) {
                Point screenPt = this.getScreenPt(pt);
                p.addPoint(screenPt.x, screenPt.y);
            }
            return p;
        }

        public Polygon getScreenPolyline(APolyline worldPoly) {
            Polygon p = new Polygon();
            for (APoint2D pt : worldPoly.getPoints()) {
                Point screenPt = this.getScreenPt(pt);
                p.addPoint(screenPt.x, screenPt.y);
            }
            return p;
        }

        public Arc2D getScreenCircle(ACircle in) {
            Point c = this.getScreenPt(in.getC());
            long r = this.getScreenLength(in.getR());
            return new Arc2D.Float((float)c.x - (float)r, (float)c.y - (float)r, (float)r * 2.0f, (float)r * 2.0f, 0.0f, 360.0f, 1);
        }

        public Arc2D getScreenArc(AArc in) {
            Point c = this.getScreenPt(in.getCenter());
            long r = this.getScreenLength(in.getRadius());
            return new Arc2D.Double((float)c.x - (float)r, (float)c.y - (float)r, (float)r * 2.0f, (float)r * 2.0f, in.startA(), in.getSweepAngle(), 0);
        }

        public Line2D getScreenLine(ALine in) {
            Point scrPoint0 = this.getScreenPt(in.getP0());
            Point scrPoint1 = this.getScreenPt(in.getP1());
            return new Line2D.Double(scrPoint0.getX(), scrPoint0.getY(), scrPoint1.getX(), scrPoint1.getY());
        }

        public Shape getScreenShape(AGeom geom) {
            if (geom == null) {
                return null;
            }
            if (geom instanceof ARect) {
                return this.getScreenRect((ARect)geom);
            }
            if (geom instanceof ACompositeGeom) {
                Area a = new Area();
                for (AGeom g : ((ACompositeGeom)geom).getChildren()) {
                    a.add(new Area(this.getScreenShape(g)));
                }
                return a;
            }
            if (geom instanceof ACircle) {
                return this.getScreenCircle((ACircle)geom);
            }
            return this.getScreenPolygon(geom.toPoly());
        }

        public ARect getWorldRect(Rectangle screenRect) {
            APoint2D p0 = this.getWorldPt(new Point(screenRect.x, screenRect.y + screenRect.height));
            APoint2D p1 = this.getWorldPt(new Point(screenRect.x + screenRect.width, screenRect.y));
            return new ARect(p0, p1);
        }

        public APolygon getWorldPolygon(Polygon screenPoly) {
            APolygon ans = new APolygon();
            for (int i = 0; i < screenPoly.npoints; ++i) {
                ans.addPoint(this.getWorldPt(new Point(screenPoly.xpoints[i], screenPoly.ypoints[i])));
            }
            return ans;
        }

        public APoint2D getWorldCenter() {
            return this.mWorld.center();
        }

        public int getScreenLength(long worldLength) {
            return (int)Math.round((double)worldLength * this.mM);
        }

        public long getWorldLength(int screenLength) {
            return Math.round((double)screenLength / this.mM);
        }

        public void recenter(Point screenPoint) {
            this.preupdate();
            this.mWorld.moveCenterTo(this.getWorldPt(screenPoint));
            this.update();
        }

        public void moveWorldBy(long dx, long dy) {
            this.preupdate();
            this.mWorld.moveBy(dx, dy);
            this.update();
        }

        public void recenter(APoint2D worldPoint) {
            this.preupdate();
            this.mWorld.moveCenterTo(worldPoint);
            this.update();
        }

        public void resize(double percent) {
            this.preupdate();
            this.mWorld.changeSizeBy(percent);
            this.update();
        }

        public int toScreenDist(long w) {
            return (int)Math.round((double)w * this.mM);
        }

        public double getWorldToScreenMultiple() {
            return this.mM;
        }

        public void scale(double factor) {
            this.scale(factor, null);
        }

        public boolean scale(double factor, APoint2D about) {
            if (!this.isWorldValid()) {
                return false;
            }
            this.preupdate();
            Point anchor = about == null ? null : this.getScreenPt(about);
            this.mWorld.scale(factor);
            if (this.mWorld.width() == 0L) {
                this.mWorld.right(this.mWorld.left() + 1L);
            }
            if (this.mWorld.height() == 0L) {
                this.mWorld.top(this.mWorld.bottom() + 1L);
            }
            if (about != null) {
                this.update(false);
                for (int i = 0; i < 10; ++i) {
                    Point afterScreenPt = this.getScreenPt(about);
                    APoint2D currentPt = this.getWorldPt(afterScreenPt);
                    APoint2D startPt = this.getWorldPt(anchor);
                    long dx = startPt.getX() - currentPt.getX();
                    long dy = startPt.getY() - currentPt.getY();
                    this.mWorld.moveBy(-dx, -dy);
                    this.update(false);
                }
            }
            this.update();
            return true;
        }

        protected void preupdate() {
            if (this == DesignCanvas2D.this.mScreenTransform) {
                DesignCanvas2D.this.fireTransformPreChange(this);
            }
        }

        protected void update() {
            this.update(true);
        }

        protected void update(boolean complete) {
            if (this.mWorld != null && this.mScreen != null) {
                double s;
                double sx = (double)this.mScreen.width / (double)this.mWorld.width();
                double sy = (double)this.mScreen.height / (double)this.mWorld.height();
                this.mM = Math.abs(sx) < Math.abs(sy) ? sx : sy;
                this.mAx = (double)this.mScreen.x + (double)this.mScreen.width / 2.0 - (double)this.mWorld.centerX() * this.mM;
                this.mAy = (double)this.mScreen.y + (double)this.mScreen.height / 2.0 - (double)this.mWorld.centerY() * this.mM;
                Point2D.Double scale = DesignCanvas2D.this.getScale((Graphics2D)DesignCanvas2D.this.getGraphics());
                this.mS = s = Math.min(scale.x, scale.y);
            }
            if (complete && this == DesignCanvas2D.this.mScreenTransform) {
                DesignCanvas2D.this.fireTransformChanged(this);
            }
        }
    }

    public class ActionPanDirection
    extends AbstractAction {
        protected PAN_DIR dir;

        public ActionPanDirection(PAN_DIR dir) {
            super(dir.text, dir.icon);
            this.dir = dir;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dir == PAN_DIR.RIGHT) {
                DesignCanvas2D.this.pan(1, 0);
            } else if (this.dir == PAN_DIR.LEFT) {
                DesignCanvas2D.this.pan(-1, 0);
            } else if (this.dir == PAN_DIR.UP) {
                DesignCanvas2D.this.pan(0, -1);
            } else if (this.dir == PAN_DIR.DOWN) {
                DesignCanvas2D.this.pan(0, 1);
            }
        }
    }

    public static enum PAN_DIR {
        RIGHT("Pan Right", OrbitIcons.PAN_RIGHT),
        LEFT("Pan Left", OrbitIcons.PAN_LEFT),
        UP("Pan Up", OrbitIcons.PAN_UP),
        DOWN("Pan Down", OrbitIcons.PAN_DOWN);

        protected String text;
        protected Icon icon;

        private PAN_DIR(String text, Icon icon) {
            this.text = text;
            this.icon = icon;
        }
    }

    public class ActionRefreshCache
    extends AbstractAction {
        public ActionRefreshCache() {
            this.putValue("Name", "Force Refresh Cache");
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("Force Refresh Cache"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            DbDoctor.resetCache((Db)db);
            DesignCanvas2D.this.refresh();
        }
    }

    public class ActionRefresh
    extends AbstractAction {
        private JPopupMenu mMenu;

        public ActionRefresh() {
            super("Refresh", OrbitIcons.REFRESH);
            this.mMenu = new JPopupMenu();
            this.mMenu.add(new JMenuItem(new AbstractAction("Refresh", OrbitIcons.REFRESH){
                {
                    super(arg0, arg1);
                    this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("Refresh"));
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesignCanvas2D.this.refresh();
                }
            }));
            this.mMenu.add(new JMenuItem(new ActionRefreshCache()));
            this.putValue("ButtonPopupMenu", this.mMenu);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mMenu.isVisible()) {
                this.mMenu.setVisible(false);
                return;
            }
            DesignCanvas2D.this.refresh();
        }
    }

    public class ActionZoomNext
    extends AbstractAction {
        public ActionZoomNext() {
            super("Zoom Next", OrbitIcons.ZOOM_NEXT);
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("Zoom Next"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignCanvas2D.this.zoomNext();
        }
    }

    public class ActionZoomPrevious
    extends AbstractAction {
        public ActionZoomPrevious() {
            super("Zoom Previous", OrbitIcons.ZOOM_PREVIOUS);
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("Zoom Previous"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignCanvas2D.this.zoomPrevious();
        }
    }

    public class ActionZoomSelected
    extends AbstractAction {
        public ActionZoomSelected() {
            super("Zoom Selected", OrbitIcons.ZOOM_SELECTED);
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("Zoom Selected"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignCanvas2D.this.zoomSelected();
        }
    }

    public class ActionZoomOut
    extends AbstractAction {
        public ActionZoomOut() {
            super("Zoom Out", OrbitIcons.ZOOM_OUT);
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("Zoom Out"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignCanvas2D.this.zoomOut();
        }
    }

    public class ActionZoomIn
    extends AbstractAction {
        public ActionZoomIn() {
            super("Zoom In", OrbitIcons.ZOOM_IN);
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("Zoom In"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignCanvas2D.this.zoomIn();
        }
    }

    public class ActionZoomFit
    extends AbstractAction {
        public ActionZoomFit() {
            super("Zoom Fit", OrbitIcons.ZOOM_FIT);
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("Zoom Fit"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Zoom Fit");){
                Cp.exec((String)"%s.zoomFit()", (Object[])new Object[]{UserCommands.class.getName()});
            }
        }
    }

    protected class MyBorder
    implements Border {
        protected int mSize = 1;
        protected Insets mInsets = new Insets(this.mSize, this.mSize, this.mSize, this.mSize);
        protected Color mColorFocus = UIManager.getColor("TabbedPane.focus");
        protected Color mColorNoFocus = UIManager.getColor("windowBorder");

        protected MyBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.mInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        public void setSize(int size) {
            this.mSize = size;
            this.mInsets = new Insets(this.mSize, this.mSize, this.mSize, this.mSize);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            boolean focused = DesignCanvas2D.this.isFocusOwner();
            g.setColor(focused ? this.mColorFocus : this.mColorNoFocus);
            for (int i = 0; i < this.mSize; ++i) {
                g.drawRect(x + i, y + i, width - 1 - i - i, height - 1 - i - i);
            }
            g.setColor(oldColor);
        }
    }
}

