/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppEnv;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.app.StatusChangeListener;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.SelectionCriteria;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.dbui.MovingSet;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ADoubleSlider;
import com.sigrity.acl.ui.ALineBorder;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.clipboard.AImageSelection;
import com.sigrity.flowman.FlowStepRegistry;
import com.sigrity.orbit.DbObjectHighlighter;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.ui.DesignCanvasInfoDisplay;
import com.sigrity.orbit.ui.DeviceListCellRenderer;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.SwapPinsUI;
import com.sigrity.orbit.ui.VisibilityControlUI;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_modes.InspectMode;
import com.sigrity.orbit.ui.canvas_modes.InteractiveMoveMode;
import com.sigrity.orbit.ui.canvas_modes.InteractiveSelectMode;
import com.sigrity.orbit.ui.canvas_modes.MakeConnectionMode;
import com.sigrity.orbit.ui.canvas_modes.MovePlaceableItemMode;
import com.sigrity.orbit.ui.canvas_modes.NavigateMode;
import com.sigrity.orbit.ui.canvas_modes.RulerMode;
import com.sigrity.orbit.ui.canvas_modes.ZoomRegionMode;
import com.sigrity.orbit.ui.common.KeyBindingUI;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.orbit.ui.core.OrbitStatusBar;
import com.sigrity.orbit.ui.core.OrbitViewFlowStep;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import rx.Observable;
import rx.subjects.PublishSubject;

public class DesignView2D
extends JLayeredPane
implements AAppView {
    static final String ACTION_TOGGLE_SCROLLBARS = "Toggle ScrollBars";
    static final String ACTION_EDIT_VIEWSETTINGS = "View Settings";
    static final String ACTION_CONNECTION_VISION = "Connection Vision";
    public static final String ACTION_CLEAR_SELECTION = "Clear Selection";
    public static final String ACTION_CLEAR_HIGHLIGHT = "Clear Highlight";
    public static final String ACTION_CLEAR_SHOWME = "Clear ShowMe";
    static final String ACTION_BUS_VIEW = "Bus View";
    static final String ACTION_SHOWME_SELECTED_DEVICES = "Show Me Selected Devices";
    static final String ACTION_SHOWME_SELECTED_PORTS = "Show Me Selected Ports";
    public static final String ACTION_SNAPSHOT_TO_CLIPBOARD = "Snapshot To Clipboard";
    public static final String ACTION_SPIT_H = "Split View Horiz";
    public static final String ACTION_SPIT_V = "Split View Vert";
    public static final String ACTION_SHOW_ACTIVE_KEYBINDINGS = "Show Active Key Bindings";
    protected static boolean sFlowStepsRegistered = false;
    protected DesignCanvas2D mCanvas;
    protected List<JMenuItem> mViewMenu;
    protected List<Action> mToolBarActions;
    protected ScrollBar mSBHorizontal;
    protected ScrollBar mSBVertical;
    protected int mOverlayCount = 0;
    protected List<JMenuItem> mModeList = new LinkedList<JMenuItem>();
    protected View2DStatus mView2DStatus = new View2DStatus();
    protected ShowMeTheWay mShowMeTheWay = null;
    public static final String MOVE_PINS = "Pin";
    public static final String MOVE_DEVICES = "Device";
    protected boolean mMonitorScrollBars = true;
    protected final int SCROLLRANGE = 1000000;
    protected DesignCanvas2D.TransformListener mWorldListener = new DesignCanvas2D.TransformListener(){

        @Override
        public void transformPreChange(DesignCanvas2D.XForm newXForm) {
        }

        @Override
        public void transformChanged(DesignCanvas2D.XForm newXForm) {
            DesignView2D.this.mMonitorScrollBars = false;
            this.processXFormChange(newXForm);
            EventQueue.invokeLater(() -> {
                DesignView2D.this.mMonitorScrollBars = true;
            });
        }

        public void processXFormChange(DesignCanvas2D.XForm newXForm) {
            assert (DesignView2D.this.mCanvas != null);
            if (DesignView2D.this.mSBHorizontal == null || DesignView2D.this.mSBVertical == null) {
                DesignView2D.this.mCanvas.removeTransformListener(this);
                return;
            }
            if (!newXForm.isWorldValid() || !newXForm.isScreenValid()) {
                return;
            }
            ARect world = DesignView2D.this.mCanvas.getWorldBounds();
            ARect view = newXForm.getWorldRect(DesignView2D.this.mCanvas.getPaintBounds());
            if (world == null || view == null || world.width() == 0L || view.width() == 0L) {
                DesignView2D.this.mSBHorizontal.setValues(-1, 2, -1, 1);
                DesignView2D.this.mSBVertical.setValues(-1, 2, -1, 1);
                return;
            }
            DesignView2D.this.mSBHorizontal.updateScrollBar(world.left(), world.right(), view.left(), view.right());
            DesignView2D.this.mSBVertical.updateScrollBar(world.bottom(), world.top(), view.bottom(), view.top());
        }
    };
    protected ChangeListener mHScroll = e -> {
        if (!this.mMonitorScrollBars) {
            return;
        }
        ScrollBar sb = this.mSBHorizontal;
        BoundedRangeModel m = sb.getModel();
        if (!this.mCanvas.isValid()) {
            return;
        }
        int newVal = m.getValue();
        if (newVal == sb.mVal) {
            return;
        }
        DesignCanvas2D.XForm x = this.mCanvas.getXForm();
        ARect visWorld = x.getWorldRect(this.mCanvas.getPaintBounds());
        double delta = (double)(newVal - sb.mVal) / sb.mScale;
        long vStart = (long)((double)sb.mViewMin + delta);
        ARect newVisibleWorld = new ARect(visWorld);
        newVisibleWorld.setLeft(vStart);
        newVisibleWorld.setRight(vStart + visWorld.width());
        this.mCanvas.mScreenTransform.setWorld(newVisibleWorld);
        this.mCanvas.refreshNow();
    };
    protected ChangeListener mVScroll = e -> {
        if (!this.mMonitorScrollBars) {
            return;
        }
        ScrollBar sb = this.mSBVertical;
        BoundedRangeModel m = sb.getModel();
        if (!this.mCanvas.isValid()) {
            return;
        }
        int newVal = m.getValue();
        if (newVal == sb.mVal) {
            return;
        }
        DesignCanvas2D.XForm x = this.mCanvas.getXForm();
        ARect visWorld = x.getWorldRect(this.mCanvas.getPaintBounds());
        double delta = (double)(newVal - sb.mVal) / sb.mScale;
        long vStart = (long)((double)sb.mViewMin - delta);
        ARect newVisibleWorld = new ARect(visWorld);
        newVisibleWorld.setBottom(vStart);
        newVisibleWorld.setTop(vStart + visWorld.height());
        this.mCanvas.mScreenTransform.setWorld(newVisibleWorld);
        this.mCanvas.refreshNow();
    };
    protected AbstractAction mToggleScrollBarsAction = new AbstractAction("Toggle ScrollBars"){
        {
            this.putValue("ButtonText", "Toggle Scroll Bars");
            this.putValue("IsSelected", false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignView2D.this.setScrollBarsVisible(!DesignView2D.this.getScrollBarsVisible());
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("IsSelected")) {
                return DesignView2D.this.getScrollBarsVisible();
            }
            return super.getValue(key);
        }
    };
    protected AbstractAction mViewSettingsAction = new AbstractAction("View Settings", OrbitIcons.VIEW_SETTING){
        {
            this.putValue("ButtonText", "View Settings...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VisibilityControlUI.showFor(DesignView2D.this);
        }
    };
    protected AbstractAction mClearSelection = new ActionClearSelection();
    protected AbstractAction mClearHighlight = new ActionClearHighlight();
    protected AbstractAction mClearShowMe = new AbstractAction("Clear ShowMe", OrbitIcons.SHOWME_CLEAR){
        {
            this.putValue("ButtonText", "Clear Show Me");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowMeTheWay.clear();
        }
    };
    private final AbstractAction mActionShowActiveKeyBindings = new ActionShowActiveKeyBindings();
    protected AbstractAction mShowMeSP = new AbstractAction("Show Me Selected Ports"){
        {
            this.putValue("ButtonText", "Show Me Selected Pins");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowMeTheWay.addSelectedPins();
        }
    };
    protected AbstractAction mSnapshotToClipboard = new AbstractAction("Snapshot To Clipboard", OrbitIcons.SNAP_TO_CLIPBOARD){
        {
            this.putValue("Name", "SnapShot");
            this.putValue("ButtonText", "Snapshot to Clipboard");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Image img = DesignView2D.this.mCanvas.getImage();
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(new AImageSelection(img), null);
            ALog.logInfo((String)"Snapshot of design view saved to system clipboard.");
        }
    };
    protected ViewMode mViewMode = null;
    protected ViewMode mViewModePrior = null;
    protected static boolean mQuiet = false;
    protected LinkedHashSet<ViewModeListener> mModeListeners = new LinkedHashSet();
    protected Float mOldHighlightFactor = null;
    protected static final Icon ICONHI = OrbitIcons.BRIGHTNESS;
    protected static final Icon ICONLO = OrbitIcons.BRIGHTNESS_LOW;
    protected HighlightSlider mAlphaSlider;
    protected MovingSet mBeingMoved = null;
    protected AbstractButton mBgIndicator = null;
    protected Map<BgProc, Thread> mBgProcs = Collections.synchronizedMap(HashBiMap.create());

    public DesignView2D(Db db) {
        this.mViewMenu = new ArrayList<JMenuItem>();
        this.mToolBarActions = new ArrayList<Action>();
        this.mCanvas = new DesignCanvas2D(db);
        this.add((Component)this.mCanvas, 10);
        this.initActions();
        this.setFocusable(false);
        this.mAlphaSlider = new HighlightSlider();
        try {
            this.restoreSettings();
        }
        catch (Exception e2) {
            ALog.logWarn((Throwable)e2, (String)"Cannot restore canvas settings", (Object[])new Object[0]);
        }
        this.mShowMeTheWay = new ShowMeTheWay(this);
    }

    public void setDefaultViewMode() {
        Optional osc;
        String selCriteriaId;
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        String vm = (String)userPrefs.getSetting("DefaultViewMode", (Object)"InspectMode");
        if (vm != null && vm.equals("InteractiveSelectMode") && (selCriteriaId = (String)userPrefs.getSetting("DefaultViewModeSelCriteria", (Object)"")) != null && !selCriteriaId.isEmpty() && (osc = SelectionCriteria.getSelectionCriteria((String)selCriteriaId)).isPresent()) {
            SelectionCriteria sc = (SelectionCriteria)osc.get();
            Action a = this.getActions().get(DesignView2D.getFavoriteInteractiveSelectionModeActionKey(sc));
            if (a != null) {
                a.actionPerformed(new ActionEvent(this, 1001, null));
                return;
            }
            this.setMode(vm);
            ViewMode m = this.getCurMode();
            if (m instanceof InteractiveSelectMode) {
                InteractiveSelectMode ism = (InteractiveSelectMode)m;
                ism.setCriteria(sc);
            }
            return;
        }
        this.setMode(vm);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.mViewMode == null) {
            EventQueue.invokeLater(() -> {
                if (this.mCanvas == null || this.mCanvas.getDb().closed()) {
                    return;
                }
                this.setDefaultViewMode();
                this.mView2DStatus.addNotify();
            });
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EventQueue.invokeLater(() -> {
            if (this.getParent() != null) {
                return;
            }
            this.setMode((ViewMode)null);
            if (this.mView2DStatus != null) {
                this.mView2DStatus.removeNotify();
                this.mView2DStatus = null;
            }
            if (this.mCanvas != null) {
                this.mCanvas.removeTransformListener(this.mWorldListener);
                this.mCanvas.deinitialize();
                this.mCanvas = null;
            }
            this.mAlphaSlider = null;
            this.mBeingMoved = null;
            this.mClearSelection = null;
            this.mClearShowMe = null;
            this.mHScroll = null;
            this.mModeListeners = null;
            this.mSBHorizontal = null;
            this.mSBVertical = null;
            this.mShowMeTheWay = null;
            this.mShowMeSP = null;
            this.mSnapshotToClipboard = null;
            this.mToggleScrollBarsAction = null;
            this.mViewMode = null;
            this.mViewModePrior = null;
            this.mViewSettingsAction = null;
            this.mVScroll = null;
            this.mWorldListener = null;
            this.removeAll();
        });
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Rectangle r = UIUtil.getBoundsMinusInsets((JComponent)this);
        r = SwingUtilities.convertRectangle(this.getParent(), r, this);
        Rectangle canvasBounds = new Rectangle(r);
        if (this.mSBHorizontal != null) {
            canvasBounds.height -= this.mSBHorizontal.getPreferredSize().height;
            canvasBounds.width -= this.mSBVertical.getPreferredSize().width;
        }
        this.mCanvas.setBounds(canvasBounds);
        for (Component c : this.getComponents()) {
            int height;
            int y;
            int width;
            int x;
            if (c == this.mSBHorizontal) {
                x = canvasBounds.x;
                width = canvasBounds.width;
                y = canvasBounds.y + canvasBounds.height;
                height = r.height - canvasBounds.height;
                c.setBounds(x, y, width, height);
                continue;
            }
            if (c == this.mSBVertical) {
                x = canvasBounds.x + canvasBounds.width;
                width = r.width - canvasBounds.width;
                y = canvasBounds.y;
                height = canvasBounds.height;
                c.setBounds(x, y, width, height);
                continue;
            }
            if (c == this.mCanvas) continue;
            c.setBounds(canvasBounds);
        }
    }

    public void addOverlay(JComponent c) {
        assert (c != null);
        this.add(c);
        this.setLayer(c, this.highestLayer() + 1);
        this.validate();
        ++this.mOverlayCount;
    }

    public void removeOverlay(JComponent c) {
        int i = this.getIndexOf(c);
        if (i < 0) {
            return;
        }
        this.remove(i);
        --this.mOverlayCount;
    }

    public int getOverlayCount() {
        return this.mOverlayCount;
    }

    public void dumpComponents() {
        for (Component c : this.getComponents()) {
            ALog.logInfo((String)"Layer %d Component %s", (Object[])new Object[]{this.getLayer(c), c.toString()});
        }
    }

    public String getTitle() {
        Design design = Design.getDesign((Db)this.getDb(), (boolean)false);
        Object title = design == null ? "" : design.getUserName();
        Db db = this.getDb();
        if (db != null && db.getDirty()) {
            title = "*" + (String)title;
        }
        return title;
    }

    public String getDescription() {
        File f = this.getDb().getFile();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public JComponent getComponent() {
        return this;
    }

    public DesignCanvas2D getCanvas() {
        return this.mCanvas;
    }

    public Db getDb() {
        return this.mCanvas == null ? null : this.mCanvas.getDb();
    }

    public AAppView.ViewStatus registerStatusListener(StatusChangeListener l, boolean register) {
        return this.mView2DStatus;
    }

    public ActionMap getActions() {
        return this.mCanvas.getActionMap();
    }

    public List<JMenuItem> getViewMenu() {
        return this.mViewMenu;
    }

    public Unit getUnit() {
        Design d = Design.getDesign((Db)this.getDb(), (boolean)false);
        if (d == null) {
            return Design.getDefaultUnitDist();
        }
        return d.getUnit();
    }

    public void setLayerDisplay(Layer layer, boolean display) {
        assert (this.mCanvas.getDb() == layer.getDb());
        ViewColorizer col = this.mCanvas.getColorizer();
        col.setDisplay(layer, display);
    }

    public boolean getLayerDisplay(Layer layer) {
        assert (this.mCanvas.getDb() == layer.getDb());
        ViewColorizer col = this.mCanvas.getColorizer();
        return col.getDisplay(layer);
    }

    @Override
    public String toString() {
        return String.format("DesignView2D '%s'", this.getTitle());
    }

    protected void setScrollBarsVisible(boolean b) {
        if (b == this.getScrollBarsVisible()) {
            return;
        }
        if (b) {
            this.mSBHorizontal = new ScrollBar(0);
            this.mSBHorizontal.getModel().addChangeListener(this.mHScroll);
            this.mSBVertical = new ScrollBar(1);
            this.mSBVertical.getModel().addChangeListener(this.mVScroll);
            this.add((Component)this.mSBHorizontal, DesignView2D.getLayer(this.mCanvas));
            this.add((Component)this.mSBVertical, DesignView2D.getLayer(this.mCanvas));
            this.mWorldListener.transformChanged(this.mCanvas.getXForm());
            this.mCanvas.addTransformListener(this.mWorldListener);
        } else {
            this.mCanvas.removeTransformListener(this.mWorldListener);
            if (this.mSBHorizontal != null) {
                this.remove(this.mSBHorizontal);
                this.mSBHorizontal = null;
            }
            if (this.mSBVertical != null) {
                this.remove(this.mSBVertical);
                this.mSBVertical = null;
            }
        }
        this.validate();
        this.saveSettings();
    }

    protected boolean getScrollBarsVisible() {
        return this.mSBHorizontal != null;
    }

    private JMenuItem createModeMenuItem(ViewModeAction a) {
        JMenuItem mi = new JMenuItem(a);
        mi.setText((String)a.getValue("ButtonText"));
        this.mModeList.add(mi);
        mi = new JMenuItem(a);
        mi.setText((String)a.getValue("ButtonText"));
        return mi;
    }

    protected void initActions() {
        this.mViewMenu.clear();
        this.mViewMenu.addAll(this.mCanvas.getViewMenu());
        JMenuItem clearShowMeItem = new JMenuItem(this.mClearShowMe);
        clearShowMeItem.setText("Clear Show Me");
        this.mViewMenu.add(clearShowMeItem);
        this.mViewMenu.add(null);
        JMenu modeMenu = new JMenu("Canvas Mode");
        ViewModeAction inspectMode = new ViewModeAction(InspectMode::new, "InspectMode", "Inspect Mode", OrbitIcons.INSPECT);
        ActionRuler rulerMode = new ActionRuler();
        ViewModeAction navMode = new ViewModeAction(NavigateMode::new, "NavigateMode", "Navigate Mode", OrbitIcons.NAVIGATE);
        ViewModeAction makeConnMode = new ViewModeAction(MakeConnectionMode::new, "MakeAConnectionMode", "Connect Pins Mode", null);
        ViewModeAction zoomMode = new ViewModeAction(ZoomRegionMode::new, "ZoomRegionMode", "Zoom Region Mode", OrbitIcons.ZOOM_REGION);
        ViewModeAction moveDeviceMode = new ViewModeAction(() -> new MovePlaceableItemMode(this), "MovePlaceableItemMode", "Move Device Mode", OrbitIcons.MOVE_DEVICE);
        ViewModeAction selectMode = new ViewModeAction(InteractiveSelectMode::new, "InteractiveSelectMode", "Interactive Select Mode", OrbitIcons.SELECT);
        ViewModeAction moveMode = new ViewModeAction(InteractiveMoveMode::new, "Move Mode", "Interactive Move Mode", OrbitIcons.MOVE_ORTH);
        JMenuItem mi = this.createModeMenuItem(inspectMode);
        this.mCanvas.addAction(mi.getAction());
        modeMenu.add(mi);
        mi = this.createModeMenuItem(rulerMode);
        this.mCanvas.addAction(mi.getAction());
        modeMenu.add(mi);
        mi = this.createModeMenuItem(navMode);
        this.mCanvas.addAction(mi.getAction());
        modeMenu.add(mi);
        mi = this.createModeMenuItem(makeConnMode);
        this.mCanvas.addAction(mi.getAction());
        modeMenu.add(mi);
        mi = this.createModeMenuItem(zoomMode);
        this.mCanvas.addAction(mi.getAction());
        modeMenu.add(mi);
        mi = this.createModeMenuItem(moveDeviceMode);
        this.mCanvas.addAction(mi.getAction());
        modeMenu.add(mi);
        mi = this.createModeMenuItem(selectMode);
        this.mCanvas.addAction(mi.getAction());
        modeMenu.add(mi);
        mi = this.createModeMenuItem(moveMode);
        this.mCanvas.addAction(mi.getAction());
        modeMenu.add(mi);
        JMenu favoritedMenu = null;
        List<Action> customSelect = this.addFavoriteSelectionCriteriaActions();
        if (AApp.getApp() == null || !AApp.getApp().hasEnv(AAppEnv.UI_THEME_INNOVUS)) {
            favoritedMenu = new JMenu("Favorited Selection Mode");
            for (Action fa : customSelect) {
                favoritedMenu.add(fa).setText((String)fa.getValue("ButtonText"));
            }
        }
        this.mViewMenu.add(modeMenu);
        if (favoritedMenu != null) {
            this.mViewMenu.add(favoritedMenu);
        }
        this.mViewMenu.add(null);
        ActionToggleConnectionDisplay displayConnection = new ActionToggleConnectionDisplay();
        this.mCanvas.addAction(displayConnection);
        this.mViewMenu.add(new JMenuItem(new ActionShowConnection()));
        this.mViewMenu.add(new JMenuItem(new ActionHideConnection()));
        this.mViewMenu.add(null);
        this.mViewMenu.add(new JMenuItem(new ActionShowActiveKeyBindings()));
        this.mCanvas.addAction(this.mActionShowActiveKeyBindings);
        this.mCanvas.bindKey(ACTION_SHOW_ACTIVE_KEYBINDINGS);
        this.mCanvas.addAction(this.mToggleScrollBarsAction);
        this.mCanvas.addAction(this.mViewSettingsAction);
        this.mViewMenu.add(new JMenuItem(this.mViewSettingsAction));
        this.mCanvas.addAction(this.mClearSelection);
        this.mCanvas.addAction(this.mClearHighlight);
        this.mCanvas.addAction(this.mClearShowMe);
        this.mCanvas.addAction(this.mShowMeSP);
        this.mCanvas.addAction(this.mSnapshotToClipboard);
        JMenuItem snapshotItem = new JMenuItem(this.mSnapshotToClipboard);
        snapshotItem.setText("Snapshot to Clipboard");
        this.mViewMenu.add(snapshotItem);
        this.mCanvas.addAction(SwapPinsUI.getSwapSelectedPinsAction());
        this.mCanvas.bindKey("RulerMode");
        this.mCanvas.bindKey("InspectMode");
        this.mCanvas.bindKey("InteractiveSelectMode");
        this.mCanvas.bindKey("NavigateMode");
        this.mCanvas.bindKey(ACTION_TOGGLE_SCROLLBARS);
        this.mCanvas.bindKey("MakeConnectionsMode");
        this.mCanvas.bindKey(ACTION_CLEAR_SELECTION);
        this.mCanvas.bindKey(ACTION_CLEAR_HIGHLIGHT);
        this.mCanvas.bindKey(ACTION_CLEAR_SHOWME);
        this.mCanvas.addAction(new RulerMode.ActionClearRulers());
        this.mCanvas.bindKey("Clear Ruler");
        this.mCanvas.bindKey("SwapSelectedPins");
        this.bindKeyCmd("Move Selected Pins", "com.sigrity.orbit.ui.core.DesignView2D.hotKeyMoveSelected(\"Pin\");", true);
        this.bindKeyCmd("Move Selected Devices", "com.sigrity.orbit.ui.core.DesignView2D.hotKeyMoveSelected(\"Device\");", true);
        this.bindKeyCmd("Swap Selected Devices", "com.sigrity.orbit.ui.DeviceTemplateUI.swapSelectedDevices()", true).putValue("ButtonText", "Swap Selected Devices");
        this.bindKeyCmd("Delete Selections", "com.sigrity.orbit.ui.canvas_modes.InteractiveSelectMode.deleteSelections();", true);
        this.bindKeyCmdGlobal("Save Design", "OrbitIO.saveCurrentDesign()", false);
        this.mToolBarActions.add(this.mCanvas.new DesignCanvas2D.ActionRefresh());
        this.mToolBarActions.add(null);
        DesignCanvas2D designCanvas2D = this.mCanvas;
        Objects.requireNonNull(designCanvas2D);
        this.mToolBarActions.add(designCanvas2D.new DesignCanvas2D.ActionPanDirection(DesignCanvas2D.PAN_DIR.LEFT));
        DesignCanvas2D designCanvas2D2 = this.mCanvas;
        Objects.requireNonNull(designCanvas2D2);
        this.mToolBarActions.add(designCanvas2D2.new DesignCanvas2D.ActionPanDirection(DesignCanvas2D.PAN_DIR.RIGHT));
        DesignCanvas2D designCanvas2D3 = this.mCanvas;
        Objects.requireNonNull(designCanvas2D3);
        this.mToolBarActions.add(designCanvas2D3.new DesignCanvas2D.ActionPanDirection(DesignCanvas2D.PAN_DIR.UP));
        DesignCanvas2D designCanvas2D4 = this.mCanvas;
        Objects.requireNonNull(designCanvas2D4);
        this.mToolBarActions.add(designCanvas2D4.new DesignCanvas2D.ActionPanDirection(DesignCanvas2D.PAN_DIR.DOWN));
        this.mToolBarActions.add(null);
        this.mToolBarActions.add(this.mCanvas.new DesignCanvas2D.ActionZoomIn());
        this.mToolBarActions.add(this.mCanvas.new DesignCanvas2D.ActionZoomOut());
        this.mToolBarActions.add(this.mCanvas.new DesignCanvas2D.ActionZoomFit());
        this.mToolBarActions.add(this.mCanvas.new DesignCanvas2D.ActionZoomSelected());
        this.mToolBarActions.add(this.mCanvas.new DesignCanvas2D.ActionZoomPrevious());
        this.mToolBarActions.add(this.mCanvas.new DesignCanvas2D.ActionZoomNext());
        this.mToolBarActions.add(null);
        this.mToolBarActions.add(navMode);
        this.mToolBarActions.add(zoomMode);
        this.mToolBarActions.add(inspectMode);
        this.mToolBarActions.add(rulerMode);
        if (AApp.getApp() != null && AApp.getApp().hasEnv(AAppEnv.UI_THEME_INNOVUS)) {
            this.mToolBarActions.add(moveMode);
        }
        this.mToolBarActions.add(null);
        this.mToolBarActions.add(selectMode);
        for (Action a : customSelect) {
            this.mToolBarActions.add(a);
        }
        this.mToolBarActions.add(null);
        this.mToolBarActions.add(this.mClearSelection);
        if (this.mClearHighlight.getValue("SmallIcon") != null) {
            this.mToolBarActions.add(this.mClearHighlight);
        }
        this.mToolBarActions.add(this.mClearShowMe);
        this.mToolBarActions.add(null);
        this.mToolBarActions.add(displayConnection);
        this.mToolBarActions.add(null);
        this.mToolBarActions.add(this.mViewSettingsAction);
        this.mToolBarActions.add(this.mSnapshotToClipboard);
        if (!sFlowStepsRegistered) {
            String stepGroup = this.getClass().getName();
            for (String key : this.getActionsKeys()) {
                FlowStepRegistry.registerStep(stepGroup, key, new OrbitViewFlowStep(key));
            }
            sFlowStepsRegistered = true;
        }
    }

    public static void hotKeyMoveSelected(String type) {
        int dCount = 0;
        int pCount = 0;
        for (DbObject o : Selection.getCurrentSelectionForDb((Db)OrbitIO.getCurDb()).getAll()) {
            if (o instanceof Device) {
                ++dCount;
            }
            if (!(o instanceof PinInstance)) continue;
            ++pCount;
        }
        if (type.equals(MOVE_PINS)) {
            if (pCount == 0) {
                ALog.logWarn((String)"No pins selected");
                return;
            }
            ALog.logInfo((String)("Moving " + pCount + " pins"));
        } else if (type.equals(MOVE_DEVICES)) {
            if (dCount == 0) {
                ALog.logWarn((String)"No devices selected");
                return;
            }
            ALog.logInfo((String)("Moving " + dCount + " devices"));
        }
        Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.Do%s.Start()", (Object[])new Object[]{type});
        APoint2D startLoc = ((DesignView2D)OrbitIO.getCurView()).getCanvas().getWorldPt(AbstractViewMode.getLastInspectedPoint());
        String locStr = String.format("%dL, %dL,", startLoc.getX(), startLoc.getY());
        Cp.exec((String)"com.sigrity.orbit.ui.PlaceableItemUI.%s(%s %s)", (Object[])new Object[]{"moveSelectedInteractively", locStr, "false,false"});
        ((DesignView2D)OrbitIO.getCurView()).getCanvas().refresh();
    }

    public static String getFavoriteInteractiveSelectionModeActionKey(SelectionCriteria sc) {
        return String.format("%s/%s", "InteractiveSelectMode", sc.getId().toString());
    }

    public List<Action> addFavoriteSelectionCriteriaActions() {
        ArrayList<Action> list = new ArrayList<Action>();
        if (AApp.getApp() != null && AApp.getApp().hasEnv(AAppEnv.UI_THEME_INNOVUS)) {
            return list;
        }
        for (SelectionCriteria sc : SelectionCriteria.getFavorites()) {
            FavoriteSelectionCriteriaAction a = new FavoriteSelectionCriteriaAction(sc);
            this.mCanvas.addAction(a);
            list.add(a);
        }
        return list;
    }

    public void removeFavoriteSelectionCriteriaActions() {
        ActionMap actionMap = this.mCanvas.getActionMap();
        for (Object key : AUtil.linkedList((Object[])actionMap.allKeys())) {
            Action a = actionMap.get(key);
            if (!(a instanceof FavoriteSelectionCriteriaAction)) continue;
            actionMap.remove(key);
        }
    }

    public Action bindKeyCmd(String actionName, String cmd, boolean refreshView) {
        Action a = this.createCmdAction(actionName, cmd, refreshView);
        this.mCanvas.bindKey(actionName);
        return a;
    }

    public Action bindKeyCmdGlobal(String actionName, String cmd, boolean refreshView) {
        Action a = this.createCmdAction(actionName, cmd, refreshView);
        this.mCanvas.bindKeyGlobal(actionName);
        return a;
    }

    protected Action createCmdAction(final String actionName, final String cmd, final boolean refreshView) {
        AbstractAction a = new AbstractAction(actionName){

            @Override
            public void actionPerformed(ActionEvent e) {
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)DesignView2D.this.mCanvas.getDb(), (String)actionName);){
                    Cp.exec((String)cmd, (Object[])new Object[0]);
                }
                if (refreshView) {
                    DesignView2D.this.mCanvas.refresh();
                }
            }
        };
        this.mCanvas.addAction(a);
        return a;
    }

    public IterableIterator<String> getActionsKeys() {
        Object[] keys = this.mCanvas.getActionMap().keys();
        return new ProcessingIterator<Object, String>(AUtil.getIterator((Object[])keys)){

            protected String process(Object o) {
                if (o instanceof String) {
                    return (String)o;
                }
                assert (false);
                return null;
            }
        };
    }

    protected void saveSettings() {
        Settings s = Settings.getSettings((String)"GUI");
        s.putSetting("ShowViewScrollBars", (Object)this.getScrollBarsVisible());
        s.save();
    }

    protected void restoreSettings() {
        DesignCanvasInfoDisplay.Factory udif;
        String udifName;
        Settings s = Settings.getSettings((String)"GUI");
        Boolean sbv = (Boolean)s.getSettingOfClass("ShowViewScrollBars", Boolean.class);
        if (sbv != null) {
            this.setScrollBarsVisible(sbv);
        } else {
            this.setScrollBarsVisible(true);
        }
        Settings userPrefs = Settings.getSettings((String)"UserPreferences");
        String string = udifName = userPrefs == null ? null : (String)userPrefs.getSettingOfClass("DefaultCanvasDisplayInfo", String.class);
        if (udifName == null) {
            DesignCanvasInfoDisplay.Registry registry = DesignCanvasInfoDisplay.getRegistry();
            DesignCanvasInfoDisplay.Factory dfltFactory = registry == null ? null : registry.getDefault();
            String string2 = udifName = dfltFactory == null ? null : dfltFactory.getName();
        }
        if (udifName != null && (udif = DesignCanvasInfoDisplay.getRegistry().getByName(udifName)) != null) {
            DesignCanvasInfoDisplay.getManager().install(this, udif);
        }
    }

    public static void setQuiet(boolean flag) {
        mQuiet = flag;
    }

    public void setMode(ViewMode mode) {
        if (!this.fireSettingMode(mode)) {
            return;
        }
        if (mode != this.mViewMode && this.mViewMode != null) {
            this.mViewModePrior = this.mViewMode;
        }
        if (this.mViewMode != null) {
            this.mViewMode.uninstallMode();
        }
        this.mViewMode = mode;
        if (mode != null) {
            mode.installMode(this);
            if (!mQuiet) {
                ALog.logInfo((String)"Mode set to '%s'.", (Object[])new Object[]{mode.getName()});
            }
            this.mCanvas.setCursor(mode.getCursor());
        } else {
            this.mCanvas.setCursor(null);
        }
        this.fireSetMode(mode);
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.mCanvas.setCursor(cursor);
    }

    public void setMode(String mode) {
        Action a = this.mCanvas.getActionMap().get(mode);
        if (a != null) {
            a.actionPerformed(null);
        }
    }

    public ViewMode getMode(String mode) {
        Action a = this.mCanvas.getActionMap().get(mode);
        if (a instanceof ViewModeAction) {
            return ((ViewModeAction)a).getMode();
        }
        return null;
    }

    public ViewMode getCurMode() {
        return this.mViewMode;
    }

    public ViewMode getPriorMode() {
        return this.mViewModePrior;
    }

    public boolean addModeListener(ViewModeListener l) {
        return this.mModeListeners.add(l);
    }

    public boolean removeModeListener(ViewModeListener l) {
        return this.mModeListeners.remove(l);
    }

    protected boolean fireSettingMode(ViewMode m) {
        for (ViewModeListener l : AUtil.linkedList(this.mModeListeners)) {
            if (l.settingMode(m)) continue;
            return false;
        }
        return true;
    }

    protected void fireSetMode(ViewMode m) {
        for (ViewModeListener l : AUtil.linkedList(this.mModeListeners)) {
            try {
                l.setMode(m);
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Something wrong in switch mode", (Object[])new Object[0]);
            }
        }
    }

    public DevicePath getDeviceAt(APoint2D worldPoint, String title, boolean guess) {
        Db db = this.getDb();
        Design design = Design.getDesign((Db)db);
        if (guess) {
            DevicePath best = this.getDeviceAt(worldPoint);
            if (best == null) {
                ALog.logWarn((String)"No device at %s.", (Object[])new Object[]{this.mCanvas.worldToUser(worldPoint)});
            } else if (best.getDevice().getIsFixed()) {
                ALog.logWarn((String)("Can't move fixed device " + best.getDevice().getName()));
                best = null;
            }
            return best;
        }
        List possible = design.getDescendantDevicesList(worldPoint);
        if (possible.isEmpty()) {
            ALog.logWarn((String)"No device at %s.", (Object[])new Object[]{this.mCanvas.worldToUser(worldPoint)});
            return null;
        }
        if (possible.size() == 1) {
            Device d = ((DevicePath)possible.get(0)).getLast();
            if (d.getIsFixed()) {
                ALog.logWarn((String)("Can't move fixed device " + d.getName()));
                return null;
            }
            return (DevicePath)possible.get(0);
        }
        final MutableBoolean ok = new MutableBoolean(false);
        final ADialog dlg = new ADialog((Component)this, title, Dialog.ModalityType.APPLICATION_MODAL);
        GridBagManager gbm = GridBagManager.layout((JDialog)dlg);
        gbm.add("Select device:");
        gbm.newline();
        ArrayList<DevicePath> freeDevices = new ArrayList<DevicePath>();
        for (DevicePath p : possible) {
            Device d = p.getLast();
            if (d.getIsFixed()) continue;
            freeDevices.add(p);
        }
        if (freeDevices.isEmpty()) {
            ALog.logWarn((String)"No free devices at %s.", (Object[])new Object[]{this.mCanvas.worldToUser(worldPoint)});
            return null;
        }
        final JList<DevicePath> lstDevices = new JList<DevicePath>(possible.toArray(new DevicePath[0]));
        lstDevices.setCellRenderer(new DeviceListCellRenderer());
        JScrollPane sp = new JScrollPane(lstDevices, 20, 30);
        lstDevices.setSelectionMode(0);
        lstDevices.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DevicePath dp;
                if (e.getClickCount() == 2 && lstDevices.locationToIndex(e.getPoint()) != -1 && !(dp = (DevicePath)lstDevices.getSelectedValue()).getLast().getIsFixed()) {
                    ok.setValue(true);
                    UIUtil.closeWindow((Window)dlg);
                }
            }
        });
        gbm.add((Component)sp, (GridBagConstraints)GridBagManager.FILLALL);
        gbm.newline();
        gbm.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnOk = new JButton("OK");
        gbm.add((Component)btnOk);
        btnOk.addActionListener(e -> {
            ok.setValue(true);
            UIUtil.closeWindow((Window)dlg);
        });
        JButton btnCancel = new JButton("Cancel");
        gbm.add((Component)btnCancel);
        btnCancel.addActionListener(e -> lstDevices.clearSelection());
        gbm.pop();
        lstDevices.setSelectedIndex(0);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOk);
        dlg.pack();
        UIUtil.center((Component)dlg);
        dlg.setVisible(true);
        if (ok.getValue()) {
            return lstDevices.getSelectedValue();
        }
        return null;
    }

    public DevicePath getDeviceAt(APoint2D worldPoint) {
        Db db = this.getDb();
        Design design = Design.getDesign((Db)db);
        List possible = design.getDescendantDevicesList(worldPoint);
        DevicePath bestGuess = null;
        for (DevicePath p : possible) {
            if (bestGuess == null) {
                bestGuess = p;
                continue;
            }
            if (!(p.getBB().area() < bestGuess.getBB().area())) continue;
            bestGuess = p;
        }
        return bestGuess;
    }

    public DevicePath getDevicePathAt(APoint2D worldPoint, Device lastDevice) {
        if (worldPoint == null) {
            return null;
        }
        Db db = this.getDb();
        Design design = Design.getDesign((Db)db);
        return design.getDescendantDevices(worldPoint).stream().filter(p -> p.getLast().equals(lastDevice)).findFirst().orElse(null);
    }

    public ARect getViewBounds() {
        return this.mCanvas.getVisibleBounds();
    }

    public ShowMeTheWay getShowMeTheWay() {
        return this.mShowMeTheWay;
    }

    public void highlight(Selection sel) {
        this.highlight(sel, true);
    }

    public void highlight(Selection sel, boolean resetHighlightFactor) {
        DesignCanvas2D canvas = this.getCanvas();
        if (sel != null) {
            if (this.mOldHighlightFactor == null) {
                this.mOldHighlightFactor = Float.valueOf(canvas.getUnhighlightAlpha());
            }
            DbObjectHighlighter.highlight(this, sel);
            if (resetHighlightFactor) {
                this.setHighlightFactor(0.1f);
            }
            canvas.refresh();
        } else {
            DbObjectHighlighter.clear(this);
            if (this.mOldHighlightFactor != null) {
                this.setHighlightFactor(this.mOldHighlightFactor.floatValue());
                this.mOldHighlightFactor = null;
            }
        }
    }

    public void setHighlightFactor(float a) {
        this.mAlphaSlider.setPos(a);
    }

    public HighlightSlider getHighlightSlider() {
        return this.mAlphaSlider;
    }

    public MovingSet getBeingMoved() {
        if (this.mBeingMoved == null) {
            this.mBeingMoved = new MovingSet(false);
        }
        return this.mBeingMoved;
    }

    public void setBeingMoved(MovingSet selset) {
        this.mBeingMoved = selset;
    }

    public BgProc runBackgroundProc(String desc, Runnable r) {
        BgProc bgp = BgProc.create(desc, r);
        Thread t = new Thread((Runnable)bgp, desc);
        this.mBgProcs.put(bgp, t);
        bgp.observeDone().subscribe(v -> {
            this.mBgProcs.remove(bgp);
            if (this.mBgProcs.isEmpty()) {
                this.removeBgIndicator();
            }
        });
        this.updateBgIndicator();
        t.start();
        return bgp;
    }

    public boolean isAlive(BgProc bgp) {
        Thread t = bgp == null ? null : this.mBgProcs.get(bgp);
        return t != null && t.isAlive();
    }

    public void interrupt(BgProc bgp) {
        Thread t;
        Thread thread = t = bgp == null ? null : this.mBgProcs.get(bgp);
        if (t != null) {
            t.interrupt();
            this.mBgProcs.remove(bgp);
        }
    }

    protected void updateBgIndicator() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this::updateBgIndicator);
            return;
        }
        if (this.mBgIndicator == null) {
            JButton btn = new JButton(UIUtil.getIcon(DesignView2D.class, (String)"res/iconBgIndicator.gif"));
            btn.setMargin(new Insets(0, 0, 0, 0));
            btn.setBorder(new ALineBorder(OrbitIO.getApp().getWorkspace().mStatusBar.getBackground(), 0, 4, 0, 0));
            btn.setBackground(Color.BLACK);
            btn.setFocusable(false);
            this.mBgIndicator = btn;
            this.mView2DStatus.addBgIndicator(this.mBgIndicator);
        }
        String tip = String.format("<html>%d view task%s active", this.mBgProcs.size(), this.mBgProcs.size() == 1 ? "" : "s");
        this.mBgIndicator.setToolTipText(tip);
    }

    protected void removeBgIndicator() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this::removeBgIndicator);
            return;
        }
        if (this.mBgIndicator == null) {
            return;
        }
        this.mView2DStatus.removeBgIndicator(this.mBgIndicator);
        this.mBgIndicator = null;
    }

    public List<Action> getToolBarActions() {
        return this.mToolBarActions;
    }

    public ViewColorizer getColorizer() {
        return this.mCanvas.getColorizer();
    }

    public static class BgProc
    implements Runnable {
        String mDesc;
        Runnable mRunnable;
        Thread mThread = null;
        protected PublishSubject<Void> mDoneSubject = PublishSubject.create();

        public static BgProc create(String desc, Runnable t) {
            return new BgProc(desc, t);
        }

        protected BgProc(String desc, Runnable r) {
            this.mDesc = desc;
            this.mRunnable = r;
        }

        public Observable<Void> observeDone() {
            return this.mDoneSubject;
        }

        @Override
        public void run() {
            try {
                this.mRunnable.run();
            }
            finally {
                this.mDoneSubject.onNext(null);
            }
        }
    }

    protected class View2DStatus
    implements AAppView.ViewStatus {
        protected JLabel mModeDisplay;
        protected Icon mIconIdle;
        protected Icon mIconDrawing;
        protected JLabel mLocationDisplay;
        protected MouseHandler mMouseHandler = null;
        protected MyViewModeListener mViewModeListener = null;
        protected JPanel mViewComp = new JPanel();
        protected JPanel mLocationComp = new JPanel();

        public View2DStatus() {
            this.mIconIdle = this.createStatusIcon(10, Color.GREEN);
            this.mIconDrawing = this.createStatusIcon(10, Color.WHITE);
            GridBagManager l = GridBagManager.layout((Container)this.mViewComp);
            this.mModeDisplay = new JLabel("---", this.mIconIdle, 10);
            this.mModeDisplay.setIconTextGap(this.mModeDisplay.getIconTextGap() / 2);
            this.mModeDisplay.setOpaque(true);
            OrbitStatusBar.setStatusLook(this.mModeDisplay);
            this.mModeDisplay.addMouseListener(new ModePopupListener());
            l.add((Component)this.mModeDisplay, (GridBagConstraints)GridBagManager.LEFT.fill(3).noInsets());
            l.addFillX();
            l = GridBagManager.layout((Container)this.mLocationComp);
            this.mLocationDisplay = new JLabel("---");
            this.mLocationDisplay.setFocusable(false);
            OrbitStatusBar.setStatusLook(this.mLocationDisplay);
            this.mLocationDisplay.setHorizontalAlignment(4);
            l.addFillX();
            l.add((Component)this.mLocationDisplay, (GridBagConstraints)GridBagManager.RIGHT.fill(3).anchor(13).noInsets());
        }

        public void addNotify() {
            this.mMouseHandler = new MouseHandler();
            DesignView2D.this.mCanvas.addMouseListener(this.mMouseHandler);
            DesignView2D.this.mCanvas.addMouseMotionListener(this.mMouseHandler);
            DesignView2D.this.mCanvas.drawingActive().subscribe(drawing -> {
                this.mModeDisplay.setIcon(drawing != false ? this.mIconDrawing : this.mIconIdle);
                if (EventQueue.isDispatchThread() && !Thread.holdsLock(this.mModeDisplay.getTreeLock())) {
                    this.mModeDisplay.paintImmediately(this.mModeDisplay.getBounds());
                }
            });
            this.mViewModeListener = new MyViewModeListener();
            DesignView2D.this.addModeListener(this.mViewModeListener);
            this.updateLocationDisplay(null);
            this.updateModeDisplay();
        }

        public void removeNotify() {
            DesignView2D.this.removeModeListener(this.mViewModeListener);
            this.mViewModeListener = null;
            DesignView2D.this.mCanvas.removeMouseMotionListener(this.mMouseHandler);
            DesignView2D.this.mCanvas.removeMouseListener(this.mMouseHandler);
            this.mMouseHandler = null;
        }

        protected void updateLocationDisplay(Point mouseLoc) {
            if (mouseLoc == null) {
                mouseLoc = DesignView2D.this.mCanvas.getMouseLoc();
            }
            if (mouseLoc == null) {
                this.mLocationDisplay.setEnabled(false);
                return;
            }
            this.mLocationDisplay.setEnabled(true);
            Point2D.Double userPoint = DesignView2D.this.mCanvas.screenToUser(mouseLoc);
            Unit u = DesignView2D.this.getUnit();
            String ud = u == null ? "" : String.format(" %s", u.getUserName());
            String loc = u != null ? String.format("%s, %s%s", u.formatUser(((Point2D)userPoint).getX()), u.formatUser(((Point2D)userPoint).getY()), ud) : String.format("%,f, %,f%s", ((Point2D)userPoint).getX(), ((Point2D)userPoint).getY(), ud);
            if (!loc.equals(this.mLocationDisplay.getText())) {
                this.mLocationDisplay.setText(loc);
                this.mLocationDisplay.invalidate();
                if (DesignView2D.this.getParent() != null) {
                    DesignView2D.this.getParent().validate();
                }
                this.task();
            }
        }

        protected void task() {
            Runnable r = () -> DesignView2D.this.paintImmediately(this.mLocationDisplay.getVisibleRect());
            if (EventQueue.isDispatchThread()) {
                boolean isPainting = UIUtil.isPainting((JComponent)this.mLocationDisplay);
                if (!isPainting) {
                    r.run();
                } else {
                    EventQueue.invokeLater(r);
                }
            } else {
                EventQueue.invokeLater(r);
            }
        }

        protected void updateModeDisplay() {
            String mode = "";
            ViewMode vm = DesignView2D.this.getCurMode();
            if (vm != null) {
                mode = vm.getName();
            }
            this.mModeDisplay.setText(mode);
        }

        protected Icon createStatusIcon(int size, Color c) {
            AColorIcon i = new AColorIcon(size, c);
            i.setBorderColor(null);
            i.setWhiteBackground(false);
            return i;
        }

        protected void addBgIndicator(JComponent indicator) {
            GridBagLayout l = (GridBagLayout)this.mViewComp.getLayout();
            int[][] layoutDims = l.getLayoutDimensions();
            this.mViewComp.add((Component)indicator, GridBagManager.LEFT.gridLoc(layoutDims[0].length, 0).noInsets().fill(3));
            this.mViewComp.getParent().validate();
        }

        public void removeBgIndicator(JComponent indicator) {
            this.mViewComp.remove(indicator);
            Container c = this.mViewComp.getParent();
            if (c != null) {
                c.validate();
                c.repaint();
            }
        }

        public JComponent getViewComponent() {
            return this.mViewComp;
        }

        public JComponent getLocationComponent() {
            return this.mLocationComp;
        }

        protected class MyViewModeListener
        implements ViewModeListener {
            protected MyViewModeListener() {
            }

            @Override
            public boolean settingMode(ViewMode newMode) {
                return true;
            }

            @Override
            public void setMode(ViewMode newMode) {
                View2DStatus.this.updateModeDisplay();
            }
        }

        protected class MouseHandler
        extends MouseInputAdapter {
            protected MouseHandler() {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                View2DStatus.this.updateLocationDisplay(null);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                View2DStatus.this.mLocationDisplay.setEnabled(false);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                View2DStatus.this.updateLocationDisplay(null);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                View2DStatus.this.updateLocationDisplay(null);
            }
        }

        class ModePopupListener
        extends MouseAdapter {
            ModePopupListener() {
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                this.getContextMenu().show(ev.getComponent(), ev.getX(), ev.getY());
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                this.getContextMenu().show(ev.getComponent(), ev.getX(), ev.getY());
            }

            private JPopupMenu getContextMenu() {
                JPopupMenu menu = new JPopupMenu();
                for (JMenuItem mi : DesignView2D.this.mModeList) {
                    menu.add(mi);
                }
                return menu;
            }
        }
    }

    public class HighlightSlider
    extends JPanel {
        protected final GridBagManager mLayout;
        protected JLabel mLblLow;
        protected ADoubleSlider mSlider;
        protected JLabel mLblHigh;
        protected Listener mListener = new Listener();
        protected boolean mPendingRefresh = false;

        public HighlightSlider() {
            this.setBackground(AColor.CLEAR);
            this.setOpaque(false);
            this.mLayout = GridBagManager.layout((Container)this);
            this.mLblLow = new JLabel(ICONLO);
            this.mSlider = new ADoubleSlider(0, 100);
            this.mSlider.setOpaque(false);
            this.mSlider.setSecondValue((int)(DesignView2D.this.getCanvas().getUseSelectionColorsThreshold() * 100.0f));
            this.mSlider.setValue((int)(DesignView2D.this.getCanvas().getUnhighlightAlpha() * 100.0f));
            this.mSlider.addChangeListener(e -> {
                ViewColorizer colorizer = DesignView2D.this.getColorizer();
                if (colorizer == null) {
                    return;
                }
                boolean usc = colorizer.getUseSelectionColors();
                float v = (float)this.mSlider.getValue() / 100.0f;
                DesignView2D.this.getCanvas().setUnhighlightAlpha(v);
                float v2 = (float)this.mSlider.getSecondValue() / 100.0f;
                DesignView2D.this.getCanvas().setUseSelectionColorThreshold(v2);
                if (usc != colorizer.getUseSelectionColors()) {
                    this.mPendingRefresh = true;
                }
                if (!this.mSlider.getValueIsAdjusting() && this.mPendingRefresh) {
                    this.mPendingRefresh = false;
                    DesignView2D.this.getCanvas().refresh();
                }
            });
            this.mLblHigh = new JLabel(ICONHI);
            this.setOrientation(0);
            UIUtil.setToolTips((Container)this, (String)"<html>Highlighted object contrast<br>(Right-click-drag or alt-drag to set selection color threshold)</html>");
        }

        public void setPos(float p) {
            this.mSlider.setValue((int)(p * 100.0f));
        }

        protected void updateOrientation() {
            JToolBar tb = (JToolBar)UIUtil.getAncestorOfType((Component)this, JToolBar.class);
            if (tb == null) {
                return;
            }
            int tbOrient = tb.getOrientation();
            if (tbOrient == this.getCurrentOrientation()) {
                return;
            }
            this.setOrientation(tbOrient);
            tb.validate();
        }

        protected void setOrientation(int orient) {
            GridBagManager.GridBagConstraintsEx constraint;
            this.removeAll();
            GridBagManager.GridBagConstraintsEx gridBagConstraintsEx = constraint = orient == 0 ? GridBagManager.LEFT.noInsets() : GridBagManager.CENTER.noInsets();
            if (orient != 0) {
                this.mLayout.newline();
                this.mLayout.add((Component)this.mLblHigh, (GridBagConstraints)constraint);
                this.mLayout.newline();
            } else {
                this.mLayout.add((Component)this.mLblLow, (GridBagConstraints)constraint);
            }
            this.mSlider.setOrientation(orient);
            Dimension sliderSize = orient == 0 ? new Dimension(72, 24) : new Dimension(24, 72);
            this.mSlider.setPreferredSize(sliderSize);
            this.mSlider.setMinimumSize(sliderSize);
            this.mLayout.add((Component)this.mSlider, (GridBagConstraints)constraint);
            if (orient != 0) {
                this.mLayout.newline();
                this.mLayout.add((Component)this.mLblLow, (GridBagConstraints)constraint);
            } else {
                this.mLayout.add((Component)this.mLblHigh, (GridBagConstraints)constraint);
            }
            Dimension pnlSize = this.getPreferredSize();
            this.setSize(pnlSize);
            this.setMaximumSize(pnlSize);
            this.setAlignmentX(0.0f);
            this.setAlignmentY(0.5f);
        }

        protected int getCurrentOrientation() {
            return this.mSlider.getOrientation();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.addHierarchyListener(this.mListener);
        }

        @Override
        public void removeNotify() {
            this.removeHierarchyListener(this.mListener);
            super.removeNotify();
        }

        protected class Listener
        implements HierarchyListener,
        HierarchyBoundsListener {
            protected Listener() {
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                HighlightSlider.this.updateOrientation();
            }

            @Override
            public void ancestorMoved(HierarchyEvent e) {
            }

            @Override
            public void ancestorResized(HierarchyEvent e) {
                HighlightSlider.this.updateOrientation();
            }
        }
    }

    public static class MouseAction
    extends MouseEvent {
        protected boolean mAltB1IsB2 = true;

        public MouseAction(MouseEvent e) {
            super(e.getComponent(), e.getID(), e.getWhen(), e.getModifiersEx(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        @Override
        public int getButton() {
            int b = super.getButton();
            if (b == 1 && this.isAltDown()) {
                return 2;
            }
            return b;
        }

        public boolean isOutside() {
            Component c = super.getComponent();
            if (c == null) {
                return false;
            }
            return !c.getBounds().contains(this.getPoint());
        }
    }

    public static interface ViewModeListener {
        public boolean settingMode(ViewMode var1);

        public void setMode(ViewMode var1);
    }

    public static interface ViewMode {
        public void installMode(DesignView2D var1);

        public void uninstallMode();

        public String getName();

        public Cursor getCursor();

        public JPanel getOptionPanel();
    }

    protected class FavoriteSelectionCriteriaAction
    extends ViewModeAction {
        protected SelectionCriteria mCriteria;

        public FavoriteSelectionCriteriaAction(SelectionCriteria sc) {
            super(InteractiveSelectMode::new, DesignView2D.getFavoriteInteractiveSelectionModeActionKey(sc), "Interactive Select: " + sc.getName(), sc.getIconSmall());
            this.mCriteria = sc;
        }

        @Override
        public ViewMode getMode() {
            ViewMode mode = super.getMode();
            ((InteractiveSelectMode)mode).setCriteria(this.mCriteria);
            return mode;
        }
    }

    public class ViewModeAction
    extends AbstractAction {
        protected Supplier<ViewMode> mModeFactory;
        private ViewMode mMode;

        public ViewModeAction(Supplier<ViewMode> modeFactory, String name, String text, Icon icon) {
            super(name, icon);
            this.mModeFactory = modeFactory;
            this.putValue("ButtonText", text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DesignView2D.this.getCurMode() != this.getMode()) {
                DesignView2D.this.setMode(this.getMode());
            }
        }

        public ViewMode getMode() {
            if (this.mMode == null) {
                this.mMode = this.mModeFactory.get();
            }
            return this.mMode;
        }

        public boolean isCurrentMode(ViewMode mode) {
            return mode != null && this.mMode == mode;
        }
    }

    public static enum SplitDir {
        H("Horizontal"),
        V("Veritcal");

        String mDesc;

        private SplitDir(String desc) {
            this.mDesc = desc;
        }

        public String getDesc() {
            return this.mDesc;
        }

        public String toString() {
            return String.format("%s [%s]", this.mDesc, super.toString());
        }
    }

    public static class ActionToggleConnectionDisplay
    extends AbstractAction {
        private boolean mDisplay;
        private JPopupMenu mMenu;

        public ActionToggleConnectionDisplay() {
            super("Display Connection");
            this.updateIcon();
            this.mMenu = new JPopupMenu();
            this.mMenu.add(new ActionShowConnection());
            this.mMenu.add(new ActionHideConnection());
            this.putValue("ButtonPopupMenu", this.mMenu);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mMenu.isVisible()) {
                this.mMenu.setVisible(false);
                return;
            }
            Db db = OrbitIO.getCurDb();
            if (this.mDisplay) {
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Create Connections");){
                    Cp.exec((String)"UserCommands.createConnections();", (Object[])new Object[0]);
                }
            }
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Remove Connections");){
                Cp.exec((String)"UserCommands.removeConnections();", (Object[])new Object[0]);
            }
            this.updateIcon();
        }

        private void updateIcon() {
            Db db = OrbitIO.getCurDb();
            boolean bl = this.mDisplay = db == null || db.getDbClass(Connection.class).getInstanceCount() == 0;
            if (this.mDisplay) {
                this.putValue("SmallIcon", OrbitIcons.SHOW_RATS);
            } else {
                this.putValue("SmallIcon", OrbitIcons.BLANK_RATS);
            }
        }
    }

    private class ActionRuler
    extends ViewModeAction {
        public ActionRuler() {
            super(RulerMode::new, "RulerMode", "Ruler Mode", OrbitIcons.RULER);
            JPopupMenu menu = new JPopupMenu();
            menu.add(new RulerMode.ActionClearRulers());
            menu.add(new RulerMode.ActionRemoveLastRuler());
            menu.add(new RulerMode.ActionChangeColor());
            menu.add(new RulerMode.ActionChangeOrthoColor());
            if (OrbitIO.getGuiWorkspace() != null) {
                OrbitIO.getGuiWorkspace().beautify(menu);
            }
            this.putValue("ButtonPopupMenu", menu);
        }
    }

    public static class ActionHideConnection
    extends AbstractAction {
        public ActionHideConnection() {
            super("Hide Connections", OrbitIcons.BLANK_RATS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Hide Connection");){
                Cp.exec((String)"UserCommands.removeConnections();", (Object[])new Object[0]);
            }
        }
    }

    public static class ActionShowConnection
    extends AbstractAction {
        public ActionShowConnection() {
            super("Show Connections", OrbitIcons.SHOW_RATS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Show Connection");){
                Cp.exec((String)"UserCommands.createConnections();", (Object[])new Object[0]);
            }
        }
    }

    public static class ActionShowActiveKeyBindings
    extends AbstractAction {
        public ActionShowActiveKeyBindings() {
            super(DesignView2D.ACTION_SHOW_ACTIVE_KEYBINDINGS);
            this.putValue("ButtonText", "Show Active Key Bindings...");
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke(DesignView2D.ACTION_SHOW_ACTIVE_KEYBINDINGS));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyBindingUI.showUI();
        }
    }

    private class ActionClearHighlight
    extends AbstractAction {
        public ActionClearHighlight() {
            super(DesignView2D.ACTION_CLEAR_HIGHLIGHT, UIManager.getIcon("CDNS.dehighlightAllIcon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignView2D.this.highlight(null);
        }
    }

    public class ActionClearSelection
    extends AbstractAction {
        public ActionClearSelection() {
            super(DesignView2D.ACTION_CLEAR_SELECTION, OrbitIcons.SELECT_CLEAR);
            this.putValue("ButtonText", DesignView2D.ACTION_CLEAR_SELECTION);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)DesignView2D.ACTION_CLEAR_SELECTION);){
                Cp.exec((String)"OrbitIO.getCurDesign().getCurSelection().clear()", (Object[])new Object[0]);
            }
            DesignView2D.this.mCanvas.refresh();
        }
    }

    public class ScrollBar
    extends JScrollBar {
        long mViewMin;
        long mViewMax;
        int mVal;
        double mScale;

        public ScrollBar(int orientation) {
            super(orientation);
        }

        public void updateScrollBar(long worldMin, long worldMax, long viewMin, long viewMax) {
            boolean vertical = this.getOrientation() == 1;
            long l = Math.max(0L, viewMin - worldMin);
            long r = Math.max(0L, worldMax - viewMax);
            long c = Math.max(0L, Math.abs(worldMax - worldMin) - l - r);
            long range = l / 3L + c / 3L + r / 3L;
            long knob = c / 3L;
            long lSpace = l / 3L;
            double scale = 1000000.0 / (double)range;
            int extent = (int)(scale * (double)knob);
            int start = vertical ? (int)(scale * (double)(range - (lSpace + knob))) : (int)(scale * (double)lSpace);
            this.setValues(start, extent, 0, 1000000);
            double xInc = (double)extent * 0.99;
            this.setBlockIncrement((int)xInc);
            this.setUnitIncrement((int)(xInc / 10.0));
            this.mViewMin = viewMin;
            this.mViewMax = viewMax;
            this.mScale = scale / 3.0;
            this.mVal = start;
        }
    }
}

