/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.AColor;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AggregateIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.StatusChangeListener;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.NetObject;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.topology.SpatialIndex2D;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DesignSettings;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.oio3d.A3DViewPanel;
import com.sigrity.orbit.oio3d.Cube;
import com.sigrity.orbit.oio3d.ExtrudedPolygon;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.util.PhysicalNetUtil;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class DesignView3D
extends A3DViewPanel
implements AAppView {
    protected final Db mDb;
    protected ViewColorizer mColorizer;
    protected boolean mCanvasBG = false;
    protected boolean mShowAxes = true;
    protected ARect mLimitedWorld = null;
    protected int mDeviceAlpha = 128;
    protected boolean mFlatLayers = false;
    protected long mLayerOffsetZ = 300000L;
    protected Set<DevicePath> mAllowPaths = null;
    protected Set<HierInst<DbObject>> mAllowHierInsts = null;
    protected Unit mViewUnit;
    protected Unit mUserUnit;
    protected List<Action> mToolBarActions = new LinkedList<Action>();
    private Action mRefreshAction = new AbstractAction("Refresh", OrbitIcons.REFRESH){

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignView3D.this.resetContent();
        }
    };
    private Action mDisplayOptionsAction = new AbstractAction("View Options...", OrbitIcons.VIEW_SETTING){

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewOptionsDialog d = new ViewOptionsDialog(UIUtil.getParentWindow((Component)DesignView3D.this));
            d.setVisible(true);
        }
    };
    protected HashMap<Color, Appearance> mDrawSolids = new HashMap();
    protected HashMap<Color, Appearance> mDrawTranslucent = new HashMap();
    protected HashMap<Color, Appearance> mDrawWireFrames = new HashMap();
    protected HashMap<Color, Appearance> mDrawPoints = new HashMap();
    private static final Color3f WHITE = new Color3f(1.0f, 1.0f, 1.0f);

    public DesignView3D(Db db) {
        this.mDb = db;
        this.mViewUnit = this.get3DViewUnit();
        this.mUserUnit = this.getUnit();
        this.initActions();
    }

    private void zoomTo(ARect worldBound) {
        double vz = this.mViewUnit.toUser(Math.max(worldBound.width(), worldBound.height()));
        double vx = this.mViewUnit.toUser(worldBound.centerX());
        double vy = this.mViewUnit.toUser(worldBound.centerY());
        A3DViewPanel.XForm3D xform = new A3DViewPanel.XForm3D(-vx, -vy, vz, 0.0, 0.0, 0.0);
        this.mXform.update(xform);
    }

    protected void initActions() {
        this.mToolBarActions.add(this.mRefreshAction);
        this.mToolBarActions.add(null);
        this.mToolBarActions.add(new ActionPan("Pan Left", OrbitIcons.PAN_LEFT, 1, 0));
        this.mToolBarActions.add(new ActionPan("Pan Right", OrbitIcons.PAN_RIGHT, -1, 0));
        this.mToolBarActions.add(new ActionPan("Pan Up", OrbitIcons.PAN_UP, 0, -1));
        this.mToolBarActions.add(new ActionPan("Pan Down", OrbitIcons.PAN_DOWN, 0, 1));
        this.mToolBarActions.add(null);
        this.mToolBarActions.add(new ActionZoom("Zoom In", OrbitIcons.ZOOM_IN, 0.9));
        this.mToolBarActions.add(new ActionZoom("Zoom Out", OrbitIcons.ZOOM_OUT, 1.1111111111111112));
        this.mToolBarActions.add(null);
        this.mToolBarActions.add(new ActionRotate("Rotate X", UIManager.getIcon("CDNS.3dRotateXIcon"), 0.05235987755982988, 0.0, 0.0));
        this.mToolBarActions.add(new ActionRotate("Rotate X-Rev", UIManager.getIcon("CDNS.3dRotateXReverseIcon"), -0.05235987755982988, 0.0, 0.0));
        this.mToolBarActions.add(new ActionRotate("Rotate Y", UIManager.getIcon("CDNS.3dRotateYIcon"), 0.0, 0.0, 0.05235987755982988));
        this.mToolBarActions.add(new ActionRotate("Rotate Y-Rev", UIManager.getIcon("CDNS.3dRotateYReverseIcon"), 0.0, 0.0, -0.05235987755982988));
        this.mToolBarActions.add(null);
        this.mToolBarActions.add(this.mDisplayOptionsAction);
    }

    protected void resetContent() {
        this.setContent(this.createScene());
    }

    protected BranchGroup createScene() {
        this.initColorizer();
        BranchGroup content = new BranchGroup();
        content.setCapability(3);
        Design design = Design.getDesign((Db)this.mDb);
        for (Device device : design.getChildren()) {
            this.drawDevice((Group)content, new DevicePath(device));
        }
        this.drawConnections(content);
        if (this.mShowAxes) {
            ARect r = design.getExtent();
            long max = Math.max(Math.abs(r.left()), Math.abs(r.right()));
            max = Math.max(max, Math.abs(r.top()));
            max = Math.max(max, Math.abs(r.bottom()));
            double maxExt = this.mViewUnit.toUser(max);
            this.constructAxes((Group)content, maxExt * 1.5);
        }
        if (this.mCanvasBG) {
            BoundingSphere boundingSphere = new BoundingSphere(content.getBounds());
            Transform3D bsxform = new Transform3D();
            bsxform.setScale(new Vector3d(50.0, 50.0, 50.0));
            boundingSphere.transform(bsxform);
            APatternColor colorCanvas = this.mColorizer.findColor(Design.getDesignPath((Db)this.getDb()), (ViewColorizer.Key)ViewColorizer.KDesignCanvas);
            Background background = new Background(new Color3f(colorCanvas == null ? null : colorCanvas.getColor()));
            background.setApplicationBounds((Bounds)boundingSphere);
            content.addChild((Node)background);
        }
        return content;
    }

    protected void drawConnections(BranchGroup group) {
        for (Connection c : this.mDb.getObjects(Connection.class)) {
            if (c.getPortA() == null) continue;
            this.drawConnection(group, c);
        }
    }

    public void drawConnection(BranchGroup group, Connection c) {
        APatternColor color = this.mColorizer.getColor(c);
        if (color == null) {
            return;
        }
        ALine l = c.getLine();
        if (l == null) {
            return;
        }
        double x0 = this.mViewUnit.toUser(l.getP0().getX());
        double y0 = this.mViewUnit.toUser(l.getP0().getY());
        double z0 = this.mViewUnit.toUser(Substrate.getZLoc((DevicePath)c.getDPPA().getPath()));
        double x1 = this.mViewUnit.toUser(l.getP1().getX());
        double y1 = this.mViewUnit.toUser(l.getP1().getY());
        double z1 = this.mViewUnit.toUser(Substrate.getZLoc((DevicePath)c.getDPPB().getPath()));
        Shape3D shape = new Shape3D();
        shape.setPickable(false);
        shape.setCollidable(false);
        LineArray line = new LineArray(2, 5);
        line.setCoordinate(0, new Point3d(x0, y0, z0));
        line.setCoordinate(1, new Point3d(x1, y1, z1));
        line.setColor(0, new Color3b(color.getColor()));
        shape.addGeometry((Geometry)line);
        Appearance a = new Appearance();
        LineAttributes la = new LineAttributes();
        la.setLineAntialiasingEnable(true);
        a.setLineAttributes(la);
        shape.setAppearance(a);
        group.addChild((Node)shape);
    }

    protected void drawDevice(Group parentNode, DevicePath devicePath) {
        if (this.mLimitedWorld != null && !devicePath.getBB().intersects(this.mLimitedWorld) && !this.isAllowed(devicePath)) {
            return;
        }
        BranchGroup bg = new BranchGroup();
        parentNode.addChild((Node)bg);
        Device device = devicePath.getLast();
        APoint2D loc = device.getLoc();
        double x = this.mViewUnit.toUser(loc.getX());
        double y = this.mViewUnit.toUser(loc.getY());
        long dbZ = Substrate.getZLoc((Device)device);
        double z = this.mViewUnit.toUser(dbZ);
        Transform3D xform = new Transform3D();
        xform.setTranslation(new Vector3d(x, y, z));
        float rot = device.getRotate();
        if (rot != 0.0f) {
            double r = Math.toRadians(360.0f - rot);
            xform.setRotation(new AxisAngle4d(0.0, 0.0, 1.0, r));
        }
        if (device.getMirror()) {
            xform.setScale(new Vector3d(-1.0, 1.0, 1.0));
        }
        TransformGroup tg = new TransformGroup(xform);
        bg.addChild((Node)tg);
        Device3dGroup dt3 = new Device3dGroup(devicePath);
        tg.addChild((Node)dt3);
        for (Device child : device.getChildren()) {
            this.drawDevice((Group)tg, new DevicePath(devicePath, child));
        }
    }

    @Override
    public void displayContextMenu(int x, int y) {
        JPopupMenu menu = new JPopupMenu();
        for (Action a : this.getViewContextActions(x, y)) {
            if (a == null) {
                menu.add(new JSeparator());
                continue;
            }
            if (a instanceof A3DViewPanel.GetMenuItem) {
                menu.add(((A3DViewPanel.GetMenuItem)((Object)a)).getMenuItem());
                continue;
            }
            menu.add(a);
        }
        if (OrbitIO.getGuiWorkspace() != null) {
            OrbitIO.getGuiWorkspace().beautify(menu);
        }
        if (menu.getComponentCount() > 0) {
            menu.show((Component)this.mCanvas3d, x, y);
        }
    }

    @Override
    public IterableIterator<Action> getViewContextActions(int x, int y) {
        IterableIterator<Action> i1 = super.getViewContextActions(x, y);
        AIterableItr i2 = new AIterableItr((Object[])new Action[]{null, this.mRefreshAction, null, this.mDisplayOptionsAction});
        return new AggregateIterator(i1, (Iterator)i2);
    }

    public ActionMap getActions() {
        return this.mActions;
    }

    public Component getComponent() {
        return this;
    }

    public Db getDb() {
        return this.mDb;
    }

    public String getDescription() {
        File f = this.getDb().getFile();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public String getTitle() {
        File f = this.getDb().getFile();
        if (f != null) {
            return f.getName() + " (3D)";
        }
        return "New Design";
    }

    public Unit getUnit() {
        return Design.getUnit((Db)this.getDb());
    }

    public AAppView.ViewStatus registerStatusListener(StatusChangeListener l, boolean register) {
        return null;
    }

    public Appearance getAppearance(Color c) {
        return this.getWireFrame(c);
    }

    public Appearance getTranslucent(Color c) {
        Appearance a = this.mDrawTranslucent.get(c);
        if (a == null) {
            a = new TranslucentAppearance(c);
            this.mDrawTranslucent.put(c, a);
        }
        return a;
    }

    public Appearance getWireFrame(Color c) {
        Appearance a = this.mDrawWireFrames.get(c);
        if (a == null) {
            a = new WireframeAppearance(c);
            this.mDrawWireFrames.put(c, a);
        }
        return a;
    }

    public Appearance getSolid(Color c) {
        Appearance a = this.mDrawSolids.get(c);
        if (a == null) {
            a = new SolidAppearance(c);
            this.mDrawSolids.put(c, a);
        }
        return a;
    }

    public void resetViewSettings() {
        this.mColorizer = ViewColorizer.createViewColorizer((Db)this.mDb, (DevicePath)Design.getDesignPath((Db)this.mDb));
        Design design = Design.getDesign((Db)this.mDb);
        if (design != null) {
            DesignSettings.set((Design)design, (String)"ViewColorizer", (Object)this.mColorizer);
        }
    }

    public ViewColorizer getColorizer() {
        if (this.mColorizer == null) {
            this.initColorizer();
        }
        return this.mColorizer;
    }

    protected void initColorizer() {
        Design design = Design.getDesign((Db)this.mDb);
        if (design != null) {
            this.mColorizer = (ViewColorizer)DesignSettings.get((Design)design, (String)"ViewColorizer", ViewColorizer.class);
        }
        if (this.mColorizer == null) {
            this.resetViewSettings();
        }
    }

    protected Vector3f getWorldCenter() {
        Design design = Design.getDesign((Db)this.mDb);
        ARect world = null;
        for (DevicePath path : design.getDescendantDevices()) {
            if (world == null) {
                world = new ARect(path.getBB());
                continue;
            }
            world.expand(path.getBB());
        }
        if (world == null) {
            return new Vector3f();
        }
        Unit u = this.get3DViewUnit();
        return new Vector3f((float)u.toUser(world.centerX()), (float)u.toUser(world.centerX()), 0.0f);
    }

    protected Unit get3DViewUnit() {
        return new Unit("3D View Unit", 3000000.0);
    }

    protected Unit getUserUnit() {
        return Design.getUnit((Db)this.getDb());
    }

    protected void constructAxes(Group node, double extent) {
        double headLen = extent / 20.0;
        Shape3D shape = new Shape3D();
        shape.setPickable(false);
        shape.setCollidable(false);
        LineArray axisXLines = new LineArray(10, 5);
        axisXLines.setCoordinate(0, new Point3d(-extent, 0.0, 0.0));
        axisXLines.setCoordinate(1, new Point3d(extent, 0.0, 0.0));
        axisXLines.setCoordinate(2, new Point3d(extent, 0.0, 0.0));
        axisXLines.setCoordinate(3, new Point3d(extent - headLen, 0.0, headLen / 2.0));
        axisXLines.setCoordinate(4, new Point3d(extent, 0.0, 0.0));
        axisXLines.setCoordinate(5, new Point3d(extent - headLen, 0.0, -headLen / 2.0));
        axisXLines.setCoordinate(6, new Point3d(extent, 0.0, 0.0));
        axisXLines.setCoordinate(7, new Point3d(extent - headLen, headLen / 2.0, 0.0));
        axisXLines.setCoordinate(8, new Point3d(extent, 0.0, 0.0));
        axisXLines.setCoordinate(9, new Point3d(extent - headLen, -headLen / 2.0, 0.0));
        for (int i = 0; i < 10; ++i) {
            axisXLines.setColor(i, new Color3b(Color.RED));
        }
        shape.addGeometry((Geometry)axisXLines);
        LineArray axisYLines = new LineArray(10, 5);
        axisYLines.setCoordinate(0, new Point3d(0.0, -extent, 0.0));
        axisYLines.setCoordinate(1, new Point3d(0.0, extent, 0.0));
        axisYLines.setCoordinate(2, new Point3d(0.0, extent, 0.0));
        axisYLines.setCoordinate(3, new Point3d(0.0, extent - headLen, headLen / 2.0));
        axisYLines.setCoordinate(4, new Point3d(0.0, extent, 0.0));
        axisYLines.setCoordinate(5, new Point3d(0.0, extent - headLen, -headLen / 2.0));
        axisYLines.setCoordinate(6, new Point3d(0.0, extent, 0.0));
        axisYLines.setCoordinate(7, new Point3d(headLen / 2.0, extent - headLen, 0.0));
        axisYLines.setCoordinate(8, new Point3d(0.0, extent, 0.0));
        axisYLines.setCoordinate(9, new Point3d(-headLen / 2.0, extent - headLen, 0.0));
        for (int i = 0; i < 10; ++i) {
            axisYLines.setColor(i, new Color3b(Color.GREEN));
        }
        shape.addGeometry((Geometry)axisYLines);
        LineArray axisZLines = new LineArray(10, 5);
        axisZLines.setCoordinate(0, new Point3d(0.0, 0.0, -extent));
        axisZLines.setCoordinate(1, new Point3d(0.0, 0.0, extent));
        axisZLines.setCoordinate(2, new Point3d(0.0, 0.0, extent));
        axisZLines.setCoordinate(3, new Point3d(0.0, headLen / 2.0, extent - headLen));
        axisZLines.setCoordinate(4, new Point3d(0.0, 0.0, extent));
        axisZLines.setCoordinate(5, new Point3d(0.0, -headLen / 2.0, extent - headLen));
        axisZLines.setCoordinate(6, new Point3d(0.0, 0.0, extent));
        axisZLines.setCoordinate(7, new Point3d(headLen / 2.0, 0.0, extent - headLen));
        axisZLines.setCoordinate(8, new Point3d(0.0, 0.0, extent));
        axisZLines.setCoordinate(9, new Point3d(-headLen / 2.0, 0.0, extent - headLen));
        for (int i = 0; i < 10; ++i) {
            axisZLines.setColor(i, new Color3b(Color.BLUE));
        }
        shape.addGeometry((Geometry)axisZLines);
        Appearance a = new Appearance();
        LineAttributes la = new LineAttributes();
        la.setLineAntialiasingEnable(true);
        a.setLineAttributes(la);
        shape.setAppearance(a);
        node.addChild((Node)shape);
    }

    protected TransformGroup transform(long x, long y, float rot, boolean mirror) {
        Transform3D xform = new Transform3D();
        xform.setTranslation(new Vector3d(this.mViewUnit.toUser(x), this.mViewUnit.toUser(y), 0.0));
        if (rot != 0.0f) {
            double r = Math.toRadians(360.0f - rot);
            xform.setRotation(new AxisAngle4d(0.0, 0.0, 1.0, r));
        }
        if (mirror) {
            xform.setScale(new Vector3d(-1.0, 1.0, 1.0));
        }
        return new TransformGroup(xform);
    }

    protected TransformGroup transform(APoint2D p, float rot, boolean mirror) {
        return this.transform(p.getX(), p.getY(), rot, mirror);
    }

    protected TransformGroup translate(long x, long y) {
        return this.transform(x, y, 0.0f, false);
    }

    protected TransformGroup translate(APoint2D p) {
        return this.translate(p.getX(), p.getY());
    }

    protected Group createCircle3d(ACircle circle, long h, Appearance a) {
        double r = this.mViewUnit.toUser(circle.getR());
        double dz = this.mViewUnit.toUser(h);
        Cylinder cylinder = new Cylinder((float)r, (float)dz, a);
        APoint2D center = circle.getC();
        Transform3D xform = new Transform3D();
        if (center.getX() != 0L || center.getY() != 0L || h != 0L) {
            xform.setTranslation(new Vector3d(this.mViewUnit.toUser(center.getX()), this.mViewUnit.toUser(center.getY()), dz / 2.0));
        }
        xform.setRotation(new AxisAngle4d(1.0, 0.0, 0.0, 1.5707963267948966));
        TransformGroup xg = new TransformGroup(xform);
        xg.addChild((Node)cylinder);
        return xg;
    }

    protected Group createSphere3d(ACircle circle, long h, Appearance a) {
        double r = this.mViewUnit.toUser(circle.getR());
        double dz = this.mViewUnit.toUser(h);
        Sphere sphere = new Sphere((float)r, a);
        APoint2D center = circle.getC();
        Transform3D xform = new Transform3D();
        if (center.getX() != 0L || center.getY() != 0L || h != 0L) {
            xform.setTranslation(new Vector3d(this.mViewUnit.toUser(center.getX()), this.mViewUnit.toUser(center.getY()), dz / 2.0));
        }
        xform.setRotation(new AxisAngle4d(1.0, 0.0, 0.0, 1.5707963267948966));
        TransformGroup xg = new TransformGroup(xform);
        xg.addChild((Node)sphere);
        return xg;
    }

    protected ExtrudedPolygon createPoly3d(APolygon ref, long height, Appearance a) {
        double dz = this.mViewUnit.toUser(height);
        double[] pts = new double[ref.getPointCount() * 2];
        int i = 0;
        for (APoint2D pt : ref.getPoints()) {
            pts[i++] = this.mViewUnit.toUser(pt.getX());
            pts[i++] = this.mViewUnit.toUser(pt.getY());
        }
        return new ExtrudedPolygon(a, pts, dz);
    }

    protected Group createPipe(long radius, double[] path, Appearance a) {
        double r = this.mViewUnit.toUser(radius);
        TransformGroup xg = null;
        for (int v = 0; v < 1; ++v) {
            int vNext = v + 1;
            double x0 = path[v * 3 + 0];
            double y0 = path[v * 3 + 1];
            double z0 = path[v * 3 + 2];
            double x1 = path[vNext * 3 + 0];
            double y1 = path[vNext * 3 + 1];
            double z1 = path[vNext * 3 + 2];
            double dx = x1 - x0;
            double dy = y1 - y0;
            double dz = z1 - z0;
            double l = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0) + Math.pow(dz, 2.0));
            if (l == 0.0) {
                return null;
            }
            Cylinder cylinder = new Cylinder((float)r, (float)l, a);
            Transform3D xform = new Transform3D();
            Transform3D xformMove = new Transform3D();
            Transform3D xformPlace = new Transform3D();
            Transform3D xformXYRot = new Transform3D();
            Transform3D xformZ = new Transform3D();
            double angleXYPlane = Math.toDegrees(Math.atan2(dy, dx));
            if (angleXYPlane < 0.0) {
                angleXYPlane += 360.0;
            }
            double angleZ = Math.toDegrees(Math.asin(dz / l));
            angleXYPlane = Math.toRadians(angleXYPlane);
            angleZ = Math.toRadians(angleZ);
            xformZ.rotX(angleZ);
            xformMove.setTranslation(new Vector3d(l / 2.0 * Math.cos(angleXYPlane), l / 2.0 * Math.sin(angleXYPlane), l / 2.0 * Math.sin(angleZ)));
            xformMove.setTranslation(new Vector3d(0.0, l / 2.0, 0.0));
            xformPlace.setTranslation(new Vector3d(x0, y0, z0));
            xformXYRot.setRotation(new AxisAngle4d(0.0, 0.0, 1.0, angleXYPlane - 1.5707963267948966));
            xform.setIdentity();
            xform.mul(xformPlace);
            xform.mul(xformXYRot);
            xform.mul(xformZ);
            xform.mul(xformMove);
            xg = new TransformGroup(xform);
            xg.addChild((Node)cylinder);
        }
        return xg;
    }

    public List<JMenuItem> getViewMenu() {
        return new ArrayList<JMenuItem>();
    }

    public List<Action> getToolBarActions() {
        return this.mToolBarActions;
    }

    protected boolean isAllowed(DevicePath path) {
        return this.mAllowPaths == null || this.mAllowPaths.contains(path);
    }

    protected boolean isAllowed(HierInst<? extends DbObject> hierInst) {
        return this.mAllowHierInsts == null || this.mAllowHierInsts.contains(hierInst);
    }

    protected void prepareWhitelist(boolean selected, boolean logical, boolean physical) {
        if (!selected) {
            return;
        }
        Selection sel = Selection.getCurrentSelectionForDb((Db)this.mDb);
        this.mAllowPaths = new HashSet<DevicePath>();
        this.mAllowHierInsts = new HashSet<HierInst<DbObject>>();
        for (HierInst hierInst : sel.getAllHierInsts()) {
            this.addAllowedObjects((HierInst<? extends DbObject>)hierInst, logical, physical);
        }
    }

    protected void addAllowedObjects(HierInst<? extends DbObject> hierInst, boolean logical, boolean physical) {
        this.mAllowHierInsts.add(hierInst);
        DevicePath path = hierInst.getPath();
        if (hierInst.getDbObject() instanceof Device) {
            path = path.addPath(new DevicePath((Device)hierInst.getDbObject()));
        }
        while (path != null) {
            this.mAllowPaths.add(path);
            path = path.getParent();
        }
        if (physical && hierInst.getDbObject() instanceof NetObject) {
            NetObject netObj = (NetObject)hierInst.getDbObject();
            for (HierInst connected : PhysicalNetUtil.getPhysConnected((HierInst)HierInst.create((DevicePath)path, (DbObject)netObj), (boolean)true)) {
                this.addAllowedObjects((HierInst<? extends DbObject>)connected, false, false);
            }
        }
    }

    public static DesignView3D show3D(AAppView currentView, Db db) {
        View3DStartupDialog dialog = new View3DStartupDialog(db);
        dialog.setVisible(true);
        if (!dialog.mOK) {
            return null;
        }
        DesignView2D v2d = (DesignView2D)currentView;
        ARect worldBound = v2d.getViewBounds();
        DesignView3D v3d = new DesignView3D(db);
        if (dialog.mCbVisible.isSelected()) {
            v3d.mLimitedWorld = v2d.getViewBounds();
        }
        boolean selected = dialog.mCbSelected.isSelected();
        boolean logical = dialog.mCbLogicalConnected.isSelected();
        boolean physical = dialog.mCbPhysicalConnected.isSelected();
        v3d.prepareWhitelist(selected, logical, physical);
        v3d.resetContent();
        v3d.zoomTo(worldBound);
        return v3d;
    }

    private static class View3DStartupDialog
    extends DbDialog {
        private boolean mOK = false;
        private JCheckBox mCbSelected;
        private JCheckBox mCbVisible;
        private JCheckBox mCbLogicalConnected;
        private JCheckBox mCbPhysicalConnected;

        public View3DStartupDialog(Db db) {
            super(db, (Component)OrbitIO.getMainWindow(), "3D Viewer Startup");
            this.setModal(true);
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            this.mCbVisible = new JCheckBox("Only visible objects in Current 2D view");
            this.mCbSelected = new JCheckBox("Only selected objects");
            this.mCbLogicalConnected = new JCheckBox("Associated logical connected objects");
            this.mCbLogicalConnected.setEnabled(false);
            this.mCbPhysicalConnected = new JCheckBox("Associated physical connected objects");
            this.mCbPhysicalConnected.setEnabled(false);
            this.mCbSelected.addItemListener(e -> {
                this.mCbLogicalConnected.setEnabled(this.mCbSelected.isSelected());
                this.mCbPhysicalConnected.setEnabled(this.mCbSelected.isSelected());
            });
            l.push("Option", (GridBagConstraints)GridBagManager.FILLX);
            l.add((Component)this.mCbVisible, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.mCbSelected, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.mCbLogicalConnected, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)this.mCbPhysicalConnected, (GridBagConstraints)GridBagManager.LEFT);
            l.pop();
            l.newline();
            JButton okBtn = new JButton("OK");
            okBtn.addActionListener(e -> {
                this.mOK = true;
                UIUtil.closeWindow((Window)((Object)this));
            });
            JButton cancelBtn = new JButton("Cancel");
            l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            l.add((Component)okBtn);
            l.add((Component)cancelBtn);
            l.pop();
            UIUtil.makeFootButton((AbstractButton)okBtn);
            UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)cancelBtn);
            this.setMinimumSize(new Dimension(200, 150));
            this.pack();
            UIUtil.center((Component)((Object)this));
        }
    }

    public class ViewOptionsDialog
    extends DbDialog {
        protected ViewOptionsPanel mOptionsPanel;
        protected ActionListener mOk;

        public ViewOptionsDialog(Window owner) {
            super(DesignView3D.this.mDb, (Component)owner);
            this.mOk = e -> {
                if (!this.mOptionsPanel.validateUiData()) {
                    return;
                }
                if (this.mOptionsPanel.applyUiData()) {
                    DesignView3D.this.resetContent();
                }
                UIUtil.closeWindow((Window)((Object)this));
            };
            this.setTitle("3D View Options");
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            this.mOptionsPanel = (ViewOptionsPanel)l.add((Component)new ViewOptionsPanel());
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
            btnOk.addActionListener(this.mOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
        }
    }

    public class ViewOptionsPanel
    extends JPanel {
        protected JCheckBox mCbShowAxes;
        protected JCheckBox mCbFlatLayers;
        protected JTextField mTxtLayerOffsetZ;
        protected JSlider mSlideDeviceTransparency;
        protected JPanel mPnlFlatLayerOpts;
        protected ActionListener mFlatLayersToggleListener = e -> UIUtil.setEnabled((Container)this.mPnlFlatLayerOpts, (boolean)this.mCbFlatLayers.isSelected());

        public ViewOptionsPanel() {
            GridBagManager l = GridBagManager.layout((Container)this);
            this.mCbShowAxes = (JCheckBox)l.add((Component)new JCheckBox("Show axes"));
            l.newline();
            this.mCbFlatLayers = (JCheckBox)l.add((Component)new JCheckBox("Flat layers"));
            this.mCbFlatLayers.addActionListener(this.mFlatLayersToggleListener);
            l.newline();
            this.mPnlFlatLayerOpts = l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.indent();
            l.add("Layer offset: ");
            this.mTxtLayerOffsetZ = (JTextField)l.add((Component)new JTextField(10));
            l.pop();
            l.newline();
            l.add("Devices:");
            l.newline();
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.indent();
            this.mSlideDeviceTransparency = (JSlider)l.add((Component)new JSlider(0, 255, DesignView3D.this.mDeviceAlpha), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            Hashtable<Integer, JLabel> transparencyLabels = new Hashtable<Integer, JLabel>();
            transparencyLabels.put(0, new JLabel("Clear"));
            transparencyLabels.put(255, new JLabel("Opaque"));
            this.mSlideDeviceTransparency.setLabelTable(transparencyLabels);
            this.mSlideDeviceTransparency.setPaintLabels(true);
            l.pop();
            this.populateUiData();
        }

        public void populateUiData() {
            this.mCbShowAxes.setSelected(DesignView3D.this.mShowAxes);
            this.mCbFlatLayers.setSelected(DesignView3D.this.mFlatLayers);
            this.mTxtLayerOffsetZ.setText(DesignView3D.this.mUserUnit.toUserStr(DesignView3D.this.mLayerOffsetZ));
            this.mFlatLayersToggleListener.actionPerformed(null);
            this.mSlideDeviceTransparency.setValue(DesignView3D.this.mDeviceAlpha);
        }

        public boolean validateUiData() {
            try {
                if (this.mTxtLayerOffsetZ.isEnabled()) {
                    AFieldValidator.validateDouble((JTextField)this.mTxtLayerOffsetZ);
                }
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return false;
            }
            return true;
        }

        public boolean applyUiData() {
            long uiLayerOffsetZ;
            if (!this.validateUiData()) {
                return false;
            }
            boolean needRefresh = false;
            if (DesignView3D.this.mShowAxes != this.mCbShowAxes.isSelected()) {
                DesignView3D.this.mShowAxes = this.mCbShowAxes.isSelected();
                needRefresh = true;
            }
            if (DesignView3D.this.mFlatLayers != this.mCbFlatLayers.isSelected()) {
                DesignView3D.this.mFlatLayers = this.mCbFlatLayers.isSelected();
                needRefresh = true;
            }
            if (this.mTxtLayerOffsetZ.isEnabled() && DesignView3D.this.mLayerOffsetZ != (uiLayerOffsetZ = DesignView3D.this.mUserUnit.fromUser(AFieldValidator.getDouble((JTextField)this.mTxtLayerOffsetZ, (double)DesignView3D.this.mUserUnit.toUser(DesignView3D.this.mLayerOffsetZ))))) {
                DesignView3D.this.mLayerOffsetZ = uiLayerOffsetZ;
                needRefresh = true;
            }
            if (DesignView3D.this.mDeviceAlpha != this.mSlideDeviceTransparency.getValue()) {
                DesignView3D.this.mDeviceAlpha = this.mSlideDeviceTransparency.getValue();
                needRefresh = true;
            }
            return needRefresh;
        }
    }

    public static class PointAppearance
    extends Appearance {
        public PointAppearance(Color c) {
            ColoringAttributes ca = new ColoringAttributes();
            ca.setShadeModel(0);
            ca.setColor((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            this.setColoringAttributes(ca);
            PolygonAttributes pla = new PolygonAttributes();
            pla.setPolygonMode(0);
            pla.setCullFace(0);
            pla.setBackFaceNormalFlip(true);
            this.setPolygonAttributes(pla);
            PointAttributes pa = new PointAttributes();
            pa.setPointAntialiasingEnable(false);
            this.setPointAttributes(pa);
            RenderingAttributes ra = new RenderingAttributes();
            ra.setIgnoreVertexColors(true);
            this.setRenderingAttributes(ra);
        }
    }

    public static class WireframeAppearance
    extends Appearance {
        public WireframeAppearance(Color c) {
            ColoringAttributes ca = new ColoringAttributes();
            ca.setShadeModel(0);
            ca.setColor((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f);
            this.setColoringAttributes(ca);
            PolygonAttributes pla = new PolygonAttributes();
            pla.setPolygonMode(1);
            pla.setCullFace(0);
            pla.setBackFaceNormalFlip(true);
            this.setPolygonAttributes(pla);
            LineAttributes la = new LineAttributes();
            la.setLineAntialiasingEnable(true);
            this.setLineAttributes(la);
            RenderingAttributes ra = new RenderingAttributes();
            ra.setIgnoreVertexColors(true);
            this.setRenderingAttributes(ra);
        }
    }

    public static class TranslucentAppearance
    extends SolidAppearance {
        public TranslucentAppearance(Color c) {
            super(c);
            if (c.getAlpha() < 255) {
                TransparencyAttributes ta = new TransparencyAttributes();
                ta.setTransparency(1.0f - (float)c.getAlpha() / 255.0f);
                ta.setTransparencyMode(1);
                this.setTransparencyAttributes(ta);
            }
        }
    }

    public static class SolidAppearance
    extends Appearance {
        public SolidAppearance(Color c) {
            Color3f color3 = new Color3f(c);
            ColoringAttributes ca = new ColoringAttributes();
            ca.setShadeModel(0);
            ca.setColor(color3);
            this.setColoringAttributes(ca);
            Material mat = new Material();
            mat.setAmbientColor(color3);
            mat.setSpecularColor(WHITE);
            mat.setDiffuseColor(color3);
            mat.setShininess(64.0f);
            this.setMaterial(mat);
            PolygonAttributes pla = new PolygonAttributes();
            pla.setPolygonMode(2);
            pla.setCullFace(1);
            pla.setBackFaceNormalFlip(true);
            this.setPolygonAttributes(pla);
            LineAttributes la = new LineAttributes();
            la.setLineAntialiasingEnable(true);
            this.setLineAttributes(la);
        }
    }

    public class Device3dGroup
    extends Group {
        protected final DevicePath mParentPath;
        protected final DevicePath mInstPath;
        protected final ARect mLimitedLocalWorld;
        protected HashMap<Layer, Group> mLyrGrps = new HashMap();

        public Device3dGroup(DevicePath path) {
            Substrate substrate;
            AGeom bounds;
            this.mParentPath = path.getParent();
            this.mInstPath = path;
            this.mLimitedLocalWorld = this.getLimitedLocalWorld();
            Device device = path.getLast();
            DeviceTemplate dt = device.getTemplate();
            boolean flipped = path.getFlipped();
            long height = Substrate.getHeight((Device)device);
            if (flipped) {
                height = -height;
            }
            if ((bounds = dt.getBounds(true)) == null) {
                return;
            }
            APolygon poly = bounds.toPoly();
            APatternColor c = DesignView3D.this.mColorizer.getColor(path);
            if (c == null) {
                return;
            }
            if (DesignView3D.this.mDeviceAlpha < 255) {
                Appearance a = DesignView3D.this.getWireFrame(c.getColor());
                ExtrudedPolygon p3 = DesignView3D.this.createPoly3d(poly, height, a);
                this.addChild((Node)p3);
            }
            if (DesignView3D.this.mDeviceAlpha > 0) {
                AColor c2 = AColor.withAlpha((Color)c.getColor(), (int)DesignView3D.this.mDeviceAlpha);
                Appearance a = DesignView3D.this.getTranslucent((Color)c2);
                ExtrudedPolygon p3 = DesignView3D.this.createPoly3d(poly, height, a);
                this.addChild((Node)p3);
            }
            if ((substrate = dt.getSubstrate()) != null) {
                int curZ;
                int priorZ = curZ = 0;
                Device3dGroup priorGroup = this;
                for (Layer layer : substrate.getLayers()) {
                    long dz;
                    if (curZ != priorZ) {
                        Transform3D x3 = new Transform3D();
                        x3.setTranslation(new Vector3d(0.0, 0.0, DesignView3D.this.mViewUnit.toUser((long)curZ)));
                        TransformGroup tg = new TransformGroup(x3);
                        this.addChild((Node)tg);
                        priorGroup = tg;
                    }
                    this.mLyrGrps.put(layer, priorGroup);
                    priorZ = curZ;
                    long l = dz = DesignView3D.this.mFlatLayers ? DesignView3D.this.mLayerOffsetZ : layer.getHeight();
                    if (flipped) {
                        dz = -dz;
                    }
                    curZ = (int)((long)curZ + dz);
                }
            }
            this.addPins();
            this.addWires();
        }

        protected ARect getLimitedLocalWorld() {
            AffineTransform t;
            if (DesignView3D.this.mLimitedWorld == null) {
                return null;
            }
            try {
                t = this.mInstPath.getTransform().createInverse();
            }
            catch (NoninvertibleTransformException e) {
                ALog.logDebug((Throwable)e);
                return null;
            }
            return DesignView3D.this.mLimitedWorld.transform(t).getBounds();
        }

        protected Group getLayerGroup(Layer l) {
            return this.mLyrGrps.get(l);
        }

        protected IterableIterator<PinInstance> getPins() {
            Device device = this.mInstPath.getDevice();
            if (device == null) {
                return AEmptyItr.create();
            }
            LinkedHashSet<PinInstance> pinsInView = new LinkedHashSet<PinInstance>();
            if (DesignView3D.this.mAllowHierInsts != null) {
                for (PinInstance pinInst : device.getPins()) {
                    if (!DesignView3D.this.isAllowed((HierInst<? extends DbObject>)HierInst.create((DevicePath)this.mInstPath, (DbObject)pinInst))) continue;
                    pinsInView.add(pinInst);
                }
                return AIterableItr.itr(pinsInView);
            }
            if (this.mLimitedLocalWorld == null) {
                return device.getPins();
            }
            SpatialIndex2D pinIndex = device.getPinSpatialIndex();
            for (PinTemplate pt : pinIndex.intersects(this.mLimitedLocalWorld)) {
                if (pt.getDeviceTemplate() != device.getTemplate()) continue;
                pinsInView.add(PinInstance.getPinInstance((Device)device, (PinTemplate)pt));
            }
            return AIterableItr.itr(pinsInView);
        }

        protected IterableIterator<Wire> getWires() {
            Device device = this.mInstPath.getDevice();
            if (device == null) {
                return AEmptyItr.create();
            }
            if (DesignView3D.this.mAllowHierInsts != null) {
                LinkedHashSet<Wire> wireInView = new LinkedHashSet<Wire>();
                for (Wire wire : device.getTemplate().getWires()) {
                    if (!DesignView3D.this.isAllowed((HierInst<? extends DbObject>)HierInst.create((DevicePath)this.mInstPath, (DbObject)wire))) continue;
                    wireInView.add(wire);
                }
                return AIterableItr.itr(wireInView);
            }
            if (this.mLimitedLocalWorld == null) {
                return device.getTemplate().getWires();
            }
            SpatialIndex2D wireIndex = device.getTemplate().getWireSpatialIndex();
            return wireIndex.intersects(this.mLimitedLocalWorld);
        }

        protected void addPins() {
            for (PinInstance pinInst : this.getPins()) {
                PadTemplate pad = pinInst.getPadTemplate();
                if (pad == null) continue;
                this.addPorts(pinInst.getPinTemplate());
            }
        }

        protected void addPorts(PinTemplate pt) {
            for (PortTemplate port : pt.getPortTemplates()) {
                Transform3D x3 = new Transform3D();
                APoint2D loc = port.getLoc();
                double locX = DesignView3D.this.mViewUnit.toUser(loc.getX());
                double locY = DesignView3D.this.mViewUnit.toUser(loc.getY());
                x3.setTranslation(new Vector3d(locX, locY, 0.0));
                float rot = port.getRotate();
                if (rot != 0.0f) {
                    double r = Math.toRadians(360.0f - rot);
                    x3.setRotation(new AxisAngle4d(0.0, 0.0, 1.0, r));
                }
                if (port.getMirror()) {
                    x3.setScale(new Vector3d(-1.0, 1.0, 1.0));
                }
                ArrayList lshapes = AUtil.arrayList((Iterator)pt.getLayerShapes());
                Collections.sort(lshapes);
                for (LayerShape ls : lshapes) {
                    Layer layer = ls.getLayer();
                    long height = DesignView3D.this.mFlatLayers ? 0L : layer.getHeight();
                    APatternColor color = DesignView3D.this.mColorizer.getColor(this.mInstPath, pt, layer);
                    if (color == null) continue;
                    TransformGroup tg = new TransformGroup(x3);
                    Group lGroup = this.getLayerGroup(layer);
                    if (lGroup == null) continue;
                    this.getLayerGroup(layer).addChild((Node)tg);
                    Appearance a = DesignView3D.this.getSolid(color.getColor());
                    this.addPad((Group)tg, ls.getGeom(), height, a, pt.getType());
                }
            }
        }

        protected void addWires() {
            for (Wire wire : this.getWires()) {
                if (wire.getType() == Wire.Type.BOND) {
                    this.addBondWire(wire);
                    continue;
                }
                APath path = wire.getPath();
                APolygon poly = path.toPoly();
                Layer layer = wire.getLayer();
                long height = layer.getHeight();
                APatternColor color = DesignView3D.this.mColorizer.getColor(this.mInstPath, wire);
                if (color == null) continue;
                Appearance appearance = DesignView3D.this.getSolid(color.getColor());
                ExtrudedPolygon poly3d = DesignView3D.this.createPoly3d(poly, height, appearance);
                this.addChild((Node)poly3d);
            }
        }

        public void addBondWire(Wire w) {
            APatternColor color = DesignView3D.this.mColorizer.getColor(this.mInstPath, w);
            if (color == null) {
                return;
            }
            APath path = w.getPath();
            ALine l = new ALine(path.getFirstPoint(), path.getLastPoint());
            PinInstance fp = PinInstance.getPinInstance((HierInst)w.getPinA(), (boolean)true);
            assert (fp != null);
            fp = fp.getFirstExternallyConnected();
            assert (fp != null);
            PinInstance tp = PinInstance.getPinInstance((HierInst)w.getPinB(), (boolean)true);
            assert (tp != null);
            tp = tp.getFirstExternallyConnected();
            assert (tp != null);
            Device device0 = fp.getDevice();
            Device device1 = tp.getDevice();
            if (!device0.getIsSubstrate()) {
                DevicePath dp = device0.getADevicePath();
                device0 = dp.pathToSubstrate().getLast();
            }
            double x0 = DesignView3D.this.mViewUnit.toUser(l.getP0().getX());
            double y0 = DesignView3D.this.mViewUnit.toUser(l.getP0().getY());
            double z0 = DesignView3D.this.mViewUnit.toUser(Substrate.getZLoc((Device)device0) + Substrate.getHeight((Device)device0));
            double x1 = DesignView3D.this.mViewUnit.toUser(l.getP1().getX());
            double y1 = DesignView3D.this.mViewUnit.toUser(l.getP1().getY());
            double z1 = DesignView3D.this.mViewUnit.toUser(Substrate.getZLoc((Device)device1) + Substrate.getHeight((Device)device1));
            Shape3D shape = new Shape3D();
            shape.setPickable(false);
            shape.setCollidable(false);
            LineArray line = new LineArray(2, 5);
            line.setCoordinate(0, new Point3d(x0, y0, z0));
            line.setCoordinate(1, new Point3d(x1, y1, z1));
            line.setColor(0, new Color3b(color.getColor()));
            shape.addGeometry((Geometry)line);
            Appearance a = new Appearance();
            LineAttributes la = new LineAttributes();
            la.setLineAntialiasingEnable(true);
            a.setLineAttributes(la);
            shape.setAppearance(a);
            this.addChild((Node)shape);
        }

        protected void addPad(Group parentNode, AGeom geom, long height, Appearance a, PinTemplate.Type portType) {
            double dz = DesignView3D.this.mViewUnit.toUser(height);
            if (geom instanceof ACircle) {
                ACircle circle = (ACircle)geom;
                Group n = portType == PinTemplate.Type.BALLPAD && height != 0L ? DesignView3D.this.createSphere3d(circle, height, a) : DesignView3D.this.createCircle3d(circle, height, a);
                parentNode.addChild((Node)n);
            } else if (geom instanceof ARect) {
                ARect r = new ARect((ARect)geom);
                double x0 = DesignView3D.this.mViewUnit.toUser(r.left());
                double x1 = DesignView3D.this.mViewUnit.toUser(r.right());
                double y0 = DesignView3D.this.mViewUnit.toUser(r.bottom());
                double y1 = DesignView3D.this.mViewUnit.toUser(r.top());
                Cube c = new Cube(a, x0, y0, 0.0, x1, y1, dz);
                parentNode.addChild((Node)c);
            } else if (geom instanceof APath) {
                APath path = (APath)geom;
                APolygon poly = path.toPoly();
                parentNode.addChild((Node)DesignView3D.this.createPoly3d(poly, height, a));
            } else if (geom instanceof APolygon) {
                APolygon p = (APolygon)geom;
                parentNode.addChild((Node)DesignView3D.this.createPoly3d(p, height, a));
            } else assert (false) : "Unsupported geometry";
        }
    }

    private class ActionRotate
    extends AbstractAction {
        double rx;
        double ry;
        double rz;

        public ActionRotate(String text, Icon icon, double rx, double ry, double rz) {
            super(text, icon);
            this.rx = rx;
            this.ry = ry;
            this.rz = rz;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignView3D.this.rotate(this.rx, this.ry, this.rz);
        }
    }

    private class ActionZoom
    extends AbstractAction {
        double dz;

        public ActionZoom(String text, Icon icon, double dz) {
            super(text, icon);
            this.dz = dz;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignView3D.this.zoom(this.dz);
        }
    }

    private class ActionPan
    extends AbstractAction {
        int dx;
        int dy;

        public ActionPan(String text, Icon icon, int dx, int dy) {
            super(text, icon);
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignView3D.this.pan(this.dx, this.dy);
        }
    }
}

