/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import bsh.TokenMgrError;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.cp.CpConsole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class GuiCommandLine
extends JPanel {
    protected static final int MAX_SAVED_COMMANDS = 128;
    protected Cp mCp;
    protected JComboBox<String> mCboCommands;
    protected DefaultComboBoxModel<String> mCommands;
    protected Component mCurEditor = null;
    protected KeyListener mKeyListener = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            super.keyTyped(e);
            char key = e.getKeyChar();
            if (key == '\n') {
                String cmd = (String)GuiCommandLine.this.mCboCommands.getEditor().getItem();
                if (cmd != null) {
                    cmd = cmd.trim();
                }
                if (cmd == null || cmd.length() == 0) {
                    return;
                }
                int idx = GuiCommandLine.this.mCommands.getIndexOf(cmd);
                if (idx >= 0) {
                    GuiCommandLine.this.mCommands.removeElementAt(idx);
                }
                GuiCommandLine.this.mCommands.insertElementAt(cmd, 0);
                GuiCommandLine.this.mCommands.setSelectedItem(null);
                GuiCommandLine.this.saveCommands();
                ALog.logInfo((String)"Executing user command '%s'.", (Object[])new Object[]{cmd});
                cmd = cmd.replace('\t', ' ');
                try {
                    Object result = GuiCommandLine.this.mCp.doCmd(cmd, new Object[0]);
                    CpConsole.logResult((ALog.ALogLevel)ALog.LVL_INFO, (String)"Command result", (Object)result);
                }
                catch (TokenMgrError tme) {
                    ALog.logError((Throwable)tme, (String)"Syntax error in user command: %s.", (Object[])new Object[]{tme.getMessage()});
                }
                catch (Throwable t) {
                    String msg = t.getMessage();
                    if (msg == null) {
                        msg = t.toString();
                    }
                    ALog.logError((Throwable)t, (String)"Error executing user command: %s.", (Object[])new Object[]{msg});
                }
            }
        }
    };

    public GuiCommandLine(Cp cp) {
        this.mCp = cp;
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.mCboCommands = new JComboBox();
        this.mCboCommands.setEditable(true);
        this.add(this.mCboCommands);
        Dimension ps = this.mCboCommands.getPreferredSize();
        this.mCboCommands.setMinimumSize(new Dimension(ps.height, 20));
        this.installEditorListener();
        this.mCboCommands.addPropertyChangeListener("editor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null) {
                    GuiCommandLine.this.removeEditorListener();
                }
                if (evt.getNewValue() != null) {
                    GuiCommandLine.this.installEditorListener();
                }
            }
        });
        this.mCommands = (DefaultComboBoxModel)this.mCboCommands.getModel();
        this.restoreCommands();
        this.mCboCommands.setSelectedIndex(-1);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                GuiCommandLine.this.mCboCommands.requestFocusInWindow();
            }
        });
    }

    protected void saveCommands() {
        Settings s = Settings.getSettings((String)"GuiCommandLine");
        s.removeAll(Settings.Type.User);
        for (int i = 0; i < this.mCommands.getSize() && i < 128; ++i) {
            s.putSetting("Command" + i, (Object)this.mCommands.getElementAt(i));
        }
        s.save();
    }

    protected void restoreCommands() {
        String cmd;
        Settings mruSettings = Settings.getSettings((String)"GuiCommandLine");
        for (int i = 0; i < 128 && (cmd = (String)mruSettings.getSettingOfClass("Command" + i, String.class)) != null; ++i) {
            if ((cmd = cmd.trim()).length() == 0) continue;
            this.mCommands.addElement(cmd);
        }
    }

    protected void removeEditorListener() {
        if (this.mCurEditor != null) {
            this.mCurEditor.removeKeyListener(this.mKeyListener);
            this.mCurEditor = null;
        }
    }

    protected void installEditorListener() {
        this.removeEditorListener();
        this.mCurEditor = this.mCboCommands.getEditor().getEditorComponent();
        this.mCurEditor.addKeyListener(this.mKeyListener);
    }
}

