/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui.core;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.ACheckBoxIcon;
import com.sigrity.acl.ui.ASeparator;
import com.sigrity.acl.ui.AclUIManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.OrbitGuiI18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.FontUIResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OrbitContextMenuWS {
    public static final boolean enable = true;
    public static final String UNCLASSIFIED_ID = "UnClassified";
    protected OrbitIO mApp;
    protected ContextMenuXML mGlobalXML = new ContextMenuXML();
    protected HashMap<String, APair<String, Integer>> mHeuristicMap = new HashMap();
    protected HashMap<String, Integer> mHeuristicCount = new HashMap();
    protected HashMap<String, Icon> mHIcon = new HashMap();
    protected HashMap<String, ContextMenuXML> mShortcutXML = new HashMap();
    private static Map<Object, Object> defaultUIManager = null;

    private MenuNode createHeuristicMenuNode(MenuNode parent, Integer priority) {
        MenuNode m = new MenuNode(MenuType.MenuItem, parent);
        ++m.dep;
        m.index = parent.index + priority;
        return m;
    }

    public OrbitContextMenuWS(OrbitIO app) {
        this.mApp = app;
        this.loadConfig();
    }

    public void loadConfig() {
        String key;
        String mFileName = "OrbitContextMenuWS.xml";
        File file = Settings.findConfigFile((String)mFileName);
        if (file == null) {
            ALog.logInfo((String)"There is no %s file.", (Object[])new Object[]{mFileName});
            return;
        }
        Element elDoc = AXDomUtil.getDocumentElement((File)file);
        if (elDoc == null) {
            return;
        }
        for (Element el : AXDomUtil.getElements((Element)elDoc, (String)"HeuristicMapper/*")) {
            if (!el.getTagName().equals("WordMap")) continue;
            key = el.getAttribute("key");
            String id = el.getAttribute("groupId");
            Integer c = this.mHeuristicCount.get(id);
            int count = (c == null ? 0 : c) + 1;
            this.mHeuristicMap.put(key, (APair<String, Integer>)new APair((Object)id, (Object)count));
            this.mHeuristicCount.put(id, count);
        }
        for (Element el : AXDomUtil.getElements((Element)elDoc, (String)"Icon/*")) {
            if (!el.getTagName().equals("WordMap")) continue;
            key = el.getAttribute("key");
            String iconPath = el.getAttribute("icon");
            String iconKey = el.getAttribute("iconKey");
            Icon i = null;
            if (iconKey != null) {
                i = (Icon)UIManager.get(iconKey);
            }
            if (i == null && iconPath != null && !iconPath.isBlank()) {
                i = UIUtil.getIcon(OrbitIO.class, (String)iconPath);
            }
            Icon i16x16 = UIUtil.getScaledIcon((Icon)i, (int)16, (int)16);
            if (i == null) continue;
            this.mHIcon.put(key, i16x16);
        }
        for (Element el : AXDomUtil.getElements((Element)elDoc, (String)"*")) {
            if (!el.getTagName().equals("ContextMenu")) continue;
            this.mGlobalXML.parseContextMenu(el);
        }
        for (Element el : AXDomUtil.getElements((Element)elDoc, (String)"ShortcutContextMenu/*")) {
            if (!el.getTagName().equals("Shortcut")) continue;
            String groupName = el.getAttribute("forGroupName");
            ContextMenuXML xml = new ContextMenuXML();
            xml.parseContextMenu(el);
            this.mShortcutXML.put(groupName, xml);
        }
    }

    private void foldStack(Stack<MenuUINode> stack, int limitDep) {
        while (!stack.empty()) {
            if (stack.peek().depth() <= limitDep) {
                return;
            }
            ArrayList<MenuUINode> children = new ArrayList<MenuUINode>();
            MenuUINode e = stack.pop();
            MenuUINode p = new MenuUINode(e.parent());
            MenuUINode lastAdd = e;
            children.add(e);
            assert (p.depth() < e.depth());
            do {
                if (!stack.empty() && stack.peek().depth() > e.depth()) {
                    this.foldStack(stack, e.depth());
                }
                while (!stack.empty() && stack.peek().parent() == e.parent()) {
                    if (lastAdd != null && stack.peek().node == lastAdd.node) {
                        lastAdd.merge(stack.pop());
                        continue;
                    }
                    lastAdd = stack.pop();
                    children.add(lastAdd);
                }
            } while (!stack.empty() && stack.peek().depth() > e.depth());
            Collections.reverse(children);
            p.process(children);
            stack.add(p);
        }
    }

    private MenuUINode group(ArrayList<APair<MenuNode, JMenuItem>> acs) {
        Collections.sort(acs, (x, y) -> Integer.compare(((MenuNode)x.first).index, ((MenuNode)y.first).index));
        Stack<MenuUINode> stack = new Stack<MenuUINode>();
        for (int i = 0; i < acs.size(); ++i) {
            APair<MenuNode, JMenuItem> a = acs.get(i);
            ArrayList<MenuUINode> children = new ArrayList<MenuUINode>();
            MenuUINode e = new MenuUINode((MenuNode)a.first, (JMenuItem)a.second);
            MenuUINode p = new MenuUINode(e.parent());
            children.add(e);
            while (i + 1 < acs.size() && ((MenuNode)acs.get((int)(i + 1)).first).parent == e.parent()) {
                APair<MenuNode, JMenuItem> ai = acs.get(i + 1);
                children.add(new MenuUINode((MenuNode)ai.first, (JMenuItem)ai.second));
                ++i;
            }
            Collections.reverse(children);
            do {
                if (!stack.empty() && stack.peek().depth() > e.depth()) {
                    this.foldStack(stack, e.depth());
                }
                while (!stack.empty() && stack.peek().parent() == e.parent()) {
                    children.add(stack.pop());
                }
            } while (!stack.empty() && stack.peek().depth() > e.depth());
            Collections.reverse(children);
            p.process(children);
            stack.push(p);
        }
        this.foldStack(stack, -1);
        assert (stack.size() <= 1);
        if (stack.size() == 1) {
            MenuUINode e = stack.pop();
            while (e.node != null && e.node.type != MenuType.ContextMenu) {
                e.upgrade();
            }
            return e;
        }
        return new MenuUINode(null);
    }

    private static Component[] fetchMenuItems(JComponent m) {
        if (m instanceof JPopupMenu) {
            return ((JPopupMenu)m).getComponents();
        }
        if (m instanceof JMenu) {
            return ((JMenu)m).getMenuComponents();
        }
        return null;
    }

    public void beautify(JComponent m) {
        this.reform(m);
        OrbitContextMenuWS.reduce(m);
        this.decorate(m);
        this.i18n(m);
    }

    private void i18n(JComponent m) {
        Component[] cs = OrbitContextMenuWS.fetchMenuItems(m);
        if (cs == null) {
            return;
        }
        for (int i = 0; i < cs.length; ++i) {
            Component c = cs[i];
            if (c instanceof JMenuItem) {
                OrbitGuiI18n.translate("context_menu", "", (JMenuItem)c);
                continue;
            }
            if (!(c instanceof JMenu)) continue;
            OrbitGuiI18n.translate("context_menu", "", (JMenu)c);
        }
    }

    public void light(JComponent m) {
        Component[] cs = OrbitContextMenuWS.fetchMenuItems(m);
        if (cs == null) {
            return;
        }
        m.removeAll();
        for (int i = 0; i < cs.length; ++i) {
            Component c = cs[i];
            if (!(c instanceof JMenuItem)) continue;
            JMenuItem mi = (JMenuItem)c;
            if ((mi = this.beautifyMenuItem(mi)).getIcon() == null) {
                mi.setIcon(AEmptyIcon.N);
            } else {
                mi.setIcon(UIUtil.getScaledIcon((Icon)mi.getIcon(), (int)16, (int)16));
            }
            cs[i] = mi;
        }
        for (Component c : cs) {
            m.add(c);
            if (!(c instanceof JMenu)) continue;
            this.light((JMenu)c);
        }
    }

    private JMenuItem beautifyMenuItem(JMenuItem e) {
        MenuNode node;
        JMenuItem mi;
        Action a = e.getAction();
        if (a == null && e.getActionListeners().length == 0) {
            return e;
        }
        if (e instanceof JCheckBoxMenuItem || e instanceof JRadioButtonMenuItem) {
            MaskMenuItem item = new MaskMenuItem(e);
            e = item;
        } else if (a != null && a.getValue("SwingSelectedKey") != null) {
            boolean selected = (Boolean)a.getValue("SwingSelectedKey");
            a.putValue("SwingSelectedKey", null);
            JMenuItem item = new JMenuItem(a);
            item.setIcon(selected ? ACheckBoxIcon.Y : ACheckBoxIcon.N);
            if (a.getValue("InitUnChecked") != null) {
                item.setIcon(ACheckBoxIcon.N);
                a.putValue("InitUnChecked", null);
            }
            e = item;
        } else if (e instanceof JMenuItem && (mi = e).getIcon() == null && mi.getAction() != null && (node = this.mGlobalXML.mAction2Node.get(mi.getAction().getClass().getName())) != null && node.icon != null) {
            mi.setIcon(node.icon);
        }
        return e;
    }

    private LinkedList<Component> reform(String groupName, LinkedList<JMenuItem> miList) {
        LinkedList<Component> ret = new LinkedList<Component>();
        ArrayList<APair<MenuNode, JMenuItem>> acs = new ArrayList<APair<MenuNode, JMenuItem>>();
        ContextMenuXML xml = this.mShortcutXML.get(groupName);
        if (xml == null) {
            for (JMenuItem mi : miList) {
                mi = this.beautifyMenuItem(mi);
                ret.add(mi);
                if (!(mi instanceof JMenu)) continue;
                this.light(mi);
            }
            Collections.sort(ret, (x, y) -> ((JMenuItem)x).getText().compareTo(((JMenuItem)y).getText()));
            return ret;
        }
        ArrayList<JMenuItem> unknown = new ArrayList<JMenuItem>();
        for (JMenuItem e : miList) {
            MenuNode node = null;
            Action a = e.getAction();
            e = this.beautifyMenuItem(e);
            if (a != null && (node = xml.mAction2Node.get(a.getClass().getName())) != null) {
                acs.add((APair<MenuNode, JMenuItem>)new APair((Object)node, (Object)e));
            }
            if (node != null) continue;
            unknown.add(e);
        }
        MenuUINode bottom = this.group(acs);
        for (JMenuItem mi : unknown) {
            ret.add(mi);
            if (!(mi instanceof JMenu)) continue;
            this.light(mi);
        }
        if (ret.size() > 0 && bottom.items.size() > 0) {
            ret.add(new AHierSeparator(null, 1));
        }
        for (Component c : bottom.items) {
            if (c instanceof JSeparator) {
                ret.add(new AHierSeparator(null, 1));
            } else {
                ret.add(c);
            }
            if (!(c instanceof JMenu)) continue;
            this.light((JMenu)c);
        }
        this.addIcon(bottom.items);
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private void reform(JComponent m) {
        ArrayList<Component> cs = new ArrayList<Component>();
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        ArrayList<APair<MenuNode, JMenuItem>> acs = new ArrayList<APair<MenuNode, JMenuItem>>();
        this.collectAndClear(m, cs);
        LinkedList<JMenuItem> deferred = new LinkedList<JMenuItem>();
        JSeparator groupHeader = null;
        boolean isPushed = false;
        for (Component c : cs) {
            if (c instanceof JMenuItem) {
                deferred.add((JMenuItem)c);
                continue;
            }
            if (!(c instanceof JSeparator)) continue;
            if (groupHeader instanceof ASeparator) {
                m.add(groupHeader);
                for (Component component : this.reform(((ASeparator)groupHeader).getText(), deferred)) {
                    m.add(component);
                }
                deferred.clear();
                isPushed = true;
            } else if (groupHeader == null || groupHeader instanceof JSeparator) {
                if (groupHeader != null && !deferred.isEmpty() && isPushed) {
                    m.add(groupHeader);
                }
                if (!deferred.isEmpty()) {
                    isPushed = true;
                }
                for (JMenuItem jMenuItem : deferred) {
                    m.add(this.beautifyMenuItem(jMenuItem));
                }
                deferred.clear();
            }
            groupHeader = (JSeparator)c;
        }
        items.addAll(deferred);
        if (!deferred.isEmpty() && isPushed) {
            m.add(new JSeparator());
        }
        ArrayList<void> unknown = new ArrayList<void>();
        ArrayList<void> unclassified = new ArrayList<void>();
        for (JMenuItem jMenuItem : items) {
            void var11_17;
            MenuNode node = null;
            if (jMenuItem.getAction() != null) {
                Action a = jMenuItem.getAction();
                JMenuItem jMenuItem2 = this.beautifyMenuItem(jMenuItem);
                node = this.mGlobalXML.mAction2Node.get(a.getClass().getName());
                if (node != null) {
                    acs.add((APair<MenuNode, JMenuItem>)new APair((Object)node, (Object)jMenuItem2));
                }
            }
            if (node == null) {
                unclassified.add(var11_17);
                String[] words = var11_17.getText().split(" ");
                if (this.mHeuristicMap.containsKey(words[0])) {
                    APair<String, Integer> idInfo = this.mHeuristicMap.get(words[0]);
                    String groupId = (String)idInfo.first;
                    int priority = (Integer)idInfo.second;
                    node = this.mGlobalXML.getNodeById(groupId);
                    if (node != null) {
                        acs.add((APair<MenuNode, JMenuItem>)new APair((Object)this.createHeuristicMenuNode(node, priority), (Object)var11_17));
                    }
                }
            }
            if (node == null && (node = this.mGlobalXML.getNodeById(UNCLASSIFIED_ID)) != null) {
                acs.add((APair<MenuNode, JMenuItem>)new APair((Object)this.createHeuristicMenuNode(node, 0), (Object)var11_17));
            }
            if (node != null) continue;
            unknown.add(var11_17);
        }
        for (JMenuItem jMenuItem : unclassified) {
            if (!(jMenuItem instanceof JMenu)) continue;
            this.reform(jMenuItem);
        }
        Collections.sort(unknown, (x, y) -> x.getText().compareTo(y.getText()));
        MenuUINode top = this.group(acs);
        for (Component c : top.items) {
            m.add(c);
        }
        if ((m instanceof JPopupMenu && m.getComponentCount() > 0 || m instanceof JMenu && ((JMenu)m).getMenuComponentCount() > 0) && unknown.size() > 0) {
            m.add(new JSeparator());
        }
        for (JMenuItem mi : unknown) {
            m.add(mi);
        }
    }

    private void addIcon(Iterable<Component> cs) {
        String lastWord = null;
        for (Component c : cs) {
            String firstWord = null;
            if (!(c instanceof JMenuItem)) continue;
            JMenuItem mi = (JMenuItem)c;
            if (mi.getIcon() != null) {
                mi.setIcon(UIUtil.getScaledIcon((Icon)mi.getIcon(), (int)16, (int)16));
            }
            if ((firstWord = mi.getText().split(" ")[0]).equals(lastWord)) continue;
            Icon i = this.mHIcon.get(firstWord);
            if (i != null && !this.hasIcon(mi)) {
                mi.setIcon(UIUtil.getScaledIcon((Icon)i, (int)16, (int)16));
            } else if (!this.hasIcon(mi)) {
                mi.setIcon(AEmptyIcon.N);
            } else if (mi.getIcon() != null) {
                mi.setIcon(UIUtil.getScaledIcon((Icon)mi.getIcon(), (int)16, (int)16));
            }
            lastWord = firstWord;
        }
    }

    private boolean hasIcon(JMenuItem mi) {
        Action action = mi.getAction();
        return mi.getIcon() != null || action != null && action.getValue("SmallIcon") != null;
    }

    public static void reduce(JComponent m) {
        Component[] cs = OrbitContextMenuWS.fetchMenuItems(m);
        ArrayList<Component> next = new ArrayList<Component>();
        Component sep = null;
        m.removeAll();
        for (Component c : cs) {
            if (c instanceof JSeparator) {
                sep = c;
                continue;
            }
            if (sep != null) {
                if (next.size() > 0 || !sep.getClass().equals(JSeparator.class)) {
                    next.add(sep);
                }
                sep = null;
            }
            next.add(c);
        }
        for (Component c : next) {
            String orphanName;
            if (!(c instanceof JMenu)) continue;
            JMenu mm = (JMenu)c;
            OrbitContextMenuWS.reduce(mm);
            Component[] mcs = OrbitContextMenuWS.fetchMenuItems(mm);
            if (mcs == null || mcs.length != 1 || !(mcs[0] instanceof JMenu)) continue;
            JMenu orphan = (JMenu)mcs[0];
            String parentName = mm.getText();
            if (!parentName.equals(orphanName = orphan.getText())) continue;
            Component[] child = OrbitContextMenuWS.fetchMenuItems(orphan);
            mm.removeAll();
            for (Component cc : child) {
                mm.add(cc);
            }
        }
        for (Component c : next) {
            m.add(c);
        }
    }

    private void decorate(JComponent m) {
        Component[] cs = OrbitContextMenuWS.fetchMenuItems(m);
        if (cs == null) {
            return;
        }
        this.addIcon(Arrays.asList(cs));
        for (Component c : cs) {
            if (!(c instanceof JMenu)) continue;
            this.decorate((JMenu)c);
        }
    }

    private void collectAndClear(Component cc, ArrayList<Component> actions) {
        block3: {
            block2: {
                if (!(cc instanceof JPopupMenu)) break block2;
                JPopupMenu m = (JPopupMenu)cc;
                for (Component c : m.getComponents()) {
                    if (!(c instanceof JMenuItem) && !(c instanceof JSeparator)) continue;
                    actions.add(c);
                    m.remove(c);
                }
                break block3;
            }
            if (!(cc instanceof JMenu)) break block3;
            JMenu m = (JMenu)cc;
            for (Component c : m.getMenuComponents()) {
                if (!(c instanceof JMenuItem) && !(c instanceof JSeparator)) continue;
                actions.add(c);
                m.remove(c);
            }
        }
    }

    public static void dump(JPopupMenu m) {
        for (Component c : m.getComponents()) {
            Action a;
            if (c instanceof JMenu) {
                OrbitContextMenuWS.dump((JMenu)c, "");
                continue;
            }
            if (!(c instanceof JMenuItem) || (a = ((JMenuItem)c).getAction()) == null) continue;
            String path = "> " + ((JMenuItem)c).getText();
            System.out.printf("%s %s\n", path, a.getClass().getName());
        }
    }

    public static void dump(JMenuItem m, String path) {
        path = (String)path + " > " + m.getText();
        if (m instanceof JMenu) {
            JMenu mu = (JMenu)m;
            for (int i = 0; i < mu.getItemCount(); ++i) {
                JMenuItem c = mu.getItem(i);
                if (c instanceof JMenu) {
                    OrbitContextMenuWS.dump(c, (String)path);
                    continue;
                }
                if (!(c instanceof JMenuItem)) continue;
                OrbitContextMenuWS.dump(c, (String)path);
            }
        } else {
            Action a = m.getAction();
            if (a == null) {
                return;
            }
            path = (String)path + " > " + m.getText();
            System.out.printf("%s %s\n", path, a.getClass().getName());
        }
    }

    public static void blackOcean() {
        boolean setupDefault;
        boolean bl = setupDefault = defaultUIManager == null;
        if (setupDefault) {
            defaultUIManager = new HashMap<Object, Object>();
        }
        Enumeration keys = UIManager.getDefaults().keys();
        HashMap defaultMap = new HashMap();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (setupDefault) {
                defaultUIManager.put(key, value);
            }
            defaultMap.put(key, value);
        }
        for (Map.Entry e : defaultMap.entrySet()) {
            if (!(e.getValue() instanceof Color)) continue;
            Color c = AColor.getComplementary((Color)((Color)e.getValue())).brighter().brighter();
            UIManager.put(e.getKey(), c);
        }
        AclUIManager.put((String)"JFX.Theme", (Object)"dark");
        if (OrbitIO.getMainWindow() != null) {
            SwingUtilities.updateComponentTreeUI(OrbitIO.getMainWindow());
        }
    }

    public static void blueOcean() {
        try {
            if (defaultUIManager != null) {
                for (Map.Entry entry : defaultUIManager.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!(value instanceof FontUIResource)) continue;
                    UIManager.put(key, UIManager.getDefaults().get(key));
                }
            }
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            for (Window w : Window.getWindows()) {
                SwingUtilities.updateComponentTreeUI(w);
                if (!w.isDisplayable() || !(w instanceof Frame ? !((Frame)w).isResizable() : !(w instanceof Dialog) || !((Dialog)w).isResizable())) continue;
                w.pack();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            ALog.logError((Throwable)e);
        }
    }

    static class AHierSeparator
    extends JSeparator {
        public static final String SEPARATOR_KEY = "AclUiSeparatorKey";
        protected String mText = null;
        protected Rectangle2D mTextBounds = null;
        protected int level = 0;

        public AHierSeparator() {
        }

        public AHierSeparator(int orientation) {
            super(orientation);
        }

        public AHierSeparator(String text) {
            this.setText(text);
        }

        public AHierSeparator(String text, int level) {
            this.setText(text);
            this.level = level;
        }

        public String getText() {
            return this.mText;
        }

        public void setText(String text) {
            this.mText = text;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            Rectangle2D b = this.getTextBounds(this.getGraphics());
            if (b != null) {
                d.width = (int)((double)d.width + (4.0 + b.getWidth()));
                d.height = (int)((double)d.height + (b.getHeight() + 3.0));
            }
            return d;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Color background;
            Container parent = this.getParent();
            Insets insets = parent == null ? new Insets(0, 0, 0, 0) : parent.getInsets();
            Color color = background = parent == null ? this.getBackground() : parent.getBackground();
            if (parent != null) {
                this.setBackground(parent.getBackground());
            }
            int yoffset = this.getSize().height / 2;
            g.translate(0, yoffset);
            super.paintComponent(g);
            g.translate(0, -yoffset);
            if (!(g instanceof Graphics2D) || this.getTextBounds(g) == null) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(background);
                g2.fillRect(0, 1, 21 * this.level, g2.getClipBounds().height);
                return;
            }
            Graphics2D g2 = (Graphics2D)g.create();
            int y = (int)Math.ceil(-this.getTextBounds(g2).getY());
            Color origColor = g2.getColor();
            g2.setColor(background);
            g2.fillRect(insets.left + 1, 1, (int)this.getTextBounds(g2).getWidth() + 4, g2.getClipBounds().height);
            g2.setColor(origColor);
            if (this.mText != null) {
                g2.drawString(this.mText, insets.left + 3, y + 1);
            }
        }

        protected Rectangle2D getTextBounds(Graphics g) {
            if (this.mText == null) {
                return null;
            }
            if (this.mTextBounds == null) {
                FontMetrics fm = this.getFontMetrics(this.getFont());
                this.mTextBounds = new Rectangle2D.Float(0.0f, -fm.getAscent(), fm.stringWidth(this.mText), fm.getHeight() - fm.getLeading());
            }
            return this.mTextBounds;
        }
    }

    public static class ARadioIcon
    implements Icon {
        private static final Icon RADIO_ICON = UIManager.getIcon("RadioButton.icon");
        private static final Image RADIO_Y = ARadioIcon.createImage(true);
        private static final Image CHECKBOX_N = ARadioIcon.createImage(false);
        public static final Icon Y = new ARadioIcon(true);
        public static final Icon N = new ARadioIcon(false);
        private boolean mSelected;

        private ARadioIcon(boolean selected) {
            this.mSelected = selected;
        }

        private static Image createImage(boolean selected) {
            Icon icon = RADIO_ICON;
            JRadioButton btn = new JRadioButton("", selected);
            if (selected && btn.getSelectedIcon() != null) {
                return UIUtil.getAwtImage((Icon)btn.getSelectedIcon());
            }
            BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(btn, image.getGraphics(), 0, 0);
            return image;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawImage(this.mSelected ? RADIO_Y : CHECKBOX_N, x, y, x + this.getIconWidth(), y + this.getIconHeight(), 0, 0, RADIO_Y.getWidth(null), RADIO_Y.getHeight(null), null);
        }

        @Override
        public int getIconWidth() {
            return RADIO_Y.getWidth(null);
        }

        @Override
        public int getIconHeight() {
            return RADIO_Y.getHeight(null);
        }
    }

    public static class AEmptyIcon
    implements Icon {
        public static final AEmptyIcon N = new AEmptyIcon();

        private AEmptyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return ACheckBoxIcon.Y.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return ACheckBoxIcon.Y.getIconHeight();
        }
    }

    class ContextMenuXML {
        int index = 0;
        HashMap<String, MenuNode> mAction2Node = new HashMap();
        HashMap<String, MenuNode> mId2Node = new HashMap();

        public void addLeafNode(MenuNode p) {
            p.index = this.index;
            this.mAction2Node.put(p.actionClass, p);
            if (p.id != null) {
                this.mId2Node.put(p.id, p);
            }
            ++this.index;
        }

        public void addInnerNode(MenuNode p, Map<String, Integer> heuristicCount) {
            p.index = this.index++;
            if (p.id != null) {
                this.mId2Node.put(p.id, p);
                Integer inc = heuristicCount.get(p.id);
                if (inc != null) {
                    this.index += inc.intValue();
                }
            }
        }

        public MenuNode getNodeById(String id) {
            if (id == null) {
                return null;
            }
            return this.mId2Node.get(id);
        }

        public void parseContextMenu(Element rt) {
            NodeList list = rt.getChildNodes();
            int count = list.getLength();
            MenuNode root = new MenuNode(MenuType.ContextMenu, null);
            root.text = "ContextMenu";
            for (int i = 0; i < count; ++i) {
                Element chEl;
                Node chNode = list.item(i);
                if (chNode.getNodeType() != 1 || !(chEl = (Element)chNode).getTagName().equals("MenuGroup")) continue;
                root.add(this.parse(chEl, root, 1));
            }
        }

        private MenuNode parse(Element el, MenuNode parent, int dep) {
            String tagName = el.getTagName();
            MenuNode p = new MenuNode(tagName, parent);
            p.text = el.getAttribute("text");
            p.dep = dep;
            if (el.hasAttribute("id")) {
                p.id = el.getAttribute("id");
            }
            if (el.hasAttribute("icon")) {
                p.icon = UIUtil.getIcon(OrbitIO.class, (String)el.getAttribute("icon"));
            }
            if (el.hasAttribute("rename")) {
                p.rename = true;
                p.text = el.getAttribute("rename");
            }
            if (p.type == MenuType.MenuItem) {
                p.actionClass = el.getAttribute("actionClass");
                this.addLeafNode(p);
                return p;
            }
            this.addInnerNode(p, OrbitContextMenuWS.this.mHeuristicCount);
            NodeList list = el.getChildNodes();
            int count = list.getLength();
            for (int i = 0; i < count; ++i) {
                Node chNode = list.item(i);
                if (chNode.getNodeType() != 1) continue;
                Element chEl = (Element)chNode;
                p.add(this.parse(chEl, p, dep + 1));
            }
            return p;
        }
    }

    class MenuUINode {
        MenuNode node;
        ArrayList<Component> items;

        public MenuUINode(MenuNode u) {
            this.node = u;
            this.items = new ArrayList();
        }

        public MenuUINode(MenuNode u, JMenuItem mi) {
            assert (u != null);
            this.node = u;
            this.items = new ArrayList();
            this.items.add(mi);
            this.publish();
        }

        public void publish() {
            if (this.node == null) {
                return;
            }
            if (this.node.type.equals((Object)MenuType.Menu)) {
                JMenu m = new JMenu(this.node.text);
                boolean lastSep = false;
                for (Component c : this.items) {
                    if (c instanceof JSeparator) {
                        lastSep = true;
                        continue;
                    }
                    if (lastSep) {
                        lastSep = false;
                        m.addSeparator();
                    }
                    m.add(c);
                }
                this.items.clear();
                this.items.add(m);
            } else if (this.node.type.equals((Object)MenuType.MenuGroup)) {
                this.mergeSubMenu();
                this.items.add(new JSeparator());
            } else if (this.node.type.equals((Object)MenuType.ContextMenu)) {
                this.removeLastSeparator();
            } else if (this.node.type.equals((Object)MenuType.MenuItem)) {
                JMenuItem mi = (JMenuItem)this.items.get(0);
                if (this.node.rename) {
                    mi.setText(this.node.text);
                }
                if (this.node.icon != null && mi.getIcon() == null) {
                    mi.setIcon(this.node.icon);
                }
            }
        }

        protected void removeLastSeparator() {
            while (this.items.get(this.items.size() - 1) instanceof JSeparator) {
                this.items.remove(this.items.size() - 1);
            }
        }

        public int depth() {
            return this.node == null ? -1 : this.node.dep;
        }

        public String text() {
            return this.node == null ? "none" : this.node.text;
        }

        public MenuNode parent() {
            return this.node == null ? null : this.node.parent;
        }

        public void process(List<MenuUINode> children) {
            for (MenuUINode child : children) {
                for (Component c : child.items) {
                    this.items.add(c);
                }
            }
            this.publish();
        }

        public void upgrade() {
            this.node = this.node.parent;
            this.publish();
        }

        public void merge(MenuUINode m) {
            assert (this.node == m.node);
            if (this.node.type.equals((Object)MenuType.MenuGroup)) {
                this.removeLastSeparator();
            }
            this.items.addAll(m.items);
            this.mergeSubMenu();
        }

        public void mergeSubMenu() {
            HashMap<String, JMenu> hash = new HashMap<String, JMenu>();
            Iterator<Component> it = this.items.iterator();
            while (it.hasNext()) {
                Component c = it.next();
                if (!(c instanceof JMenu)) continue;
                JMenu m = (JMenu)c;
                String key = m.getText();
                JMenu p = (JMenu)hash.get(key);
                if (p != null) {
                    for (Component mc : m.getMenuComponents()) {
                        p.add(mc);
                    }
                    it.remove();
                    continue;
                }
                hash.put(key, m);
            }
        }
    }

    class MenuNode {
        MenuType type;
        MenuNode parent;
        ArrayList<MenuNode> children;
        String text;
        String actionClass;
        String id;
        Icon icon;
        int index;
        int dep;
        boolean rename = false;

        MenuNode(MenuType t, MenuNode p) {
            this.type = t;
            this.parent = p;
            this.children = new ArrayList();
        }

        MenuNode(String t, MenuNode p) {
            for (MenuType mt : MenuType.values()) {
                if (!mt.text.equals(t)) continue;
                this.type = mt;
            }
            this.parent = p;
            this.children = new ArrayList();
        }

        void add(MenuNode c) {
            this.children.add(c);
        }
    }

    static enum MenuType {
        ContextMenu("ContextMenu"),
        MenuGroup("MenuGroup"),
        Menu("Menu"),
        MenuItem("MenuItem");

        String text;

        private MenuType(String t) {
            this.text = t;
        }
    }

    public static class MaskMenuItem
    extends JMenuItem {
        AbstractButton mBtn;

        public MaskMenuItem(AbstractButton btn) {
            Icon icon;
            this.mBtn = btn;
            final Action a = btn.getAction();
            this.setAction(new AbstractAction(this.mBtn.getText()){
                {
                    super(arg0);
                    if (a != null) {
                        this.putValue("AcceleratorKey", a.getValue("AcceleratorKey"));
                    }
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    mBtn.doClick();
                }
            });
            this.setSelected(this.mBtn.isSelected());
            this.setEnabled(this.mBtn.isEnabled());
            if (a != null && (icon = (Icon)a.getValue("SmallIcon")) != null) {
                this.setIcon(UIUtil.getScaledIcon((Icon)icon, (int)16, (int)16));
            }
        }

        @Override
        public boolean isEnabled() {
            if (this.mBtn == null) {
                return false;
            }
            boolean enable = false;
            try {
                enable = this.mBtn.getAction().isEnabled();
                this.setSelected(this.mBtn.isSelected());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return enable;
        }

        @Override
        public void addNotify() {
            super.addNotify();
            JPanel p = new JPanel();
            p.add(this.mBtn);
            this.mBtn.addNotify();
            this.setSelected(this.mBtn.isSelected());
        }

        @Override
        public void setSelected(boolean selected) {
            super.setSelected(selected);
            if (this.mBtn instanceof JCheckBoxMenuItem) {
                this.setIcon(selected ? ACheckBoxIcon.Y : ACheckBoxIcon.N);
            } else if (this.mBtn instanceof JRadioButtonMenuItem) {
                this.setIcon(selected ? ARadioIcon.Y : ARadioIcon.N);
            }
        }
    }

    public static class DynamicBeautifyAdapter
    extends ContainerAdapter {
        JComponent mComponent;

        public DynamicBeautifyAdapter(JComponent c) {
            this.mComponent = c;
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            if (c instanceof JMenu) {
                final JMenu t = (JMenu)c;
                OrbitIO.getGuiWorkspace().getContextMenuWorkspace().light(t);
                t.addMenuListener(new MenuListener(){

                    @Override
                    public void menuCanceled(MenuEvent e) {
                    }

                    @Override
                    public void menuDeselected(MenuEvent e) {
                    }

                    @Override
                    public void menuSelected(MenuEvent e) {
                        OrbitIO.getGuiWorkspace().getContextMenuWorkspace().light(t);
                    }
                });
            }
        }
    }
}

